//列表
function load(){
    var param = {};
    param.page = Number( $('#currPage').val() ) + 1;
    param.pagesize = 10;
    $.post(WST.U('mobile/useraddress/pageQuery'), param, function(data){
        var json = WST.toJson(data.data);
        console.log("json:",json);
        var html = '';
        if(json.data && json.data.length>0){
            $('#currPage').val(json.current_page);
            $('#totalPage').val(json.last_page);
            json.type = $("#type").val();
            json.addressId = $("#addressId").val();
            var gettpl = document.getElementById('list').innerHTML;
            laytpl(gettpl).render(json, function(html){
                $('#address-list').append(html);
            });
        }else{
            $('body').css('background', '#FFFFFF');
            html += '<div style="text-align:center"><div class="wst-prompt-icon" style="width: 1.53rem;height: 1.03rem"><img src="'+ WST.conf.VIEW +'/img/nothing-address.png"></div><div class="wst-prompt-info"><p>暂无地址</p></div></div>';
            $('#address-list').html(html);

        }
    });
}
function frame(type,n){
	if(type==1){
		$('#'+n).addClass('weui-popup-container-visible');
		$('.wst-'+n).addClass('weui-popup-modal-visible');
		if(n=='add-region'){
			init();
		}
	}else{
		$('#'+n).removeClass('weui-popup-container-visible');
		$('.wst-'+n).removeClass('weui-popup-modal-visible');
	}
}
//切换城市
function inCity(id,name){
	$('#areaId2').val(id);
	$('#city').val(name);
	frame(0,'add-city');
}
//切换区域
var searchService,pois = [];
function init(){
	var addressId = $('#saveId').val();
	if(addressId>0){
		var clat = $('#latitude').val();
		var clng = $('#longitude').val();
	}else{
		var clat = WST.conf.LATITUDE;
		var clng = WST.conf.LONGITUDE;
	}
    var center=new qq.maps.LatLng(clat,clng);
    var map=new qq.maps.Map(document.getElementById("map"),{
        center:center,
        zoom:16
    });
    var marker=new qq.maps.Marker({
        position:center,
		animation:qq.maps.MarkerAnimation.DROP,
        map:map
    });
    nearby(clat,clng);
    //调用地址解析类
    var marker3 = null;
    var geocoder = new qq.maps.Geocoder({
        complete : function(result){
            map.setCenter(result.detail.location);
            marker3 = new qq.maps.Marker({
                map:map,
                position: result.detail.location
            });
            var data = result.detail.location;
            nearby(result.detail.location.lat,result.detail.location.lng);
        }
    });
    var address = document.getElementById("city").value;
    var areaname = document.getElementById("areaName2").value;
    if(address!==areaname){
    	geocoder.getLocation(address);
    }
    //调用Poi检索类
    var latlngBounds = new qq.maps.LatLngBounds();
    var marker4 = null;
    searchService = new qq.maps.SearchService({
        complete : function(results){
            pois = results.detail.pois;
            if(pois){
                var poi = pois[1];
                latlngBounds.extend(poi.latLng);  
                marker4 = new qq.maps.Marker({
                    map:map,
                    position: poi.latLng
                });
    		    var gettpl = document.getElementById('listr2').innerHTML;
    		    laytpl(gettpl).render(pois, function(html){
    		        $('#region-list').html(html);
    		    });
                map.fitBounds(latlngBounds);
            }else{
            	$.toptips('无法查找您的地址，请详细输入','info');
            }
        }
    });
    //添加监听事件   获取鼠标单击事件
    qq.maps.event.addListener(map, 'click', function(event) {
       marker.setMap(null);
       if(address!==areaname){
    	   marker3.setMap(null);
       }
       var keyword = document.getElementById("add-search").value;
       if(keyword){
    	   marker4.setMap(null);
       }
       var marker2=new qq.maps.Marker({
                position:event.latLng, 
                map:map
          });
	   qq.maps.event.addListener(map, 'click', function(event) {
		   marker2.setMap(null);      
	   });
	   nearby(event.latLng.getLat(),event.latLng.getLng());
    });
}
function addSearch(){
	var keyword = document.getElementById("add-search").value;
	searchService.search(keyword);
}
function nearby(lat,lng){
	var url = encodeURI(WST.conf.__HTTP__+'apis.map.qq.com/ws/geocoder/v1/?location=' + lat + "," + lng + "&key="+WST.conf.MAP_KEY+"&get_poi=1&output=jsonp&&callback=?");
	$.getJSON(url, function (result) {
		if(result.result!=undefined){
			pois = result.result.pois;
		    var gettpl = document.getElementById('listr').innerHTML;
		    laytpl(gettpl).render(pois, function(html){
		        $('#region-list').html(html);
		    });
		}
	})
}
function inRegion(id){
	if(pois[id].title || pois[id].name){
    	if(pois[id].title){
    		$('#region').val(pois[id].ad_info.district+pois[id].title);
        	$('#latitude').val(pois[id].location.lat);
        	$('#longitude').val(pois[id].location.lng);
    	}else if(pois[id].name){
    		$('#region').val(pois[id].name);
        	$('#latitude').val(pois[id].latLng.lat);
        	$('#longitude').val(pois[id].latLng.lng);
    	}
    	frame(0,'add-region');
	}else{
		$.toptips('选择失败，请重新打开页面重试','info');
        return false;
	}
}
//保存收货地址
function infoAddress(addressId){
	$('#saveId').val(addressId);
	$('#defaults').prop("checked",false);
    WST.emptyLabel('val','#userName,#userPhone,#areaId2,#areaName2,#city,#region,#latitude,#longitude,#doorNum');
	if(addressId>0){
		$('#saveAdd-title').html('修改地址');
		$('#saveAdd-del').show();
	    $.post(WST.U('mobile/useraddress/getById'), {addressId:addressId}, function(data){
	        var json = WST.toJson(data);
	        if( json.status == 1 ){
	            $('#userName').val(json.data.userName);
	            $('#userPhone').val(json.data.userPhone);
	            $('#areaId2').val(json.data.areaId2);
	            $('#city').val(json.data.areaName2);
	            $('#areaName2').val(json.data.areaName2);
	            $('#region').val(json.data.userAddress);
	            $('#latitude').val(json.data.latitude);
	            $('#longitude').val(json.data.longitude);
	            $('#doorNum').val(json.data.doorNum);
	            if(json.data.isDefault==1){
	            	$('#defaults').prop("checked",true);
	            }
	        }
	        data = json = null;
	    });
	}else{
		$('#saveAdd-del').hide();
        $('#areaId2').val(WST.conf.AREAID2);
        $('#city').val(WST.conf.AREANAME2);
        $('#areaName2').val(WST.conf.AREANAME2);
		$('#saveAdd-title').html('新增地址');
	}
}
function saveAddress(){
    var userName = $('#userName').val();
    var userPhone = $('#userPhone').val();
    var areaId2 = $('#areaId2').val();
    var userAddress = $('#region').val();
    var latitude = $('#latitude').val();
    var longitude = $('#longitude').val();
    var doorNum = $('#doorNum').val();
    if( $('#defaults').is(':checked')){
    	var isDefault = 1;
    }else{
    	var isDefault = 0;
    }
    if(userName==''){
    	$.toptips('请输入收货人姓名','info');
        return false;
    }
    if(userPhone==''){
    	$.toptips('请输入收货人手机号码','info');
        return false;
    }
    if(areaId2==''){
    	$.toptips('请选择城市','info');
        return false;
    }
    if(userAddress==''){
    	$.toptips('请选择详细地址','info');
        return false;
    }
    if(doorNum==''){
    	$.toptips('请输入门牌号','info');
        return false;
    }
    var param = {};
    param.addressId = $('#saveId').val();
    param.userName = userName;
    param.areaId2 = areaId2;
    param.userPhone = userPhone;
    param.userAddress = userAddress;
    param.latitude = latitude;
    param.longitude = longitude;
    param.doorNum = doorNum;
    param.isDefault = isDefault;
	$('#saveAdd').attr('disabled', 'disabled');
    $.post(WST.U('mobile/useraddress/edits'), param, function(data){
        var json = WST.toJson(data);
        if( json.status == 1 ){
        	$.toast(json.msg);
        	if(type==1){
        		var addressId = param.addressId;
        	}
            setTimeout(function(){
            	var type = $("#type").val();
            	if(type==0){
                    $('#currPage').val(0);
                    $('#totalPage').val(0);
                    $('.wst-ad-list').html('<div id="address-list"></div>');
                	load();
                	$('.close-popup').trigger("click");
            	}else{
            		chooseAddress(addressId);
            	}

            },1500);
        }else{
        	$.toptips(json.msg);
        }
    	$('#saveAdd').removeAttr('disabled');
        data = json = null;
    });
}
//删除地址
function delAddress(id){
    WST.dialog('确认删除该地址吗？','del("'+id+'")');
}
function del(id){
    $.post(WST.U('mobile/useraddress/del'), {id:id}, function(data){
        var json = WST.toJson(data);
        if( json.status == 1 ){
            $.toast(json.msg);
            WST.dialogHide('prompt');
            setTimeout(function(){
                $('#currPage').val(0);
                $('#totalPage').val(0);
                $('.wst-ad-list').html('<div id="address-list"></div>');
                load();
                $('.close-popup').trigger("click");
            },1500);
        }else{
            $.toptips(json.msg);
        }
        data = json = null;
    });
}
//设置默认
function inDefault(obj,id){
    if($(obj).hasClass("weui_icon_circle")){
        $(obj).addClass('weui_icon_success').removeClass('weui_icon_circle');
    }else{
        $(obj).addClass('weui_icon_circle').removeClass('weui_icon_success');
    }
    $.post(WST.U('mobile/useraddress/setDefault'), {id:id}, function(data){
        var json = WST.toJson(data);
        if( json.status == 1 ){
        	$.toast(json.msg);
            setTimeout(function(){
                $('#currPage').val(0);
                $('#totalPage').val(0);
                $('.wst-ad-list').html('<div id="address-list"></div>');
            	load();
            },1500);
        }else{
        	$.toptips(json.msg);
        }
        data = json = null;
    });
}
//返回结算
function chooseAddress(id){
	location.href = WST.U('mobile/carts/settlement','addressId='+id);
}
$(document).ready(function(){
	load();
    $('.search-form').on('submit', '.input-form', function(event){
        event.preventDefault();
    })
});