function shopsList(){
    $('.wst-loading').show();
    load();
}
function frame(type,n){
    if(type==1){
        $('#'+n).addClass('weui-popup-container-visible');
        $('.wst-'+n).addClass('weui-popup-modal-visible');
        if(n=='sel-region'){
            init();
        }
    }else{
        $('#'+n).removeClass('weui-popup-container-visible');
        $('.wst-'+n).removeClass('weui-popup-modal-visible');
    }
}
//切换城市
function inCity(id,name){
    $('#shop_areaId').val(id);
    $('#shop_city').html(name);
    frame(0,'sel-city');
    searchShop();
}
function searchShop(){
    $('#currPage').val(0);
    $('#totalPage').val(0);
    $('#shop-list').empty();
    $('.dropload-down').remove();
    shopsList();
}
//列表
function load(){
	$('.wst-loading').hide();
    $('.wst-container').dropload({
        scrollArea : window,
        autoLoad : true,
        threshold: 100,
        domDown : {//上拉
            domClass   : 'dropload-down',
            domRefresh : '<div class="dropload-refresh f15 "><i class="icon icon-20"></i>上拉加载更多</div>',
            domLoad    : '<div class="dropload-load f15"><span class="weui-loading"></span>正在加载中...</div>',
            domNoData  : '<div class="dropload-noData">没有更多数据了</div>'
        },
        loadDownFn : function(me){
        	var param = {};
        	param.latitude = WST.conf.LATITUDE;
        	param.longitude = WST.conf.LONGITUDE;
        	param.page = Number( $('#currPage').val() ) + 1;
        	param.pagesize = 10;
            param.areaId = $('#shop_areaId').val();
            param.key = $('#wst-search-shop').val();
            $.post(WST.U('mobile/shops/pageQuery'), param,function(data){
                var json = WST.toJson(data);
                if(json.data && json.data.length>0){
        	        $('#currPage').val(json.current_page);
        	        $('#totalPage').val(json.last_page);
                    var gettpl = document.getElementById('list').innerHTML;
                    laytpl(gettpl).render(json.data, function(html){
                        $('#shop-list').append(html);
                    });
                }else{
                    // 锁定
                    me.lock();
                    // 无数据
                    me.noData();
                }
                // 每次数据加载完，必须重置
                me.resetload();
            });
        }
    });
}
//切换
function inSwitch(id){
	var param = {};
	param.id = id;
    $.post(WST.U('mobile/shops/shopSwitch'), param,function(data){
        var json = WST.toJson(data);
        if(json.status==1){
        	location.href = WST.U('mobile/index/index');
        }
    });
}
//门店位置
function shop(id){
	var param = {};
	param.shopId = id;
	param.latitude = WST.conf.LATITUDE;
    param.longitude = WST.conf.LONGITUDE;
    $.post(WST.U('mobile/shops/getById'), param,function(data){
        var json = WST.toJson(data);
        if(json.status==1){
        	$('#map').html('');
        	if(json.data.latitude && json.data.longitude){
        		position(json.data.latitude,json.data.longitude);
        	}
        	$('.info-shopname').html(json.data.shopName);
        	$('#info-shopname').html(json.data.shopAddress);
        	$('#info-time').html(json.data.serviceStartTime+'-'+json.data.serviceEndTime);
        	if(json.data.distince){
        		$('#info-distance').html(json.data.distince+'km');
        	}
        	$('#info-tel').attr('href','tel:'+json.data.shopTel);
        }
    });
}
function position(clat,clng){
    var center=new qq.maps.LatLng(clat,clng);
    var map=new qq.maps.Map(document.getElementById("map"),{
        center:center,
        zoom:16
    });
    var marker=new qq.maps.Marker({
        position:center,
		animation:qq.maps.MarkerAnimation.DROP,
        map:map
    });
}
$(document).ready(function(){
    if(WST.conf.SHOPID==0 || WST.conf.SHOPID==''){
        frame(1,'sel-city');
    }else{
    	shopsList();
    }
}); 