var dataHeight = $(".frame").css('height');
dataHeight = parseInt(dataHeight)+50+'px';
/* 发票抬头列表绑定事件 */
$(function(){
	$('#invoice_head').focus(function(){
		$('#inv_headlist').show();
	})
	$('#invoice_head').blur(function(){
		setTimeout(function(){
			$('#inv_headlist').hide();
		},100)
	})
	// 只要用户编辑了,就视为新增
	$('#invoice_head').bind('input propertychange', function() {
		$('#invoiceId').val(0);
	});
})
function onSwitch(obj,n){
	$(obj).children('.ui-icon-push').removeClass('weui_icon_circle').addClass('weui_icon_success');
	$(obj).siblings().children('.ui-icon-push').removeClass('weui_icon_success').addClass('weui_icon_circle');
}
//配送时间
function shtime(type){
	if(type==1){
		$('.weui_mask').addClass('weui_mask_visible');
		$('.weui-custom-pop').addClass('weui-dialog-visible');
	}else{
     	$('.weui_mask').removeClass('weui_mask_visible');
		$('.weui-custom-pop').removeClass('weui-dialog-visible');
	}
}
function obtainTimes(days){
	var dd = new Date();
	var h = dd.getHours();
	days = (h==23)?(days+1):days;
	dd.setDate(dd.getDate()+days);//获取AddDayCount天后的日期
	var y = dd.getFullYear();
	var m = dd.getMonth()+1;//获取当前月份的日期
	var d = dd.getDate();
	return {val:y+'-'+m+"-"+d,txt:m+"月"+d+"日"};
}
function time(){
	var html = '';
	var h = new Date().getHours();
	var days = parseInt(WST.conf.DELIVERY_DAYNUM,10);
	var str = '';
	for(var i=0; i<days; i++){ 
		str = obtainTimes(i);
		html += '<option value="'+str.val+'"';
		html += (i==0) ? ' selected' : '';
		html += '>'+str.txt+'</option>';
	}
	$('#requireTime').html(html);
	str = obtainTimes(0);
	time2(str.val);
	confirmTime();
}
//送达时间段
var times = [];
function time2(value){
	times.length = 0;
	var startTime = parseInt(WST.conf.DELIVERY_STARTTIME,10);
	var endTime = parseInt(WST.conf.DELIVERY_ENDTIME,10);
	var str1 = '';str2 = '';
	var min = 0;
	var dd = new Date();
	var h = dd.getHours();
	var currDay = dd.getFullYear()+'-'+(dd.getMonth()+1)+'-'+dd.getDate();
	if(currDay==value){
        startTime = (h>startTime)?h:startTime;
	}
	for(var i=startTime;i<endTime;i++){
        str1 = (i<10)?'0'+i:i;
        str2 = ((i+1)<10)?'0'+(i+1):(i+1);
        times.push(str1+':00-'+str2+':00');
	}
	var html = '';
    for(var i=0; i<times.length; i++){
    	html += '<option value="'+times[i]+'"';
    	html += (i==0) ? ' selected' : '';
    	html += '>'+times[i]+'</option>';   
    }
    $('#requireTime2').html(html);
}
function confirmTime(){
	var confirm1 = $("#requireTime option:selected").text();
	var confirm2 = $("#requireTime2 option:selected").val();
	$('#j-select-time').html('预计<span id="word-time"></span>送达');
	var day = obtainTimes(parseInt(confirm1,10));
	$("#word-time").html(confirm1+' ' +WST.blank(confirm2));
	shtime(0);
}

/* 选择是否需要发票 */
function isInvoice(obj,n){
	$(obj).children('.ui-icon-push').removeClass('weui_icon_circle').addClass('weui_icon_success');
	$(obj).siblings().children('.ui-icon-push').removeClass('weui_icon_success').addClass('weui_icon_circle');
	$('#isInvoice').val(n);
	$('#invoicesh').val(n);
}
/* 发票对象【个人or单位】 */
function invOnSwitch(obj,n){
	$(obj).children('.ui-icon-push').removeClass('weui_icon_circle').addClass('weui_icon_success');
	$(obj).siblings().children('.ui-icon-push').removeClass('weui_icon_success').addClass('weui_icon_circle');
	if(n==1){
		$('.inv_hidebox').show();
	}else{
		$('.inv_hidebox').hide();
	}
	$('#invoice_obj').val(n);// 记录用户所开发票对象
}

// 发票弹框
function invoiceShow(){
	$('#cover').attr("onclick","javascript:invoiceHide();").show();
	$('#frame').animate({"bottom": 0}, 500);

}
function invoiceHide(){
	$('#frame').animate({'bottom': '-100%'}, 500);
	$('#cover').hide();
}
//发票
function listInvoice(){
	$('#invoice-list').html('');
    $.post(WST.U('mobile/invoices/pageQuery'), {}, function(data){
        var json = WST.toJson(data);
        if(json.status==1){
        	json.invoiceId = $("#invoiceId").val();
        	json.isInvoice = $("#isInvoice").val();
            var gettpl = document.getElementById('invoiceBox').innerHTML;
            laytpl(gettpl).render(json.data, function(html){
                $('.inv_list_item').html(html);
				invoiceShow();
				// 点击抬头item
				$('.inv_list_item li').click(function(){
					// 设置值
					$('.inv_head_input').val($(this).html());
					$('#invoice_head').val($(this).html());
					$('#invoiceId').val($(this).attr('invId'));
					$('#invoice_code').val($(this).attr('invCode'));
				})
            });
        }
    });
}
function frame(type,n){
	if(type==1){
		$('.weui-popup-container').addClass('weui-popup-container-visible');
		$('.wst-'+n).addClass('weui-popup-modal-visible');
	}else{
		$('#'+n).removeClass('weui-popup-container-visible');
		$('.wst-'+n).removeClass('weui-popup-modal-visible');
	}
}

function saveInvoice(){
	if($('#invoice_obj').val()!=0){
		var invoiceId = $('#invoiceId').val();
		var invoiceHead = $('#invoice_head').val();
		var invoiceCode = $('#invoice_code').val();
		if(invoiceHead==''){
			$.toptips('请输入公司全称','info');
			return false;
		}
		if(invoiceCode==''){
			$.toptips('请输入纳税人识别号','info');
			return false;
		}
		var param = {};
		param.id = invoiceId;
		param.invoiceHead = invoiceHead;
		param.invoiceCode = invoiceCode;
		$.post(WST.U('mobile/invoices/edits'), param, function(data){
			var json = WST.toJson(data);
			if( json.status == 1 ){
				setInvoiceText();
				if(invoiceId==0)$('#invoiceId').val(json.data.id)
			}else{
				$.toptips(json.msg);
			}
		});
	}else{
		setInvoiceText();
	}
}

// 设置页面显示值
function setInvoiceText(){
	var isInvoice  = $('#isInvoice').val();
	var invoiceObj = $('#invoice_obj').val();// 发票对象
	var invoiceHead = $('#invoice_head').val();// 发票抬头
	var text = '不开发票';
	var _taxText = '普通';
	if(isInvoice==1){
		text = (invoiceObj==0)?(_taxText+'发票（纸质）  个人   明细'):(_taxText+'发票（纸质）<br />'+invoiceHead+'<br />明细');
	}
	$('#invoicest').html(text);
	invoiceHide();
}

//计算价格
function getCartMoney(){
	var params = {};
	if($('#couponId')){params.couponId =$('#couponId').val();}
	params.isUseScore = $('#scoreh').val();
	params.useScore = $('#userOrderScore').val();
	params.addressId = $('#addressId').val();
	params.deliverType = $('#givesh').val();
	$.post(WST.U('mobile/carts/getCartMoney'),params,function(data,textStatus){
		var json = WST.toJson(data);
		if(json.status==1){
		    json = json.data;
		 	$('#totalMoney').html(json.realTotalMoney.toFixed(2));
		 	$('#goodsMoney').val('¥ '+json.totalGoodsMoney.toFixed(2));
		 	$('#freight').val('+ ¥ '+json.freight);
		 	// 设置可用积分及积分可抵金额
		 	$('#userOrderScore').html(json.maxScore);
			$('#userOrderMoney').html(json.maxScoreMoney);
		}
	});
}
//提交订单
function submitOrder(){
	var addressId =  $('#addressId').val();
	if($('#type-gives').val()==0 && addressId==''){
		$.toptips('请选择收货地址','info');
		return false;
	}
    var param = {};
    param.addressId = addressId;
	param.payType = $('#paymentsh').val();
	param.payCode = $('#paymentsw').val();
    param.isUseScore = $('#scoreh').val();
    param.useScore = $('#userOrderScore').val();
    param.remark = $('#remark').val();
    param.deliverType = $('#givesh').val();
    param.bookTime = $("#requireTime option:selected").val() +" "+$("#requireTime2 option:selected").val();
    param.isInvoice = $('#isInvoice').val();
    param.invoiceId = $('#invoiceId').val();
    if($('#couponId')){param.couponId=$('#couponId').val()}
    param.invoiceClient = $('#word-invoice').html();
    $('#submitOrder').attr('disabled', 'disabled');
	$.post(WST.U('mobile/orders/submit'),param,function(data,textStatus){ 
		var json = WST.toJson(data);
	    if(json.status==1){
	    	$.toast(json.msg);
	    	setTimeout(function(){
    	    if(param.payType==1 && $('#totalMoney').html()>0){
				if(param.payCode=='alipays' || param.payCode==''){
				  	location.href = WST.U('mobile/alipays/toPay',{"pkey":json.pkey});
				}else if(param.payCode=='wallets'){
				  	location.href = WST.U('mobile/wallets/toPay',{"pkey":json.pkey});
				}else if(param.payCode=='weixinpays'){
				  	location.href = WST.U('mobile/weixinpays/toPay',{"pkey":json.pkey});
				}
    	    }else{
    	    	location.href = WST.U('mobile/orders/index');
    	    }
	    	},1500);
	    }else{
	    	$.toptips(json.msg);
	    	$('#submitOrder').removeAttr('disabled');
	    }
	});
}
$(document).ready(function(){
	time();
	getCartMoney();
});

//弹框
function dataShow(n){
	$('#cover').attr("onclick","javascript:dataHide('"+n+"');").show();
	$('#'+n).animate({"bottom": 0}, 500);
	//显示已保存的数据
	var type = $('#'+n+'h').val();
	if(type==0){
		$('i[class*="'+n+'"]').removeClass('weui_icon_success').addClass('weui_icon_circle');
		$('.'+n+'0').removeClass('weui_icon_circle').addClass('weui_icon_success');
	}else{
		$('i[class*="'+n+'"]').removeClass('weui_icon_success').addClass('weui_icon_circle');
		$('.'+n+'1').removeClass('weui_icon_circle').addClass('weui_icon_success');
	}
	if(n=='payments'){
		var payCode = $('#'+n+'w').val();
		$('i[class*="'+n+'"]').removeClass('weui_icon_success').addClass('weui_icon_circle');
		$('.'+n+'_'+payCode).removeClass('weui_icon_circle').addClass('weui_icon_success');
	}
	if(n=='invoices'){
		if(type==0){
			$('#j-invoice').hide();
		}else{
			$('#j-invoice').show();
		}
	}
}

function dataHide(n){
	$('#'+n).animate({'bottom': '-'+dataHeight}, 500);
	$('#cover').hide();
}

function inDetermine(n){
	$('#'+n+' .weui_icon_success').each(function(){
		type = $(this).attr('mode');
		word = $(this).attr('word');
		if(n=='payments')payCode = $(this).attr('payCode');
	});
	$('#'+n+'h').val(type);
	$('#'+n+'t').html(word);
	if(n=='payments'){
		$('#'+n+'w').val(payCode);
	}
	getCartMoney();
	dataHide(n);
}


