//列表
function load(){
    $('.wst-go-list').dropload({
        scrollArea : window,
        autoLoad : true,
        threshold: 100,
        domDown : {//上拉
            domClass   : 'dropload-down',
            domRefresh : '<div class="dropload-refresh f15 "><i class="icon icon-20"></i>上拉加载更多</div>',
            domLoad    : '<div class="dropload-load f15"><span class="weui-loading"></span>正在加载中...</div>',
            domNoData  : '<div class="dropload-noData">没有更多商品了</div>'
        },
        loadDownFn : function(me){
        	var param = {};
        	param.shopId = WST.conf.SHOPID;
        	param.keyword = $('#keyword').val();
        	param.page = Number( $('#currPage').val() ) + 1;
        	param.pagesize = 10;
            $.post(WST.U('mobile/goods/pageQuery'), param,function(data){
                var json = WST.toJson(data);
                if(json.data && json.data.length>0){
        	        $('#currPage').val(json.current_page);
        	        $('#totalPage').val(json.last_page);
                    var gettpl = document.getElementById('list').innerHTML;
                    laytpl(gettpl).render(json, function(html){
                        $('#goods-list').append(html);
                        echo.init();//图片懒加载
                    });

                }else{
                    // 锁定
                    me.lock();
                    // 无数据
                    me.noData();
                }
                if(json.keylist && json.keylist.length>0){
                	$('#keylist').show();
                    var gettpl2 = document.getElementById('list2').innerHTML;
                    laytpl(gettpl2).render(json.keylist, function(html){
                        $('#keyword-list').html(html);
                        echo.init();//图片懒加载
                    });
                }else{
                	$('#keylist').hide();
                }
                // 每次数据加载完，必须重置
                me.resetload();
            });
        }
    });
}
//搜索
function search(data=''){
	if(!data){
		var data = $('#wst-search').val();
	}
	$('#wst-search').val(data)
	$('#keyword').val(data);
	$('#goods-search').val(data);
    $('#currPage').val(0);
    $('#totalPage').val(0);
    $('.wst-go-list').html('<div id="goods-list"></div>');
    $('.close-popup').trigger("click");
    load();
}
function change(obj){
	$('#goods-search').val($(obj).val());
}
$(document).ready(function(){
	load();
    $('.search-form').on('submit', '.input-form', function(event){
        event.preventDefault();
    })
});