var WST = WST?WST:{};
var lat = 0;
var longt = 0;
//定位
WST.location = function(){
	$('.wst-loading').show();
    if(navigator.geolocation){
       navigator.geolocation.getCurrentPosition(showLocation, errorHandler);
    }else{
    	//没有定位成功就使用IP定位的经纬度
    	errorHandler();
       //Sorry, browser does not support geolocation!
    }
}
function showLocation(position) {
	lat = position.coords.latitude;
	longt = position.coords.longitude;
	console.log('定位位置：'+lat+":"+longt);
	shopLocation();
}

function errorHandler(err) {
	$.showLoading('定位失败<br/>正在使用IP定位');
	//没有定位成功就使用IP定位的经纬度
    longt = WST.conf.INIT_LONGITUDE;
    lat = WST.conf.INIT_LATITUDE;
    shopLocation();
	//if(err.code == 1) {
		//Error: Access is denied!
	//}else if( err.code == 2) {
		//Error: Position is unavailable!
	//}
}
function shopLocation(){
	console.log(lat+":"+longt);
	//如果获取不到经纬度就让用户自行选择城市
	if(lat=='' || lat=='0'){
		$.showLoading('定位失败<br/>请选择城市');
		setTimeout(function(){
            location.href=WST.U('mobile/shops/index');
		},1500);
		return;
	}
    var param = {};
	param.latitude = lat;
	param.longitude = longt;
	$.post(WST.U('mobile/shops/shopLocation'), param,function(data){
	    var json = WST.toJson(data);
	    if(json.status==1){
	        window.location.reload();
	    }
	});
}
//底部的tab
WST.tabFooter = function(tab){
	$('.weui_tab').tab({
		    defaultIndex: tab,
		    activeClass:'active'
	});
}
//商品主页
WST.intoGoods = function(id){
	location.href = WST.U('mobile/goods/detail','goodsId='+id);
};
//搜索
WST.search = function(){
	var data = $('#wst-search').val();
	location.href = WST.U('mobile/goods/lists','keyword='+data);
};
WST.delKeyword = function(){
	$.confirm("确认删除全部历史记录？", "", function() {
		var param = {};
	    $.post(WST.U('mobile/goods/delKeyword'), {},function(data){
	        var json = WST.toJson(data);
	        if(json.status==1){
	        	$("#keylist").hide();
	        	$.toast("删除成功");
	        }
	    });
	}, function() {});
}
//显示指定文章
WST.articleInfo = function(id,n){
	$.post(WST.U('mobile/Articles/getById'),{id:id},function(data){
	    var json = WST.toJson(data);
	    if(json.status==1){
	    	$(n).html(json.data.articleContent);
	    }
	});
};
//刷新验证码
WST.getVerify = function(id){
    $(id).attr('src',WST.U('mobile/index/getVerify','rnd='+Math.random()));
}
//加入购物车
WST.addCart = function(id,type=0){
	var buyNum = $("#buyNum").val()?$("#buyNum").val():1;
	$.post(WST.U('mobile/carts/addCart'),{goodsId:id,buyNum:buyNum,rnd:Math.random()},function(data,textStatus){
	     var json = WST.toJson(data);
	     if(json.status==1){
	    	 $.toast(json.msg);
	    	 setTimeout(function(){
	    	 	$.hideLoading();
	    	 },300)
	    	 if(type==1){
	    		 $('.goodsNum_'+id).val(1);
	    		 $('.goods-carts'+id+' .add-cart').show();
	    		 $('.goods-carts'+id+' .cart').hide();
	    	 }
	    	 $("#cartNum").html(json.cartNum);
	     }else{
			 $.toptips(json.msg);
		 }
	});
}
//修改购物车商品状态
WST.changeCartGoods = function(id,buyNum,isCheck,type=0){
	$.post(WST.U('mobile/carts/changeCartGoods'),{id:id,isCheck:isCheck,buyNum:buyNum,type:type,rnd:Math.random()},function(data,textStatus){
	     var json = WST.toJson(data);
	     if(json.status==1){
	    	 if(type==1 && buyNum==0){
	    		 $('.goods-carts'+id+' .cart').show();
	    		 $('.goods-carts'+id+' .add-cart').hide();
	    		 var cartNum = (json.cartNum==0)?'':json.cartNum;
	    		 $("#cartNum").html(cartNum);
	    	 }
	     }else{
	    	 $.toptips(json.msg);
	     }
	});
}
//批量修改购物车状态
WST.batchChangeCartGoods = function(ids,isCheck){
	$.post(WST.U('mobile/carts/batchChangeCartGoods'),{ids:ids,isCheck:isCheck},function(data,textStatus){
	     var json = WST.toJson(data);
	     if(json.status!=1){
	    	 $.toptips(json.msg);
	     }
	});
}
//加减
WST.changeNum = function(diffNum,iptId,id){
	var suffix = (id)?"_"+id:"";
	var iptElem = $(iptId+suffix);
	var minVal = parseInt(iptElem.attr('data-min'),10);
	var maxVal = parseInt(iptElem.attr('data-max'),10);
	var num = parseInt(iptElem.val(),10);
	num = num?num:1;
	num = num + diffNum;
	if(maxVal<=num)num=maxVal;
	if(num<=minVal)num=minVal;
	iptElem.val(num);
	if(suffix!='')WST.changeCartGoods(id,num,-1,1);
}

WST.changeIptNum = function(diffNum,iptId,id,func){
	var suffix = (id)?"_"+id:"";
	var iptElem = $(iptId+suffix);
	var minVal = parseInt(iptElem.attr('data-min'),10);
	var maxVal = parseInt(iptElem.attr('data-max'),10);
	var num = parseInt(iptElem.val(),10);
	num = num?num:1;
	num = num + diffNum;
	if(maxVal<=num)num=maxVal;
	if(num<=minVal)num=minVal;
	if(num==0)num=1;
	iptElem.val(num);
	if(suffix!='')WST.changeCartGoods(id,num,-1);
	if(func){
		var fn = window[func];
		fn();
	}
}
//提示对话框
WST.dialog = function(content,event,title){
	$("#wst-di-prompt").addClass('show');
	$("#wst-dialog").html(content);
	$("#wst-dialog-title").html(title);
	$("#wst-event2").attr("onclick","javascript:"+event);
	$("#wst-di-prompt").show();
}
WST.dialogHide = function(event){
	$("#wst-di-"+event).hide();
}
//分享
WST.share = function(type){
	if(type==1){
		$('.wst-share').show().addClass('fadeIn');
	}else{
		$('.wst-share').fadeOut().removeClass('fadeOut');
	}
}
/**
* 上传图片
*/
WST.upload = function(datas,file){
    var formData = new FormData();
    //将base64编码转换为Blob
    //append函数的第一个参数是后台获取数据的参数名,在php中用$FILES['imageName']接收
    var imgSuffix = datas.img.split(";")[0].split('/')[1];
    formData.append("imageName",WST.Base64ToBlob(datas.img),"image."+imgSuffix);
    //ajax 提交form
    $.ajax({
        url : WST.U('mobile/index/uploadPic',datas.data), 
        type : "POST",
        data : formData,
        dataType:"json",
        processData : false, //不要去处理发送的数据
        contentType : false, //不要去设置Content-Type请求头
        success:function(data){
        	var json = WST.toJson(data);
        	typeof file == "function" && file(json);
        }
    });
}
/**
 * 将以base64的图片url数据转换为Blob
 * @param url
 * 用url方式表示的base64图片数据
 */
WST.Base64ToBlob = function(url){
    //去掉url的头，并转换为byte
    var bytes=window.atob(url.split(',')[1]);        
    //处理异常,将ascii码小于0的转换为大于0
    var ab = new ArrayBuffer(bytes.length);
    var ia = new Uint8Array(ab);
    for (var i = 0; i < bytes.length; i++) {
        ia[i] = bytes.charCodeAt(i);
    }
    // 此处type注意与photoClip初始化中的outputType类型保持一致
    return new Blob( [ab] , {type : 'image/jpeg'});
}
//显示隐藏
WST.showHide = function(t,str){
	var s = str.split(',');
	if(t){
		for(var i=0;i<s.length;i++){
		   $(s[i]).show();
		}
	}else{
		for(var i=0;i<s.length;i++){
		   $(s[i]).hide();
		}
	}
	s = null;
}

//只能輸入數字
WST.isNumberKey = function(evt){
	var charCode = (evt.which) ? evt.which : event.keyCode;
	if (charCode > 31 && (charCode < 48 || charCode > 57)){
		return false;
	}else{		
		return true;
	}
}  

//只能輸入數字和小數點
WST.isNumberdoteKey = function(evt){
	var e = evt || window.event; 
	var srcElement = e.srcElement || e.target;
	
	var charCode = (evt.which) ? evt.which : event.keyCode;			
	if (charCode > 31 && ((charCode < 48 || charCode > 57) && charCode!=46)){
		return false;
	}else{
		if(charCode==46){
			var s = srcElement.value;			
			if(s.length==0 || s.indexOf(".")!=-1){
				return false;
			}			
		}		
		return true;
	}
}
//只能輸入數字
WST.isChinese = function(obj,isReplace){
 	var pattern = /[\u4E00-\u9FA5]|[\uFE30-\uFFA0]/i
 	if(pattern.test(obj.value)){
 		if(isReplace)obj.value=obj.value.replace(/[\u4E00-\u9FA5]|[\uFE30-\uFFA0]/ig,"");
 		return true;
 	}
 	return false;
}
//返回当前页面高度
WST.pageHeight = function(){
	if(WST.checkBrowser().msie){ 
		return document.compatMode == "CSS1Compat"? document.documentElement.clientHeight : 
		document.body.clientHeight; 
	}else{ 
		return self.innerHeight; 
	} 
};
//返回当前页面宽度 
WST.pageWidth = function(){
	if(WST.checkBrowser().msie){ 
		return document.compatMode == "CSS1Compat"? document.documentElement.clientWidth : 
		document.body.clientWidth; 
	}else{ 
		return self.innerWidth; 
	} 
};
WST.checkBrowser = function(){
	return {
		mozilla : /firefox/.test(navigator.userAgent.toLowerCase()),
		webkit : /webkit/.test(navigator.userAgent.toLowerCase()), 
	    opera : /opera/.test(navigator.userAgent.toLowerCase()), 
	    msie : /msie/.test(navigator.userAgent.toLowerCase())
	}
}
//判断空值
WST.blank = function(str,defaultVal){
	if(str=='0000-00-00')str = '';
	if(str=='0000-00-00 00:00:00')str = '';
	if(!str)str = '';
	if(typeof(str)=='null')str = '';
	if(typeof(str)=='undefined')str = '';
	if(str=='' && defaultVal)str = defaultVal;
	return str;
}
//清空内容
WST.emptyLabel = function(t,str){
	var s = str.split(',');
	if(t=='val'){
		for(var i=0;i<s.length;i++){
		   $(s[i]).val('');
		}
	}else if(t=='html'){
		for(var i=0;i<s.length;i++){
		   $(s[i]).html('');
		}
	}
	s = null;
}
//返回键
function backPrevPage(url){
	window.location.hash = "ready";
	window.location.hash = "ok";
  setTimeout(function(){
		$(window).on('hashchange', function(e) {
			var hashName = window.location.hash.replace('#', '');
			hashName = hashName.split('&');
			if( hashName[0] == 'ready' ){
			    location.href = url;
			}
		});
  },50);
}
//滚动到顶部
WST.runToTop = function (){ 
	currentPosition=document.documentElement.scrollTop || document.body.scrollTop; 
	currentPosition-=30;
	if(currentPosition>0){
		window.scrollTo(0,currentPosition);  
	}  
	else{  
		window.scrollTo(0,0);  
		clearInterval(timer); 
	}  
}
WST.toJson = function(str,notLimit){
	var json = {};
	if(str){
	try{
		if(typeof(str )=="object"){
			json = str;
		}else{
			json = eval("("+str+")");
		}
		if(!notLimit){
			if(json.status && json.status=='-999'){
				WST.inLogin();
			}
		}
	}catch(e){
		alert("系统发生错误:"+e.getMessage);
		json = {};
	}
	return json;
	}else{
		return;
	}
}
//登录
WST.inLogin = function(){
	window.location.href = WST.U('mobile/users/login');
}
$(function(){
	echo.init();//图片懒加载
    // 滚动到顶部	
    $(window).scroll(function(){
        if( $(window).scrollTop() > 200 ){
            $('.wst-totop').show();
        }else{
            $('.wst-totop').hide();
        }
    });
    $('.wst-totop').on('click', function() {
    	timer=setInterval("WST.runToTop()",1);
	});
	/**
	 * 获取WSTMart基础配置
	 * @type {object}
	 */
	WST.conf = window.conf;
	/* 基础对象检测 */
	WST.conf || $.error("WSTMart基础配置没有正确加载！");
	/**
	 * 解析URL
	 * @param  {string} url 被解析的URL
	 * @return {object}     解析后的数据
	 */
	WST.parse_url = function(url){
		var parse = url.match(/^(?:([a-z]+):\/\/)?([\w-]+(?:\.[\w-]+)+)?(?::(\d+))?([\w-\/]+)?(?:\?((?:\w+=[^#&=\/]*)?(?:&\w+=[^#&=\/]*)*))?(?:#([\w-]+))?$/i);
		parse || $.error("url格式不正确！");
		return {
			"scheme"   : parse[1],
			"host"     : parse[2],
			"port"     : parse[3],
			"path"     : parse[4],
			"query"    : parse[5],
			"fragment" : parse[6]
		};
	}

	WST.parse_str = function(str){
		var value = str.split("&"), vars = {}, param;
		for(var i=0;i<value.length;i++){
			param = value[i].split("=");
			vars[param[0]] = param[1];
		}
		return vars;
	}
	WST.U = function(url, vars){
		if(!url || url=='')return '';
		var info = this.parse_url(url), path = [], reg;
		/* 验证info */
		info.path || $.error("url格式错误！");
		url = info.path;
		/* 解析URL */
		path = url.split("/");
		path = [path.pop(), path.pop(), path.pop()].reverse();
		path[1] || $.error("WST.U(" + url + ")没有指定控制器");

		/* 解析参数 */
		if(typeof vars === "string"){
			vars = this.parse_str(vars);
		}
		/* 解析URL自带的参数 */
		info.query && $.extend(vars, this.parse_str(info.query));
		if(false !== WST.conf.SUFFIX){
			url += "." + WST.conf.SUFFIX;
		}
		if($.isPlainObject(vars)){
			url += "?" + $.param(vars);
		}
		//url = url.replace(new RegExp("%2F","gm"),"+");
		url = WST.conf.APP + "/"+url;
		return url;
	}
	WST.AU = function(url, vars){
        if(!url || url=='')return '';
        var info = this.parse_url(url);
        url = info.path;
        path = url.split("/");
        url = "addon/";
        path = [path.pop(), path.pop()].reverse();
        path[0] || $.error("WST.AU(" + url + ")没有指定控制器");
        path[1] || $.error("WST.AU(" + url + ")没有指定接口");
        url  = url + info.scheme + "-" + path.join('-');
        /* 解析参数 */
		if(typeof vars === "string"){
			vars = this.parse_str(vars);
		}
		info.query && $.extend(vars, this.parse_str(info.query));
		if(false !== WST.conf.SUFFIX){
			url += "." + WST.conf.SUFFIX;
		}
		if($.isPlainObject(vars)){
			url += "?" + $.param(vars);
		}
		return WST.conf.APP + "/"+url;
	}
});

//首页
WST.intoIndex = function(){
	location.href = WST.U('mobile/index/index',true);
};


WST.showDialog = function(objId){
	$('#'+objId).addClass('show').removeClass('hide');
	$('.wst-mask').show();
}
WST.hideDialog = function(objId){
	$('#'+objId).addClass('hide').removeClass('show');
	$('.wst-mask').hide();
}
