<?php
namespace wststore\mobile\model;
use wststore\common\model\Users as CUsers;
use think\Db;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 用户类
 */
class Users extends CUsers{
	protected $pk = 'userId';
	/**
	 * 用户自动登录
	 */
	public function accordLogin(){
		$wxOpenId = session('WST_WX_OPENID');
		$rs = $this->where(["dataFlag"=>1, "userStatus"=>1,"wxOpenId"=>$wxOpenId])->order('lastTime desc')->find();
		if(!empty($rs)){
			$userId = $rs['userId'];
			//获取用户等级
			$rrs = WSTUserRank($rs['userTotalScore']);
			$rs['rankId'] = $rrs['rankId'];
			$rs['rankName'] = $rrs['rankName'];
			$rs['userrankImg'] = $rrs['userrankImg'];
			$rs['wxOpenId'] = session('WST_WX_OPENID');
			$ip = request()->ip();
			$update = [];
			$update = ["lastTime"=>date('Y-m-d H:i:s'),"lastIP"=>$ip];
			$update['wxOpenId'] = $wxOpenId;
			$this->where(["userId"=>$userId])->update($update);
			//记录登录日志
			$data = array();
			$data["userId"] = $userId;
			$data["loginTime"] = date('Y-m-d H:i:s');
			$data["loginIp"] = $ip;
			$data['loginSrc'] = 1;
			Db::name('log_user_logins')->insert($data);
			session('WST_USER',$rs);
			return WSTReturn("","1");
		}
		return WSTReturn("用户不存在");
	}
	/**
	 * 用户自动注册
	 */
	public function accordRegist(){
		$wxOpenId = session('WST_WX_OPENID');
		$rs = $this->where(["dataFlag"=>1, "userStatus"=>1,"wxOpenId"=>$wxOpenId])->order('lastTime desc')->find();
		if(empty($rs)){
			$loginName = time();
			$loginName = WSTRandomLoginName($loginName);
			if($loginName=='')return WSTReturn("注册失败!");//分派不了登录名
			$data['loginName'] = $loginName;
			//检测账号，邮箱，手机是否存在
			$data["loginSecret"] = rand(1000,9999);
			$data['loginPwd'] = '';
			$data['userType'] = 0;
			$data['userName'] = '用户';
			$data['userQQ'] = "";
			$data['userScore'] = 0;
			$data['createTime'] = date('Y-m-d H:i:s');
			$data['dataFlag'] = 1;
			$data['wxOpenId'] = session('WST_WX_OPENID');
			$userinfo = session('WST_WX_USERINFO');
			if($userinfo){
				$nickname = json_encode($userinfo['nickname']);
				$nickname = preg_replace("/\\\u[ed][0-9a-f]{3}\\\u[ed][0-9a-f]{3}/","*",$nickname);//替换成*
				$nickname = json_decode($nickname);
				$data['userName'] = $nickname;
				$data['userSex'] = $userinfo['sex'];
				$data['userPhoto'] = $userinfo['headimgurl'];
				// 保存unionId【若存在】 详见 unionId说明 https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140839
				$data['wxUnionId'] = isset($userinfo['unionid'])?$userinfo['unionid']:'';
			}
			Db::startTrans();
			try{
				$userId = $this->data($data)->save();
				if(false !== $userId){
					$data = array();
					$ip = request()->ip();
					$data['lastTime'] = date('Y-m-d H:i:s');
					$data['lastIP'] = $ip;
					$userId = $this->userId;
					$this->where(["userId"=>$userId])->update($data);
					//记录登录日志
					$data = array();
					$data["userId"] = $userId;
					$data["loginTime"] = date('Y-m-d H:i:s');
					$data["loginIp"] = $ip;
					$data['loginSrc'] = 1;
					Db::name('log_user_logins')->insert($data);
					$user = $this->get(['userId'=>$userId]);
					if($user['userPhoto']=='')$user['userPhoto'] = WSTConf('CONF.userLogo');
					session('WST_USER',$user);
					//发送用户注册消息
	                $tpl = WSTMsgTemplates('USER_REGISTER');
	                if( $tpl['tplContent']!='' && $tpl['status']=='1'){
	                    $find = ['${MALL_NAME}','${LOGIN_NAME}'];
	                    $replace = [WSTConf('CONF.mallName'),$nickname];
					    WSTSendMsg($userId,str_replace($find,$replace,$tpl['tplContent']),['from'=>0,'dataId'=>0]);
	                }
					Db::commit();
					return WSTReturn("",1);
				}
			}catch (\Exception $e) {
				Db::rollback();
			}
		}
		return WSTReturn("注册失败");
	}
}
