<?php
namespace wststore\mobile\model;
use think\Db;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 默认类
 */
class Index extends Base{
	/**
	 * 楼层
	 */
	public function pageQuery(){
		$shopId = (int)input('shopId');
		$rs = Db::name('goods_libs')->alias('gl')->join('__GOODS__ g','gl.goodsLibId=g.goodsLibId','left')->join('__SHOPS__ s','g.shopId=s.shopId')
		->where(['g.isSale'=>1,'gl.isSale'=>1,'gl.dataFlag'=>1,'g.isRecom'=>1,'s.shopId'=>$shopId])
		->field('g.goodsLibId,s.shopId,g.goodsId,gl.goodsName,gl.goodsImg,gl.goodsSn,g.goodsStock,g.saleNum,g.shopPrice,g.costPrice,g.visitNum,g.goodsStock')
		->order('saleNum desc,g.goodsId asc')->paginate(input('pagesize/d'))->toArray();
		return $rs;
	}

	public function location(){
		$lat = (float)input("latitude");
		$lng = (float)input("longitude");
		if($lat && $lng){
			$data['types'] = 1;
		}else{
			//ip定位
			$ipLocation =  WSTIpLocation();
			$lat = $ipLocation['latitude'];
			$lng = $ipLocation['longitude'];
			$data['types'] = 0;
		}
		$rs = WSTLatLngAddress($lat,$lng);
		if($rs['status']==0){
			$data['latitude'] = $lat;
			$data['longitude'] = $lng;
			$data['address'] = $rs['result']['formatted_addresses']['recommend'];
			$data['city'] = $rs['result']['address_component']['city'];
			$data['district'] = $rs['result']['address_component']['district'];
			$data['detailed'] = $rs['result']['address'];
			$data['areaId2'] = 0;
			$areas = Db::name('areas')->where("isShow=1 and dataFlag = 1 and areaType=1 and areaName like '%".$data['city']."%'")->order('areaKey asc')->find();
			if($areas)$data['areaId2'] = $areas['areaId'];
			$data['areaId3'] = 0;
			$areas = Db::name('areas')->where("isShow=1 and dataFlag = 1 and areaType=2 and areaName like '%".$data['district']."%'")->order('areaKey asc')->find();
			if($areas)$data['areaId3'] = $areas['areaId'];
			return jsonReturn('success',1,$data);
		}else{
			return jsonReturn('无法定位',-1);
		}
	}
	/**
	 * 获取系统消息
	 */
	function getSysMsg($msg=''){
		$data = [];
		$userId = (int)session('WST_USER.userId');
		if(in_array("msg",$msg)){
			$data['message']['num'] = Db::name('messages')->where(['userId'=>$userId,'msgStatus'=>0,'dataFlag'=>1])->count();
		}
		if(in_array("order",$msg)){
			$data['order']['waitpay'] = Db::name('orders')->where(['userId'=>$userId,'orderStatus'=>-2,'dataFlag'=>1])->count();
			$data['order']['waitdeliver'] = Db::name('orders')->where(['userId'=>$userId,'orderStatus'=>0,'deliverType'=>0,'dataFlag'=>1])->count();
			$data['order']['waitreceive'] = Db::name('orders')->where(['userId'=>$userId,'orderStatus'=>1,'dataFlag'=>1])->count();
			$data['order']['waitpick'] = Db::name('orders')->where(['userId'=>$userId,'orderStatus'=>0,'deliverType'=>1,'dataFlag'=>1])->count();
			$data['order']['waitrefund'] = Db::name('orders')->where([['userId','=',$userId],['orderStatus','in',[-1,-3]],['payType','=',1],['isPay','=',1],['dataFlag','=',1]])->count();
		}
		return $data;
	}
}
