<?php
namespace wststore\mobile\model;
use think\Db;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 商品类
 */
class Goods extends Base{
	/**
	 * 获取列表
	 */
	public function pageQuery(){
		$shopId = (int)input('shopId');
		$catId = (int)input('catId');
		$keyword = input('keyword');
		$where = $where2 = [];
		$where['g.isSale'] = 1;
		$where['g.isRecom'] = 1;
		$where['gl.isSale'] = 1;
		$where['gl.dataFlag'] = 1;
		$where['g.shopId'] = $shopId;
		if($catId>0)$where['gl.goodsCatId'] = $catId;
		if($keyword!=''){
			$where2 = $this->getKeyWords($keyword);
			$history = cookie("wx_history_keyword");
			$history = is_array($history)?$history:[];
			unset($history[$keyword]);
			$history[$keyword] = $keyword;
			if(!empty($history)){
				cookie("wx_history_keyword",$history,25920000);
			}
		}
		$rs = Db::name('goods_libs')->alias('gl')->join('__GOODS__ g','gl.goodsLibId=g.goodsLibId','left')
		->where($where)->where($where2)
		->field('g.goodsLibId,g.shopId,g.goodsId,gl.goodsName,gl.goodsImg,gl.goodsSn,g.goodsStock,g.saleNum,g.shopPrice,g.costPrice,g.visitNum')
		->order('saleNum desc,g.goodsId asc')->paginate(input('pagesize/d'))->toArray();
		return $rs;		
	}
	/**
	 * 关键字
	 */
	public function getKeyWords($name){
		$words = WSTAnalysis($name);
		if(!empty($words)){
			$str = [];
			if(count($words)==1){
				$str[] = ['gl.goodsSerachKeywords','LIKE','%'.$words[0].'%'];
			}else{
				foreach ($words as $v){
					$str[] = ['gl.goodsSerachKeywords','LIKE','%'.$v.'%'];
				}
			}
			return $str;
		}
		return "";
	}
	/**
	 * 获取商品资料在前台展示
	 */
	public function getBySale($goodsId){
		$key = input('key');
		// 浏览量
		Db::name('goods_libs')->where('goodsLibId',$goodsId)->setInc('visitNum',1);
		$rs = Db::name('goods')->alias('g')->join('__GOODS_LIBS__ gl','gl.goodsLibId=g.goodsLibId','left')
		->where(['goodsId'=>$goodsId,'dataFlag'=>1])
		->field('g.goodsId,g.costPrice,g.goodsStock,g.shopPrice,g.goodsLibId,gl.goodsImg,gl.goodsName,gl.goodsDesc,gl.gallery,gl.goodsUnit')
		->find();
		if(!empty($rs)){
			$gallery = [];
			$gallery[] = $rs['goodsImg'];
			if($rs['gallery']!=''){
				$tmp = explode(',',$rs['gallery']);
				$gallery = array_merge($gallery,$tmp);
			}
			$rs['gallery'] = $gallery;
			//获取商品属性
			$rs['attrs'] = Db::name('attributes')->alias('a')->join('goods_attributes ga','a.attrId=ga.attrId','inner')
			->where(['a.isShow'=>1,'dataFlag'=>1,'goodsLibId'=>$rs['goodsLibId']])->field('a.attrName,ga.attrVal')
			->order('attrSort asc')->select();

		}
		return $rs;
	}
}