<?php
namespace wststore\mobile\model;
use think\Db;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 *  文章类
 */
class Articles extends Base{
	/**
	*  根据id获取资讯文章
	*/
	public function getById(){
		$id = (int)input('id');
		$rs = $this->where('dataFlag=1 and isShow=1 and articleId='.$id)->cache(true)->find();
        return $rs;
	}
	/**
	 *  根据catId获取文章列表
	 */
	public function getArticles($catId){
		$data = $this->getArticleCats();
		$ids = [];
		if(isset($data[$catId])){
			foreach($data[$catId] as $key =>$v){
				$ids[] = $v['catId'];
			}
		}
		$rs = $this->where([['dataFlag','=',1],['isShow','=',1],['catId','in',$ids]])
		->order('catSort asc,createTime desc')->cache(true)->select();
		return $rs;
	}
	/**
	 * 获取文章分类
	 */
	public function getArticleCats(){
		$data = cache('WST_ARTICLE_CATS');
		if(!$data){
			$data = [];
			$rs = Db::name('article_cats')->where(['dataFlag'=>1])->order('catSort asc')->select();
			if($rs){
				foreach($rs as $key =>$v){
					$data[$v['parentId']][] = $v;
				}
			}
			cache('WST_ARTICLE_CATS',$data);
		}
		return $data;
	}
}
