<?php
namespace wststore\mobile\controller;
use wststore\common\model\Orders as OM;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 余额控制器
 */
class Wallets extends Base{
	// 前置方法执行列表
	protected $beforeActionList = [
			'checkAuth'
	];
	/**
	 * 跳去支付页面
	 */
	public function toPay(){
		$pkey = WSTBase64urlDecode(input("pkey"));
		$pkey = explode('@',$pkey);
        $user = [];
        $user['userId'] = (int)session('WST_USER.userId');
        $user["orderId"] = (int)$pkey[0];
        $this->assign('user',$user);
		$m = new OM();
		$data = $m->getByUnique('1',0,$user["orderId"]);
		$this->assign('data',$data);
		$rs = $m->getPayOrders($user);
		if(empty($rs['needPay'])){
			$this->assign('type','');
			return $this->fetch("users/orders/list");
		}else{
			$this->assign('needPay',$rs['needPay']);
			//获取用户钱包
			$userInfo = model('users')->getFieldsById($user['userId'],'userMoney,payPwd');
			$this->assign('userMoney',$userInfo['userMoney']);
        	$payPwd = empty($userInfo['payPwd'])?0:1;
			$this->assign('payPwd',$payPwd);
	    }
	    return $this->fetch('users/orders/pay_wallets');
	}
	/**
	 * 钱包支付
	 */
	public function payByWallet(){
		$m = new OM();
		return $m->payByWallet();
	}
}
