<?php
namespace wststore\mobile\controller;
use wststore\mobile\model\Users as M;
use wststore\common\model\LogSms;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 用户控制器
 */
class Users extends Base{
	// 前置方法执行列表
	protected $beforeActionList = [
		'checkAuth' => ['except'=>'login,checklogin,register,regist,checkuserphone,phonecode']
	];
	/**
	 * 会员中心
	 */
	public function index(){
		$userId = session('WST_USER.userId');
		$m = new M();
		$user = $m->getById($userId);
		if($user['userName']=='')$user['userName']=$user['loginName'];
		$this->assign('user', $user);
		//商城未读消息的数量 及 各订单状态数量
		$msg = model('index')->getSysMsg(['msg','order']);
		$this->assign('msg',$msg);
		return $this->fetch('users/index');
	}
	/**
	 * 会员登录页
	 */
	public function login(){
		$USER = session('WST_USER');
		if(!empty($USER) && $USER['userId']!=''){
			$this->redirect("users/index");
		}
		$userinfo = session('WST_WX_USERINFO');
		$this->assign('info',$userinfo);
		return $this->fetch('login');
	}
	/**
	 * 会员登录
	 */
	public function checkLogin(){
		$m = new M();
		$rs =  $m->checkLogin(1);
		$rs['url'] = session('WST_REFER_URL');
		return $rs;
	}
	/**
	 * 会员注册页
	 */
	public function register(){
		return $this->fetch('register');
	}
	/**
	 * 会员注册
	 */
	public function regist(){
		$m = new M();
		$rs =  $m->regist(1);
		$rs['url'] = session('WST_REFER_URL');
		return $rs;
	}
	/**
	 * 手机号码是否存在
	 */
	public function checkUserPhone(){
		$userPhone = input("post.userPhone");
		$m = new M();
		$rs = $m->checkUserPhone($userPhone,(int)session('WST_USER.userId'));
		if($rs["status"]==1){
			return WSTReturn("",1);
		}else{
			return WSTReturn("手机号已注册",-1);
		}
	}
	/**
	 * 获取验证码
	 */
	public function phoneCode(){
		$userPhone = input("post.userPhone");
		$rs = array();
		if(!WSTIsPhone($userPhone)){
			return WSTReturn("手机号格式不正确!");
		}
		$m = new M();
		$rs = $m->checkUserPhone($userPhone,(int)session('WST_USER.userId'));
		if($rs["status"]!=1){
			return WSTReturn("手机号已存在!");
		}
		$phoneVerify = rand(100000,999999);
		$tpl = WSTMsgTemplates('PHONE_USER_REGISTER_VERFIY');
		if($tpl['tplContent']!='' && $tpl['status']=='1'){
			$params = ['tpl'=>$tpl,'params'=>['MALL_NAME'=>WSTConf("CONF.mallName"),'VERFIY_CODE'=>$phoneVerify,'VERFIY_TIME'=>10]];
			$m = new LogSms();
			$rv = $m->sendSMS(0,$userPhone,$params,'getPhoneVerifyCode',$phoneVerify);
		}
		if($rv['status']==1){
			session('VerifyCode_userPhone',$userPhone);
			session('VerifyCode_userPhone_Verify',$phoneVerify);
			session('VerifyCode_userPhone_Time',time());
		}
		return $rv;
	}
	/**
	 * 设置支付密码
	 */
	public function editPayPass(){
		$m = new M();
		$userId = (int)session('WST_USER.userId');
		return $m->editPayPass($userId);
	}
	public function editpayPwd(){
		$m = new M();
		$userId = (int)session('WST_USER.userId');
		return $m->editPayPass($userId);
	}
	/**
	 * 更多
	 */
	public function more(){
		$m = new M();
		return $this->fetch('users/more/list');
	}
	/**
	 * 账户安全
	 */
	public function security(){
		$m = new M();
		$userId = (int)session('WST_USER.userId');
		$rs = $m->getById($userId);
		$payPwd = $rs['payPwd'];
		$userPhone = $rs['userPhone'];
		$user['payPwd'] = empty($payPwd)?0:1;
		$user['userPhone'] = empty($userPhone)?0:1;
		$this->assign('user', $user);
		return $this->fetch('users/security/list');
	}
	/**
	 * 支付密码
	 */
	public function passPay(){
		$m = new M();
		$userId = (int)session('WST_USER.userId');
		$rs = $m->getById($userId);
		$payPwd = $rs['payPwd'];
		$user['payPwd'] = empty($payPwd)?0:1;
		$this->assign('user', $user);
		return $this->fetch('users/security/pass_pay');
	}
	/**
	 * 忘记支付密码
	 */
	public function backPayPass(){
		$m = new M();
		$userId = (int)session('WST_USER.userId');
		$rs = $m->getById($userId);
		$userPhone = $rs['userPhone'];
		$user['userPhone'] = WSTStrReplace($rs['userPhone'],'*',3);
		$user['phoneType'] = empty($userPhone)?0:1;
		$backType = (int)session('Type_backPaypwd');
		$timeVerify = session('Verify_backPaypwd_Time');
		$user['backType'] = ($backType==1 && time()<floatval($timeVerify)+10*60)?1:0;
		$this->assign('user', $user);
		return $this->fetch('users/security/back_paypwd');
	}
	/**
	 * 忘记支付密码：发送短信
	 */
	public function backpayCode(){
		$m = new M();
		$data = $m->getById(session('WST_USER.userId'));
		$userPhone = $data['userPhone'];
		$phoneVerify = rand(100000,999999);
		$rv = ['status'=>-1,'msg'=>'短信发送失败'];
		$tpl = WSTMsgTemplates('PHONE_FOTGET_PAY');
		if($tpl['tplContent']!='' && $tpl['status']=='1'){
			$params = ['tpl'=>$tpl,'params'=>['LOGIN_NAME'=>$data['loginName'],'VERFIY_CODE'=>$phoneVerify,'VERFIY_TIME'=>10]];
			$m = new LogSms();
			$rv = $m->sendSMS(0,$userPhone,$params,'getPhoneVerifyt',$phoneVerify);
		}
		if($rv['status']==1){
			$USER = [];
			$USER['userPhone'] = $userPhone;
			$USER['phoneVerify'] = $phoneVerify;
			session('Verify_backPaypwd_info',$USER);
			session('Verify_backPaypwd_Time',time());
			return WSTReturn('发送成功',1);
		}
		return $rv;
	}
	/**
	 * 忘记支付密码：验证短信
	 */
	public function verifybackPay(){
		$phoneVerify = input("post.phoneCode");
		$timeVerify = session('Verify_backPaypwd_Time');
		if(!session('Verify_backPaypwd_info.phoneVerify') || time()>floatval($timeVerify)+10*60){
			return WSTReturn("校验码已失效，请重新发送！");
		}
		if($phoneVerify==session('Verify_backPaypwd_info.phoneVerify')){
			session('Type_backPaypwd',1);
			return WSTReturn("验证成功",1);
		}
		return WSTReturn("校验码不一致，请重新输入！");
	}
	/**
	 * 忘记支付密码：重置密码
	 */
	public function resetbackPay(){
		$m = new M();
		return $m->resetbackPay();
	}
	/**
	 * 修改手机
	 */
	public function editphone(){
		$m = new M();
		$userId = (int)session('WST_USER.userId');
		$rs = $m->getById($userId);
		$userPhone = $rs['userPhone'];
		$user['userPhone'] = WSTStrReplace($rs['userPhone'],'*',3);
		$user['phoneType'] = empty($userPhone)?0:1;
		$this->assign('user', $user);
		session('Edit_userPhone_Time', null);
		return $this->fetch('users/security/phone');
	}
	/**
	 * 绑定手机：发送短信验证码
	 */
	public function codeBindingPhone(){
		$userPhone = input("post.userPhone");
		if(!WSTIsPhone($userPhone)){
			return WSTReturn("手机号格式不正确!");
			exit();
		}
		$rs = array();
		$m = new M();
		$rs = WSTCheckLoginKey($userPhone,(int)session('WST_USER.userId'));
		if($rs["status"]!=1){
			return WSTReturn("手机号已存在!");
			exit();
		}
		$data = $m->getById(session('WST_USER.userId'));
		$phoneVerify = rand(100000,999999);
		$rv = ['status'=>-1,'msg'=>'短信发送失败'];
		$tpl = WSTMsgTemplates('PHONE_BIND');
		if($tpl['tplContent']!='' && $tpl['status']=='1'){
			$params = ['tpl'=>$tpl,'params'=>['LOGIN_NAME'=>$data['loginName'],'VERFIY_CODE'=>$phoneVerify,'VERFIY_TIME'=>10]];
			$m = new LogSms();
			$rv = $m->sendSMS(0,$userPhone,$params,'sendCodeTie',$phoneVerify);
		}
		if($rv['status']==1){
			$USER = [];
			$USER['userPhone'] = $userPhone;
			$USER['phoneVerify'] = $phoneVerify;
			session('Verify_info',$USER);
			session('Verify_userPhone_Time',time());
			return WSTReturn('发送成功',1);
		}
		return $rv;
	}
	/**
	 * 绑定手机
	 */
	public function phoneBinding(){
		$phoneVerify = input("post.phoneCode");
		$timeVerify = session('Verify_userPhone_Time');
		if(!session('Verify_info.phoneVerify') || time()>floatval($timeVerify)+10*60){
			return WSTReturn("校验码已失效，请重新发送！");
		}
		if($phoneVerify==session('Verify_info.phoneVerify')){
			$m = new M();
			$rs = $m->editPhone((int)session('WST_USER.userId'),session('Verify_info.userPhone'));
			return $rs;
		}
		return WSTReturn("校验码不一致，请重新输入！");
	}
	/**
	 * 修改手机：发送短信验证码
	 */
	public function codeEditPhone(){
		$m = new M();
		$data = $m->getById(session('WST_USER.userId'));
		$userPhone = $data['userPhone'];
		$phoneVerify = rand(100000,999999);
		$rv = ['status'=>-1,'msg'=>'短信发送失败'];
		$tpl = WSTMsgTemplates('PHONE_EDIT');
		if($tpl['tplContent']!='' && $tpl['status']=='1'){
			$params = ['tpl'=>$tpl,'params'=>['LOGIN_NAME'=>$data['loginName'],'VERFIY_CODE'=>$phoneVerify,'VERFIY_TIME'=>10]];
			$m = new LogSms();
			$rv = $m->sendSMS(0,$userPhone,$params,'getPhoneVerifyt',$phoneVerify);
		}
		if($rv['status']==1){
			$USER = [];
			$USER['userPhone'] = $userPhone;
			$USER['phoneVerify'] = $phoneVerify;
			session('Verify_info2',$USER);
			session('Verify_userPhone_Time2',time());
			return WSTReturn('发送成功',1);
		}
		return $rv;
	}
	/**
	 * 修改手机
	 */
	public function phoneEdit(){
		$phoneVerify = input("post.phoneCode");
		$timeVerify = session('Verify_userPhone_Time2');
		if(!session('Verify_info2.phoneVerify') || time()>floatval($timeVerify)+10*60){
			return WSTReturn("校验码已失效，请重新发送！");
		}
		if($phoneVerify==session('Verify_info2.phoneVerify')){
			session('Edit_userPhone_Time',time());
			return WSTReturn("验证成功",1);
		}
		return WSTReturn("校验码不一致，请重新输入！");
	}
	public function editphones(){
		$m = new M();
		$userId = (int)session('WST_USER.userId');
		$user = $m->getById($userId);
		$userPhone = $user['userPhone'];
		$user['userPhone'] = WSTStrReplace($user['userPhone'],'*',3);
		$timeVerify = session('Edit_userPhone_Time');
		if(time()>floatval($timeVerify)+15*60){
			$user['phoneType'] = 1;
		}else{
			$user['phoneType'] = 0;
		}
		$this->assign('user', $user);
		return $this->fetch('users/security/phone');
	}

    /**
     * 用户退出
     */
    public function logout(){
        session('WST_USER',null);
        return WSTReturn("",1);
    }
}
