<?php
namespace wststore\mobile\controller;
use wststore\mobile\model\Shops as M;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 门店控制器
 */
class Shops extends Base{
	/**
     * 门店
     */
    public function index(){
        //获取省级地区信息
        $area = model('mobile/Areas')->getCitys();
        $areaList = [];
        if(isset($area)){
            foreach ($area as $key =>$v){
                $areaList[$v['areaKey']][] = $v;
            }
        }
        $this->assign('area',$areaList);
    	return $this->fetch('shop_switch');
    }
    /**
     * 列表
     */
    public function pageQuery(){
    	$s = model('shops');
    	$rs = $s->pageQuery();
    	if(isset($rs['data'])){
    		foreach ($rs['data'] as $key =>$v){
    			$rs['data'][$key]['shopImg'] = WSTImg($v['shopImg'],3,'shopLogo');
    			$rs['data'][$key]['serviceStartTime'] = date('H:i',strtotime($v['serviceStartTime']));
    			$rs['data'][$key]['serviceEndTime'] = date('H:i',strtotime($v['serviceEndTime']));
    		}
    	}
    	return $rs;
    }
    /**
     * 保存门店
     */
    public function shopSwitch(){
    	$s = new M();
        $rs = $s->shopSwitch();
        return $rs;
    }
    /**
     * 定位最近门店
     */
    public function shopLocation(){
    	$s = new M();
    	$rs = $s->shopLocation();
    	return $rs;
    }
    /**
     * 获取门店信息
     */
    public function getById(){
    	$m = new M();
    	$long = (float)input("longitude",0);
    	$lat = (float)input("latitude",0);
    	$rs = $m->getFieldsById((int)input('post.shopId/d'),"shopName,shopAddress,latitude,longitude,shopTel,serviceStartTime,serviceEndTime,round(6378.138*2*asin(sqrt(pow(sin( (".$lat."*pi()/180-latitude*pi()/180)/2),2)+cos(".$lat."*pi()/180)*cos(latitude*pi()/180)* pow(sin( (".$long."*pi()/180-longitude*pi()/180)/2),2)))*1000)/1000 as distince");
    	return WSTReturn("",1,$rs);
    }
}
