<?php
namespace wststore\mobile\controller;
use wststore\common\model\Orders as M;
use wststore\common\model\Payments;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 订单控制器
 */
class Orders extends Base{
	// 前置方法执行列表
    protected $beforeActionList = [
        'checkAuth'
    ];
	/**
	 * 提交订单
	 */
	public function submit(){
		$m = new M();
		$rs = $m->submit(1);
		if($rs["status"]==1){
			$pkey = WSTBase64urlEncode($rs["data"]."@1");
			$rs["pkey"] = $pkey;
		}
		return $rs;
	}
	/**
	 * 订单管理
	 */
	public function index(){
		$type = input('param.type','');
		$this->assign('type',$type);
		return $this->fetch("users/orders/list");
	}
	/**
	 * 订单列表
	 */
	public function orderList(){
		$flag = -1;
		$deliver = -1;
		$type = strtolower(input('param.type'));
		$status = [];
		switch ($type) {
			case 'waitpay':
				$status=[-2];
				break;
			case 'waitdeliver':
				$status=[0];
				$deliver = 0;
				break;
			case 'waitreceive':
				$status=[1];
				$deliver = 0;
				break;
			case 'finish':
				$status=[2];
				break;
			case 'waitcarry':
				$status=[0];
				$deliver = 1;
				break;
			default:
				$status=[-3,-2,-1,0,1,2];
				break;
		}
		$m = new M();
		$rs = $m->userOrdersByPage($status,$flag,$deliver);
		foreach($rs['data'] as $k=>$v){
			if(!empty($v['list'])){
				foreach($v['list'] as $k1=>$v1){
					$rs['data'][$k]['list'][$k1]['goodsImg'] = WSTImg($v1['goodsImg'],3,'goodsLogo');
				}
			}
			$rs['data'][$k]['totalGoodsNum'] = count($v['list']);
		}
		return $rs;
	}
	public function refund(){
		$type = input('param.type','');
		$this->assign('type',$type);
		return $this->fetch("users/orders/list_refund");
	}
	/**
	 * 退款订单列表
	 */
	public function orderRefundList(){
		$m = new M();
		$rs = $m->userOrderRefundByPage();
		foreach($rs['data'] as $k=>$v){
			if(!empty($v['list'])){
				foreach($v['list'] as $k1=>$v1){
					$rs['data'][$k]['list'][$k1]['goodsImg'] = WSTImg($v1['goodsImg'],3,'goodsLogo');
				}
			}
			$rs['data'][$k]['totalGoodsNum'] = count($v['list']);
		}
		return $rs;
	}
	/**
	 * 订单详情
	 */
	public function getDetail(){
		$m = new M();
		$rs = $m->getByView((int)input('id'));
		if(isset($rs['orderNo'])){
			$rs['status'] = WSTLangOrderStatus($rs['orderStatus']);
			$rs['payInfo'] = WSTLangPayType($rs['payType']);
			$rs['deliverInfo'] = WSTLangDeliverType($rs['deliverType']);
			foreach($rs['goods'] as $k=>$v){
				$v['goodsImg'] = WSTImg($v['goodsImg'],3,'goodsLogo');
			}
			hook('mobileDocumentOrderSummaryView',['rs'=>&$rs]);
			return WSTReturn("",1,$rs);
		}else{
			return WSTReturn("无相关信息",-1);
		}
	}
	/**
	 * 用户确认收货
	 */
	public function receive(){
		$m = new M();
		$rs = $m->receive();
		return $rs;
	}
	/**
	 * 用户取消订单
	 */
	public function cancel(){
		$m = new M();
		$rs = $m->cancel();
		return $rs;
	}
	/**
	 * 用户拒收订单
	 */
	public function reject(){
		$m = new M();
		$rs = $m->reject();
		return $rs;
	}
	/**
	 * 在线支付方式
	 */
	public function payMode(){
		//获取支付方式
		$pa = new Payments();
		$payments = $pa->getByGroup('2');
		$this->assign('payments',$payments);
		$this->assign('pkey',input("pkey"));
		return $this->fetch("users/orders/pay_list");
	}
	/**
	 * 用户评价页
	 */
	public function orderAppraise(){
		$m = new M();
		$orderId = (int)input('id');
		$data = $m->getOrderInfoAndAppr();
		$this->assign('data',$data);
		$this->assign('orderId',$orderId);
		return $this->fetch('users/orders/appraises');
	}

    /**
     * 用户-评价详情页
     */
    public function orderAppraiseDetail(){
        $m = model('Orders');
        $oId = (int)input('orderId');
        //根据订单id,订单商品id获取 商品信息
        $data = $m->getOrderInfoByGoodsId();
        $this->assign('data',$data);
        $this->assign('orderId',$oId);
        return $this->fetch('users/orders/orders_appraises_detail');
    }
}
