<?php
namespace wststore\mobile\controller;
use wststore\mobile\model\GoodsCats as M;
use wststore\common\model\Tags;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 商品分类控制器
 */
class GoodsCats extends Base{
	/**
     * 分类
     */
    public function index(){
    	$m = new M();
    	$list = $m->getGoodsCats();
    	$this->assign('list',$list);
    	$this->assign("keylist", cookie("wx_history_keyword"));
        return $this->fetch('category');
    }
    /**
     * 列表
     */
    public function pageQuery(){
    	$rs = model('goods')->pageQuery();
    	$rs['carts'] = model('carts')->cartGoodsNum();
    	if($rs['current_page']==1){
    		$t = new Tags();
    		$floor = (int)input('floor');
    		$shopId = (int)input('shopId');
    		$rs['ads'] = $t->listAds('mo-category-'.$floor,6,$shopId,86400);
    	}
    	$rs['keylist'] = [];
    	$keylist = cookie("wx_history_keyword");
    	if($keylist){
    		foreach ($keylist as $key =>$v){
    			$rs['keylist'][] = $v;
    		}
    	}
    	if(isset($rs['data'])){
    		foreach ($rs['data'] as $key =>$v){
    			$rs['data'][$key]['goodsImg'] = WSTImg($v['goodsImg'],3,'goodsLogo');
    		}
    	}
        hook('afterQueryGoods',['page'=>&$rs]);
    	return $rs;
    }
}
