<?php
namespace wststore\mobile\controller;
use wststore\mobile\model\Goods as M;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 商品控制器
 */
class Goods extends Base{
	/**
	 * 商品主页
	 */
	public function detail(){
		$root = WSTDomain();
		$m = model('goods');
		$goods = $m->getBySale(input('goodsId/d'));
		if(!empty($goods)){
			$goods['goodsDesc']=htmlspecialchars_decode($goods['goodsDesc']);
			$rule = '/<img src="\/(upload.*?)"/';
			preg_match_all($rule, $goods['goodsDesc'], $images);
			foreach($images[0] as $k=>$v){
				$goods['goodsDesc'] = str_replace('/'.$images[1][$k], $root.WSTConf("CONF.goodsLogo") . "\"  data-echo=\"".$root."/".WSTImg($images[1][$k],3), $goods['goodsDesc']);
			}
			$carts = model('carts')->cartGoodsNum();
			$goods['cartGoodsNum'] = (isset($carts[$goods['goodsId']]))?$carts[$goods['goodsId']]:0;
            $goods['appraises'] = model('GoodsAppraises')->getGoodsEachApprNum($goods['goodsId']);
            $goods['appraise'] = model('GoodsAppraises')->getGoodsFirstAppraise($goods['goodsId']);
            $goods['appraiseNum'] = model('GoodsAppraises')->getGoodsAppraiseCount($goods['goodsId']);
		}else{
			return $this->fetch('error_lost');
		}
		$this->assign("info", $goods);
		return $this->fetch('goods_detail');
	}
	/**
	 * 商品列表
	 */
	public function lists(){
		$this->assign("keyword", input('keyword'));
		return $this->fetch('goods_list');
	}
    /**
     * 列表
     */
    public function pageQuery(){
    	$m = new M();
    	$rs = $m->pageQuery();
    	$rs['carts'] = model('carts')->cartGoodsNum();
    	$rs['keylist'] = [];
    	$keylist = cookie("wx_history_keyword");
    	if($keylist){
    		foreach ($keylist as $key =>$v){
    			$rs['keylist'][] = $v;
    		}
    	}
    	if(isset($rs['data'])){
    		foreach ($rs['data'] as $key =>$v){
    			$rs['data'][$key]['goodsImg'] = WSTImg($v['goodsImg'],3,'goodsLogo');
    		}
    	}
    	return $rs;
    }
    /**
     * 删除关键字记录
     */
    public function delKeyword(){
    	cookie("wx_history_keyword",null);
    	return WSTReturn("",1);
    }
    
}
