<?php
namespace wststore\mobile\controller;
use think\Controller;
use Env;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 基础控制器
 */
class Base extends Controller {
	public function __construct(){
		parent::__construct();
		WSTConf('CONF',WSTConfig());
		WSTSwitchs();
		$this->assign("v",WSTConf('CONF.wstVersion'));
		//先通过IP获取一个默认的经纬度
		$initLocation = session('INIT_LOCATION');
		if(empty($initLocation)){
			$initLocation = WSTIpLocation();
			session('INIT_LOCATION',$initLocation);
		}
        $this->assign("initLocation", $initLocation);
		//城市session
		$current_areas2 = session('USER_AREAS2');
		if(empty($current_areas2)){
			$current_areas2['areaId'] = 0;
			$current_areas2['areaName'] = '';
			session('USER_AREAS2',$current_areas2);
		}
		$this->assign("current_areas2",$current_areas2);
		//店铺session
        $current_shop = session('WST_USER_SHOP');
		if(empty($current_shop)){
			$current_shop['shopId'] = 0;
			$current_shop['shopName'] = '';
			session('WST_USER_SHOP',$current_shop);
		}
		$this->assign("current_shop",$current_shop);
		//二次修正的经纬度session
        if(session('USER_LONGITUDE')=='')session('USER_LONGITUDE',0);
        if(session('USER_LATITUDE')=='')session('USER_LATITUDE',0);
		//如果拒绝经纬度又有店铺的情况下就把初始化的经纬度给前端端
		if($current_shop['shopId']!=0 && session('USER_LONGITUDE',0)==0 && $initLocation['longitude']!=0){
            session('USER_LONGITUDE',$initLocation['longitude']);
            session('USER_LATITUDE',$initLocation['latitude']);
		}
        $this->assign("current_long",session('USER_LONGITUDE'));
		$this->assign("current_lat",session('USER_LATITUDE'));
		
		$this->view->filter(function($content){
            $style = WSTConf('CONF.wstmobileStyle')?WSTConf('CONF.wstmobileStyle'):'default';
            return str_replace("__MOBILE__",str_replace('/index.php','',$this->request->root()).'/wststore/mobile/view/'.$style,$content);
        });
		
		if(WSTConf('CONF.seoMallSwitch')==0){
			$this->redirect('mobile/switchs/index');
			exit;
		}
	}
	protected function fetch($template = '', $vars = [], $config = []){
		$style = WSTConf('CONF.wstmobileStyle')?WSTConf('CONF.wstmobileStyle'):'default';
		return $this->view->fetch($style."/".$template, $vars, $config);
		
	}
	// 权限验证方法
	protected function checkAuth(){
		$request = request();
		$USER = session('WST_USER');
		if(empty($USER)){
			if(request()->isAjax()){
				die('{"status":-999,"msg":"还没登录帐号"}');
			}else{
				session('WST_REFER_URL',$request->url(true));
				$url=urlencode($request->url(true));
				header("location:".url('mobile/users/login'));
				exit;
			}
		}
	}
	/**
	 * 上传图片
	 */
	public function uploadPic(){
		return WSTUploadPic(0);
	}
	/**
	 * 获取验证码
	 */
	public function getVerify(){
		WSTVerify();
	}
}