<?php 
namespace wststore\common\validate;
use think\Validate;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 用户地址验证器
 */
class UserAddress extends Validate{
	protected $rule = [
		'areaId2' => 'require',
		'userAddress'  => 'require',
		'userName' => 'require',
		'isDefault' => 'in:0,1',
		'userPhone' => 'require',
		'doorNum' => 'require'
	];
	
	protected $message  =  [
		'areaId2.require' => '请选择城市',
		'userAddress.require' => '请选择详细地址',
		'userName.require' => '请输入收货人姓名',
		'isDefault.in'  => '请选择是否默认地址',
		'userPhone.require'  => '请输入收货人手机号码',
		'doorNum.require'  => '请输入收货人手机号码'
	];

    protected $scene = [
        'add'   =>  ['areaId2','userAddress','userName','isDefault','userPhone','doorNum'],
        'edit'  =>  ['areaId2','userAddress','userName','isDefault','userPhone','doorNum']
    ]; 
}