<?php
namespace wststore\common\validate;
use think\Validate;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 开店申请验证器
 */
class ShopApplys extends Validate{
    protected $rule = [
        'linkMan'=>'require',
        'linkTel'=>'require|max:20',
        'areaId'=>'require',
        'shopAddress'=>'require'
    ];

    protected $message  =   [
        'linkMan.require' => '请输入申请人姓名',
        'linkTel.require' => '请输入申请人联系方式',
        'areaId.require' => '请选择申请城市',
        'shopAddress.require' => '请输入开店地址',
        'linkTel.max' => '联系电话不能超过20位'
    ];

    protected $scene = [
        'add'   =>  ['linkMan','linkTel','areaId','shopAddress']
    ];
}