<?php
namespace wststore\common\model;
use wststore\common\validate\UserAddress as Validate;
use think\Db;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 用户地址
 */
class UserAddress extends Base{
	protected $pk = 'addressId';
    /**
     * 获取列表
     */
   	public function pageQuery($uId=0){
      	$userId = ((int)$uId==0)?(int)session('WST_USER.userId'):$uId;
        $where = ['userId'=>(int)$userId,'dataFlag'=>1];
        $rs = $this->order('isDefault desc, addressId desc')->where($where)->paginate(input('pagesize/d'))->toArray();
        $areaIds = [];
        $areaMaps = [];
        if($rs['data']){
        	foreach ($rs['data'] as $key => $v){
        		$areaIds[] = $v['areaId2'];
        	}
        	if(!empty($areaIds)){
        		$areas = Db::name('areas')->where([['areaId','in',$areaIds],['isShow','=',1],['dataFlag','=',1]])->field('areaId,areaName')->select();
        		foreach ($areas as $v2){
        			$areaMaps[$v2['areaId']] = $v2['areaName'];
        		}
        		foreach ($rs['data'] as $key => $v){
        			$rs['data'][$key]['areaName2'] = $areaMaps[$v['areaId2']];
        		}
        	}
        }
        return $rs;
    }
    /**
    *  获取用户信息
    */
    public function getById($id, $uId=0){
        $userId = ((int)$uId==0)?(int)session('WST_USER.userId'):$uId;
    	$rs = $this->get(['addressId'=>$id,'userId'=>$userId,'dataFlag'=>1]);
    	$rs['areaName2'] = '';
    	if(isset($rs['areaId2'])){
    		$areas = Db::name('areas')->where([['areaId','=',$rs['areaId2']],['isShow','=',1],['dataFlag','=',1]])->field('areaId,areaName')->find();
    		$rs['areaName2'] = $areas['areaName'];
    	}
        return $rs;
    }
    /**
     * 新增
     */
    public function add($uId=0){
        $data = input('post.');
        unset($data['addressId']);
        $data['userId'] = ((int)$uId==0)?(int)session('WST_USER.userId'):$uId;
        $data['createTime'] = date('Y-m-d H:i:s');
        $validate = new Validate;
        if (!$validate->scene('add')->check($data)) {
        	return WSTReturn($validate->getError());
        }else{
        	$result = $this->allowField(true)->save($data);
        }
        if(false !== $result){
            //修改默认地址
            if((int)input('post.isDefault')==1){
            	$this->where("addressId != $this->addressId and userId=".$data['userId'])->setField('isDefault',0);
            }
            return WSTReturn("新增成功", 1,['addressId'=>$this->addressId]);
        }else{
            return WSTReturn($this->getError(),-1);
        }
    }
    /**
     * 编辑资料
     */
    public function edit($uId=0){
        $userId = ((int)$uId==0)?(int)session('WST_USER.userId'):$uId;
        $id = (int)input('post.addressId');
        $data = input('post.');
        $validate = new Validate;
        if (!$validate->scene('edit')->check($data)) {
        	return WSTReturn($validate->getError());
        }else{
        	$result = $this->allowField(true)->save($data,['addressId'=>$id,'userId'=>$userId]);
        }
        if(false !== $result){
	        //修改默认地址
	        if((int)input('post.isDefault')==1){
	        	$this->where("addressId != $id and userId=".$userId)->setField('isDefault',0);
	        }
            return WSTReturn("编辑成功", 1);
        }else{
            return WSTReturn($this->getError(),-1);
        }
    }
    /**
     * 删除
     */
    public function del($uId=0){
        $userId = ((int)$uId==0)?(int)session('WST_USER.userId'):$uId;
        $id = input('post.id/d');
        $data = [];
        $data['dataFlag'] = -1;
        $result = $this->update($data,['addressId'=>$id,'userId'=>$userId]);
        if(false !== $result){
            return WSTReturn("删除成功", 1);
        }else{
            return WSTReturn($this->getError(),-1);
        }
    }
    /**
     * 设置为默认地址
     */
    public function setDefault($uId=0){
    	$userId = ((int)$uId==0)?(int)session('WST_USER.userId'):$uId;
    	$id = (int)input('post.id');
    	$this->where([['addressId','<>',$id],['userId','=',$userId]])->setField('isDefault',0);
    	$rs = $this->where("addressId = $id and userId=".$userId)->setField('isDefault',1);
    	if(false !== $rs){
    		return WSTReturn("设置成功", 1);
    	}else{
    		return WSTReturn($this->getError(),-1);
    	}
    }
    /**
     * 获取默认地址
     */
    public function getDefaultAddress($uId=0){
    	$userId = ((int)$uId==0)?(int)session('WST_USER.userId'):$uId;
    	$where = ['userId'=>$userId,'dataFlag'=>1];
    	$rs = $this->where($where)->order('isDefault desc,addressId desc')->find();
    	if(empty($rs))return [];
    	$rs['areaName2'] = Db::name('areas')->where([['areaId','=',$rs['areaId2']],['isShow','=',1],['dataFlag','=',1]])->value('areaName');
    	return $rs;
    }
}
