<?php
namespace wststore\common\model;
use think\Db;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 标签业务处理类
 */
class Tags extends Base{
	/**
	 * 获取广告位置
	 */
	public function listAds($positionCode,$num,$shopId,$cache = 0){
		$cacheData = cache('TAG_ADS'.$positionCode.'_'.$shopId);
		if($cacheData)return $cacheData;
		$today = date('Y-m-d');
		$rs = Db::name("ad_mgrs")->alias('a')->join('__AD_POSITIONS__ ap','a.adPositionId= ap.positionId and ap.dataFlag=1','left')
		          ->where("a.dataFlag=1 and ap.positionCode='".$positionCode."' and (a.shopId='".$shopId."' or a.shopId=0) and adStartDate<= '$today' and adEndDate>='$today'")
		          ->field('adId,adName,adURL,adFile,positionWidth,positionHeight')
		          ->order('adSort')->limit($num)->select();
		if(count($rs)>0){
			foreach ($rs as $key => $v) {
				 $rs[$key]['isOpen'] = false;
				if(stripos($v['adURL'],'http:')!== false || stripos($v['adURL'],'https:')!== false){
                     $rs[$key]['isOpen'] = true;
				}
			}
		}
		cache('TAG_ADS'.$positionCode.'_'.$shopId,$rs,$cache);
		return $rs;
	}
	/**
	 * 获取指定商品
	 */
	public function listGoods($type,$catId = 0,$num,$cache = 0){
		$type = strtolower($type);
		if(strtolower($type)=='history'){
			return $this->historyByGoods($num);
		}elseif(strtolower($type)=='guess'){
			return $this->getGuessLike($catId,$num);
		}else{
			return $this->listByGoods($type,$catId,$num,$cache);
		}
	}
	/**
	 * 推荐商品
	 */
	public function listByGoods($type,$catId,$num,$shopId,$cache = 0){
		if(!in_array($type,[0,1,2,3]))return [];
		$cacheData = cache('TAG_GOODS_'.$type."_".$catId."_".$num."_".$shopId);
		hook('afterQueryGoods',['page'=>&$cacheData]);
		if($cacheData)return $cacheData;
		$goodsCatIds = WSTGoodsCatPath($catId);
		$types = ['recom'=>'g.isRecom','new'=>'g.isNew','hot'=>'g.isHot','best'=>'g.isBest'];
		$order = ['recom'=>'g.saleNum desc,g.goodsId asc',
				'new'=>'g.saleTime desc,g.goodsId asc',
				'hot'=>'g.saleNum desc,g.goodsId asc',
				'best'=>'g.saleNum desc,g.goodsId asc',
				'visit'=>'g.visitNum desc'
		];

		$where = [];
		$where[] = ['g.isSale','=',1];
		$where[] = ['gl.isSale','=',1];
		$where[] = ['gl.dataFlag','=',1];
		$where[] = ['s.shopId','=',$shopId];
		if($type!='visit')
			$where[] = [$types[$type],'=',1];
		if(!empty($goodsCatIds))$where[] = ['gl.goodsCatIdPath','like',implode('_',$goodsCatIds).'_%'];
		$goods = Db::name('goods_libs')->alias('gl')->join('__GOODS__ g','gl.goodsLibId=g.goodsLibId','left')->join('__SHOPS__ s','g.shopId=s.shopId')
		->where($where)->field('g.goodsTips,s.shopName,s.shopId,g.goodsId,gl.goodsName,gl.goodsImg,gl.goodsSn,g.goodsStock,g.saleNum,g.shopPrice,g.costPrice,g.visitNum')
		->order($order[$type])->limit($num)->select();
		cache('TAG_GOODS_'.$type."_".$catId."_".$num."_".$shopId,$goods,$cache);
		return $goods;
	}

	/**
	 * 获取友情链接
	 */
	public function listFriendlink($num,$cache = 0){
		$cacheData = cache('TAG_FRIENDLINK_'.$cache);
		if($cacheData)return $cacheData;
		$rs = Db::name("friendlinks")->where(["dataFlag"=>1])->order("friendlinkSort asc")->select();
		cache('TAG_FRIENDLINK_'.$cache,$rs,$cache);
	    return $rs;
	}
}
