<?php
namespace wststore\common\model;
use think\Db;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 门店类
 */
class Shops extends Base{
    /**
     * 获取店铺信息
     */
    public function getFieldsById($shopId,$fields=''){
        return $this->where(['shopId'=>$shopId,'dataFlag'=>1])->field($fields)->find();
    }
    /**
     * 根据经纬度定位门店
     */
	public function shopLocation(){
		$lng = (float)input("longitude",0);
		$lat = (float)input("latitude",0);
		$shop = $this->alias('s')->where(['s.dataFlag'=>1,'s.shopStatus'=>1])
		->field('s.shopId,s.shopName,s.areaIdPath')
		->field("round(6378.138*2*asin(sqrt(pow(sin( (".$lat."*pi()/180-s.latitude*pi()/180)/2),2)+cos(".$lat."*pi()/180)*cos(s.latitude*pi()/180)* pow(sin( (".$lng."*pi()/180-s.longitude*pi()/180)/2),2)))*1000)/1000 as distince")
		->order('distince asc')->find();
		if($shop){
            //保存经纬度
            session('USER_LONGITUDE',$lng);
            session('USER_LATITUDE',$lat);
            //保存选择门店
            $data = [];
			$data['shopId'] = $shop['shopId'];
			$data['shopName'] = $shop['shopName'];
            session('WST_USER_SHOP',$data);
            //保存选择城市
            $areaIds = explode('_',$shop['areaIdPath']);
            $where = [];
            $where[] = ['isShow','=',1];
            $where[] = ['dataFlag','=',1];
            $where[] = ['areaType','=',1];
            $where[] = ['isShow','=',1];
            $where[] = ['areaId','in',$areaIds];
            $rs = Db::name('areas')->where($where)->field('areaId,areaName')->find();
            if($rs){
                $data2 = [];
                $data2['areaId'] = $rs['areaId'];
                $data2['areaName'] = $rs['areaName'];
                session('USER_AREAS2',$data2);
            }
			return WSTReturn("",1,['areas'=>$data2,'shops'=>$data]);
		}else{
			return WSTReturn("附近没有相关门店",-1);
		}
	}
    /**
     * 切换门店
     */
    public function shopSwitch(){
        $shopId = (int)input('id');
        $shop = $this->getFieldsById($shopId,'shopId,shopName,areaIdPath');
        if($shop){
            $data = [];
            $data['shopId'] = $shop['shopId'];
            $data['shopName'] = $shop['shopName'];
            session('WST_USER_SHOP',$data);
            //保存选择城市
            $areaIds = explode('_',$shop['areaIdPath']);
            $where = [];
            $where[] = ['isShow','=',1];
            $where[] = ['dataFlag','=',1];
            $where[] = ['areaType','=',1];
            $where[] = ['isShow','=',1];
            $where[] = ['areaId','in',$areaIds];
            $rs = model('areas')->where($where)->field('areaId,areaName,areaKey')->order('areaId')->find();
            if($rs){
                $data = [];
                $data['areaId'] = $rs['areaId'];
                $data['areaName'] = $rs['areaName'];
                session('USER_AREAS2',$data);
            }
        }
        return WSTReturn("",1);
    }
    /**
     * 列表
     */
    public function pageQuery(){
        $long = (float)input("longitude",0);
        $lat = (float)input("latitude",0);
        $areaId = (int)input("areaId",0);
        $key = input("key");
    	$where = [];
    	if($areaId>0)$where[] = ['areaIdPath','like','%_'.$areaId.'_%'];
    	if($key!='')$where[] = ['shopAddress|shopName','like','%'.$key.'%'];
    	$where[] = ['s.dataFlag','=',1];
    	$where[] = ['s.shopStatus','=',1];
    	$page = $this->alias('s')->where($where)
    	->field('s.shopId,s.shopImg,s.shopName,s.shopAddress,s.shopTel,s.serviceStartTime,s.serviceEndTime')
        ->field("round(6378.138*2*asin(sqrt(pow(sin( (".$lat."*pi()/180-s.latitude*pi()/180)/2),2)+cos(".$lat."*pi()/180)*cos(s.latitude*pi()/180)* pow(sin( (".$long."*pi()/180-s.longitude*pi()/180)/2),2)))*1000)/1000 as distince")
        ->order('distince asc')
    	->paginate(input('pagesize/d'))->toArray();
    	return $page;
    }
}
