<?php
namespace wststore\common\model;
use wststore\common\validate\ShopApplys as validate;
use think\Db;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 门店类
 */
class ShopApplys extends Base{
    /**
     *  新增加盟合作
     */
    public function add($uId=0){
        $userId = ($uId>0)?$uId:session('WST_USER.userId');
        //判断有没有提交过申请，限制每天只能提交一次
        $rsNum = Db::name('shop_applys')->where(['dataFlag'=>1,'userId'=>$userId])->count();
        if($rsNum>0)return WSTReturn('您当天已提交过开店申请，请勿重复提交');
        $data = input('post.');
        WSTAllow($data,'linkMan,linkTel,areaId,shopAddress');
        Db::startTrans();
        try{
            $data['userId'] = $userId;
            $data['createTime'] = date('Y-m-d H:i:s');
            $data['dataFlag'] = 1;
            $validate = new validate();
            if(!$validate->scene('add')->check($data))return WSTReturn($validate->getError());
            $result = $this->allowField(true)->save($data);
            if(false !== $result){
                Db::commit();
                return WSTReturn("开店申请已提交", 1);
            }
        }catch (\Exception $e) {
            Db::rollback();
        }
        return WSTReturn("开店申请已提交失败");
    }
}
