<?php
namespace wststore\common\model;
use think\Db;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 订单业务处理类
 */
class Orders extends Base{
	protected $pk = 'orderId';
	/**
	 * 提交订单
	 */
	public function submit($orderSrc=0, $uId=0,$sId=0){
		$addressId = (int)input('post.addressId');
		$deliverType = ((int)input('post.deliverType')!=0)?1:0;
		$isInvoice = ((int)input('post.isInvoice')!=0)?1:0;
		$invoiceClient = ($isInvoice==1)?input('post.invoiceClient'):'';
		$payType = ((int)input('post.payType')!=0)?1:0;
		$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
		$shopId = ($sId==0)?(int)session('WST_USER_SHOP.shopId'):$sId;
		if($userId==0)return WSTReturn('下单失败，请先登录');
		$isUseScore = (int)input('isUseScore');
		$useScore = (int)input('useScore');
		//检测购物车
		$carts = model('common/carts')->getCarts(true,$userId,$shopId);
		if(empty($carts['carts']))return WSTReturn("请选择要购买的商品");
		//使用积分金额不能超过商品金额
		$tempScoreMoney = WSTScoreToMoney($carts['goodsTotalMoney'],true);
		$useScore = ($useScore>$tempScoreMoney)?$tempScoreMoney:$useScore;
		if($deliverType==0){// 配送方式为快递，必须有用户地址
			//检测地址是否有效
			$address = Db::name('user_address')->where(['userId'=>$userId,'addressId'=>$addressId,'dataFlag'=>1])->find();
			if(empty($address)){
				return WSTReturn("无效的用户地址");
			}
	        $address['areaName2'] = Db::name('areas')->where([['areaId','=',$address['areaId2']],['isShow','=',1],['dataFlag','=',1]])->value('areaName');
	        $address['userAddress'] = $address['areaName2'].$address['userAddress'].$address['doorNum'];
	        $address['areaId'] = $address['areaId2'];
		    WSTUnset($address, 'isDefault,dataFlag,createTime,userId,doorNum,areaName2');
	    }else{
	    	$address = [];
			$address['areaId'] = 0;
			$address['userName'] = '';
			$address['userPhone'] = '';
			$address['userAddress'] = '';
	    }
		
		//计算出积分
		$orderScoreMoney = $this->getOrderScoreMoney($isUseScore,$useScore,$userId);
		//生成订单
		Db::startTrans();
		try{
			$orderNo = WSTOrderNo(); 
			$orderScore = 0;
			//创建订单
			$order = [];
			// 订单来源 0:PC   1:微信  2:手机版   3:安卓App  4:苹果App
			$module = request()->module();
			$mArr = ['home'=>0,'wechat'=>1,'mobile'=>2];
			// 			默认订单来自pc版
			$order['orderSrc'] = isset($mArr[$module])?$mArr[$module]:0;
			$order = array_merge($order,$address);
			$order['orderNo'] = $orderNo;
			$order['userId'] = $userId;
			$order['shopId'] = $shopId;
			$order['payType'] = $payType;
			$order['goodsMoney'] = $carts['goodsTotalMoney'];
			$order['deliverType'] = $deliverType;
			$order['orderunique'] = '';
			$order['bookTime'] = input('post.bookTime');
			// 运费
			$order['deliverMoney'] = ($deliverType==1)?0:WSTOrderFreight($userId,$shopId,$addressId);
			$order['totalMoney'] = $order['goodsMoney']+$order['deliverMoney'];
			//积分支付-计算分配积分和金额
			$order['scoreMoney'] = $orderScoreMoney['useMoney'];
			$order['useScore'] = $orderScoreMoney['useScore'];
			//实付金额要减去积分兑换的金额
			$order['realTotalMoney'] = WSTPositiveNum($order['totalMoney'] - $order['scoreMoney']);
			$order['needPay'] = $order['realTotalMoney'];
			//是否开启优惠券
			hook("beforeInsertOrder",['order'=>&$order,'carts'=>$carts]);
            if($payType==1){
                if($order['needPay']>0){
                    $order['orderStatus'] = -2;//待付款
				    $order['isPay'] = 0; 
                }else{
                    $order['orderStatus'] = 0;//待发货
				    $order['isPay'] = 1; 
				    $order['payFrom'] = 'others';
                }
			}else{
			    $order['orderStatus'] = 0;//待发货
				if($order['needPay']==0){
					$order['isPay'] = 1;
					$order['payFrom'] = 'others';
				}
			}
			//积分
			$orderScore = 0;
			//如果开启下单获取积分则有积分
			if(WSTConf('CONF.isOrderScore')==1){
				 $orderScore = round($order['goodsMoney'],0);
			}
			$order['orderScore'] = $orderScore;
			$order['isInvoice'] = $isInvoice;
			$order['invoiceJson'] = model('invoices')->getInviceInfo((int)input('param.invoiceId'),$uId);// 发票信息
			$order['invoiceClient'] = $invoiceClient;
            $order['orderType'] = 0;
			$order['orderRemarks'] = input('post.remark');
			$order['dataFlag'] = 1;
			$order['createTime'] = date('Y-m-d H:i:s');
			$result = $this->data($order,true)->isUpdate(false)->allowField(true)->save($order);
			$orderId = 0;
			if(false !== $result){
				$orderId = $this->orderId;
				$orderTotalGoods = [];
				foreach ($carts['carts'] as $gkey =>$goods){
					//创建订单商品记录
					$orderGgoods = [];
					$orderGoods['orderId'] = $orderId;
					$orderGoods['goodsId'] = $goods['goodsId'];
					$orderGoods['goodsNum'] = $goods['cartNum'];
					$orderGoods['goodsPrice'] = $goods['shopPrice'];
					$orderGoods['goodsName'] = $goods['goodsName'];
					$orderGoods['goodsImg'] = $goods['goodsImg'];
					$orderGoods['goodsCode'] = '';
					$orderGoods['goodsType'] = 0;
					$orderGoods['extraJson'] = '';
					$orderGoods['promotionJson'] = '';
					$orderTotalGoods[] = $orderGoods;
					Db::name('goods')->where('goodsId',$goods['goodsId'])->update([
						'goodsStock'=>['exp','goodsStock-'.$goods['cartNum']],
						'saleNum'=>['exp','saleNum+'.$goods['cartNum']]
					]);
				}
				Db::name('order_goods')->insertAll($orderTotalGoods);
				//创建积分流水--如果有抵扣积分就肯定是开启了支付支付
				if($order['useScore']>0){
					$score = [];
					$score['userId'] = $userId;
					$score['score'] = $order['useScore'];
					$score['dataSrc'] = 1;
					$score['dataId'] = $orderId;
					$score['dataRemarks'] = "交易订单【".$orderNo."】使用积分".$order['useScore']."个";
					$score['scoreType'] = 0;
					model('UserScores')->add($score);
				}
				//建立订单记录
				$logOrder = [];
				$logOrder['orderId'] = $orderId;
				$logOrder['orderStatus'] = ($payType==1 && $order['needPay']==0)?-2:$order['orderStatus'];
				$logOrder['logContent'] = ($payType==1)?"下单成功，等待用户支付":"下单成功";
				$logOrder['logUserId'] = $userId;
				$logOrder['logType'] = 0;
				$logOrder['logTime'] = date('Y-m-d H:i:s');
				Db::name('log_orders')->insert($logOrder);
				if($payType==1 && $order['needPay']==0){
					$logOrder = [];
					$logOrder['orderId'] = $orderId;
					$logOrder['orderStatus'] = 0;
					$logOrder['logContent'] = "订单已支付，下单成功";
					$logOrder['logUserId'] = $userId;
					$logOrder['logType'] = 0;
					$logOrder['logTime'] = date('Y-m-d H:i:s');
					Db::name('log_orders')->insert($logOrder);
				}
                if((int)WSTConf('CONF.wxenabled')==1){
                	$address = ($deliverType==0)?$address['userName'].'|'.$address['userAddress']:"自提";
		            $params = [];
			        $params['ORDER_NO'] = $orderNo;
		            $params['ORDER_TIME'] = date('Y-m-d H:i:s');             
		            $goodsNames = $goods['goodsName']."*".$goods['cartNum'];
			        $params['GOODS'] = $goodsNames;
			        $params['MONEY'] = $order['realTotalMoney'] + $order['scoreMoney'];
			        $params['ADDRESS'] = $address;
			        $params['PAY_TYPE'] = WSTLangPayType($order['payType']);
			        WSTWxShopMessage(['CODE'=>'WX_ORDER_SUBMIT','shopId'=>$shopId,'params'=>$params]);
		        }

			}
			//删除已选的购物车商品
			Db::name('carts')->where(['userId'=>$userId,'isCheck'=>1])->delete();
			Db::commit();
			return WSTReturn("提交订单成功", 1,$orderId);
		}catch (\Exception $e) {
			print_r($e);
            Db::rollback();
            return WSTReturn('提交订单失败',-1);
        }
	}
	/**
	 * 计算可用积分和抵扣金额
	 */
	public function getOrderScoreMoney($isUseScore, $useScore, $uId=0){
		$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
		if((int)WSTConf('CONF.isOpenScorePay')==1 && $isUseScore){
			$uses = model('common/users')->getFieldsById($userId,'userScore');
			//如果又要积分支付又传个0或者负数就默认全部用完...
			if($useScore<=0)$useScore = $uses['userScore'];
			if($uses['userScore']<$useScore)$useScore = $uses['userScore'];
			$money = WSTScoreToMoney($useScore);
			return ['useScore'=>$useScore,'useMoney'=>$money];
		}
		return ['useScore'=>0,'useMoney'=>0];
	}
	/**
	 * 获取用户订单列表
	 */
	public function userOrdersByPage($orderStatus,$isAppraise = -1,$deliverType=-1,$uId=0){
		$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
		$orderNo = input('post.orderNo');
		$where = ['o.userId'=>$userId,'o.dataFlag'=>1];
		if(is_array($orderStatus)){
			$where[] = ['orderStatus','in',$orderStatus];
		}else{
			$where['orderStatus'] = $orderStatus;
		}
		if($isAppraise!=-1)$where['isAppraise'] = $isAppraise;
		if($deliverType!=-1)$where['deliverType'] = $deliverType;
		if($orderNo!=''){
			$where[] = ['o.orderNo','like',"%$orderNo%"];
		}
		$page = $this->alias('o')->where($where)->join('__SHOPS__ s','o.shopId=s.shopId')
		->field('o.noticeDeliver,o.userName,o.orderId,o.orderNo,o.goodsMoney,o.totalMoney,o.realTotalMoney,
		o.orderStatus,o.deliverType,deliverMoney,isPay,payType,payFrom,needPay,isAppraise,isRefund,orderSrc,o.createTime,s.shopName,s.shopTel')
		->order('o.createTime', 'desc')->paginate(input('pagesize/d'))->toArray();
		if(count($page['data'])>0){
			$orderIds = [];
			foreach ($page['data'] as $v){
				$orderIds[] = $v['orderId'];
			}
			//获取订单商品
			$goods = Db::name('order_goods')->where('orderId','in',$orderIds)->select();
			$goodsMap = [];
			foreach ($goods as $v){
				$goodsMap[$v['orderId']][] = $v;
			}
			foreach ($page['data'] as $key => $v){
				$page['data'][$key]['list'] = $goodsMap[$v['orderId']];
				$page['data'][$key]['payTypeName'] = WSTLangPayType($v['payType']);
				$page['data'][$key]['deliverType'] = WSTLangDeliverType($v['deliverType']==1);
				$page['data'][$key]['status'] = WSTLangOrderStatus($v['orderStatus']);
				if($v["orderStatus"]==-2){
					$page['data'][$key]['pkey'] = WSTBase64urlEncode($v["orderId"]."@0");
				}
			}
		}
		return $page;
	}
	/**
	 * 获取订单详情
	 */
	public function getByView($orderId,$uId=0){
		$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
		$orders = $this->alias('o')->join('__EXPRESS__ e','o.expressId=e.expressId','left')
		->join('__SHOPS__ s','o.shopId=s.shopId')
		->join('__ORDER_COMPLAINS__ oc','oc.orderId=o.orderId','left')
		->where('o.dataFlag=1 and o.orderId='.$orderId.' and ( o.userId='.$userId.')')
		->field('o.*,e.expressName,s.shopTel,s.shopAddress,oc.complainId')->find();
		if(empty($orders))return WSTReturn("无效的订单信息");
		$orders = $orders->toArray();
		$orders['isComplain'] = 1;
		if(($orders['complainId']=='') && ($orders['payType']==0 || ($orders['payType']==1 && $orders['orderStatus']!=-2))){
			$orders['isComplain'] = '';
		}
		//获取订单信息
		$orders['log'] =Db::name('log_orders')->where('orderId',$orderId)->order('logId asc')->select();
		//获取订单商品
		$orders['goods'] = Db::name('order_goods')->where('orderId',$orderId)->order('id asc')->select();
		//获取快递单号
		if($orders['shopDeliverType']==1){
			$express = Db::name('express')->where('expressId','=',$orders['expressId'])->find();
		    $orders['express'] = $express['expressName'];
		}
		return $orders;
	}
	/**
	 * 获取用户退款订单列表
	 */
	public function userOrderRefundByPage($uId=0){
		$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
		$orderNo = input('post.orderNo');
		$where = ['o.userId'=>$userId,'o.dataFlag'=>1];
		$where[] = ['payType','=',1];
		$where[] = ['isPay','=',1];
		$where[] = ['orderStatus','in',[-1,-3]];
		if($orderNo!='')$where[] = ['o.orderNo','like',"%$orderNo%"];
		$page = $this->alias('o')->where($where)->join('__SHOPS__ s','o.shopId=s.shopId')
		->field('o.noticeDeliver,o.userName,o.orderId,o.orderNo,o.goodsMoney,o.totalMoney,o.realTotalMoney,
		o.orderStatus,o.deliverType,deliverMoney,isPay,payType,payFrom,needPay,isAppraise,isRefund,orderSrc,o.createTime,s.shopName,s.shopTel')
		->order('o.createTime', 'desc')->paginate(input('pagesize/d'))->toArray();
		if(count($page['data'])>0){
			$orderIds = [];
			foreach ($page['data'] as $v){
				$orderIds[] = $v['orderId'];
			}
			$goods = Db::name('order_goods')->where('orderId','in',$orderIds)->select();
			$goodsMap = [];
			foreach ($goods as $v){
				$goodsMap[$v['orderId']][] = $v;
			}
			foreach ($page['data'] as $key => $v){
				$page['data'][$key]['list'] = $goodsMap[$v['orderId']];
				$page['data'][$key]['payTypeName'] = WSTLangPayType($v['payType']);
				$page['data'][$key]['deliverType'] = WSTLangDeliverType($v['deliverType']==1);
				$page['data'][$key]['status'] = WSTLangOrderStatus($v['orderStatus']);
			}
		}
		return $page;
	}
	/**
	 * 根据订单id获取 商品信息跟商品评价
	 */
	public function getOrderInfoAndAppr($uId=0){
		$orderId = (int)input('id');
		$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
		$goodsInfo = Db::name('order_goods')
		->field('id,orderId,goodsName,goodsId,goodsImg,goodsCode,goodsNum')
		->where(['orderId'=>$orderId])
		->select();
		//根据商品id 与 订单id 取评价
		$alreadys = 0;// 已评价商品数
		$count = count($goodsInfo);//订单下总商品数
		if($count>0){
			foreach($goodsInfo as $k=>$v){
				$appraise = Db::name('goods_appraises')
				->field('goodsScore,serviceScore,timeScore,content,images,createTime')
				->where(['goodsId'=>$v['goodsId'],
						'orderId'=>$orderId,
						'dataFlag'=>1,
						'userId'=>$userId,
						'orderGoodsId'=>$v['id']
				])->find();
				if(!empty($appraise)){
					++$alreadys;
					$appraise['images'] = ($appraise['images']!='')?explode(',', $appraise['images']):[];
				}
				$goodsInfo[$k]['appraise'] = $appraise;
			}
		}
		return ['count'=>$count,'list'=>$goodsInfo,'alreadys'=>$alreadys];
	
	}
	/**
	 * 用户收货
	 */
	public function receive($orderId=0, $uId=0){
		$orderId = ($orderId==0)?(int)input('post.id'):$orderId;
		$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
		$order = $this->where(['userId'=>$userId,'orderId'=>$orderId,'orderStatus'=>1])
		->field('shopId,orderId,orderNo,payType,orderScore')->find();
		if(!empty($order)){
			Db::startTrans();
			try{
				$data = ['orderStatus'=>2,'receiveTime'=>date('Y-m-d H:i:s')];
				$result = $this->where('orderId',$order['orderId'])->update($data);
				if(false != $result){	
					//修改商品成交量
					$goodss = Db::name('order_goods')->where('orderId',$order['orderId'])->field('goodsId,goodsNum')->select();
					foreach($goodss as $key =>$v){
						Db::name('goods')->where('goodsId',$v['goodsId'])->setInc('saleNum', $v['goodsNum']);
					}
					//新增订单日志
					$logOrder = [];
					$logOrder['orderId'] = $orderId;
					$logOrder['orderStatus'] = 2;
					$logOrder['logContent'] = "用户已收货";
					$logOrder['logUserId'] = $userId;
					$logOrder['logType'] = 0;
					$logOrder['logTime'] = date('Y-m-d H:i:s');
					Db::name('log_orders')->insert($logOrder);
					//给用户增加积分
					if(WSTConf("CONF.isOrderScore")==1){
						$score = [];
						$score['userId'] = $userId;
						$score['score'] = $order['orderScore'];
						$score['dataSrc'] = 1;
						$score['dataId'] = $orderId;
						$score['dataRemarks'] = "交易订单【".$order['orderNo']."】获得积分".$order['orderScore']."个";
						$score['scoreType'] = 1;
						$score['createTime'] = date('Y-m-d H:i:s');
						model('UserScores')->save($score);
						// 增加用户积分
						model('Users')->where("userId=$userId")->setInc('userScore',$order['orderScore']);
						// 用户总积分
						model('Users')->where("userId=$userId")->setInc('userTotalScore',$order['orderScore']);
					}
					//微信消息
		            if((int)WSTConf('CONF.wxenabled')==1){
		            	$params = [];
		                $params['ORDER_NO'] = $order['orderNo'];  
		                $params['ORDER_TIME'] = date('Y-m-d H:i:s');
		                WSTWxShopMessage(['CODE'=>'WX_ORDER_RECEIVE','shopId'=>$order['shopId'],'params'=>$params]);
		            } 
					Db::commit();
					return WSTReturn('操作成功',1);
				}
			}catch (\Exception $e) {
				Db::rollback();
				return WSTReturn('操作失败',-1);
			}
		}
		return WSTReturn('操作失败，请检查订单状态是否已改变');
	}
	/**
	 * 用户取消订单
	 */
	public function cancel($uId=0){
		$orderId = (int)input('post.id');
		$reason = (int)input('post.reason');
		$content = input('post.content');
		$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
		$order = $this->where([['orderStatus','in',[-2,0]],['userId','=',$userId],['orderId','=',$orderId]])
		->field('shopId,orderId,orderNo,realTotalMoney,orderStatus,payType,isPay,useScore,orderCode,scoreMoney')->find();
		$reasonData = WSTDatas('ORDER_CANCEL',$reason);
		if(empty($reasonData))return WSTReturn("无效的取消原因");
		if(!empty($order)){
			Db::startTrans();
			try{
				$data = ['orderStatus'=>-1,'interruptCode'=>$reason];
				if($reason==10000)$data['interruptCodeRemark'] = $content;
				//如果是货到付款的话，则把实付金额设置为0
				if($order['payType']==0 || ($order['orderStatus']==-2 && $order['payType']==1))$data['realTotalMoney'] = 0;
				$result = $this->where('orderId',$order['orderId'])->update($data);
				if(false != $result){
					//返还商品库存
					$goods = Db::name('order_goods')->where('orderId',$orderId)->select();
					foreach ($goods as $key => $v){
						if($order['orderCode']=='order'){
							Db::name('goods')->where('goodsId',$v['goodsId'])->setInc('goodsStock',$v['goodsNum']);
						}
					}
					//新增订单日志
					$logOrder = [];
					$logOrder['orderId'] = $orderId;
					$logOrder['orderStatus'] = -1;
					$logOrder['logContent'] = "用户取消订单，取消原因：".$reasonData['dataName'].(($content!='')?("-".$content):"");
					$logOrder['logUserId'] = $userId;
					$logOrder['logType'] = 0;
					$logOrder['logTime'] = date('Y-m-d H:i:s');
					Db::name('log_orders')->insert($logOrder);
					//有积分则退回积分
					if($order['useScore']>0){
						$data = [];
						$data['userId'] = $userId;
						$data['score'] = $order['useScore'];
						$data['dataSrc'] = 0;
						$data['dataId'] = $orderId;
						$data['dataRemarks'] = '订单【'.$order['orderNo'].'】取消退回积分';
						$data['scoreType'] = 1;
						$data['createTime'] = date('Y-m-d H:i:s');
						model('common/UserScores')->add($data);
					}
					//创建退款记录
					if($order['payType']==1 && $order['isPay']==1){
						$data = [];
						$data['orderId'] = $orderId;
						$data['refundMoney'] = $order['realTotalMoney'];
						$data['createTime'] = date('Y-m-d H:i:s');
						$data['refundStatus'] = 0;
						Db::name('order_refunds')->insert($data);
					}
					//微信消息
		            if((int)WSTConf('CONF.wxenabled')==1){
		            	$params = [];
		                $params['ORDER_NO'] = $order['orderNo'];            
		                $goodsNames = [];
		                foreach ($goods as $gkey =>$g){
	                        $goodsNames[] = $g['goodsName']."*".$g['goodsNum'];
		                }
		                $params['REASON'] = $reasonData['dataName'];
		                $params['GOODS'] = implode(',',$goodsNames);
		                $params['MONEY'] = $order['realTotalMoney'] + $order['scoreMoney'];
	                    WSTWxShopMessage(['CODE'=>'WX_ORDER_CANCEL','shopId'=>$order['shopId'],'params'=>$params]);
		            }  
					Db::commit();
					return WSTReturn('订单取消成功',1);
				}
			}catch (\Exception $e) {
				Db::rollback();
				return WSTReturn('操作失败',-1);
			}
		}
		return WSTReturn('操作失败，请检查订单状态是否已改变');
	}
	/**
	 * 用户拒收订单
	 */
	public function reject($uId=0){
		$orderId = (int)input('post.id');
		$reason = (int)input('post.reason');
		$content = input('post.content');
		$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
		$order = $this->where(['userId'=>$userId,'orderId'=>$orderId,'orderStatus'=>1])
		->field('shopId,orderId,orderNo,realTotalMoney,payType,isPay,scoreMoney,userAddress,userName,useScore')->find();
		$reasonData = WSTDatas('ORDER_REJECT',$reason);
		if(empty($reasonData))return WSTReturn("无效的拒收原因");
		if($reason==10000 && $content=='')return WSTReturn("请输入拒收原因");
		if(!empty($order)){
			Db::startTrans();
			try{
				$data = ['orderStatus'=>-3,'interruptCode'=>$reason];
				if($order['payType']==0)$data['realTotalMoney'] = 0;
				if($reason==10000)$data['interruptCodeRemark'] = $content;
				$result = $this->where('orderId',$order['orderId'])->update($data);
				if(false != $result){
					//新增订单日志
					$logOrder = [];
					$logOrder['orderId'] = $orderId;
					$logOrder['orderStatus'] = -3;
					$logOrder['logContent'] = "用户拒收订单，拒收原因：".$reasonData['dataName'].(($reason==10000)?"-".$content:"");
					$logOrder['logUserId'] = $userId;
					$logOrder['logType'] = 0;
					$logOrder['logTime'] = date('Y-m-d H:i:s');
					Db::name('log_orders')->insert($logOrder);
					//有积分则退回积分
					if($order['useScore']>0){
						$data = [];
						$data['userId'] = $userId;
						$data['score'] = $order['useScore'];
						$data['dataSrc'] = 0;
						$data['dataId'] = $orderId;
						$data['dataRemarks'] = '订单【'.$order['orderNo'].'】取消退回积分';
						$data['scoreType'] = 1;
						$data['createTime'] = date('Y-m-d H:i:s');
						model('common/UserScores')->add($data);
					}
					//创建退款记录
					if($order['payType']==1 && $order['isPay']==1){
						$data = [];
						$data['orderId'] = $orderId;
						$data['refundMoney'] = $order['realTotalMoney'];
						$data['createTime'] = date('Y-m-d H:i:s');
						$data['refundStatus'] = 0;
						Db::name('order_refunds')->insert($data);
					}
					//微信消息
		            if((int)WSTConf('CONF.wxenabled')==1){
		            	$params = [];
		                $params['ORDER_NO'] = $order['orderNo'];  
	                    $goods = Db::name('order_goods')->where('orderId',$order['orderId'])->select();           
		                $goodsNames = [];
		                foreach ($goods as $gkey =>$goods){
	                        $goodsNames[] = $goods['goodsName']."*".$goods['goodsNum'];
		                }
		                $params['GOODS'] = implode(',',$goodsNames);
		                $params['MONEY'] = $order['realTotalMoney'] + $order['scoreMoney'];
		                $params['ADDRESS'] = $order['userAddress']." ".$order['userName'];
		                $params['REASON'] = $reasonData['dataName'].(($reason==10000)?"-".$content:"");
	                    WSTWxShopMessage(['CODE'=>'WX_ORDER_REJECT','shopId'=>$order['shopId'],'params'=>$params]);
		            } 
					Db::commit();
					return WSTReturn('操作成功',1);
				}
			}catch (\Exception $e) {
				print_r($e);
				Db::rollback();
				return WSTReturn('操作失败',-1);
			}
		}
		return WSTReturn('操作失败，请检查订单状态是否已改变');
	}
	/**
	 * 根据订单唯一流水获取订单信息
	 */
	public function getByUnique($payfor = '',$uId=0,$orderId=0){
		$orderId = ($orderId>0)?$orderId:(int)input('id/d',0);
		$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
		$rs = $this->where(['userId'=>$userId,'orderId'=>$orderId])->field('orderId,orderNo,payType,needPay,deliverMoney,userName,userAddress,userPhone')->find();

		if(empty($rs))return [];
		$data = [];
		$data['deliverMoney'] = $rs['deliverMoney'];
		$data['orderNo'] = $rs['orderNo'];
		$data['userName'] = $rs['userName'];
		$data['userAddress'] = $rs['userAddress'];
		$data['userPhone'] = $rs['userPhone'];
		$data['orderId'] = $orderId;
		$data['totalMoney'] = $rs['needPay'];
		$data['payType'] = $rs['payType'];
		//获取商品信息
		$goods = Db::name('order_goods')->where(['orderId'=>$orderId])->select();
		foreach ($goods as $key =>$v){
			$data['goods'][] = $v;
		}
		//如果是在线支付的话就要加载支付信息
		if($data['payType']==1){
			//获取支付信息
			$payments = model('payments')->where(['isOnline'=>1,'enabled'=>1])->where("find_in_set ($payfor,payFor)")->order('payOrder asc')->select();
			$data['payments'] = $payments;
		}
		return $data;
	}
	/**
	 * 获取支付订单信息
	 */
	public function getPayOrders($obj){
		$userId = (int)$obj["userId"];
		$orderId = $obj["orderId"];
		$needPay = 0;
		$where = ["userId"=>$userId,"dataFlag"=>1,"orderStatus"=>-2,"isPay"=>0,"payType"=>1];
		$where[] = ["needPay",">",0];
		$where['orderId'] = $orderId;
		$data = [];
		$data["needPay"] = model('orders')->where($where)->sum('needPay');
		$data["payRand"] = model('orders')->where($where)->max('payRand');
		return $data;
	}
	/**
	 * 余额支付
	 */
	public function payByWallet($uId=0){
		$payPwd = input('payPwd');
		if(!$payPwd)return WSTReturn('请输入密码',-1);
		$decrypt_data = WSTRSA($payPwd);
		if($decrypt_data['status']==1){
			$payPwd = $decrypt_data['data'];
		}else{
			return WSTReturn('支付失败');
		}
		$key = input('key');
		$key = WSTBase64url($key,false);
		$base64 = new \org\Base64();
		$key = $base64->decrypt($key,"WSTMart");
		$key = explode('_',$key);
		if(count($key)>1){
			$orderNo = $key[0];
			$isBatch = (int)$key[1];
		}else{
			$orderId = input("id/d");
		}
		$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
		//判断是否开启余额支付
		$isEnbalePay = model('common/payments')->isEnablePayment('wallets');
		if($isEnbalePay==0)return WSTReturn('非法的支付方式',-1);
		//判断订单状态
		$where = ["userId"=>$userId,"dataFlag"=>1,"orderStatus"=>-2,"isPay"=>0,"payType"=>1];

		$where['orderId'] = $orderId;
		$orders = $this->field('shopId,orderId,orderNo,orderType,needPay,payFrom,realTotalMoney,deliverType')->where($where)->find();
		if(empty($orders))return WSTReturn('您的订单已支付',-1);
		//判断订单金额是否正确
		$needPay = $orders['needPay'];
		//获取用户钱包
		$user = model('users')->get($userId);
		if($user->payPwd=='')return WSTReturn('您未设置支付密码，请先设置密码',-1);
		if($user->payPwd!=md5($payPwd.$user->loginSecret))return WSTReturn('您的支付密码不正确',-1);
		if($needPay > $user->userMoney)return WSTReturn('您的钱包余额不足',-1);
		$rechargeMoney = $user->rechargeMoney;
		Db::startTrans();
		try{
			//处理订单信息
			$tmpNeedPay = $orders->needPay;
			$lockCashMoney = ($rechargeMoney>$tmpNeedPay)?$tmpNeedPay:$rechargeMoney;
			$orders->needPay = 0;
			$orders->isPay = 1;
			$orders->orderStatus = 0;
			$orders->payFrom = 'wallets';
			$orders->lockCashMoney = $lockCashMoney;
			$orders->payTime = date('Y-m-d H:i:s');
			$result = $orders->save();
			if(false != $result){
				//新增订单日志
				$logOrder = [];
				$logOrder['orderId'] = $orders->orderId;
				$logOrder['orderStatus'] = 0;
				$logOrder['logContent'] = "支付成功，等待".(($orders['deliverType']==0)?"门店发货":"用户自提");;
				$logOrder['logUserId'] = $userId;
				$logOrder['logType'] = 0;
				$logOrder['logTime'] = date('Y-m-d H:i:s');
				Db::name('log_orders')->insert($logOrder);
				//创建一条支出流水记录
				$lm = [];
				$lm['userId'] = $userId;
				$lm['dataId'] = $orders->orderId;
				$lm['dataSrc'] = 1;
				$lm['remark'] = '交易订单【'.$orders->orderNo.'】支出¥'.$tmpNeedPay;
				$lm['moneyType'] = 0;
				$lm['money'] = $tmpNeedPay;
				$lm['payType'] = 'wallets';
				model('LogMoneys')->add($lm);
				//修改用户充值金额
				model('users')->where(["userId"=>$userId])->setDec("rechargeMoney",$lockCashMoney);
				//微信消息
			    if((int)WSTConf('CONF.wxenabled')==1){
				    $params = [];
					$params['ORDER_NO'] = $orders->orderNo;
					$params['PAY_TIME'] = date('Y-m-d H:i:s');             
					$params['MONEY'] = $orders->realTotalMoney;
					$params['PAY_SRC'] = WSTLangPayFrom($orders->payFrom);
					WSTWxShopMessage(['CODE'=>'WX_ORDER_PAY','shopId'=>$orders->shopId,'params'=>$params]);
				}
			}
			Db::commit();
			return WSTReturn('订单支付成功',1);
		}catch (\Exception $e) {
			print_r($e);
			Db::rollback();
			return WSTReturn('订单支付失败');
		}
	}

	/**
	 * 完成支付订单
	 */
	public function complatePay ($obj){
		$trade_no = $obj["trade_no"];
		$orderId = $obj["out_trade_no"];
		$userId = (int)$obj["userId"];
		$payFrom = $obj["payFrom"];
		$payMoney = (float)$obj["total_fee"];
	
		if($payFrom!=''){
			$cnt = model('orders')
			->where(['payFrom'=>$payFrom,"userId"=>$userId,"tradeNo"=>$trade_no])
			->count();
			if($cnt>0){
				return WSTReturn('订单已支付',-1);
			}
		}
		$where = ["userId"=>$userId,"dataFlag"=>1,"orderStatus"=>-2,"isPay"=>0,"payType"=>1];
		$where[] = ["needPay",">",0];
		$where['orderId'] = $orderId;
		
		$order = model('orders')->where($where)->find();
	    $needPay = $order->needPay;
		if($needPay>$payMoney){
			return WSTReturn('支付金额不正确',-1);
		}
		Db::startTrans();
		try{
			//修改订单状态
			$order->needPay = 0;
			$order->isPay = 1;
			$order->orderStatus = 0;
			$order->tradeNo = $trade_no;
			$order->payFrom = $payFrom;
			$rs = $order->save();
				
			//新增订单日志
			$logOrder = [];
			$logOrder['orderId'] = $orderId;
			$logOrder['orderStatus'] = 0;
			$logOrder['logContent'] = "支付成功，等待".(($order['deliverType']==0)?"门店发货":"用户自提");
			$logOrder['logUserId'] = $userId;
			$logOrder['logType'] = 0;
			$logOrder['logTime'] = date('Y-m-d H:i:s');
			Db::name('log_orders')->insert($logOrder);
            
            //创建一条充值流水记录
			$lm = [];
			$lm['userId'] = $userId;
			$lm['dataId'] = $orderId;
			$lm['dataSrc'] = 1;
			$lm['remark'] = '交易订单【'.$order->orderNo.'】充值¥'.$needPay;
			$lm['moneyType'] = 1;
			$lm['money'] = $needPay;
			$lm['payType'] = $payFrom;
			model('LogMoneys')->add($lm);

			//创建一条支出流水记录
			$lm = [];
			$lm['userId'] = $userId;
			$lm['dataId'] = $orderId;
			$lm['dataSrc'] = 1;
			$lm['remark'] = '交易订单【'.$order->orderNo.'】支出¥'.$needPay;
			$lm['moneyType'] = 0;
			$lm['money'] = $needPay;
			$lm['payType'] = $payFrom;
			model('LogMoneys')->add($lm);
            //微信消息
		    if((int)WSTConf('CONF.wxenabled')==1){
			    $params = [];
				$params['ORDER_NO'] = $order->orderNo;
				$params['PAY_TIME'] = date('Y-m-d H:i:s');             
				$params['MONEY'] = $order->realTotalMoney;
				$params['PAY_SRC'] = WSTLangPayFrom($order->payFrom);
				WSTWxShopMessage(['CODE'=>'WX_ORDER_PAY','shopId'=>$order->shopId,'params'=>$params]);
			}
			Db::commit();
			return WSTReturn('支付成功',1);
		}catch (\Exception $e) {
			Db::rollback();
			return WSTReturn('操作失败',-1);
		}
	}
	/**
	 * 获取订单金额以及用户钱包金额
	 */
	public function getOrderPayInfo($obj){
        $userId = (int)$obj["userId"];
		$orderNo = $obj["orderNo"];
		$isBatch = (int)$obj["isBatch"];
		$needPay = 0;
		$where = ["userId"=>$userId,"dataFlag"=>1,"orderStatus"=>-2,"isPay"=>0,"payType"=>1];
		$where[] = ["needPay",">",0];
		if($isBatch==1){
			$where['orderunique'] = $orderNo;
		}else{
			$where['orderNo'] = $orderNo;
		}
		$orders = model('orders')->where($where)->field('needPay,payRand')->select();
		if(empty($orders))return [];
		$needPay = 0;
		$payRand = 0;
		foreach($orders as $order){
            $needPay += $order['needPay'];
            if($payRand<$order['payRand'])$payRand = $order['payRand'];
		}
		$data = array();
		$data["needPay"] = $needPay;
		$data["payRand"] = $payRand;
		return $data;
	}

	/**
     * 根据订单id,订单商品id获取单个商品信息
     */
    public function getOrderInfoByGoodsId($uId=0){
        $orderId = (int)input('orderId');
        $orderGoodsId = (int)input('orderGoodsId');
        $userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;

        $goodsInfo = Db::name('order_goods')
            ->field('id,orderId,goodsName,goodsId,goodsImg,goodsCode')
            ->where(['orderId'=>$orderId,'id'=>$orderGoodsId])
            ->find();
        return $goodsInfo;
    }

    /**
	 * 检查订单是否已支付
	 */
	public function checkOrderPay ($obj){
		$userId = $obj["userId"];
		$orderId = $obj["orderId"];
		$rs = array();
		$where = ["userId"=>$userId,"dataFlag"=>1,"orderStatus"=>-2,"isPay"=>0,"payType"=>1];
		$where['orderId'] = $orderId;
		
		$rs = $this->field('orderId,orderNo')->where($where)->select();
		if(count($rs)>0){
			return WSTReturn('',1);
		}else{
			return WSTReturn('订单已支付',-1);
		}
	}
}
