<?php
namespace wststore\common\model;

/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 商城消息
 */
class Messages extends Base{
   /**
    * 获取列表
    */
    public function pageQuery($uId=0){
         $userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
         $where = ['userId'=>(int)$userId,'dataFlag'=>1];
         $page = $this->where($where)->order('msgStatus asc,id desc')->paginate(input('pagesize/d'))->toArray();
         foreach ($page['data'] as $key => $v){
         	$page['data'][$key]['msgContent'] = WSTMSubstr(strip_tags(htmlspecialchars_decode($v['msgContent'])),0,140);
         }
         return $page;
    }
   /**
    *  获取某一条消息详情
    */
    public function getById($uId=0){
    	  $userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
        $id = (int)input('msgId');
        $data = $this->get(['id'=>$id,'userId'=>$userId]);
        if(!empty($data)){
          $data['msgContent'] = htmlspecialchars_decode($data['msgContent']);
          if($data['msgStatus']==0){
            $this->where('id',$id)->setField('msgStatus',1);
          }
        }
        return $data;
    }

    /**
     * 删除
     */
    public function del(){
    	$userId = (int)session('WST_USER.userId');
        $id = input('id/d');
        $data = [];
        $data['dataFlag'] = -1;
        $result = $this->update($data,['id'=>$id,'userId'=>$userId]);
        if(false !== $result){
            return WSTReturn("删除成功", 1);
        }else{
            return WSTReturn($this->getError(),-1);
        }
    }
    /**
    * 批量删除
    */
    public function batchDel($uId=0){
    	  $userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
        $ids = WSTFormatIn(',',input('ids'));
        $data = [];
        $data['dataFlag'] = -1;
        $result = $this->update($data,[['id','in',$ids],['userId','=',$userId]]);
        if(false !== $result){
            return WSTReturn("删除成功", 1);
        }else{
            return WSTReturn($this->getError(),-1);
        }
    }
}
