<?php
namespace wststore\common\model;
use wststore\common\validate\GoodsAppraises as Validate;
use think\Db;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 评价类
 */
class GoodsAppraises extends Base{
    /**
     *  获取评论
     */
    public function getAppr($uId=0){
        $userId = ($uId>0)?$uId:(int)session('WST_USER.userId');
        $orderId = (int)input('orderId');
        $rss['goodsId']= (int)input('goodsId');
        $rss['goodsScore'] = $rss['timeScore'] = $rss['serviceScore'] = $rss['content'] = '';
        $rs = $this->where(['orderId'=>$orderId,'userId'=>$userId,'goodsId'=>$rss['goodsId']])->find();
        $rs['orderGoodsId'] = $rss['orderGoodsId'] = (int)input('orderGoodsId');
        if($rs!==false){
            if(empty($rs['id']))$rs = $rss;
            return WSTReturn('',1,$rs);
        }
        return WSTReturn('获取出错',-1);
    }
 	/**
	* 添加评价
	*/
	public function add($uId=0){
		//检测订单是否有效
		$orderId = (int)input('orderId');
		$goodsId = (int)input('goodsId');
		$orderGoodsId = (int)input('orderGoodsId');
		if($orderGoodsId==0)return WSTReturn('数据出错,请联系管理员');
		$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
		$goodsScore = (int)input('goodsScore');
		$timeScore = (int)input('timeScore');
		$serviceScore = (int)input('serviceScore');
		$content = input('content');
		if(isset($content)){
			if(!WSTCheckFilterWords($content,WSTConf("CONF.limitWords"))){
				return WSTReturn("点评内容包含非法字符");
			}
		}
		$orders = model('orders')->where(['orderId'=>$orderId,'dataFlag'=>1])->field('orderStatus,orderNo,isAppraise,orderScore,shopId')->find();
		if(empty($orders))return WSTReturn("无效的订单");
		if($orders['orderStatus']!=2)return WSTReturn("订单状态已改变，请刷新订单后再尝试!");
		//检测商品是否已评价
		$apCount = $this->where(['orderGoodsId'=>$orderGoodsId,'dataFlag'=>1])->count();
		if($apCount>0)return WSTReturn("该商品已评价!");
		Db::startTrans();
		try{	
			//增加订单评价
			$data = [];
			$data['shopId'] = $orders['shopId'];
			$data['userId'] = $userId;
			$data['goodsId'] = $goodsId;
			$data['orderId'] = $orderId;
			$data['goodsScore'] = $goodsScore;
			$data['serviceScore'] = $serviceScore;
			$data['timeScore']= $timeScore;
			$data['content'] = $content;
			$data['images'] = input('images');
			$data['createTime'] = date('Y-m-d H:i:s');
			$data['orderGoodsId'] = $orderGoodsId;
			if(empty(WSTConf('CONF.isAppraise'))){
                $data['isShow'] = 0;
			}
			$validate = new Validate;
			if (!$validate->scene('add')->check($data)) {
				return WSTReturn($validate->getError());
			}else{
				$rs = $this->allowField(true)->save($data);
			}
			if($rs !==false){
				WSTUseImages(0, $this->id, $data['images']);
				//增加商品评分
				
			    if(!empty(WSTConf('CONF.isAppraise'))){
				$prefix = config('database.prefix');
				$updateSql = "update ".$prefix."goods_scores set 
				             totalScore=totalScore+".(int)($goodsScore+$serviceScore+$timeScore).",
				             goodsScore=goodsScore+".(int)$goodsScore.",
				             serviceScore=serviceScore+".(int)$serviceScore.",
				             timeScore=timeScore+".(int)$timeScore.",
				             totalUsers=totalUsers+1,goodsUsers=goodsUsers+1,serviceUsers=serviceUsers+1,timeUsers=timeUsers+1
				             where goodsId=".$goodsId;
				Db::execute($updateSql);
				//增加商品评价数
				Db::name('goods')->where('goodsId',$goodsId)->setInc('appraiseNum');
			    }
				// 查询该订单是否已经完成评价,修改orders表中的isAppraise
				$ogRs = Db::name('order_goods')->alias('og')
				   ->join('__GOODS_APPRAISES__ ga','og.orderId=ga.orderId and og.goodsId=ga.goodsId ','left')
				   ->where('og.orderId',$orderId)->field('og.id,ga.id gid')->select();
				$isFinish = true;
				foreach ($ogRs as $key => $v){
					if($v['id']>0 && $v['gid']==''){
						$isFinish = false;
						break;
					}
				}
				//订单商品全部评价完则修改订单状态
				if($isFinish){
					if(WSTConf("CONF.isAppraisesScore")==1){
						$appraisesScore = (int)WSTConf('CONF.appraisesScore');
						if($appraisesScore>0){
							//给用户增加积分
							$score = [];
							$score['userId'] = $userId;
							$score['score'] = $appraisesScore;
							$score['dataSrc'] = 1;
							$score['dataId'] = $orderId;
							$score['dataRemarks'] = "评价订单【".$orders['orderNo']."】获得积分".$appraisesScore."个";
							$score['scoreType'] = 1;
							$score['createTime'] = date('Y-m-d H:i:s');
							// 增加用户积分,总积分
							model('UserScores')->add($score);
						}
					}
					//修改订单评价状态
					model('orders')->where('orderId',$orderId)->update(['isAppraise'=>1,'isClosed'=>1]);
				}
				Db::commit();
				return WSTReturn('评价成功',1);
			}else{
				return WSTReturn($this->getError(),-1);
			}
		}catch (\Exception $e) {
		    Db::rollback();
	        return WSTReturn('评价失败',-1);
	    }

	}

    /**
     * 根据商品id取第一条好评评论（用户展示商品详情）
     */
    public function getGoodsFirstAppraise($goodsId,$ftype = 1){
        $where = ['ga.goodsId'=>$goodsId,
            'ga.dataFlag'=>1,
            'ga.isShow'=>1];
        $filterWhere = "(ga.goodsScore+ga.serviceScore+ga.timeScore)>=15*0.9";
        $rs = [];
        $rs  = 	$this->alias('ga')
            ->field('ga.id,ga.content,ga.images,ga.shopReply,ga.replyTime,ga.createTime,ga.goodsScore,ga.serviceScore,ga.timeScore,ga.shopId,ga.orderId,s.shopName,u.userPhoto,u.loginName,u.userTotalScore')
            ->join('__USERS__ u','ga.userId=u.userId','left')
            ->join('__ORDER_GOODS__ og','og.orderId=ga.orderId and og.id=ga.orderGoodsId and og.goodsId=ga.goodsId','inner')
            ->join('__SHOPS__ s','ga.shopId=s.shopId','inner')
            ->where($where)
            //->where($filterWhere)
            ->order('ga.id desc')
            ->find();
        if($rs){
            // 格式化时间
            $rs['createTime'] = date('Y-m-d',strtotime($rs['createTime']));
            if($rs['images']!=''){
                $rs['images'] = explode(',',$rs['images']);
            }else{
                $rs['images'] = [];
            }
            if($ftype==1)$rs['userPhoto'] = WSTUserPhoto($rs['userPhoto']);
        }
        return $rs;
    }

    /**
     * 根据商品id取评论
     */
    public function getById(){
        // 处理匿名
        $goodsId = (int)input('goodsId');
        $where = ['ga.goodsId'=>$goodsId,
            'ga.dataFlag'=>1,
            'ga.isShow'=>1];
        // 筛选条件
        $type = input('type');
        $filterWhere = '';
        switch ($type) {
            case 'pic':// 晒图
                $filterWhere = " ga.images <> '' ";
                break;
            case 'best':// 好评
                $filterWhere = "(ga.goodsScore+ga.serviceScore+ga.timeScore)>=15*0.9";
                break;
            case 'good':// 中评
                $filterWhere = "(ga.goodsScore+ga.serviceScore+ga.timeScore)>=15*0.6 and (ga.goodsScore+ga.serviceScore+ga.timeScore)<15*0.9";
                break;
            case 'bad':// 差评
                $filterWhere = "(ga.goodsScore+ga.serviceScore+ga.timeScore)<15*0.6";
                break;
        }
        $rs  = 	$this->alias('ga')
            ->field('ga.id,ga.content,ga.images,ga.shopReply,ga.replyTime,ga.createTime,ga.goodsScore,ga.serviceScore,ga.timeScore,ga.shopId,ga.orderId,s.shopName,u.userPhoto,u.loginName,u.userTotalScore')
            ->join('__USERS__ u','ga.userId=u.userId','left')
            ->join('__ORDER_GOODS__ og','og.orderId=ga.orderId and og.id=ga.orderGoodsId and og.goodsId=ga.goodsId','inner')
            ->join('__SHOPS__ s','ga.shopId=s.shopId','inner')
            ->where($where)
            ->where($filterWhere)
            ->order('ga.id desc')
            ->paginate(input('pagesize/d'))
            ->toArray();
        foreach($rs['data'] as $k=>$v){
            // 格式化时间
            $rs['data'][$k]['createTime'] = date('Y-m-d',strtotime($v['createTime']));
            // 总评分
            $rs['data'][$k]['avgScore'] = ceil(($v['goodsScore'] + $v['serviceScore'] + $v['timeScore'])/3);

            //获取用户等级
            $rrs = WSTUserRank($v['userTotalScore']);
            $rs['data'][$k]['rankImg']  = $rrs['userrankImg'];
            $rs['data'][$k]['rankName'] = empty($rrs['rankName'])?' ':$rrs['rankName'];

        }
        // 获取该商品 各评价数
        $eachApprNum = $this->getGoodsEachApprNum($goodsId);
        $rs['bestNum'] = $eachApprNum['best'];
        $rs['goodNum'] = $eachApprNum['good'];
        $rs['badNum'] = $eachApprNum['bad'];
        $rs['picNum'] = $eachApprNum['pic'];
        $rs['sum'] = $eachApprNum['sum'];
        if($rs!==false){
            return WSTReturn('',1,$rs);
        }else{
            return WSTReturn($this->getError(),-1);
        }
    }
    /**
     * 根据商品id获取各评价数
     */
    public function getGoodsEachApprNum($goodsId){
        $rs = $this->field('(goodsScore+timeScore+serviceScore) as sumScore')->where(['dataFlag'=>1,'isShow'=>1,'goodsId'=>$goodsId])->select();
        $data = [];
        $best=0;
        $good=0;
        $bad=0;
        foreach($rs as $k=>$v){
            $sumScore = $v['sumScore'];
            // 计算好、差评数
            if($sumScore >= 15*0.9){
                ++$best;
            }else if($sumScore < 15*0.6){
                ++$bad;
            }
        }
        $data['best'] = $best;
        $data['bad'] = $bad;
        $data['good'] = count($rs)-$best-$bad;
        // 晒图评价数
        $data['pic'] = $this->where([['images','<>',''],['goodsId','=',$goodsId],['isShow','=',1],['dataFlag','=',1]])->count();
        // 总评价数
        $data['sum'] = $this->where(['dataFlag'=>1,'isShow'=>1,'goodsId'=>$goodsId])->count();
        return $data;
    }

    /**
     * 根据商品id获取评价数
     */
    public function getGoodsAppraiseCount($goodsId){
        $rs = $this->where(['dataFlag'=>1,'isShow'=>1,'goodsId'=>$goodsId])->count();
        return (!empty($rs))?$rs:0;
    }
}
