<?php
namespace wststore\common\model;
use think\Db;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 购物车业务处理类
 */

class Carts extends Base{
	protected $pk = 'cartId';
	/**
	 * 加入购物车
	 */
	public function addCart($uId=0){
		$userId = ($uId)>0?$uId:(int)session('WST_USER.userId');
		$goodsId = (int)input('post.goodsId');
		$cartNum = (int)input('post.buyNum',1);
		$cartNum = ($cartNum>0)?$cartNum:1;
		if($userId==0)return WSTReturn('加入购物车失败，请先登录',-2);
		//验证传过来的商品是否合法
		$chk = $this->checkGoodsSaleSpec($goodsId);
		if($chk['status']==-1)return $chk;
		//检测库存是否足够
		if($chk['data']['stock']<$cartNum)return WSTReturn("加入购物车失败，商品库存不足", -1);
		$goods = $this->where(['userId'=>$userId,'goodsId'=>$goodsId])->select();
		if(count($goods)==0){
			$data = array();
			$data['userId'] = $userId;
			$data['goodsId'] = $goodsId;
			$data['isCheck'] = 1;
			$data['cartNum'] = $cartNum;
			$rs = $this->save($data);
		}else{
			$rs = $this->where(['userId'=>$userId,'goodsId'=>$goodsId])->setInc('cartNum',$cartNum);
		}
		if(false !==$rs){
            $cartId = $this->where(['userId'=>$userId,'goodsId'=>$goodsId])->value('cartId');
			return WSTReturn("添加成功", 1,['cartId'=>$cartId]);
		}
		return WSTReturn("加入购物车失败", -1);
	}
	/**
	 * 验证商品是否合法
	 */
	public function checkGoodsSaleSpec($goodsId){
		$goods = model('Goods')->alias('g')->join('__GOODS_LIBS__ gl','gl.goodsLibId=g.goodsLibId','left')
		->where(['g.isSale'=>1,'g.goodsId'=>$goodsId,'gl.isSale'=>1,'gl.dataFlag'=>1])
		->field('g.goodsId,g.goodsStock')->find();
		if(empty($goods))return WSTReturn("添加失败，无效的商品信息", -1);
		$goodsStock = (int)$goods['goodsStock'];
		return WSTReturn("", 1,['goodsSpecId'=>0,'stock'=>$goodsStock]);
	}
	/**
	 * 获取购物车列表
	 */
	public function getCarts($isSettlement = false,$uId=0,$sId=0){
		$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
		$shopId = ($sId==0)?(int)session('WST_USER_SHOP.shopId'):$sId;
		$where = [];
		$where['c.userId'] = $userId;
		$where['s.shopId'] = $shopId;
		$prefix = config('database.prefix');
		if($isSettlement)$where['c.isCheck'] = 1;
		$rs = Db::table($prefix.'carts')
		->alias([$prefix.'carts'=>'c',$prefix.'goods' => 'g',$prefix.'shops' => 's',$prefix.'goods_libs' => 'gl'])
		->join($prefix.'goods','c.goodsId=g.goodsId','inner')
		->join($prefix.'shops','s.shopId=g.shopId','left')
		->join($prefix.'goods_libs','gl.goodsLibId=g.goodsLibId','left')
		->where($where)
		->field('c.cartId,c.isCheck,c.cartNum,c.userId,s.shopId,s.shopName,s.freight,g.goodsId,gl.goodsName,g.shopPrice,g.goodsStock,gl.goodsImg,gl.goodsCatId')
		->select();
		$carts = [];
		$freight = 0;
		$goodsTotalNum = 0;
		$goodsTotalMoney = 0;
		foreach ($rs as $key =>$v){
			$freight = $v['freight'];
			//判断能否购买，预设allowBuy值为10，为将来的各种情况预留10个情况值，从0到9
			$v['allowBuy'] = 10;
			if($v['goodsStock']<=0){
				$v['allowBuy'] = 0;//库存不足
			}else if($v['goodsStock']<$v['cartNum']){
				//$v['allowBuy'] = 1;//库存比购买数小
				$v['cartNum'] = $v['goodsStock'];
			}
			//如果是结算的话，则要过滤了不符合条件的商品
			if($isSettlement && $v['allowBuy']!=10){
				$this->disChkGoods($v['goodsId'],$userId);
				continue;
			}
			if($v['isCheck']==1){
				$goodsTotalMoney = $goodsTotalMoney + $v['shopPrice'] * $v['cartNum'];
				$goodsTotalNum++;
			}
			$carts[] = $v;
		}
        $cartData = ['carts'=>$carts,'goodsTotalMoney'=>$goodsTotalMoney,'goodsTotalNum'=>$goodsTotalNum,'freight'=>$freight];
        //店铺优惠活动监听
        hook("afterQueryCarts",["carts"=>&$cartData,'isSettlement'=>$isSettlement,'isVirtual'=>false,'uId'=>$userId]);
		return $cartData;
	}
	/**
	 * 获取加入商品数量
	 */
	public function cartGoodsNum($uId=0){
		$userId = ($uId>0)?$uId:(int)session('WST_USER.userId');
		$rs = Db::name('carts')->where(['userId'=>$userId])->field('cartId,goodsId,cartNum')->select();
		$data = [];
		if($rs){
			foreach ($rs as $key =>$v){
				$data[$v['goodsId']] = $v['cartNum'];
			}
		}
		return $data;
	}
	/**
	 * 修改购物车商品数量
	 */
	public function changeCartNum($uId=0){
		$buyNum = (int)input('post.buyNum/d');
		$id = input('post.id/d');
		$userId = ($uId>0)?$uId:(int)session('WST_USER.userId');
		$data = [];
		$data['cartNum'] = $buyNum;
		if($buyNum==0){
			$this->where(['userId'=>$userId,'goodsId'=>$id])->delete();
		}else{
			$this->where(['userId'=>$userId,'goodsId'=>$id])->update($data);
		}
		return WSTReturn("操作成功", 1,WSTCartNum());
	}
	/**
	 * 修改购物车商品状态
	 */
	public function changeCartGoods($uId=0){
		$isCheck = input('post.isCheck/d',-1);
		$buyNum = input('post.buyNum/d',1);
		$id = input('post.id/d');
		$type = input('post.type');
		$userId = ($uId>0)?$uId:(int)session('WST_USER.userId');
		$data = [];
		if($isCheck!=-1)$data['isCheck'] = $isCheck;
		$where['userId'] = $userId;
		if($type==1){
			$where['goodsId'] = $id;
		}else{
			$where['cartId'] = $id;
			if($buyNum<1)$buyNum = 1;
		}
		$data['cartNum'] = $buyNum;
		if($buyNum==0){
			$this->where($where)->delete();
		}else{
			$this->where($where)->update($data);
		}
		return WSTReturn("操作成功", 1);
	}
	/**
	 * 批量修改购物车商品状态
	 */
	public function batchChangeCartGoods($uId=0){
		$ids = input('ids');
		if($ids=='')return WSTReturn("操作失败");
		$ids = explode(',',WSTFormatIn(',',$ids));
		$userId = ($uId>0)?$uId:(int)session('WST_USER.userId');
		$isCheck = ((int)input('post.isCheck/d',-1)==1)?1:0;
		$this->where([['cartId','in',$ids],['userId','=',$userId]])->update(['isCheck'=>$isCheck]);
		return WSTReturn("操作成功", 1);
	}
	/**
	 * 取消购物车商品选中状态
	 */
	public function disChkGoods($goodsId,$userId){
		$this->save(['isCheck'=>0],['userId'=>$userId,'goodsId'=>$goodsId]);
	}
	/**
	 * 删除购物车里的商品
	 */
	public function delCart($uId=0){
		$userId = ($uId>0)?$uId:(int)session('WST_USER.userId');
		$id = input('post.id');
		$id = explode(',',WSTFormatIn(",",$id));
		$id = array_filter($id);
		$this->where("userId = ".$userId." and cartId in(".implode(',', $id).")")->delete();
		return WSTReturn("删除成功", 1);
	}
	/**
	 * 计算订单金额
	 */
	public function getCartMoney($uId=0,$sId=0){
		$data = ['freight'=>0,'totalMoney'=>0,'totalGoodsMoney'=>0];
		$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
		$shopId = ($sId==0)?(int)session('WST_USER_SHOP.shopId'):$sId;
		$addressId = (int)input('post.addressId');
		//计算各店铺运费及金额
		$deliverType = (int)input('deliverType');
		$carts = $this->getCarts(true,$userId,$shopId);
		$shopFreight = 0;
		if($addressId>0){
			$shopFreight = ($deliverType==1)?0:WSTOrderFreight($userId,$shopId,$addressId);
		}else{
			$shopFreight = 0;
		}
		$data['freight'] = $shopFreight;
		foreach ($carts['carts'] as $key =>$v){
			$data['totalGoodsMoney'] += $v['shopPrice'] * $v['cartNum'];
		}
		hook("afterCalculateCartMoney",["data"=>&$data,'carts'=>$carts,'uId'=>$uId]);
		$data['totalMoney'] = $data['totalGoodsMoney'] + $shopFreight;
		$data['totalGoodsMoney'] = ($data['totalGoodsMoney']>$data['totalMoney'])?$data['totalMoney']:$data['totalGoodsMoney'];
		$data['maxScore'] = 0;
		$data['maxScoreMoney'] = 0;
		$data['useScore'] = 0;
		$data['scoreMoney'] = 0;
		//计算最大可用积分
		$maxScoreMoney = $data['totalGoodsMoney'];
		$maxScore = WSTScoreToMoney($data['totalGoodsMoney'],true);
		//最大可用积分不能大于用户积分
		$user = model('users')->getFieldsById($userId,'userScore');
		if($maxScore>$user['userScore']){
			$maxScore = $user['userScore'];
			$maxScoreMoney = WSTScoreToMoney($maxScore);
		}
		$data['maxScore'] = $maxScore;
		$data['maxScoreMoney'] = $maxScoreMoney;
		//判断是否使用积分
		$isUseScore = (int)input('isUseScore');
		if($isUseScore==1){
			//不能比用户积分还多
			$useScore = (int)input('useScore');
			if($useScore>$maxScore)$useScore = $maxScore;
			$data['useScore'] = $useScore;
            $data['scoreMoney'] = WSTScoreToMoney($useScore);
		}
		$data['realTotalMoney'] = WSTBCMoney($data['totalMoney'],-$data['scoreMoney'],2);

		return WSTReturn('',1,$data);
	}
}
