var grid;
$(function(){
    var laydate = layui.laydate;
    laydate.render({
        elem: '#startDate'
    });
    laydate.render({
        elem: '#endDate'
    });
})
function toView(id){
	location.href=WST.U('admin/orders/view','id='+id);
}

function initRefundGrid(){
    var h = WST.pageHeight();
    var cols = [
            {title:'订单编号', name:'orderNo',sortable: true, renderer: function(val,item,rowIndex){
            	var h = "";
	            h += "<img class='order-source' src='"+WST.conf.STATIC+"/images/order_source_"+item['orderSrc']+".png'>";  
                h += "<a style='cursor:pointer' onclick='javascript:showDetail("+ item['orderId'] +");'>"+item['orderNo']+"</a>";
	            return h;
            }},
            {title:'用户', name:'loginName',sortable: true},
            {title:'订单来源', name:'orderCodeTitle',width:40,sortable: true,hidden: true},
            {title:'配送方式', name:'deliverType',width:40,sortable: true,hidden: true},
            {title:'实收金额', name:'realTotalMoney', width:30,sortable: true,renderer: function(val,item,rowIndex){
            	return "¥"+val;
            }},
            {title:'待退金额', name:'refundMoney',width:30,sortable: true, renderer: function(val,item,rowIndex){
                return "¥"+val;
            }},
            {title:'创建时间', name:'createTime',sortable: true},
            {title:'支付来源', name:'payFrom',sortable: true},
            {title:'退款状态', name:'isRefund', width:30,sortable: true,renderer: function(val,item,rowIndex){
            	return (item['isRefund']==1)?"已退款":"未退款";
            }},
            {title:'退款备注', name:'refundRemark',hidden: true},
            {title:'操作', name:'op' ,width:120, align:'center', renderer: function(val,item,rowIndex){
                var h = '';
	            h += "<a class='btn btn-blue' href='javascript:toView(" + item['orderId'] + ")'><i class='fa fa-search'></i>详情</a> ";
	            return h;
	        }}
            ];
 
    mmg = $('.mmg').mmGrid({height: (h-90),indexCol: true, indexColWidth:50, cols: cols,method:'POST',
        url: WST.U('admin/orderrefunds/queryByPage'), fullWidthRows: true, autoLoad: true,nowrap:true,
        remoteSort:true ,
        sortName: 'createTime',
        sortStatus: 'desc',
        plugins: [
            $('#pg').mmPaginator({})
        ]
    });  
}
function loadRefundGrid(){
	var p = WST.getParams('.j-ipt');
	p.page = 1;
	mmg.load(p);
}
function showDetail(id){
    parent.showBox({title:'订单详情',type:2,content:WST.U('admin/orders/view',{id:id,from:1}),area: ['1020px', '500px'],btn:['关闭']});
}
function toExport(){
	var params = {};
	params = WST.getParams('.j-ipt');
	var box = WST.confirm({content:"您确定要导出订单吗?",yes:function(){
		layer.close(box);
		location.href=WST.U('admin/orderrefunds/toExport',params);
    }});
}