var mmg;
function initGrid(){
    var h = WST.pageHeight();
    var cols = [
            {title:'银行名称', name:'bankName', width: 600},
            {title:'银行图标', name:'bankImg', width: 30, renderer: function(val,item,rowIndex){
               return'<img src="'+WST.conf.ROOT+'/'+item['bankImg']+'" height="28px" />';
            }},
            {title:'操作', name:'' ,width:40, align:'center', renderer: function(val,item,rowIndex){
                var h = "";
                if(WST.GRANT.YHGL_02)h += "<button  class='btn btn-blue' onclick='javascript:getForEdit("+item['bankId']+")'><i class='fa fa-pencil'></i>修改</button> ";
                if(WST.GRANT.YHGL_03)h += "<button  class='btn btn-red' onclick='javascript:toDel(" + item['bankId'] + ")'><i class='fa fa-trash-o'></i>删除</button> "; 
                return h;
            }}
            ];
 
    mmg = $('.mmg').mmGrid({height: h-90,indexCol: true, cols: cols,method:'POST',
        url: WST.U('admin/banks/pageQuery'), fullWidthRows: true, autoLoad: true,
        plugins: [
            $('#pg').mmPaginator({})
        ]
    });   
}
function toDel(id){
	var box = WST.confirm({content:"您确定要删除该记录吗?",yes:function(){
	           var loading = WST.msg('正在提交数据，请稍后...', {icon: 16,time:60000});
	           	$.post(WST.U('admin/banks/del'),{id:id},function(data,textStatus){
	           			  layer.close(loading);
	           			  var json = WST.toAdminJson(data);
	           			  if(json.status=='1'){
	           			    	WST.msg("操作成功",{icon:1});
	           			    	layer.close(box);
	           		            mmg.load();
	           			  }else{
	           			    	WST.msg(json.msg,{icon:2});
	           			  }
	           		});
	            }});
}

function getForEdit(id){
	if(id>0){
		 var loading = WST.msg('正在获取数据，请稍后...', {icon: 16,time:60000});
	     $.post(WST.U('admin/banks/get'),{id:id},function(data,textStatus){
	           layer.close(loading);
	           var json = WST.toAdminJson(data);
	           if(json.bankId){
	           		WST.setValues(json);
	           		if(json.bankImg){
						$('#preview').html('<img src="'+WST.conf.ROOT+'/'+json.bankImg+'" height="70px" />');
					}else{
						$('#preview').html('');
					}
	           		toEdit(json.bankId);
	           }else{
	           		WST.msg(json.msg,{icon:2});
	           }
	    });
	}else{
		$('#preview').html('');
		WST.setValues({bankId:0,bankName:'',bankImg:''});
	    toEdit(0);
	}
}
var isInitUpload = false;
function toEdit(id){
	if(!isInitUpload)initUpload();
	var title =(id==0)?"新增":"编辑";
	var box = WST.open({title:title,type:1,content:$('#bankBox'),area: ['450px', '320px'],btn:['确定','取消'],yes:function(){
		$('#bankForm').submit();
	},cancel:function(){
		$('#bankBox').hide();
	},btn2:function(){
	    $('#bankBox').hide();
	 }});
	$('#bankForm').validator({
        fields: {
            bankName: {
            	rule:"required;",
            	msg:{required:"银行名称不能为空"},
            	tip:"请输入银行名称",
            	ok:""
            },
            bankImg: {
            	rule:"required;",
            	msg:{required:"银行图标不能为空"},
            	tip:"请输入银行图标",
            	ok:""
            }
        },
       valid: function(form){
		        var params = WST.getParams('.ipt');
	                params.bankId = id;
	                var loading = WST.msg('正在提交数据，请稍后...', {icon: 16,time:60000});
	           		$.post(WST.U('admin/banks/'+((id==0)?"add":"edit")),params,function(data,textStatus){
	           			  layer.close(loading);
	           			  var json = WST.toAdminJson(data);
	           			  if(json.status=='1'){
	           			    	WST.msg("操作成功",{icon:1});
	           			    	$('#bankForm')[0].reset();
	           			    	$('#bankBox').hide();
	           			    	layer.close(box);
	           		            mmg.load();
	           			  }else{
	           			        WST.msg(json.msg,{icon:2});
	           			  }
	           		});

    	}

  });

}

function initUpload(){
	isInitUpload = true;
	//文件上传
	WST.upload({
	    pick:'#bankFilePicker',
	    formData: {dir:'banks'},
	    accept: {extensions: 'gif,jpg,jpeg,png',mimeTypes: 'image/jpg,image/jpeg,image/png,image/gif'},
	    callback:function(f){
	      var json = WST.toAdminJson(f);
	      if(json.status==1){
	        $('#uploadMsg').empty().hide();
	        //将上传的图片路径赋给全局变量
		    $('#bankImg').val(json.savePath+json.thumb);
		    $('#preview').html('<img src="'+WST.conf.ROOT+'/'+json.savePath+json.thumb+'" height="75" />');
	      }else{
	      	WST.msg(json.msg,{icon:2});
	      }
	  },
	  progress:function(rate){
	      $('#uploadMsg').show().html('已上传'+rate+"%");
	  }
	});
}