<?php 
namespace wststore\admin\validate;
use think\Validate;
use think\Db;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 职员验证器
 */
class Staffs extends Validate{
	protected $rule = [
	    'loginName'=>'require|max:20|checkLoginName:1',
	    'loginPwd'=>'require|min:6',
        'staffName'=>'require|max:60',
        'workStatus'=>'require|in:0,1',
        'staffStatus'=>'require|in:0,1'
    ];
    protected $message  =   [
        'loginName.require' => '请输入登录账号',
        'loginName.max'     => '登录账号不能超过20个字符',
        'loginName.checkLoginName'   => '',
        'loginPwd.require'  => '请输入登录密码',
        'loginPwd.min'  => '登录密码不能少于6个字符',  
        'staffName.require'  => '请输入职员名称',  
        'staffName.max'  => '职员名称不能超过20个字符',  
        'workStatus.require'  => '请选择工作状态', 
        'workStatus.in'  => '无效的工作状态值', 
        'staffStatus.require'  => '请选择账号状态'
    ];

    protected $scene = [
        'add'   =>  ['loginName','loginPwd','staffName','workStatus','staffStatus'],
        'edit'  =>  ['staffName','workStatus','staffStatus']
    ]; 
    
    protected function checkLoginName($value){
    	$where = [];
    	$where[] = ['dataFlag','=',1];
    	$where[] = ['loginName','=',$value];
    	$rs = Db::name('staffs')->where($where)->count();
    	return ($rs==0)?true:'该登录账号已存在';
    }
}