<?php 
namespace wststore\admin\validate;
use think\Validate;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 店铺验证器
 */
class Shops extends Validate{
	protected $rule = [
	    'shopSn'=>'checkShopSn:1',
	    'shopName'=>'require|max:40',
        'shopTel'=>'require|max:40',
        'shopkeeper'=>'require|max:100',
        'telephone'=>'require|max:40',
        'isSelf'=>'in:0,1',
        'areaId'=>'require',
        'longitude'=>'require',
        'latitude'=>'require',
        'serviceRadius'=>'require',
        'shopAddress'=>'require',
        'shopAtive'=>'in:0,1',
        'bankUserName'=>'require|max:100',
        'bankNo'=>'require',
        'bankId'=>'require',
        'bankAreaId'=>'require',
        'shopStatus'=>'in:-1,1',
        'statusDesc'=>'checkStatusDesc:1'
    ];

    protected $message  =   [
        'shopSn.checkShopSn' => '请输入门店编号|门店编号不能超过20个字符',
        'shopName.require' => '请输入门店名称',
        'shopName.max' => '门店名称不能超过20个字符',
        'shopTel.require' => '请输入公司联系电话',
        'shopTel.max' => '公司联系电话不能超过20个字符',
        'shopkeeper.require' => '请输入公司紧急联系人',
        'shopkeeper.max' => '公司紧急联系人不能超过50个字符',
        'telephone.require' => '请输入公司紧急联系人手机',
        'telephone.max' => '公司紧急联系人手机不能超过20个字符',
        'isSelf.in' => '无效的自营店类型',
        'areaId.require' => '请选择公司所在区域',
        'longitude.require' => '请在地图上标出门店地址',
        'latitude.require' => '请在地图上标出门店地址',
        'serviceRadius.require' => '请填写配送半径',
        'shopAddress.require' => '请输入公司详细地址',
        'shopAtive.in' => '无效的营业状态',
        'bankUserName.require' => '请输入银行开户名',
        'bankUserName.max' => '银行开户名称长度不能能超过50个字符',
        'bankNo.require' => '请输入对公结算银行账号',
        'bankId.require' => '请选择结算银行',
        'bankAreaId.require' => '请选择开户所地区',
        'shopStatus.in' => '无效的门店状态',
        'statusDesc.checkStatusDesc' => '请输入门店停止原因'
    ];

    protected $scene = [
        'add'   =>  ['shopSn','shopName','shopCompany','shopkeeper','telephone','shopCompany','shopTel','isSelf',
                     'areaId','longitude','latitude','shopAddress','shopAtive','bankId','bankAreaId','bankNo','bankUserName','shopAtive'],
        'edit'  =>  ['shopSn','shopName','shopCompany','shopkeeper','telephone','shopCompany','shopTel','isSelf',
                     'areaId','longitude','latitude','shopAddress','shopAtive','bankId','bankAreaId','bankNo','bankUserName','shopAtive']
    ]; 
    
    protected function checkShopSn($value){
    	$shopId = Input('post.shopId/d',0);
    	$key = Input('post.shopSn');
    	if($shopId>0){
    		if($key=='')return '请输入门店编号';
    		$isChk = model('Shops')->checkShopSn($key,$shopId);
    		if($isChk)return '对不起，该门店编号已存在';
    	}
    	return true;
    }
    
    protected function checkStatusDesc($value){
    	$shopStatus = Input('post.shopStatus/d',0);
    	$key = Input('post.statusDesc');
    	return ($shopStatus==-1 && $key=='')?'请输入门店停止原因':true;
    }
}