<?php
namespace wststore\admin\validate;
use think\Validate;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 商品库验证器
 */
class GoodsLibs extends Validate{
	protected $rule = [
		'goodsName' => 'require|max:300',
		'goodsImg' => 'require',
		'goodsSn' => 'checkGoodsSn:1',
		'productNo' => 'checkProductNo:1',
		'costPrice' => 'checkCostPrice:1',
		'shopCostPrice'=> 'checkShopCostPrice:1',
		'retailPrice' => 'checkRetailPrice:1',
		'goodsUnit' => 'require',
		'isSale' => 'in:,0,1',
		'isRecom' => 'in:,0,1',
		'isBest' => 'in:,0,1',
		'isNew' => 'in:,0,1',
		'isHot' => 'in:,0,1',
		'isFreeShipping' => 'in:,0,1',
		'goodsCatId' => 'require',
		'goodsDesc' => 'require'
	];
	
	protected $message  =  [
		'goodsName.require' => '请输入商品名称',
		'goodsName.max' => '商品名称不能超过100个字符',
		'goodsImg.require' => '请上传商品图片',
		'goodsSn.checkGoodsSn' => '请输入商品编号',
		'productNo.checkProductNo' => '请输入商品货号',
		'costPrice.checkCostPrice' => '请输入成本价',
		'shopCostPrice.checkShopCostPrice' => '请输入门店进货价',
		'retailPrice.checkRetailPrice' => '请输入零售价',
		'goodsUnit.require' => '请输入商品单位',
		'isSale.in' => '无效的上架状态',
		'isRecom.in' => '无效的推荐状态',
		'isBest.in' => '无效的精品状态',
		'isNew.in' => '无效的新品状态',
		'isHot.in' => '无效的热销状态',
		'isFreeShipping.in' => '无效的包邮状态',
		'goodsCatId.require' => '请选择商品分类',
		'goodsDesc.require' => '请输入商品描述'
	];
	
	
    /**
     * 检测商品编号
     */
    protected function checkGoodsSn($value){
    	$goodsId = Input('post.goodsLibId/d',0);
    	$key = Input('post.goodsSn');
    	if($key=='')return '请输入商品编号';
    	$isChk = model('GoodsLibs')->checkExistGoodsKey('goodsSn',$key,$goodsId);
    	if($isChk)return '对不起，该商品编号已存在';
    	return true;
    }
    /**
     * 检测商品货号
     */
    protected function checkProductNo($value){
    	$goodsId = Input('post.goodsLibId/d',0);
    	$key = Input('post.productNo');
    	if($key=='')return '请输入商品货号';
    	$isChk = model('GoodsLibs')->checkExistGoodsKey('productNo',$key,$goodsId);
    	if($isChk)return '对不起，该商品货号已存在';
    	return true;
    }
    /**
     * 检测价格
     */
    public function checkCostPrice(){
        $costPrice = floatval(input('post.costPrice'));
        if($costPrice<0.01)return '成本价不能小于0.01';
        return true;
    }
    public function checkShopCostPrice(){
        $shopCostPrice = floatval(input('post.shopCostPrice'));
        if($shopCostPrice<0.01)return '门店进货价不能小于0.01';
        return true;
    }
    public function checkRetailPrice(){
        $retailPrice = floatval(input('post.retailPrice'));
        if($retailPrice<0.01)return '建议零售价不能小于0.01';
        return true;
    }
}