<?php
namespace wststore\admin\model;
use wststore\admin\validate\Shops as validate;
use think\Db;
use think\Loader;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 店铺业务处理
 */
class Shops extends Base{
	protected $pk = 'shopId';
	/**
	 * 分页
	 */
	public function pageQuery($shopStatus=1){
		$areaIdPath = input('areaIdPath');
		$shopName = input('shopName');
		$isSelf = input('isSelf/d',-1);
		$where = [];
		$where[] = ['s.dataFlag','=',1];
		$where[] = ['s.shopStatus','=',$shopStatus];
		if($isSelf!=-1)$where[] = ['s.isSelf','=',$isSelf];
		if($shopName!='')$where[] = ['shopName','like','%'.$shopName.'%'];
		if($areaIdPath !='')$where[] = ['areaIdPath','like',$areaIdPath."%"];
		$sort = input('sort');
		$order = [];
		if($sort!=''){
			$sortArr = explode('.',$sort);
			$order = $sortArr[0].' '.$sortArr[1];
		}
		return Db::table('__SHOPS__')->alias('s')->join('__AREAS__ a2','s.areaId=a2.areaId','left')
			       ->where($where)
			       ->field('s.shopId,shopSn,shopName,a2.areaName,shopkeeper,telephone,shopAddress,isSelf,shopAtive,shopStatus')
			       ->order($order)
			       ->paginate(input('limit/d'));
	}

	/**
	 * 列表
	 */
	public function listQuery($shopStatus = -100,$isSelf = -100){
		$where = [];
		$where['dataFlag'] = 1;
		if($shopStatus!=-100)$where['shopStatus'] = $shopStatus;
		if($isSelf!=-100)$where['isSelf'] = $isSelf;
		return Db::table('__SHOPS__')->where($where)
		         ->field('shopId,shopSn,shopName')
		         ->order('shopId desc')->select();
	}

	/**
	 * 删除
	 */
    public function del(){
	    $id = input('post.id/d');
		Db::startTrans();
        try{
	        $shop = $this->get($id);
	        $shop->dataFlag = -1;
	        $result = $shop->save();
            if(false !== $result){
            	//下架及下架商品
        	    Db::commit();
        	    return WSTReturn("删除成功", 1);
            }
        }catch (\Exception $e) {
            Db::rollback();
        }
        return WSTReturn('删除失败',-1);
	}
	
	/**
	 * 获取店铺信息
	 */
	public function getById($id){
		$shop = $this->alias('s')
                   ->where('s.shopId',$id)
                   ->find()
                   ->toArray();
		//获取认证类型
	    $shopAccreds = Db::name('shop_accreds')->where('shopId',$id)->select();
	    $shop['accreds'] = [];
		foreach ($shopAccreds as $v){
			$shop['accreds'][$v['accredId']] = true;
		}
        return $shop;
	}
	/**
	 * 生成店铺编号
	 * @param $key 编号前缀,要控制不要超过int总长度，最好是一两个字母
	 */
	public function getShopSn($key = ''){
		$rs = $this->Max("REPLACE(shopSn,'S','')+''");
		if($rs==''){
			return $key.'000000001';
		}else{
			for($i=0;$i<1000;$i++){
			   $num = (int)str_replace($key,'',$rs);
			   $shopSn = $key.sprintf("%09d",($num+1));
			   $ischeck = $this->checkShopSn($shopSn);
			   if(!$ischeck)return $shopSn;
			}
			return '';//一直都检测到那就不要强行添加了
		}
	}
	
	/**
	 * 检测店铺编号是否存在
	 */
	public function checkShopSn($shopSn,$shopId=0){
		$dbo = $this->where(['shopSn'=>$shopSn,'dataFlag'=>1]);
		if($shopId>0)$dbo->where('shopId','<>',$shopId);
		$num = $dbo->Count();
		if($num==0)return false;
		return true;
	}

	/**
	 * 新增
	 */
	public function add(){
		$data = input('post.');
    	$validate = new validate();
		if(!$validate->scene('add')->check($data))return WSTReturn($validate->getError());	
        $accredIds = Input('post.accredIds');
        Db::startTrans();
        try{
	        //创建商家基础信息
		    $data['createTime'] = date('Y-m-d H:i:s');
		    $areaIds = model('Areas')->getParentIs($data['areaId']);
			if(!empty($areaIds))$data['areaIdPath'] = implode('_',$areaIds)."_";
			$areaIds = model('Areas')->getParentIs($data['bankAreaId']);
			if(!empty($areaIds))$data['bankAreaIdPath'] = implode('_',$areaIds)."_";
		    WSTUnset($data,'id,shopId,dataFlag');
		    if($data['shopSn']=='')$data['shopSn'] = $this->getShopSn('S');
	        $this->allowField(true)->save($data);
	        $shopId = $this->shopId;
		        
	        //建立店铺配置信息
	        $sc = [];
	        $sc['shopId'] = $shopId;
	        Db::name('ShopConfigs')->insert($sc);
	        //建立店铺评分记录
			$ss = [];
			$ss['shopId'] = $shopId;
			Db::name('shop_scores')->insert($ss);
		    //认证类型
	        if($accredIds!=''){
	            $accreds = explode(',',$accredIds);
		        foreach ($accreds as $v){
			        if((int)$v>0)Db::name('shop_accreds')->insert(['shopId'=>$shopId,'accredId'=>$v]);
			    }
	        }
	        //拷贝店铺角色
	        $shoproles = Db::name('shop_roles')->where([['shopId','=',0],['dataFlag','=',1]])->select();
            if(count($shoproles)>0){
            	foreach ($shoproles as $key => $v) {
            		$shoproles[$key]['sysRoleId'] = $shoproles[$key]['roleId'];
            		$shoproles[$key]['shopId'] = $shopId;
            		$shoproles[$key]['createTime'] = date('Y-m-d H:i:s');
            		unset($shoproles[$key]['roleId']);
            	}
                Db::name('shop_roles')->insertAll($shoproles);
            }
	        Db::commit();
	        return WSTReturn("新增成功", 1);
        }catch (\Exception $e) {
            Db::rollback();
            return WSTReturn('新增失败',-1);
        }
	}
    /**
	 * 编辑
	 */
	public function edit(){
		$data = input('post.');
		$shopId = input('post.shopId/d',0);
		$shops = $this->get($shopId);
		if(empty($shops) || $shops->dataFlag!=1)return WSTReturn('门店不存在');
		$validate = new validate();
		if(!$validate->scene('edit')->check($data))return WSTReturn($validate->getError());	
        $accredIds = input('post.accredIds');
        Db::startTrans();
        try{
	        //保存店铺基础信息
	        $areaIds = model('Areas')->getParentIs($data['areaId']);
		    if(!empty($areaIds))$data['areaIdPath'] = implode('_',$areaIds)."_";
		    $areaIds = model('Areas')->getParentIs($data['bankAreaId']);
		    if(!empty($areaIds))$data['bankAreaIdPath'] = implode('_',$areaIds)."_";
	        WSTUnset($data,'id,shopId,dataFlag,createTime,accredIds,isSelf');
	        $this->allowField(true)->save($data,['shopId'=>$shopId,'dataFlag'=>1]);
	       
		    //认证类型
		    Db::name('shop_accreds')->where('shopId','=',$shopId)->delete();
	        if($accredIds!=''){
	            $accreds = explode(',',$accredIds);
		        foreach ($accreds as $key =>$v){
			        if((int)$v>0){
			        	Db::name('shop_accreds')->insert(['shopId'=>$shopId,'accredId'=>$v]);
			        }
			    }
	        }
		    if((int)input('shopStatus')!=1){
		        //店铺状态不正常就停用所有的商品
		        model('shop/goods')->unsaleByShopId($shopId);
		    } 
	        Db::commit();
	        return WSTReturn("编辑成功", 1);
        }catch (\Exception $e) {
            Db::rollback();
            return WSTReturn('编辑失败',-1);
        }
	}
}
