<?php
namespace wststore\admin\model;
use think\Db;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 进货单控制器
 */
class Purchases extends Base{
	/**
	 * 获取进货单列表
	 */
	public function pageQuery(){
		$key = input('key');
		$startDate = input('startDate');
		$endDate = input('endDate');
		$where = [];		
		if($key!='')$where[] = ['p.purchaseNo','like','%'.$key.'%'];
		if($startDate!='')$where[] = ['p.createTime','>=',$startDate." 00:00:00"];
		if($endDate!='')$where[] = ['p.createTime','<=',$endDate." 23:59:59"];
        return $this->alias('p')->join('__STAFFS__ s','s.staffId=p.staffId')
                    ->join('__SHOPS__ sp','sp.shopId=p.shopId')
                    ->field('p.*,s.staffName,sp.shopName')
                    ->where($where)->order('id desc')
                    ->paginate(input('limit/d'))->toArray();
	}

	/**
	 * 获取进货单明细
	 */
	public function getById(){
		$id = input('id/d');
		$shopId = (int)session('WST_SHOP.shopId');
		$rs = $this->where([['id','=',$id],['dataFlag','=',1],['shopId','=',$shopId]])->find();
		if(empty($rs))return [];
		$rs['list']  = Db::name('purchase_goods')->alias('pg')
		         ->join('__GOODS_LIBS__ gl','gl.goodsLibId=pg.goodsLibId')
		         ->where([['pg.purchaseId','=',$id],['pg.shopId','=',$shopId]])
		         ->field('gl.goodsLibId,gl.goodsName,pg.goodsPrice,pg.goodsQty,pg.receiveQty')
		         ->select();
        return $rs;
	}

	/**
	 * 处理请求
	 */
	public function handle(){
		$id = input('id/d');
		$status = input('type/d');
		if(!in_array($status,[1,2]))return WSTReturn('无效的操作状态');
		$result = $this->save(['purchaseStatus'=>$status],['dataFlag'=>1,'id'=>$id]);
		if($result!==false){
			return WSTReturn('操作成功',1);
		}else{
			return WSTReturn('操作失败');
		}
	}
}
