<?php 
namespace wststore\admin\model;
use think\Db;
use think\facade\Env;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 系统业务处理
 */
class Index extends Base{
    /**
	 * 清除缓存
	 */
	public function clearCache(){
		$dirpath = Env::get('runtime_path')."cache";
		$isEmpty = WSTDelDir($dirpath);
		return $isEmpty;
	}
	/**
	 * 获取基础统计信息
	 */
	public function summary(){
		$data = [];
		$today = date('Y-m-d');
		//销量
		$data['sale']['today'] = Db::name('orders')->where([['orderStatus','<>',-1],['dataFlag','=',1],['createTime','like',$today.'%']])->sum('totalMoney');
		//订单
		$data['order']['today'] = Db::name('orders')->where([['orderStatus','<>',-1],['dataFlag','=',1],['createTime','like',$today.'%']])->count();
		//会员
		$data['user']['today'] = Db::name('users')->where([['userType','=',0],['createTime','like',$today.'%'],['dataFlag','=',1]])->count();
		//退款
		$data['refund']['today'] = Db::name('order_refunds')->where([['createTime','like',$today.'%']])->count();
        //昨天的信息
        $yesterday = date("Y-m-d",strtotime("-1 day"));
        $ydata = cache('WST_ADMIN_MAIN'.$yesterday);
        if(!$ydata){
        	$ydata = [];
        	$ydata['sale'] = Db::name('orders')->where([['orderStatus','<>',-1],['dataFlag','=',1],['createTime','like',$yesterday.'%']])->sum('totalMoney');
            $ydata['order'] = Db::name('orders')->where([['orderStatus','<>',-1],['dataFlag','=',1],['createTime','like',$yesterday.'%']])->count();
            
            $ydata['user'] = Db::name('users')->where([['userType','=',0],['createTime','like',$yesterday.'%'],['dataFlag','=',1]])->count();
            $ydata['refund'] = Db::name('order_refunds')->where([['createTime','like',$today.'%']])->count();
            cache('WST_ADMIN_MAIN'.$yesterday,$ydata,86400);
        }
        $data['sale']['yesterday'] = $ydata['sale'];
        $data['order']['yesterday'] = $ydata['order'];
        $data['user']['yesterday'] = $ydata['user'];
        $data['refund']['yesterday'] = $ydata['refund'];
        //退款申请
        $data['tips']['refund'] = Db::name('order_refunds')->where([['refundStatus','=',1]])->count();
        //订单投诉
        $data['tips']['complains'] = Db::name('order_complains')->where([['complainTime','like',date('Y-m-d').'%'],['complainStatus','in',[0,3]]])->count();
		$rs = Db::query('select VERSION() as sqlversion');
		$data['MySQL_Version'] = $rs[0]['sqlversion'];
		$data['time']['startDate'] = date('Y-m-d',strtotime("-1month"));
        $data['time']['endDate'] = date('Y-m-d');
		return $data;
	}
	
    /**
	 * 保存授权码
	 */
	public function saveLicense(){
		$data = [];
		$data['fieldValue'] = input('license');
	    $result = model('SysConfigs')->where('fieldCode','mallLicense')->update($data);
		if(false !== $result){
			cache('WST_CONF',null);
			return WSTReturn("操作成功",1);
		}
		return WSTReturn("操作失败");
	}
}