<?php
namespace wststore\admin\model;
use wststore\admin\validate\GoodsLibs as Validate;
use think\Db;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 商品库类
 */
class GoodsLibs extends Base{
    protected $pk = 'goodsLibId';

    /**
	 * 检测商品主表的货号或者商品编号
	 */
	public function checkExistGoodsKey($key,$val,$id = 0){
		if(!in_array($key,array('goodsSn','productNo')))return WSTReturn("非法的查询字段");
		$conditon = [$key=>$val];
		if($id>0)$conditon[] = ['goodsLibId','<>',$id];
		$rs = $dbo = $this->where($conditon)->count();
		return ($rs==0)?false:true;
	}
    /**
	 * 新增商品
	 */
	public function add(){
		$data = input('post.');
		WSTUnset($data,'goodsLibId,dataFlag');
		if(isset($data['goodsName'])){
			if(!WSTCheckFilterWords($data['goodsName'],WSTConf("CONF.limitWords"))){
				return WSTReturn("商品名称包含非法字符");
			}
		}
		if(isset($data['goodsTips'])){
			if(!WSTCheckFilterWords($data['goodsTips'],WSTConf("CONF.limitWords"))){
				return WSTReturn("商品促销信息包含非法字符");
			}
		}
		if($data['isSale']==1 && $data['goodsImg']==''){
			return WSTReturn("上架商品必须有商品图片");
		}
		if(isset($data['goodsDesc'])){
			if(!WSTCheckFilterWords($data['goodsDesc'],WSTConf("CONF.limitWords"))){
				return WSTReturn("商品描述包含非法字符");
			}
		}
		$data['saleTime'] = date('Y-m-d H:i:s');
		$data['createTime'] = date('Y-m-d H:i:s');
		$goodsCats = model('GoodsCats')->getParentIs($data['goodsCatId']);		
		$data['goodsCatIdPath'] = implode('_',$goodsCats)."_";
		Db::startTrans();
        try{
        	$validate = new Validate;
        	if (!$validate->scene(true)->check($data)) {
        		return WSTReturn($validate->getError());
        	}else{
        		$result = $this->allowField(true)->save($data);
        	}
			if(false !== $result){
				$goodsLibId = $this->goodsLibId;
				//商品图片
				WSTUseImages(0, $goodsLibId, $data['goodsImg']);
				//商品相册
				WSTUseImages(0, $goodsLibId, $data['gallery']);
				//商品描述图片
				WSTEditorImageRocord(0, $goodsLibId, '',$data['goodsDesc']);
				//建立商品评分记录
				$gs = [];
				$gs['goodsLibId'] = $goodsLibId;
				Db::name('goods_scores')->insert($gs);
    	        //保存商品属性
		    	$attrsArray = [];
		    	$attrRs = Db::name('attributes')->where([['goodsCatId','in',$goodsCats],['isShow','=',1],['dataFlag','=',1]])
		    		            ->field('attrId')->select();
		    	foreach ($attrRs as $key =>$v){
		    		$attrs = [];
		    		$attrs['attrVal'] = input('attr_'.$v['attrId']);
		    		if($attrs['attrVal']=='')continue;
		    		$attrs['goodsLibId'] = $goodsLibId;
		    		$attrs['attrId'] = $v['attrId'];
		    		$attrs['createTime'] = date('Y-m-d H:i:s');
		    		$attrsArray[] = $attrs;
		    	}
		    	if(count($attrsArray)>0)Db::name('goods_attributes')->insertAll($attrsArray);
		    	//保存关键字
        	    $searchKeys = WSTGroupGoodsSearchKey($goodsLibId);
        	    $this->where('goodsLibId',$goodsLibId)->update(['goodsSerachKeywords'=>implode(',',$searchKeys)]);
    	        Db::commit();
				return WSTReturn("新增成功", 1,['id'=>$goodsLibId]);
			}else{
				return WSTReturn($this->getError(),-1);
			}
        }catch (\Exception $e) {
            Db::rollback();
            return WSTReturn('新增失败',-1);
        }
	}
	
	/**
	 * 编辑商品资料
	 */
	public function edit(){
	    $goodsLibId = input('post.goodsLibId/d');
		$data = input('post.');
		WSTUnset($data,'goodsLibId,dataFlag,createTime');
		$ogoods = $this->where(['goodsLibId'=>$goodsLibId,'dataFlag'=>1])->field('goodsImg')->find();
		if(empty($ogoods))return WSTReturn('商品不存在');
		if(isset($data['goodsName'])){
			if(!WSTCheckFilterWords($data['goodsName'],WSTConf("CONF.limitWords"))){
				return WSTReturn("商品名称包含非法字符");
			}
		}
		if($ogoods['goodsImg']=='' && $data['isSale']==1 && $data['goodsImg']==''){
			return WSTReturn("上架商品必须有商品图片");
		}
		if(isset($data['goodsTips'])){
			if(!WSTCheckFilterWords($data['goodsTips'],WSTConf("CONF.limitWords"))){
				return WSTReturn("商品促销信息包含非法字符");
			}
		}
		if(isset($data['goodsDesc'])){
			if(!WSTCheckFilterWords($data['goodsDesc'],WSTConf("CONF.limitWords"))){
				return WSTReturn("商品描述包含非法字符");
			}
		}
		$data['saleTime'] = date('Y-m-d H:i:s');
		$goodsCats = model('GoodsCats')->getParentIs($data['goodsCatId']);
		$data['goodsCatIdPath'] = implode('_',$goodsCats)."_";
		Db::startTrans();
        try{
        	//商品图片
			WSTUseImages(0, $goodsLibId, $data['goodsImg'],'GoodsLibs','goodsImg');
			//商品相册
			WSTUseImages(0, $goodsLibId, $data['gallery'],'GoodsLibs','gallery');
			// 商品描述图片
	        $desc = $this->where('goodsLibId',$goodsLibId)->value('goodsDesc');
			WSTEditorImageRocord(0, $goodsLibId, $desc, $data['goodsDesc']);
			$validate = new Validate;
			if (!$validate->scene(true)->check($data)) {
				return WSTReturn($validate->getError());
			}else{
				$result = $this->allowField(true)->save($data,['goodsLibId'=>$goodsLibId]);
			}
			if(false !== $result){
    	        //保存商品属性
    	        //删除之前的商品属性
    	        Db::name('goods_attributes')->where(['goodsLibId'=>$goodsLibId])->delete();
    	        //新增商品属性
		    	$attrsArray = [];
		    	$attrRs = Db::name('attributes')->where([['goodsCatId','in',$goodsCats],['isShow','=',1],['dataFlag','=',1]])
		    		            ->field('attrId')->select();
		    	foreach ($attrRs as $key =>$v){
		    		$attrs = [];
		    		$attrs['attrVal'] = input('attr_'.$v['attrId']);
		    		if($attrs['attrVal']=='')continue;
		    		$attrs['goodsLibId'] = $goodsLibId;
		    		$attrs['attrId'] = $v['attrId'];
		    		$attrs['createTime'] = date('Y-m-d H:i:s');
		    		$attrsArray[] = $attrs;
		    	}
		    	if(count($attrsArray)>0)Db::name('goods_attributes')->insertAll($attrsArray);
		    	//保存关键字
        	    $searchKeys = WSTGroupGoodsSearchKey($goodsLibId);
        	    $this->where('goodsLibId',$goodsLibId)->update(['goodsSerachKeywords'=>implode(',',$searchKeys)]);
		    	//删除购物车里的商品
		    	//model('common/carts')->delCartByUpdate($goodsId);
				Db::commit();
				return WSTReturn("编辑成功", 1,['id'=>$goodsLibId]);
			}else{
				return WSTReturn($this->getError(),-1);
			}
	    }catch (\Exception $e) {
        	Db::rollback();
            return WSTReturn('编辑失败',-1);
        }
	}
	/**
	 * 获取商品信息
	 */
	public function getById($id){
        $data = $this->where(['goodsLibId'=>$id,'dataFlag'=>1])->find();
        if($data['gallery']!='')$data['gallery'] = explode(',',$data['gallery']);
        //获取属性值
		$data['attrs'] = Db::name('goods_attributes')->alias('ga')->join('attributes a','ga.attrId=a.attrId','inner')
			                 ->where('goodsLibId',$id)->field('ga.attrId,a.attrType,ga.attrVal')->select();
		return $data;
	}
     /**
      *  上架商品列表
      */
	public function saleByPage(){
		$where = [];
		$where[] = ['g.dataFlag','=',1];
		$where[] = ['g.isSale','=',1];
		$goodsCatId = (int)input('goodsCatId');
		$goodsName = input('goodsName');
		if($goodsCatId>0)$where[] = ['goodsCatId','=',$goodsCatId];
		if($goodsName != '')$where[] = ['goodsName|goodsSn','like',"%$goodsName%"];
		// 排序
		$sort = input('sort');
		$order = 'saleTime desc';
		if($sort!=''){
			$sortArr = explode('.',$sort);
			$order = $sortArr[0].' '.$sortArr[1];
		}
		$rs = $this->alias('g')->join('__GOODS_CATS__ s','g.goodsCatId=s.catId','left')
		    ->where($where)
			->field('goodsLibId,goodsName,goodsSn,costPrice,shopCostPrice,retailPrice,goodsImg,goodsCatId,s.catName,isNew,isHot,isRecom,isBest')
			->order($order)
			->paginate(input('limit/d'))->toArray();
        if(count($rs['data'])>0){
        	$libs = [];
        	foreach ($rs['data'] as $key => $v) {
        		$libs[] = $v['goodsLibId'];
        	}
        	$saleNums = Db::name('goods')->field('goodsLibId,count(saleNum) saleNum')
        	  ->where([['goodsLibId','in',$libs]])
        	  ->group('goodsLibId')
        	  ->select();
        	$libs = [];
        	foreach ($saleNums as $key => $v) {
        		$libs[$v['goodsLibId']] = $v['saleNum'];
        	}
        	foreach ($rs['data'] as $key => $v) {
        		$rs['data'][$key]['saleNum'] = isset($libs[$v['goodsLibId']])?$libs[$v['goodsLibId']]:0;
        	}
        }
		return $rs;
	}
    /**
      *  仓库商品列表
      */
	public function storeByPage(){
		$where = [];
		$where[] = ['g.dataFlag','=',1];
		$where[] = ['g.isSale','=',0];
		$goodsCatId = (int)input('goodsCatId');
		$goodsName = input('goodsName');
		if($goodsName != '')$where[] = ['goodsName|goodsSn','like',"%$goodsName%"];
		// 排序
		$sort = input('sort');
		$order = 'saleTime desc';
		if($sort!=''){
			$sortArr = explode('.',$sort);
			$order = $sortArr[0].' '.$sortArr[1];
		}
		$rs = $this->alias('g')->join('__GOODS_CATS__ s','g.goodsCatId=s.catId','left')
		    ->where($where)
			->field('goodsLibId,goodsName,goodsSn,costPrice,shopCostPrice,retailPrice,goodsImg,goodsCatId,s.catName,isNew,isHot,isRecom,isBest')
			->order($order)
			->paginate(input('limit/d'))->toArray();
		return $rs;
	}
	/**
	 * 删除商品
	 */
	public function del(){
	    $id = input('post.id/d');
		$data = [];
		$data['dataFlag'] = -1;
		$data['isSale'] = 0;
		Db::startTrans();
		try{
		    $result = $this->update($data,['goodsLibId'=>$id]);
	        if(false !== $result){
	        	//Db::name('carts')->where('goodsLibId',$id)->delete();
	        	WSTUnuseImage('GoodsLibs','goodsImg',$id);
		        WSTUnuseImage('GoodsLibs','gallery',$id);
		        Db::commit();
		        //标记删除购物车
	        	return WSTReturn("删除成功", 1);
	        }
		}catch (\Exception $e) {
            Db::rollback();
        }
        return WSTReturn('删除失败',-1);
	}
	/**
	  * 批量删除商品
	  */
	 public function batchDel(){
	 	$shopId = (int)session('WST_USER.shopId');
	   	$ids = input('post.ids/a');
	   	Db::startTrans();
		try{
		   	$rs = $this->where(['goodsLibId'=>['in',$ids],
		   						'shopId'=>$shopId])->setField(['dataFlag'=>-1,'isSale'=>0]);
			if(false !== $rs){
				//Db::name('carts')->where(['goodsId'=>['in',$ids]])->delete();
				//标记删除购物车
			    foreach ($ids as $v){
					WSTUnuseImage('goods','goodsImg',(int)$v);
			        WSTUnuseImage('goods','gallery',(int)$v);
				}
				Db::commit();
	        	return WSTReturn("删除成功", 1);
	        }
		}catch (\Exception $e) {
            Db::rollback();
        }
        return WSTReturn('删除失败',-1);
	 }

	 /**
	 * 获取商品规格属性
	 */
	public function getAttrs(){
		$goodsCatId = Input('post.goodsCatId/d');
		$goodsCatIds = model('GoodsCats')->getParentIs($goodsCatId);
		$data = [];
		$data['attrs'] = Db::name('attributes')->where([['dataFlag','=',1],['isShow','=',1],['goodsCatId','in',$goodsCatIds]])->field('attrId,attrName,attrType,attrVal')->order('attrSort asc,attrId asc')->select();
	    return WSTReturn("", 1,$data);
	}

	/**
	* 修改商品状态
	*/
	public function changSaleStatus(){
		$is = input('post.is');
		if(!in_array($is,['isRecom','isBest','isHot','isNew']))return WSTReturn('非法的操作');
		$status = (input('post.status',1)==1)?0:1;
		$id = (int)input('post.id');
		$rs = $this->update([$is=>$status],['goodsLibId'=>$id]);
		if($rs!==false){
			return WSTReturn('设置成功',1);
		}else{
			return WSTReturn($this->getError(),-1);
		}
	}

	/**
	 * 批量上架商品
	 */
	public function changeSale(){
		$ids = input('ids');
		$isSale = (int)input('isSale',1);
		$ids = explode(',' , $ids);
		//判断商品是否满足上架要求
		if($isSale==1){
	 		//直接设置上架 返回受影响条数
	 		$where = [];
	 		$where[] = ['g.goodsLibId','in',$ids];
	 		$where[] = ['gc.dataFlag','=',1];
	 		$where[] = ['gc.isShow','=',1];
	 		$where[] = ['g.goodsImg','<>',""];
			$rs = $this->alias('g')
				  ->join('__GOODS_CATS__ gc','g.goodsCatId=gc.CatId','inner')
				  ->where($where)->setField('isSale',1);
			if($rs!==false){
				$status = ($rs==count($ids))?1:2;
				if($status==1){
					return WSTReturn('商品上架成功', 1,['num'=>$rs]);
				}else{
					return WSTReturn('已成功上架商品'.$rs.'件，请核对未能上架的商品信息是否完整。', 2,['num'=>$rs]);
				}
			}else{
	 			return WSTReturn('上架失败，请核对商品信息是否完整!', -2);
	 		}

		}else{
			$rs = $this->where([['goodsLibId','in',$ids]])->setField('isSale',$isSale);
			if($rs !== false){
				return WSTReturn('商品下架成功', 1);
			}else{
				return WSTReturn($this->getError(), -1);
			}
		}
	}

}
