<?php
namespace wststore\admin\controller;
use wststore\admin\model\Images as M;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 文章控制器
 */
class Images extends Base{
	/**
	 * 进入主页面
	 */
    public function index(){
    	return $this->fetch();
    }
    /**
     * 获取概况  
     * 后台商城消息 编辑器中的图片只记录上传图片容量  删除相关数据时无法标记图片为已删除状态
     */
    public function summary(){
    	$m = new M();
    	$data = $m->summary();
        return WSTReturn("", 1,$data);
    }
    /***
     * 获取相似商品
     */
    public function imgUpload(){
        $fileKey = key($_FILES);
        $dir = Input('param.dir');
        if($dir=='')return json_encode(['msg'=>'没有指定文件目录！','status'=>-1]);
        $dirs = WSTConf("CONF.wstUploads");
        if(!in_array($dir, $dirs)){
            return json_encode(['msg'=>'非法文件目录！','status'=>-1]);
        }
        // 上传文件
        $file = request()->file($fileKey);
        if($file===null){
            return json_encode(['msg'=>'上传文件不存在或超过服务器限制','status'=>-1]);
        }
        $validate = new \think\Validate([
            ['fileMime','fileMime:image/png,image/gif,image/jpeg,image/x-ms-bmp','只允许上传jpg,gif,png,bmp类型的文件'],
            ['fileExt','fileExt:jpg,jpeg,gif,png,bmp','只允许上传后缀为jpg,gif,png,bmp的文件'],
            ['fileSize','fileSize:2097152','文件大小超出限制'],//最大2M
        ]);
        $data = ['fileMime'  => $file,
                 'fileSize' => $file,
                 'fileExt'=> $file
                ];
        if (!$validate->check($data)) {
            return json_encode(['msg'=>$validate->getError(),'status'=>-1]);
        }
        $info = $file->rule('uniqid')->move(ROOT_PATH.'/upload/'.$dir."/".date('Y-m'));
        $hasher = new \Jenssegers\ImageHash\ImageHash();
        $hashCode =  $hasher->hash($info->getPathname());
        return json_encode(['code'=>$hashCode]);
    }
    /**
	 * 进入列表页面
	 */
    public function lists(){
    	$datas = model('Datas')->listQuery(3);
    	$this->assign('datas',$datas);
    	$this->assign('keyword',input('get.keyword'));
    	return $this->fetch('list');
    }
    /**
     * 获取分页
     */
    public function pageQuery(){
        $m = new M();
        return WSTGrid($m->pageQuery());
    }
    /**
     * 检测图片信息
     */
    public function checkImages(){
    	$imgPath = input('get.imgPath');
    	$m = WSTConf('CONF.wstMobileImgSuffix');
	    $imgPath = str_replace($m.'.','.',$imgPath);
	    $imgPath = str_replace($m.'_thumb.','.',$imgPath);
	    $imgPath = str_replace('_thumb.','.',$imgPath);
	    $imgPath_thumb = str_replace('.','_thumb.',$imgPath);
	    $mimg = '';
	    $mimg_thumb = '';
	    if($m!=''){
		    $mimg = str_replace('.',$m.'.',$imgPath);
		    $mimg_thumb = str_replace('.',$m.'_thumb.',$imgPath);
	    }
    	$data['imgpath']=$imgPath;
    	$data['img']=file_exists(WSTRootPath()."/".$imgPath)?true:false;
    	$data['thumb']=file_exists(WSTRootPath()."/".$imgPath_thumb)?true:false;
    	$data['thumbpath']=$imgPath_thumb;
    	$data['mimg']=file_exists(WSTRootPath()."/".$mimg)?true:false;
    	$data['mimgpath']=$mimg;
    	$data['mthumb']=file_exists(WSTRootPath()."/".$mimg_thumb)?true:false;
    	$data['mthumbpath']=$mimg_thumb;
    	return $this->fetch('view',$data);
    }
    /**
     * 删除
     */
    public function del(){
        $m = new M();
        return $m->del();
    }  
}
