<?php
namespace wststore\admin\controller;
use wststore\admin\model\GoodsLibs as M;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 商品库控制器
 */
class GoodsLibs extends Base{
   /**
    *  上架商品列表
    */
	public function index(){
		return $this->fetch('list_sale');
	}
	/**
	 * 获取上架商品列表
	 */
	public function saleByPage(){
		$m = new M();
		$rs = $m->saleByPage();
		$rs['status'] = 1;
		return WSTGrid($rs);
	}
	/**
	 * 仓库中商品
	 */
    public function store(){
		return $this->fetch('list_store');
	}

	/**
	 * 获取仓库中的商品
	 */
    public function storeByPage(){
		$m = new M();
		$rs = $m->storeByPage();
		$rs['status'] = 1;
		return WSTgrid($rs);
	}
    
    /**
     * 跳去编辑页面
     */
    public function toEdit(){
        $id = (int)input('get.id');
    	$m = new M();
        if($id>0){
            $object = $m->getById($id);
        }else{
            $object = $m->getEModel('goods_libs');
            $object['goodsSn'] = WSTGoodsNo();
            $object['productNo'] = WSTGoodsNo();
        }
    	$data = ['object'=>$object,'src'=>input('src')];
    	return $this->fetch('edit',$data);
    }
    
    /**
     * 编辑商品
     */
    public function edit(){
    	$m = new M();
    	return $m->edit();
    }
    /**
     * 新增商品
     */
    public function add(){
        $m = new M();
        return $m->add();
    }
    /**
     * 删除商品
     */
    public function del(){
    	$m = new M();
    	return $m->del();
    }

    /**
     * 获取商品规格属性
     */
    public function getAttrs(){
        $m = new M();
        return $m->getAttrs();
    }

    /**
    * 修改商品状态
    */
    public function changSaleStatus(){
        $m = new M();
        return $m->changSaleStatus();
    }

   /**
    *   批量上(下)架
    */
    public function changeSale(){
        $m = new M();
        return $m->changeSale();
    }

}
