<?php
namespace wststore\admin\controller;
use think\Controller;
use think\Request;
use think\App;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 */
class Base extends Controller{
    public function __construct(Request $request = null,App $app){
		parent::__construct($request,$app);
		$this->assign("v",WSTConf('CONF.wstVersion'));
        $this->view->filter(function($content){
            return str_replace("__ADMIN__",str_replace('/index.php','',$this->request->root()).'/wststore/admin/view',$content);
        });
	}
	public function getVerify(){
		WSTVerify();
	}
	
	public function uploadPic(){
		return WSTUploadPic(1);
	}

	/**
    * 编辑器上传文件
    */
    public function editorUpload(){
        return WSTEditUpload(1);
    }

    // 登录验证方法--用户
    public function checkAdminAuth(){
        $STAFF = session('WST_STAFF');
        $request = request();
        if(empty($STAFF)){
            if($request->isAjax()){
                echo json_encode(['status'=>-999,'msg'=>'对不起，您还没有登录，请先登录']);
            }else{
                header("Location:".url('admin/index/login'));
            }
            exit();
        }else{
            /*$urls = WSTVisitPrivilege();
            $privileges = session('WST_STAFF.privileges');
            $visit = $request->path();
            if(!$privileges || (array_key_exists($visit,$urls) && !$this->checkUserCode($urls[$visit],$privileges))){
                if($request->isAjax()){
                    echo json_encode(['status'=>-998,'msg'=>'对不起，您没有操作权限，请与管理员联系']);
                }else{
                    header("Content-type: text/html; charset=utf-8");
                    echo "对不起，您没有操作权限，请与管理员联系";
                }
                exit();
            }*/
        }
    }
}
