SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS `wst_shops`;
CREATE TABLE `wst_shops` (
  `shopId` int(11) NOT NULL AUTO_INCREMENT,
  `shopSn` varchar(20) DEFAULT '',
  `areaIdPath` varchar(255) DEFAULT '',
  `areaId` int(11) DEFAULT '0',
  `isSelf` tinyint(4) NOT NULL DEFAULT '0',
  `shopName` varchar(100) DEFAULT '',
  `shopkeeper` varchar(50) DEFAULT '',
  `telephone` varchar(20) DEFAULT '',
  `shopCompany` varchar(255) DEFAULT '',
  `shopImg` varchar(150) DEFAULT '',
  `shopTel` varchar(40) DEFAULT '',
  `shopQQ` varchar(50) DEFAULT NULL,
  `shopWangWang` varchar(50) DEFAULT NULL,
  `shopAddress` varchar(255) DEFAULT '',
  `bankId` int(11) DEFAULT '0',
  `bankNo` varchar(20) DEFAULT '',
  `bankUserName` varchar(50) DEFAULT '',
  `serviceStartTime` time NOT NULL DEFAULT '08:30:00',
  `serviceEndTime` time NOT NULL DEFAULT '22:30:00',
  `freight` int(11) DEFAULT '0',
  `shopAtive` tinyint(4) NOT NULL DEFAULT '1',
  `shopStatus` tinyint(4) NOT NULL DEFAULT '1',
  `statusDesc` varchar(255) DEFAULT NULL,
  `dataFlag` tinyint(4) NOT NULL DEFAULT '1',
  `createTime` date DEFAULT NULL,
  `shopMoney` decimal(11,2) DEFAULT '0.00',
  `lockMoney` decimal(11,2) DEFAULT '0.00',
  `bankAreaId` int(11) DEFAULT '0',
  `bankAreaIdPath` varchar(100) DEFAULT NULL,
  `shopNotice` varchar(300) DEFAULT NULL COMMENT '店铺公告',
  `longitude` varchar(30) DEFAULT NULL,
  `latitude` varchar(30) DEFAULT NULL,
  `mapLevel` int(11) DEFAULT '16',
  `serviceRadius` int(11) DEFAULT '1' COMMENT '公里',
  PRIMARY KEY (`shopId`),
  KEY `shopStatus` (`shopStatus`,`dataFlag`) USING BTREE,
  KEY `areaIdPath` (`areaIdPath`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4;


INSERT INTO `wst_shops` VALUES ('1', 'S000000001', '6_76_693_', '693', '1', '广州珠江新城店', '王先生', '13800138000', '', '', '020-85289921', '', '', '广东省广州市天河区花城大道85号', '17', '88888888888888', '商淘信息科技有限公司', '08:30:00', '22:30:00', '0', '1', '1', '', '1', '2020-04-27', '0.00', '0.00', '693', '6_76_693_', null, '113.321764', '23.119966', '17', '3'),
('2', 'S000000002', '6_76_693_', '693', '1', '广州燕塘店', '马先生', '15918671994', '', '', '020-85289921', '', '', '广东省广州市天河区燕岭路89号', '17', '888888888888888', '商淘信息科技有限公司', '08:30:00', '22:30:00', '0', '1', '1', '', '1', '2020-04-27', '0.00', '0.00', '693', '6_76_693_', null, '113.327542', '23.160844', '18', '3'),
('3', 'S000000003', '2_52_500_', '500', '1', '北京朝阳门店', '马先生', '15918671994', '', '', '020-85289921', '', '', '北京市东城区朝阳门内大街2号', '17', '8888888888888888', '商淘信息科技有限公司', '08:30:00', '22:30:00', '0', '1', '1', '', '1', '2020-04-27', '0.00', '0.00', '500', '2_52_500_', null, '116.433535', '39.923001', '16', '3'),
('4', 'S000000004', '3_38_418_', '418', '1', '合肥包河店', '马先生', '15918671994', '', '', '020-85289921', '', '', '安徽省合肥市包河区青弋江路', '17', '9999999999999999', '商淘信息科技有限公司', '08:30:00', '22:30:00', '0', '1', '1', '', '1', '2020-04-27', '0.00', '0.00', '418', '3_38_418_', null, '117.278881', '31.836368', '14', '3'),
('5', 'S000000005', '4_53_518_', '518', '1', '福州鼓楼店', '马先生', '15918671994', '', '', '020-85289921', '', '', '福建省福州市鼓楼区五四路162号', '17', '999999999999999999', '商淘信息科技有限公司', '08:30:00', '22:30:00', '0', '1', '1', '', '1', '2020-04-27', '0.00', '0.00', '518', '4_53_518_', null, '119.305966', '26.096293', '16', '3'),
('6', 'S000000006', '4_54_531_', '531', '1', '龙岩新罗店', '马先生', '15918671994', '', '', '020-85289921', '', '', '福建省龙岩市新罗区龙腾中路', '17', '888888888888888888', '商淘信息科技有限公司', '08:30:00', '22:30:00', '0', '1', '1', '', '1', '2020-04-27', '0.00', '0.00', '531', '4_54_531_', null, '117.014351', '25.07386', '15', '3'),
('7', 'S000000007', '4_60_587_', '587', '1', '厦门思明店', '马先生', '15918671994', '', '', '020-85289921', '', '', '福建省厦门市思明区镇海路2号', '17', '666666666666666666', '商淘信息科技有限公司', '08:30:00', '22:30:00', '0', '1', '1', '', '1', '2020-04-27', '0.00', '0.00', '587', '4_60_587_', null, '118.0804', '24.449357', '17', '3'),
('8', 'S000000008', '6_77_705_', '705', '1', '深圳福田店', '马先生', '15918671994', '', '', '020-85289921', '', '', '广东省深圳市福田区福民路125号', '17', '8888888888888888', '商淘信息科技有限公司', '08:30:00', '22:30:00', '0', '1', '1', null, '1', '2020-04-27', '0.00', '0.00', '705', '6_77_705_', null, '114.05301', '22.522408', '17', '3'),
('9', 'S000000009', '6_79_714_', '714', '1', '东莞南城店', '马先生', '15918671994', '', '', '020-85289921', '', '', '广东省东莞市胜和路', '17', '9999999999999999', '商淘信息科技有限公司', '08:30:00', '22:30:00', '0', '1', '1', null, '1', '2020-04-27', '0.00', '0.00', '714', '6_79_714_', null, '113.748504', '23.021663', '17', '3'),
('10', 'S000000010', '6_80_746_', '746', '1', '佛山禅城店', '马先生', '15918671994', '', '', '020-85289921', '', '', '广东省佛山市禅城区莺岗街1号', '17', '999999999999999', '商淘信息科技有限公司', '08:30:00', '22:30:00', '0', '1', '1', null, '1', '2020-04-27', '0.00', '0.00', '746', '6_80_746_', null, '113.115985', '23.026936', '16', '3'),
('11', 'S000000011', '6_82_758_', '758', '1', '惠州惠城店', '马先生', '15918671994', '', '', '020-85289921', '', '', '广东省惠州市惠城区水东路1号', '17', '99999999999999999', '商淘信息科技有限公司', '08:30:00', '22:30:00', '0', '1', '1', null, '1', '2020-04-27', '0.00', '0.00', '758', '6_82_758_', null, '114.398317', '23.07685', '15', '3'),
('12', 'S000000012', '6_96_850_', '850', '1', '珠海香洲店', '马先生', '15918671994', '', '', '020-85289921', '', '', '广东省珠海市香洲区红山路25号', '17', '99999999999999', '商淘信息科技有限公司', '08:30:00', '22:30:00', '0', '1', '1', null, '1', '2020-04-27', '0.00', '0.00', '850', '6_96_850_', null, '113.542049', '22.267414', '17', '3'),
('13', 'S000000013', '7_97_855_', '855', '1', '南宁兴宁店', '马先生', '15918671994', '', '', '020-85289921', '', '', '广西壮族自治区南宁市兴宁区厢竹大道', '17', '88888888888888888', '商淘信息科技有限公司', '08:30:00', '22:30:00', '0', '1', '1', null, '1', '2020-04-27', '0.00', '0.00', '855', '7_97_855_', null, '108.367252', '22.855573', '17', '3'),
('14', 'S000000014', '7_98_867_', '867', '1', '桂林象山店', '马生', '15918671994', '', '', '020-85289921', '', '', '广西壮族自治区桂林市象山区翠竹路8号', '17', '6229389223999232', '商淘信息科技有限公司', '08:30:00', '22:30:00', '0', '1', '1', null, '1', '2020-04-27', '0.00', '0.00', '867', '7_98_867_', null, '110.274754', '25.261153', '16', '3'),
('15', 'S000000015', '25_321_2707_', '2707', '1', '上海浦东店', '马先生', '15918671994', '', '', '020-85289921', '', '', '上海市浦东新区丁香路425号', '17', '99999999999999999', '商淘信息科技有限公司', '08:30:00', '22:30:00', '0', '1', '1', null, '1', '2020-04-27', '0.00', '0.00', '2707', '25_321_2707_', null, '121.541233', '31.222821', '16', '3'),
('16', 'S000000016', '31_383_3229_', '3229', '1', '杭州西湖店', '马先生', '15918671994', '', '', '020-85289921', '', '', '浙江省杭州市西湖区浙大路41号', '17', '622848200322342388', '商淘信息科技有限公司', '08:30:00', '22:30:00', '0', '1', '1', null, '1', '2020-04-27', '0.00', '0.00', '3229', '31_383_3229_', null, '120.127537', '30.260476', '16', '3'),
('17', 'S000000017', '31_384_3243_', '3243', '1', '湖州吴兴店', '马先生', '15918671994', '', '', '020-85289921', '', '', '浙江省湖州市吴兴区南塘漾路', '17', '87786787767876', '商淘信息科技有限公司', '08:30:00', '22:30:00', '0', '1', '1', null, '1', '2020-04-27', '0.00', '0.00', '3243', '31_384_3243_', null, '120.206072', '30.860679', '16', '3'),
('18', 'S000000018', '31_386_3256_', '3256', '1', '金华金东店', '马先生', '15918671994', '', '', '020-85289921', '', '', '浙江省金华市金东区光南路726号', '17', '6228923990239878', '商淘信息科技有限公司', '08:30:00', '22:30:00', '0', '1', '1', null, '1', '2020-04-27', '0.00', '0.00', '3256', '31_386_3256_', null, '119.690831', '29.099264', '16', '3'),
('19', 'S000000019', '31_388_3280_', '3280', '1', '宁波江东区', '马先生', '15918671994', '', '', '020-85289921', '', '', '浙江省宁波市鄞州区鄞县大道东段1299号', '17', '622848200879878211', '商淘信息科技有限公司', '08:30:00', '22:30:00', '0', '1', '1', null, '1', '2020-04-27', '0.00', '0.00', '3280', '31_388_3280_', null, '121.552606', '29.81812', '16', '3'),
('20', 'S000000020', '31_391_3297_', '3297', '1', '温州鹿城店', '马先生', '15918671994', '', '', '020-85289921', '', '', '浙江省温州市鹿城区城西街57号', '17', '688293022993427788', '商淘信息科技有限公司', '08:30:00', '22:30:00', '0', '1', '1', null, '1', '2020-04-27', '0.00', '0.00', '3297', '31_391_3297_', null, '120.653958', '28.015307', '17', '3');
