SET FOREIGN_KEY_CHECKS=0;


DROP TABLE IF EXISTS `wst_orders`;
CREATE TABLE `wst_orders` (
  `orderId` int(11) NOT NULL AUTO_INCREMENT,
  `orderNo` varchar(20) NOT NULL,
  `shopId` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `orderStatus` tinyint(4) NOT NULL DEFAULT '-2',
  `goodsMoney` decimal(11,2) NOT NULL,
  `deliverType` tinyint(4) NOT NULL DEFAULT '0',
  `deliverMoney` decimal(11,2) NOT NULL DEFAULT '0.00',
  `totalMoney` decimal(11,2) NOT NULL,
  `realTotalMoney` decimal(11,2) NOT NULL DEFAULT '0.00',
  `payType` tinyint(4) NOT NULL DEFAULT '0',
  `payFrom` varchar(20) DEFAULT NULL,
  `isPay` tinyint(4) NOT NULL DEFAULT '0',
  `areaId` int(11) NOT NULL,
  `areaIdPath` varchar(255) DEFAULT NULL,
  `userName` varchar(20) NOT NULL,
  `userAddress` varchar(255) NOT NULL,
  `userPhone` varchar(20) DEFAULT NULL,
  `orderScore` int(11) NOT NULL DEFAULT '0',
  `isInvoice` tinyint(4) NOT NULL DEFAULT '0',
  `orderRemarks` varchar(255) DEFAULT NULL,
  `orderSrc` tinyint(4) NOT NULL DEFAULT '0',
  `needPay` decimal(11,2) DEFAULT '0.00',
  `payRand` int(11) DEFAULT '1',
  `orderType` int(11) DEFAULT '0',
  `isRefund` tinyint(4) NOT NULL DEFAULT '0',
  `isAppraise` tinyint(4) DEFAULT '0',
  `interruptCode` int(11) DEFAULT '0',
  `interruptCodeRemark` varchar(255) DEFAULT NULL,
  `isClosed` tinyint(4) NOT NULL DEFAULT '0',
  `goodsSearchKeys` text,
  `orderunique` varchar(50) NOT NULL,
  `receiveTime` datetime DEFAULT NULL,
  `deliveryTime` datetime DEFAULT NULL,
  `expressId` int(11) DEFAULT '0',
  `expressNo` varchar(20) DEFAULT NULL,
  `tradeNo` varchar(100) DEFAULT NULL,
  `dataFlag` tinyint(4) NOT NULL DEFAULT '1',
  `createTime` datetime NOT NULL,
  `settlementId` int(11) DEFAULT '0',
  `scoreMoney` decimal(11,2) DEFAULT '0.00',
  `useScore` int(11) DEFAULT '0',
  `orderCode` varchar(20) DEFAULT 'order',
  `extraJson` text,
  `orderCodeTargetId` int(11) DEFAULT '0',
  `noticeDeliver` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '提醒发货 0:未提醒 1:已提醒',
  `invoiceJson` text COMMENT '发票信息',
  `lockCashMoney` decimal(11,2) DEFAULT '0.00' COMMENT '锁定提现金额',
  `bookTime` varchar(100) DEFAULT NULL,
  `payTime` datetime DEFAULT NULL,
  `distributor` varchar(20) DEFAULT NULL,
  `distributorPhone` varchar(20) DEFAULT NULL,
  `shopDeliverType` tinyint(4) DEFAULT '0' COMMENT '店铺配送方式 1:快递  0:店铺配送',
  PRIMARY KEY (`orderId`),
  KEY `shopId` (`shopId`,`dataFlag`),
  KEY `userId` (`userId`,`dataFlag`),
  KEY `isRefund` (`isRefund`),
  KEY `orderStatus` (`orderStatus`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;