SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS `wst_goods`;
CREATE TABLE `wst_goods` (
  `goodsId` int(11) NOT NULL AUTO_INCREMENT,
  `goodsTips` text,
  `shopId` int(11) DEFAULT NULL,
  `costPrice` decimal(11,2) DEFAULT '0.00' COMMENT '店铺成本价',
  `shopPrice` decimal(11,2) DEFAULT '0.00' COMMENT '店铺价格',
  `goodsStock` int(11) DEFAULT '0' COMMENT '库存数',
  `isSale` tinyint(4) DEFAULT '1' COMMENT '是否上架   1:上架   0:否',
  `isBest` tinyint(4) DEFAULT '1' COMMENT '是否精品 1:是  0:否',
  `isHot` tinyint(4) DEFAULT '1' COMMENT '是否热销  1:热销  0:否',
  `isNew` tinyint(4) DEFAULT '1' COMMENT '是否新品 1:新品  0:否',
  `isRecom` tinyint(4) DEFAULT '1' COMMENT '是否推荐商品 1:推荐  0:否',
  `visitNum` int(11) DEFAULT '0' COMMENT '访问数',
  `saleNum` int(11) DEFAULT '0' COMMENT '销售数',
  `goodsLibId` int(11) DEFAULT '0' COMMENT '对应的商品标准库Id',
  `saleTime` datetime DEFAULT NULL COMMENT '上架时间',
  `warnStock` int(11) DEFAULT '0' COMMENT '预警库存',
  `appraiseNum` int(11) DEFAULT '0',
  PRIMARY KEY (`goodsId`)
) ENGINE=InnoDB AUTO_INCREMENT=301 DEFAULT CHARSET=utf8mb4;


INSERT INTO `wst_goods` VALUES ('1', null, '8', '800.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '1', '2020-04-28 00:17:48', '0', '0'),
('2', null, '20', '800.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '1', '2020-04-30 00:11:12', '0', '0'),
('3', null, '20', '1500.00', '2199.00', '100', '1', '1', '1', '1', '1', '0', '0', '2', '2020-04-30 00:11:12', '0', '0'),
('4', null, '20', '2500.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '3', '2020-04-30 00:11:12', '0', '0'),
('5', null, '20', '700.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '4', '2020-04-30 00:11:12', '0', '0'),
('6', null, '20', '5000.00', '6099.00', '100', '1', '1', '1', '1', '1', '0', '0', '5', '2020-04-30 00:11:12', '0', '0'),
('7', null, '20', '4000.00', '4999.00', '100', '1', '1', '1', '1', '1', '0', '0', '6', '2020-04-30 00:11:12', '0', '0'),
('8', null, '20', '4500.00', '5199.00', '100', '1', '1', '1', '1', '1', '0', '0', '7', '2020-04-30 00:11:12', '0', '0'),
('9', null, '20', '2000.00', '2799.00', '100', '1', '1', '1', '1', '1', '0', '0', '8', '2020-04-30 00:11:12', '0', '0'),
('10', null, '20', '2000.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '9', '2020-04-30 00:11:12', '0', '0'),
('11', null, '20', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '10', '2020-04-30 00:11:12', '0', '0'),
('12', null, '20', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '11', '2020-04-30 00:11:12', '0', '0'),
('13', null, '20', '90.00', '129.00', '100', '1', '1', '1', '1', '1', '0', '0', '12', '2020-04-30 00:11:12', '0', '0'),
('14', null, '20', '15.00', '25.90', '100', '1', '1', '1', '1', '1', '0', '0', '13', '2020-04-30 00:11:12', '0', '0'),
('15', null, '20', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '14', '2020-04-30 00:11:12', '0', '0'),
('16', null, '20', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '15', '2020-04-30 00:11:12', '0', '0'),
('17', null, '19', '800.00', '1199.00', '1000', '1', '1', '1', '1', '1', '0', '0', '1', '2020-04-30 00:11:55', '0', '0'),
('18', null, '19', '1500.00', '2199.00', '1000', '1', '1', '1', '1', '1', '0', '0', '2', '2020-04-30 00:11:55', '0', '0'),
('19', null, '19', '2500.00', '2999.00', '1000', '1', '1', '1', '1', '1', '0', '0', '3', '2020-04-30 00:11:55', '0', '0'),
('20', null, '19', '700.00', '1199.00', '1000', '1', '1', '1', '1', '1', '0', '0', '4', '2020-04-30 00:11:55', '0', '0'),
('21', null, '19', '5000.00', '6099.00', '1000', '1', '1', '1', '1', '1', '0', '0', '5', '2020-04-30 00:11:55', '0', '0'),
('22', null, '19', '4000.00', '4999.00', '1000', '1', '1', '1', '1', '1', '0', '0', '6', '2020-04-30 00:11:55', '0', '0'),
('23', null, '19', '4500.00', '5199.00', '1000', '1', '1', '1', '1', '1', '0', '0', '7', '2020-04-30 00:11:55', '0', '0'),
('24', null, '19', '2000.00', '2799.00', '1000', '1', '1', '1', '1', '1', '0', '0', '8', '2020-04-30 00:11:55', '0', '0'),
('25', null, '19', '2000.00', '2999.00', '1000', '1', '1', '1', '1', '1', '0', '0', '9', '2020-04-30 00:11:55', '0', '0'),
('26', null, '19', '2000.00', '2499.00', '1000', '1', '1', '1', '1', '1', '0', '0', '10', '2020-04-30 00:11:55', '0', '0'),
('27', null, '19', '100.00', '149.00', '1000', '1', '1', '1', '1', '1', '0', '0', '11', '2020-04-30 00:11:55', '0', '0'),
('28', null, '19', '90.00', '129.00', '1000', '1', '1', '1', '1', '1', '0', '0', '12', '2020-04-30 00:11:55', '0', '0'),
('29', null, '19', '15.00', '25.90', '1000', '1', '1', '1', '1', '1', '0', '0', '13', '2020-04-30 00:11:55', '0', '0'),
('30', null, '19', '100.00', '149.00', '1000', '1', '1', '1', '1', '1', '0', '0', '14', '2020-04-30 00:11:55', '0', '0'),
('31', null, '19', '2000.00', '2499.00', '1000', '1', '1', '1', '1', '1', '0', '0', '15', '2020-04-30 00:11:55', '0', '0'),
('32', null, '18', '800.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '1', '2020-04-30 00:12:37', '0', '0'),
('33', null, '18', '1500.00', '2199.00', '100', '1', '1', '1', '1', '1', '0', '0', '2', '2020-04-30 00:12:37', '0', '0'),
('34', null, '18', '2500.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '3', '2020-04-30 00:12:37', '0', '0'),
('35', null, '18', '700.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '4', '2020-04-30 00:12:37', '0', '0'),
('36', null, '18', '5000.00', '6099.00', '100', '1', '1', '1', '1', '1', '0', '0', '5', '2020-04-30 00:12:37', '0', '0'),
('37', null, '18', '4000.00', '4999.00', '100', '1', '1', '1', '1', '1', '0', '0', '6', '2020-04-30 00:12:37', '0', '0'),
('38', null, '18', '4500.00', '5199.00', '100', '1', '1', '1', '1', '1', '0', '0', '7', '2020-04-30 00:12:37', '0', '0'),
('39', null, '18', '2000.00', '2799.00', '100', '1', '1', '1', '1', '1', '0', '0', '8', '2020-04-30 00:12:37', '0', '0'),
('40', null, '18', '2000.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '9', '2020-04-30 00:12:37', '0', '0'),
('41', null, '18', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '10', '2020-04-30 00:12:37', '0', '0'),
('42', null, '18', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '11', '2020-04-30 00:12:37', '0', '0'),
('43', null, '18', '90.00', '129.00', '100', '1', '1', '1', '1', '1', '0', '0', '12', '2020-04-30 00:12:37', '0', '0'),
('44', null, '18', '15.00', '25.90', '100', '1', '1', '1', '1', '1', '0', '0', '13', '2020-04-30 00:12:37', '0', '0'),
('45', null, '18', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '14', '2020-04-30 00:12:37', '0', '0'),
('46', null, '18', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '15', '2020-04-30 00:12:37', '0', '0'),
('47', null, '17', '800.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '1', '2020-04-30 00:13:38', '0', '0'),
('48', null, '17', '1500.00', '2199.00', '100', '1', '1', '1', '1', '1', '0', '0', '2', '2020-04-30 00:13:38', '0', '0'),
('49', null, '17', '2500.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '3', '2020-04-30 00:13:38', '0', '0'),
('50', null, '17', '700.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '4', '2020-04-30 00:13:38', '0', '0'),
('51', null, '17', '5000.00', '6099.00', '100', '1', '1', '1', '1', '1', '0', '0', '5', '2020-04-30 00:13:38', '0', '0'),
('52', null, '17', '4000.00', '4999.00', '100', '1', '1', '1', '1', '1', '0', '0', '6', '2020-04-30 00:13:38', '0', '0'),
('53', null, '17', '4500.00', '5199.00', '100', '1', '1', '1', '1', '1', '0', '0', '7', '2020-04-30 00:13:38', '0', '0'),
('54', null, '17', '2000.00', '2799.00', '100', '1', '1', '1', '1', '1', '0', '0', '8', '2020-04-30 00:13:38', '0', '0'),
('55', null, '17', '2000.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '9', '2020-04-30 00:13:38', '0', '0'),
('56', null, '17', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '10', '2020-04-30 00:13:38', '0', '0'),
('57', null, '17', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '11', '2020-04-30 00:13:38', '0', '0'),
('58', null, '17', '90.00', '129.00', '100', '1', '1', '1', '1', '1', '0', '0', '12', '2020-04-30 00:13:38', '0', '0'),
('59', null, '17', '15.00', '25.90', '100', '1', '1', '1', '1', '1', '0', '0', '13', '2020-04-30 00:13:38', '0', '0'),
('60', null, '17', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '14', '2020-04-30 00:13:38', '0', '0'),
('61', null, '17', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '15', '2020-04-30 00:13:38', '0', '0'),
('62', null, '16', '800.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '1', '2020-04-30 00:15:02', '0', '0'),
('63', null, '16', '1500.00', '2199.00', '100', '1', '1', '1', '1', '1', '0', '0', '2', '2020-04-30 00:15:02', '0', '0'),
('64', null, '16', '2500.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '3', '2020-04-30 00:15:02', '0', '0'),
('65', null, '16', '700.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '4', '2020-04-30 00:15:02', '0', '0'),
('66', null, '16', '5000.00', '6099.00', '100', '1', '1', '1', '1', '1', '0', '0', '5', '2020-04-30 00:15:02', '0', '0'),
('67', null, '16', '4000.00', '4999.00', '100', '1', '1', '1', '1', '1', '0', '0', '6', '2020-04-30 00:15:02', '0', '0'),
('68', null, '16', '4500.00', '5199.00', '100', '1', '1', '1', '1', '1', '0', '0', '7', '2020-04-30 00:15:02', '0', '0'),
('69', null, '16', '2000.00', '2799.00', '100', '1', '1', '1', '1', '1', '0', '0', '8', '2020-04-30 00:15:02', '0', '0'),
('70', null, '16', '2000.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '9', '2020-04-30 00:15:02', '0', '0'),
('71', null, '16', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '10', '2020-04-30 00:15:02', '0', '0'),
('72', null, '16', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '11', '2020-04-30 00:15:02', '0', '0'),
('73', null, '16', '90.00', '129.00', '100', '1', '1', '1', '1', '1', '0', '0', '12', '2020-04-30 00:15:02', '0', '0'),
('74', null, '16', '15.00', '25.90', '100', '1', '1', '1', '1', '1', '0', '0', '13', '2020-04-30 00:15:02', '0', '0'),
('75', null, '16', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '14', '2020-04-30 00:15:02', '0', '0'),
('76', null, '16', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '15', '2020-04-30 00:15:02', '0', '0'),
('77', null, '15', '800.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '1', '2020-04-30 00:15:22', '0', '0'),
('78', null, '15', '1500.00', '2199.00', '100', '1', '1', '1', '1', '1', '0', '0', '2', '2020-04-30 00:15:22', '0', '0'),
('79', null, '15', '2500.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '3', '2020-04-30 00:15:22', '0', '0'),
('80', null, '15', '700.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '4', '2020-04-30 00:15:22', '0', '0'),
('81', null, '15', '5000.00', '6099.00', '100', '1', '1', '1', '1', '1', '0', '0', '5', '2020-04-30 00:15:22', '0', '0'),
('82', null, '15', '4000.00', '4999.00', '100', '1', '1', '1', '1', '1', '0', '0', '6', '2020-04-30 00:15:22', '0', '0'),
('83', null, '15', '4500.00', '5199.00', '100', '1', '1', '1', '1', '1', '0', '0', '7', '2020-04-30 00:15:22', '0', '0'),
('84', null, '15', '2000.00', '2799.00', '100', '1', '1', '1', '1', '1', '0', '0', '8', '2020-04-30 00:15:22', '0', '0'),
('85', null, '15', '2000.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '9', '2020-04-30 00:15:22', '0', '0'),
('86', null, '15', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '10', '2020-04-30 00:15:22', '0', '0'),
('87', null, '15', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '11', '2020-04-30 00:15:22', '0', '0'),
('88', null, '15', '90.00', '129.00', '100', '1', '1', '1', '1', '1', '0', '0', '12', '2020-04-30 00:15:22', '0', '0'),
('89', null, '15', '15.00', '25.90', '100', '1', '1', '1', '1', '1', '0', '0', '13', '2020-04-30 00:15:22', '0', '0'),
('90', null, '15', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '14', '2020-04-30 00:15:22', '0', '0'),
('91', null, '15', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '15', '2020-04-30 00:15:22', '0', '0'),
('92', null, '14', '800.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '1', '2020-04-30 00:15:49', '0', '0'),
('93', null, '14', '1500.00', '2199.00', '100', '1', '1', '1', '1', '1', '0', '0', '2', '2020-04-30 00:15:49', '0', '0'),
('94', null, '14', '2500.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '3', '2020-04-30 00:15:49', '0', '0'),
('95', null, '14', '700.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '4', '2020-04-30 00:15:49', '0', '0'),
('96', null, '14', '5000.00', '6099.00', '100', '1', '1', '1', '1', '1', '0', '0', '5', '2020-04-30 00:15:49', '0', '0'),
('97', null, '14', '4000.00', '4999.00', '100', '1', '1', '1', '1', '1', '0', '0', '6', '2020-04-30 00:15:49', '0', '0'),
('98', null, '14', '4500.00', '5199.00', '100', '1', '1', '1', '1', '1', '0', '0', '7', '2020-04-30 00:15:49', '0', '0'),
('99', null, '14', '2000.00', '2799.00', '100', '1', '1', '1', '1', '1', '0', '0', '8', '2020-04-30 00:15:49', '0', '0'),
('100', null, '14', '2000.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '9', '2020-04-30 00:15:49', '0', '0'),
('101', null, '14', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '10', '2020-04-30 00:15:49', '0', '0'),
('102', null, '14', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '11', '2020-04-30 00:15:49', '0', '0'),
('103', null, '14', '90.00', '129.00', '100', '1', '1', '1', '1', '1', '0', '0', '12', '2020-04-30 00:15:49', '0', '0'),
('104', null, '14', '15.00', '25.90', '100', '1', '1', '1', '1', '1', '0', '0', '13', '2020-04-30 00:15:49', '0', '0'),
('105', null, '14', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '14', '2020-04-30 00:15:49', '0', '0'),
('106', null, '14', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '15', '2020-04-30 00:15:49', '0', '0'),
('107', null, '13', '800.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '1', '2020-04-30 00:16:26', '0', '0'),
('108', null, '13', '1500.00', '2199.00', '100', '1', '1', '1', '1', '1', '0', '0', '2', '2020-04-30 00:16:26', '0', '0'),
('109', null, '13', '2500.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '3', '2020-04-30 00:16:26', '0', '0'),
('110', null, '13', '700.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '4', '2020-04-30 00:16:26', '0', '0'),
('111', null, '13', '5000.00', '6099.00', '100', '1', '1', '1', '1', '1', '0', '0', '5', '2020-04-30 00:16:26', '0', '0'),
('112', null, '13', '4000.00', '4999.00', '100', '1', '1', '1', '1', '1', '0', '0', '6', '2020-04-30 00:16:26', '0', '0'),
('113', null, '13', '4500.00', '5199.00', '100', '1', '1', '1', '1', '1', '0', '0', '7', '2020-04-30 00:16:26', '0', '0'),
('114', null, '13', '2000.00', '2799.00', '100', '1', '1', '1', '1', '1', '0', '0', '8', '2020-04-30 00:16:26', '0', '0'),
('115', null, '13', '2000.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '9', '2020-04-30 00:16:26', '0', '0'),
('116', null, '13', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '10', '2020-04-30 00:16:26', '0', '0'),
('117', null, '13', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '11', '2020-04-30 00:16:26', '0', '0'),
('118', null, '13', '90.00', '129.00', '100', '1', '1', '1', '1', '1', '0', '0', '12', '2020-04-30 00:16:26', '0', '0'),
('119', null, '13', '15.00', '25.90', '100', '1', '1', '1', '1', '1', '0', '0', '13', '2020-04-30 00:16:26', '0', '0'),
('120', null, '13', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '14', '2020-04-30 00:16:26', '0', '0'),
('121', null, '13', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '15', '2020-04-30 00:16:26', '0', '0'),
('122', null, '12', '800.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '1', '2020-04-30 00:16:56', '0', '0'),
('123', null, '12', '1500.00', '2199.00', '100', '1', '1', '1', '1', '1', '0', '0', '2', '2020-04-30 00:16:56', '0', '0'),
('124', null, '12', '2500.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '3', '2020-04-30 00:16:56', '0', '0'),
('125', null, '12', '700.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '4', '2020-04-30 00:16:56', '0', '0'),
('126', null, '12', '5000.00', '6099.00', '100', '1', '1', '1', '1', '1', '0', '0', '5', '2020-04-30 00:16:56', '0', '0'),
('127', null, '12', '4000.00', '4999.00', '100', '1', '1', '1', '1', '1', '0', '0', '6', '2020-04-30 00:16:56', '0', '0'),
('128', null, '12', '4500.00', '5199.00', '100', '1', '1', '1', '1', '1', '0', '0', '7', '2020-04-30 00:16:56', '0', '0'),
('129', null, '12', '2000.00', '2799.00', '100', '1', '1', '1', '1', '1', '0', '0', '8', '2020-04-30 00:16:56', '0', '0'),
('130', null, '12', '2000.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '9', '2020-04-30 00:16:56', '0', '0'),
('131', null, '12', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '10', '2020-04-30 00:16:56', '0', '0'),
('132', null, '12', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '11', '2020-04-30 00:16:56', '0', '0'),
('133', null, '12', '90.00', '129.00', '100', '1', '1', '1', '1', '1', '0', '0', '12', '2020-04-30 00:16:56', '0', '0'),
('134', null, '12', '15.00', '25.90', '100', '1', '1', '1', '1', '1', '0', '0', '13', '2020-04-30 00:16:56', '0', '0'),
('135', null, '12', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '14', '2020-04-30 00:16:56', '0', '0'),
('136', null, '12', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '15', '2020-04-30 00:16:56', '0', '0'),
('137', null, '11', '800.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '1', '2020-04-30 00:17:19', '0', '0'),
('138', null, '11', '1500.00', '2199.00', '100', '1', '1', '1', '1', '1', '0', '0', '2', '2020-04-30 00:17:19', '0', '0'),
('139', null, '11', '2500.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '3', '2020-04-30 00:17:19', '0', '0'),
('140', null, '11', '700.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '4', '2020-04-30 00:17:19', '0', '0'),
('141', null, '11', '5000.00', '6099.00', '100', '1', '1', '1', '1', '1', '0', '0', '5', '2020-04-30 00:17:19', '0', '0'),
('142', null, '11', '4000.00', '4999.00', '100', '1', '1', '1', '1', '1', '0', '0', '6', '2020-04-30 00:17:19', '0', '0'),
('143', null, '11', '4500.00', '5199.00', '100', '1', '1', '1', '1', '1', '0', '0', '7', '2020-04-30 00:17:19', '0', '0'),
('144', null, '11', '2000.00', '2799.00', '100', '1', '1', '1', '1', '1', '0', '0', '8', '2020-04-30 00:17:19', '0', '0'),
('145', null, '11', '2000.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '9', '2020-04-30 00:17:19', '0', '0'),
('146', null, '11', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '10', '2020-04-30 00:17:19', '0', '0'),
('147', null, '11', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '11', '2020-04-30 00:17:19', '0', '0'),
('148', null, '11', '90.00', '129.00', '100', '1', '1', '1', '1', '1', '0', '0', '12', '2020-04-30 00:17:19', '0', '0'),
('149', null, '11', '15.00', '25.90', '100', '1', '1', '1', '1', '1', '0', '0', '13', '2020-04-30 00:17:19', '0', '0'),
('150', null, '11', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '14', '2020-04-30 00:17:19', '0', '0'),
('151', null, '11', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '15', '2020-04-30 00:17:19', '0', '0'),
('152', null, '10', '800.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '1', '2020-04-30 00:17:42', '0', '0'),
('153', null, '10', '1500.00', '2199.00', '100', '1', '1', '1', '1', '1', '0', '0', '2', '2020-04-30 00:17:42', '0', '0'),
('154', null, '10', '2500.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '3', '2020-04-30 00:17:42', '0', '0'),
('155', null, '10', '700.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '4', '2020-04-30 00:17:42', '0', '0'),
('156', null, '10', '5000.00', '6099.00', '100', '1', '1', '1', '1', '1', '0', '0', '5', '2020-04-30 00:17:42', '0', '0'),
('157', null, '10', '4000.00', '4999.00', '100', '1', '1', '1', '1', '1', '0', '0', '6', '2020-04-30 00:17:42', '0', '0'),
('158', null, '10', '4500.00', '5199.00', '100', '1', '1', '1', '1', '1', '0', '0', '7', '2020-04-30 00:17:42', '0', '0'),
('159', null, '10', '2000.00', '2799.00', '100', '1', '1', '1', '1', '1', '0', '0', '8', '2020-04-30 00:17:42', '0', '0'),
('160', null, '10', '2000.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '9', '2020-04-30 00:17:42', '0', '0'),
('161', null, '10', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '10', '2020-04-30 00:17:42', '0', '0'),
('162', null, '10', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '11', '2020-04-30 00:17:42', '0', '0'),
('163', null, '10', '90.00', '129.00', '100', '1', '1', '1', '1', '1', '0', '0', '12', '2020-04-30 00:17:42', '0', '0'),
('164', null, '10', '15.00', '25.90', '100', '1', '1', '1', '1', '1', '0', '0', '13', '2020-04-30 00:17:42', '0', '0'),
('165', null, '10', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '14', '2020-04-30 00:17:42', '0', '0'),
('166', null, '10', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '15', '2020-04-30 00:17:42', '0', '0'),
('167', null, '9', '800.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '1', '2020-04-30 00:18:03', '0', '0'),
('168', null, '9', '1500.00', '2199.00', '100', '1', '1', '1', '1', '1', '0', '0', '2', '2020-04-30 00:18:03', '0', '0'),
('169', null, '9', '2500.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '3', '2020-04-30 00:18:03', '0', '0'),
('170', null, '9', '700.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '4', '2020-04-30 00:18:03', '0', '0'),
('171', null, '9', '5000.00', '6099.00', '100', '1', '1', '1', '1', '1', '0', '0', '5', '2020-04-30 00:18:03', '0', '0'),
('172', null, '9', '4000.00', '4999.00', '100', '1', '1', '1', '1', '1', '0', '0', '6', '2020-04-30 00:18:03', '0', '0'),
('173', null, '9', '4500.00', '5199.00', '100', '1', '1', '1', '1', '1', '0', '0', '7', '2020-04-30 00:18:03', '0', '0'),
('174', null, '9', '2000.00', '2799.00', '100', '1', '1', '1', '1', '1', '0', '0', '8', '2020-04-30 00:18:03', '0', '0'),
('175', null, '9', '2000.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '9', '2020-04-30 00:18:03', '0', '0'),
('176', null, '9', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '10', '2020-04-30 00:18:03', '0', '0'),
('177', null, '9', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '11', '2020-04-30 00:18:03', '0', '0'),
('178', null, '9', '90.00', '129.00', '100', '1', '1', '1', '1', '1', '0', '0', '12', '2020-04-30 00:18:03', '0', '0'),
('179', null, '9', '15.00', '25.90', '100', '1', '1', '1', '1', '1', '0', '0', '13', '2020-04-30 00:18:03', '0', '0'),
('180', null, '9', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '14', '2020-04-30 00:18:03', '0', '0'),
('181', null, '9', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '15', '2020-04-30 00:18:03', '0', '0'),
('182', null, '8', '1500.00', '2199.00', '100', '1', '1', '1', '1', '1', '0', '0', '2', '2020-04-30 00:18:25', '0', '0'),
('183', null, '8', '2500.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '3', '2020-04-30 00:18:25', '0', '0'),
('184', null, '8', '700.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '4', '2020-04-30 00:18:25', '0', '0'),
('185', null, '8', '5000.00', '6099.00', '100', '1', '1', '1', '1', '1', '0', '0', '5', '2020-04-30 00:18:25', '0', '0'),
('186', null, '8', '4000.00', '4999.00', '100', '1', '1', '1', '1', '1', '0', '0', '6', '2020-04-30 00:18:25', '0', '0'),
('187', null, '8', '4500.00', '5199.00', '100', '1', '1', '1', '1', '1', '0', '0', '7', '2020-04-30 00:18:25', '0', '0'),
('188', null, '8', '2000.00', '2799.00', '100', '1', '1', '1', '1', '1', '0', '0', '8', '2020-04-30 00:18:25', '0', '0'),
('189', null, '8', '2000.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '9', '2020-04-30 00:18:25', '0', '0'),
('190', null, '8', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '10', '2020-04-30 00:18:25', '0', '0'),
('191', null, '8', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '11', '2020-04-30 00:18:25', '0', '0'),
('192', null, '8', '90.00', '129.00', '100', '1', '1', '1', '1', '1', '0', '0', '12', '2020-04-30 00:18:25', '0', '0'),
('193', null, '8', '15.00', '25.90', '100', '1', '1', '1', '1', '1', '0', '0', '13', '2020-04-30 00:18:25', '0', '0'),
('194', null, '8', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '14', '2020-04-30 00:18:25', '0', '0'),
('195', null, '8', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '15', '2020-04-30 00:18:25', '0', '0'),
('196', null, '7', '800.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '1', '2020-04-30 00:18:48', '0', '0'),
('197', null, '7', '1500.00', '2199.00', '100', '1', '1', '1', '1', '1', '0', '0', '2', '2020-04-30 00:18:48', '0', '0'),
('198', null, '7', '2500.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '3', '2020-04-30 00:18:48', '0', '0'),
('199', null, '7', '700.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '4', '2020-04-30 00:18:48', '0', '0'),
('200', null, '7', '5000.00', '6099.00', '100', '1', '1', '1', '1', '1', '0', '0', '5', '2020-04-30 00:18:48', '0', '0'),
('201', null, '7', '4000.00', '4999.00', '100', '1', '1', '1', '1', '1', '0', '0', '6', '2020-04-30 00:18:48', '0', '0'),
('202', null, '7', '4500.00', '5199.00', '100', '1', '1', '1', '1', '1', '0', '0', '7', '2020-04-30 00:18:48', '0', '0'),
('203', null, '7', '2000.00', '2799.00', '100', '1', '1', '1', '1', '1', '0', '0', '8', '2020-04-30 00:18:48', '0', '0'),
('204', null, '7', '2000.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '9', '2020-04-30 00:18:48', '0', '0'),
('205', null, '7', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '10', '2020-04-30 00:18:48', '0', '0'),
('206', null, '7', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '11', '2020-04-30 00:18:48', '0', '0'),
('207', null, '7', '90.00', '129.00', '100', '1', '1', '1', '1', '1', '0', '0', '12', '2020-04-30 00:18:48', '0', '0'),
('208', null, '7', '15.00', '25.90', '100', '1', '1', '1', '1', '1', '0', '0', '13', '2020-04-30 00:18:48', '0', '0'),
('209', null, '7', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '14', '2020-04-30 00:18:48', '0', '0'),
('210', null, '7', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '15', '2020-04-30 00:18:48', '0', '0'),
('211', null, '6', '800.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '1', '2020-04-30 00:19:07', '0', '0'),
('212', null, '6', '1500.00', '2199.00', '100', '1', '1', '1', '1', '1', '0', '0', '2', '2020-04-30 00:19:07', '0', '0'),
('213', null, '6', '2500.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '3', '2020-04-30 00:19:07', '0', '0'),
('214', null, '6', '700.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '4', '2020-04-30 00:19:07', '0', '0'),
('215', null, '6', '5000.00', '6099.00', '100', '1', '1', '1', '1', '1', '0', '0', '5', '2020-04-30 00:19:07', '0', '0'),
('216', null, '6', '4000.00', '4999.00', '100', '1', '1', '1', '1', '1', '0', '0', '6', '2020-04-30 00:19:07', '0', '0'),
('217', null, '6', '4500.00', '5199.00', '100', '1', '1', '1', '1', '1', '0', '0', '7', '2020-04-30 00:19:07', '0', '0'),
('218', null, '6', '2000.00', '2799.00', '100', '1', '1', '1', '1', '1', '0', '0', '8', '2020-04-30 00:19:07', '0', '0'),
('219', null, '6', '2000.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '9', '2020-04-30 00:19:07', '0', '0'),
('220', null, '6', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '10', '2020-04-30 00:19:07', '0', '0'),
('221', null, '6', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '11', '2020-04-30 00:19:07', '0', '0'),
('222', null, '6', '90.00', '129.00', '100', '1', '1', '1', '1', '1', '0', '0', '12', '2020-04-30 00:19:07', '0', '0'),
('223', null, '6', '15.00', '25.90', '100', '1', '1', '1', '1', '1', '0', '0', '13', '2020-04-30 00:19:07', '0', '0'),
('224', null, '6', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '14', '2020-04-30 00:19:07', '0', '0'),
('225', null, '6', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '15', '2020-04-30 00:19:07', '0', '0'),
('226', null, '5', '800.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '1', '2020-04-30 00:19:26', '0', '0'),
('227', null, '5', '1500.00', '2199.00', '100', '1', '1', '1', '1', '1', '0', '0', '2', '2020-04-30 00:19:26', '0', '0'),
('228', null, '5', '2500.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '3', '2020-04-30 00:19:26', '0', '0'),
('229', null, '5', '700.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '4', '2020-04-30 00:19:26', '0', '0'),
('230', null, '5', '5000.00', '6099.00', '100', '1', '1', '1', '1', '1', '0', '0', '5', '2020-04-30 00:19:26', '0', '0'),
('231', null, '5', '4000.00', '4999.00', '100', '1', '1', '1', '1', '1', '0', '0', '6', '2020-04-30 00:19:26', '0', '0'),
('232', null, '5', '4500.00', '5199.00', '100', '1', '1', '1', '1', '1', '0', '0', '7', '2020-04-30 00:19:26', '0', '0'),
('233', null, '5', '2000.00', '2799.00', '100', '1', '1', '1', '1', '1', '0', '0', '8', '2020-04-30 00:19:26', '0', '0'),
('234', null, '5', '2000.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '9', '2020-04-30 00:19:26', '0', '0'),
('235', null, '5', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '10', '2020-04-30 00:19:26', '0', '0'),
('236', null, '5', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '11', '2020-04-30 00:19:26', '0', '0'),
('237', null, '5', '90.00', '129.00', '100', '1', '1', '1', '1', '1', '0', '0', '12', '2020-04-30 00:19:26', '0', '0'),
('238', null, '5', '15.00', '25.90', '100', '1', '1', '1', '1', '1', '0', '0', '13', '2020-04-30 00:19:26', '0', '0'),
('239', null, '5', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '14', '2020-04-30 00:19:26', '0', '0'),
('240', null, '5', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '15', '2020-04-30 00:19:26', '0', '0'),
('241', null, '4', '800.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '1', '2020-04-30 00:19:46', '0', '0'),
('242', null, '4', '1500.00', '2199.00', '100', '1', '1', '1', '1', '1', '0', '0', '2', '2020-04-30 00:19:46', '0', '0'),
('243', null, '4', '2500.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '3', '2020-04-30 00:19:46', '0', '0'),
('244', null, '4', '700.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '4', '2020-04-30 00:19:46', '0', '0'),
('245', null, '4', '5000.00', '6099.00', '100', '1', '1', '1', '1', '1', '0', '0', '5', '2020-04-30 00:19:46', '0', '0'),
('246', null, '4', '4000.00', '4999.00', '100', '1', '1', '1', '1', '1', '0', '0', '6', '2020-04-30 00:19:46', '0', '0'),
('247', null, '4', '4500.00', '5199.00', '100', '1', '1', '1', '1', '1', '0', '0', '7', '2020-04-30 00:19:46', '0', '0'),
('248', null, '4', '2000.00', '2799.00', '100', '1', '1', '1', '1', '1', '0', '0', '8', '2020-04-30 00:19:46', '0', '0'),
('249', null, '4', '2000.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '9', '2020-04-30 00:19:46', '0', '0'),
('250', null, '4', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '10', '2020-04-30 00:19:46', '0', '0'),
('251', null, '4', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '11', '2020-04-30 00:19:46', '0', '0'),
('252', null, '4', '90.00', '129.00', '100', '1', '1', '1', '1', '1', '0', '0', '12', '2020-04-30 00:19:46', '0', '0'),
('253', null, '4', '15.00', '25.90', '100', '1', '1', '1', '1', '1', '0', '0', '13', '2020-04-30 00:19:46', '0', '0'),
('254', null, '4', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '14', '2020-04-30 00:19:46', '0', '0'),
('255', null, '4', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '15', '2020-04-30 00:19:46', '0', '0'),
('256', null, '1', '800.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '1', '2020-04-30 00:20:07', '0', '0'),
('257', null, '1', '1500.00', '2199.00', '100', '1', '1', '1', '1', '1', '0', '0', '2', '2020-04-30 00:20:07', '0', '0'),
('258', null, '1', '2500.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '3', '2020-04-30 00:20:07', '0', '0'),
('259', null, '1', '700.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '4', '2020-04-30 00:20:07', '0', '0'),
('260', null, '1', '5000.00', '6099.00', '100', '1', '1', '1', '1', '1', '0', '0', '5', '2020-04-30 00:20:07', '0', '0'),
('261', null, '1', '4000.00', '4999.00', '100', '1', '1', '1', '1', '1', '0', '0', '6', '2020-04-30 00:20:07', '0', '0'),
('262', null, '1', '4500.00', '5199.00', '100', '1', '1', '1', '1', '1', '0', '0', '7', '2020-04-30 00:20:07', '0', '0'),
('263', null, '1', '2000.00', '2799.00', '100', '1', '1', '1', '1', '1', '0', '0', '8', '2020-04-30 00:20:07', '0', '0'),
('264', null, '1', '2000.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '9', '2020-04-30 00:20:07', '0', '0'),
('265', null, '1', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '10', '2020-04-30 00:20:07', '0', '0'),
('266', null, '1', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '11', '2020-04-30 00:20:07', '0', '0'),
('267', null, '1', '90.00', '129.00', '100', '1', '1', '1', '1', '1', '0', '0', '12', '2020-04-30 00:20:07', '0', '0'),
('268', null, '1', '15.00', '25.90', '100', '1', '1', '1', '1', '1', '0', '0', '13', '2020-04-30 00:20:07', '0', '0'),
('269', null, '1', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '14', '2020-04-30 00:20:07', '0', '0'),
('270', null, '1', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '15', '2020-04-30 00:20:07', '0', '0'),
('271', null, '2', '800.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '1', '2020-04-30 00:20:40', '0', '0'),
('272', null, '2', '1500.00', '2199.00', '100', '1', '1', '1', '1', '1', '0', '0', '2', '2020-04-30 00:20:40', '0', '0'),
('273', null, '2', '2500.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '3', '2020-04-30 00:20:40', '0', '0'),
('274', null, '2', '700.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '4', '2020-04-30 00:20:40', '0', '0'),
('275', null, '2', '5000.00', '6099.00', '100', '1', '1', '1', '1', '1', '0', '0', '5', '2020-04-30 00:20:40', '0', '0'),
('276', null, '2', '4000.00', '4999.00', '100', '1', '1', '1', '1', '1', '0', '0', '6', '2020-04-30 00:20:40', '0', '0'),
('277', null, '2', '4500.00', '5199.00', '100', '1', '1', '1', '1', '1', '0', '0', '7', '2020-04-30 00:20:40', '0', '0'),
('278', null, '2', '2000.00', '2799.00', '100', '1', '1', '1', '1', '1', '0', '0', '8', '2020-04-30 00:20:40', '0', '0'),
('279', null, '2', '2000.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '9', '2020-04-30 00:20:40', '0', '0'),
('280', null, '2', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '10', '2020-04-30 00:20:40', '0', '0'),
('281', null, '2', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '11', '2020-04-30 00:20:40', '0', '0'),
('282', null, '2', '90.00', '129.00', '100', '1', '1', '1', '1', '1', '0', '0', '12', '2020-04-30 00:20:40', '0', '0'),
('283', null, '2', '15.00', '25.90', '100', '1', '1', '1', '1', '1', '0', '0', '13', '2020-04-30 00:20:40', '0', '0'),
('284', null, '2', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '14', '2020-04-30 00:20:40', '0', '0'),
('285', null, '2', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '15', '2020-04-30 00:20:40', '0', '0'),
('286', null, '3', '800.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '1', '2020-04-30 00:21:01', '0', '0'),
('287', null, '3', '1500.00', '2199.00', '100', '1', '1', '1', '1', '1', '0', '0', '2', '2020-04-30 00:21:01', '0', '0'),
('288', null, '3', '2500.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '3', '2020-04-30 00:21:01', '0', '0'),
('289', null, '3', '700.00', '1199.00', '100', '1', '1', '1', '1', '1', '0', '0', '4', '2020-04-30 00:21:01', '0', '0'),
('290', null, '3', '5000.00', '6099.00', '100', '1', '1', '1', '1', '1', '0', '0', '5', '2020-04-30 00:21:01', '0', '0'),
('291', null, '3', '4000.00', '4999.00', '100', '1', '1', '1', '1', '1', '0', '0', '6', '2020-04-30 00:21:01', '0', '0'),
('292', null, '3', '4500.00', '5199.00', '100', '1', '1', '1', '1', '1', '0', '0', '7', '2020-04-30 00:21:01', '0', '0'),
('293', null, '3', '2000.00', '2799.00', '100', '1', '1', '1', '1', '1', '0', '0', '8', '2020-04-30 00:21:01', '0', '0'),
('294', null, '3', '2000.00', '2999.00', '100', '1', '1', '1', '1', '1', '0', '0', '9', '2020-04-30 00:21:01', '0', '0'),
('295', null, '3', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '10', '2020-04-30 00:21:01', '0', '0'),
('296', null, '3', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '11', '2020-04-30 00:21:01', '0', '0'),
('297', null, '3', '90.00', '129.00', '100', '1', '1', '1', '1', '1', '0', '0', '12', '2020-04-30 00:21:01', '0', '0'),
('298', null, '3', '15.00', '25.90', '100', '1', '1', '1', '1', '1', '0', '0', '13', '2020-04-30 00:21:01', '0', '0'),
('299', null, '3', '100.00', '149.00', '100', '1', '1', '1', '1', '1', '0', '0', '14', '2020-04-30 00:21:01', '0', '0'),
('300', null, '3', '2000.00', '2499.00', '100', '1', '1', '1', '1', '1', '0', '0', '15', '2020-04-30 00:21:01', '0', '0');
