SET FOREIGN_KEY_CHECKS=0;


DROP TABLE IF EXISTS `wst_shop_privileges`;
CREATE TABLE `wst_shop_privileges` (
  `privilegeId` int(11) NOT NULL AUTO_INCREMENT,
  `shopId` int(11) DEFAULT '-1' COMMENT '店铺ID 0为系统默认',
  `menuId` int(11) NOT NULL,
  `privilegeCode` varchar(20) NOT NULL,
  `privilegeName` varchar(30) NOT NULL,
  `isMenuPrivilege` tinyint(4) NOT NULL DEFAULT '0',
  `privilegeUrl` varchar(255) DEFAULT NULL,
  `otherPrivilegeUrl` text,
  `dataFlag` tinyint(4) NOT NULL DEFAULT '1',
  `isEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`privilegeId`),
  UNIQUE KEY `privilegeCode` (`privilegeCode`),
  KEY `menuId` (`menuId`,`dataFlag`)
) ENGINE=InnoDB AUTO_INCREMENT=342 DEFAULT CHARSET=utf8mb4;


INSERT INTO `wst_shop_privileges` VALUES ('292', '0', '191', 'DDCD_00', '查看订单管理', '1', '', '', '1', '1'),
('293', '0', '192', 'DDGL_00', '查看订单管理', '1', '', '', '1', '1'),
('294', '0', '193', 'MDDFHDD_00', '查看门店待发货订单', '1', 'shop/orders/waitDelivery', 'shop/orders/waitDeliveryByPage', '1', '1'),
('296', '0', '194', 'MDYFHDD_00', '查看门店已发货订单', '1', 'shop/orders/delivery', 'shop/orders/deliveryByPage', '1', '1'),
('297', '0', '195', 'SPGL_00', '查看商品管理', '1', '', '', '1', '1'),
('303', '0', '197', 'BZSPK_00', '查看标准库列表', '1', 'shop/goodslibs/index', 'shop/goodslibs/pagequery', '1', '1'),
('304', '0', '197', 'BZSPK_01', '上架商品', '0', 'shop/goodslibs/sale', '', '1', '1'),
('305', '0', '202', 'MDSP_00', '查看门店商品', '1', '', '', '1', '1'),
('306', '0', '203', 'ZSSP_00', '查看在售商品', '1', 'shop/goods/onsale', 'shop/goods/saleByPage', '1', '1'),
('307', '0', '203', 'SPKC_01', '商品入库', '0', 'shop/goodsstock/add', '', '1', '1'),
('308', '0', '203', 'SPKC_00', '商品库存记录', '0', '', '', '1', '1'),
('309', '0', '203', 'ZSSP_04', '下架商品', '0', 'shop/goods/unsale', '', '1', '1'),
('310', '0', '210', 'GGGL_00', '查看广告管理', '1', 'shop/admgrs/index', 'shop/admgrs/pageQuery', '1', '1'),
('311', '0', '210', 'GGGL_01', '新增广告', '0', 'shop/admgrs/add', 'shop/admgrs/toEdit', '1', '1'),
('312', '0', '210', 'GGGL_02', '修改广告', '0', 'shop/admgrs/edit', 'shop/admgrs/toEdit,shop/admgrs/changeSort', '1', '1'),
('313', '0', '210', 'GGGL_03', '删除广告', '0', 'shop/admgrs/del', '', '1', '1'),
('314', '0', '204', 'CKSP_00', '查看仓库商品', '1', 'shop/goods/onstore', 'shop/goods/storeByPage', '1', '1'),
('315', '0', '204', 'SPRK_01', '商品入库', '0', 'shop/goodsstock/add', '', '1', '1'),
('316', '0', '204', 'SPRK_00', '商品库存记录', '0', '', '', '1', '1'),
('317', '0', '204', 'CKSP_04', '商品上架', '0', 'shop/goods/sale', '', '1', '1'),
('318', '0', '212', 'ZYLY_00', '查看职员列表', '1', 'shop/staffs/index', 'shop/staffs/pageQuery', '1', '1'),
('319', '0', '212', 'ZYGL_04', '编辑职员权限', '0', 'shop/staffs/changeRole', '', '1', '1'),
('320', '0', '198', 'MDDFKDD_00', '查看门店待付款订单', '1', 'shop/orders/waitPay', 'shop/orders/waitPayByPage', '1', '1'),
('321', '0', '199', 'MDYSHDD_00', '查看门店已收货订单', '1', 'shop/orders/received', 'shop/orders/receivedBypage', '1', '1'),
('322', '0', '200', 'MDQXJSDD_00', '查看门店取消/拒收订单', '1', 'shop/orders/abnormal', 'shop/orders/abnormalByPage', '1', '1'),
('323', '0', '205', 'KCYJ_00', '查看库存预警', '1', 'shop/goods/onwarn', 'shop/goods/warnByPage', '1', '1'),
('324', '0', '205', 'KCSP_01', '商品入库', '0', 'shop/goodsstock/add', '', '1', '1'),
('325', '0', '205', 'KCSP_00', '商品库存记录', '0', '', '', '1', '1'),
('326', '0', '205', 'KCYJ_04', '下架商品', '0', 'shop/goods/unsale', '', '1', '1'),
('327', '0', '211', 'DPSZ_00', '查看店铺设置', '1', 'shop/shops/index', 'shop/shops/edit', '1', '1'),
('328', '0', '215', 'DDPJ_00', '查看订单评价', '1', 'shop/goodsappraises/index', 'shop/goodsappraises/pagequery', '1', '1'),
('329', '0', '215', 'DDPJ_02', '回复订单评价', '0', 'shop/goodsappraises/edit', 'shop/goodsappraises/toEdit', '1', '1'),
('330', '0', '219', 'REPORTS_01', '查看销售排行', '1', 'shop/reports/toTopSaleGoods', 'shop/reports/topSaleGoodsByPage', '1', '1'),
('331', '0', '220', 'REPORTS_04', '查看销售订单统计', '1', 'shop/reports/toStatOrders', 'shop/reports/statOrders', '1', '1'),
('332', '0', '221', 'TKDD_00', '查看退款订单', '1', 'shop/orderrefunds/index', 'shop/orderrefunds/queryByPage,shop/orderrefunds/toExport', '1', '1'),
('333', '0', '221', 'TKDD_04', '退款操作', '0', 'shop/orderrefunds/orderRefund', 'shop/orderrefunds/toRefund,shop/orderrefunds/wxRefundNodify,shop/orderrefunds/wxAppRefundNodify', '1', '1'),
('334', '0', '222', 'PSGL_00', '查看配送管理', '1', 'shop/deliveryers/index', 'shop/deliveryers/pageQuery', '1', '1'),
('335', '0', '222', 'PSGL_01', '新增配送', '0', 'shop/deliveryers/add', 'shop/deliveryers/toEdit', '1', '1'),
('336', '0', '222', 'PSGL_02', '修改配送', '0', 'shop/deliveryers/edit', 'shop/deliveryers/toEdit', '1', '1'),
('337', '0', '222', 'PSGL_03', '删除配送', '0', 'shop/deliveryers/del', '', '1', '1'),
('338', '0', '208', 'CKSY_00', '查看首页', '0', '', '', '1', '1'),
('339', '0', '209', 'JCSZ_00', '查看基础设置', '0', '', '', '1', '1'),
('340', '0', '217', 'YYTJ_00', '查看运营统计', '0', '', '', '1', '1'),
('341', '0', '218', 'BBTJ_00', '查看报表统计', '0', '', '', '1', '1');
