SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS `wst_goods_libs`;
CREATE TABLE `wst_goods_libs` (
  `goodsLibId` int(11) NOT NULL AUTO_INCREMENT,
  `goodsSn` varchar(20) NOT NULL,
  `productNo` varchar(20) NOT NULL,
  `goodsName` varchar(100) NOT NULL,
  `goodsImg` varchar(150) NOT NULL,
  `shopCostPrice` decimal(11,2) DEFAULT '0.00' COMMENT '店铺进货价',
  `costPrice` decimal(11,2) NOT NULL DEFAULT '0.00' COMMENT '成本价',
  `retailPrice` decimal(11,2) NOT NULL DEFAULT '0.00' COMMENT '建议零售价',
  `goodsStock` int(11) NOT NULL DEFAULT '0',
  `goodsUnit` char(10) NOT NULL,
  `goodsTips` text,
  `isSale` tinyint(4) NOT NULL DEFAULT '1',
  `isBest` tinyint(4) NOT NULL DEFAULT '0',
  `isHot` tinyint(4) NOT NULL DEFAULT '0',
  `isNew` tinyint(4) NOT NULL DEFAULT '0',
  `isRecom` tinyint(4) DEFAULT '0',
  `goodsCatId` int(11) NOT NULL,
  `goodsCatIdPath` varchar(255) DEFAULT NULL,
  `brandId` int(11) DEFAULT '0',
  `goodsDesc` text NOT NULL,
  `saleTime` datetime NOT NULL,
  `visitNum` int(11) DEFAULT '0',
  `gallery` text,
  `goodsSeoKeywords` varchar(200) DEFAULT NULL,
  `dataFlag` tinyint(4) NOT NULL DEFAULT '1',
  `createTime` datetime NOT NULL,
  `goodsSerachKeywords` text,
  PRIMARY KEY (`goodsLibId`),
  KEY `goodsStatus` (`dataFlag`,`isSale`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4;
