SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS `wst_goods`;
CREATE TABLE `wst_goods` (
  `goodsId` int(11) NOT NULL AUTO_INCREMENT,
  `goodsTips` text,
  `shopId` int(11) DEFAULT NULL,
  `costPrice` decimal(11,2) DEFAULT '0.00' COMMENT '店铺成本价',
  `shopPrice` decimal(11,2) DEFAULT '0.00' COMMENT '店铺价格',
  `goodsStock` int(11) DEFAULT '0' COMMENT '库存数',
  `isSale` tinyint(4) DEFAULT '1' COMMENT '是否上架   1:上架   0:否',
  `isBest` tinyint(4) DEFAULT '1' COMMENT '是否精品 1:是  0:否',
  `isHot` tinyint(4) DEFAULT '1' COMMENT '是否热销  1:热销  0:否',
  `isNew` tinyint(4) DEFAULT '1' COMMENT '是否新品 1:新品  0:否',
  `isRecom` tinyint(4) DEFAULT '1' COMMENT '是否推荐商品 1:推荐  0:否',
  `visitNum` int(11) DEFAULT '0' COMMENT '访问数',
  `saleNum` int(11) DEFAULT '0' COMMENT '销售数',
  `goodsLibId` int(11) DEFAULT '0' COMMENT '对应的商品标准库Id',
  `saleTime` datetime DEFAULT NULL COMMENT '上架时间',
  `warnStock` int(11) DEFAULT '0' COMMENT '预警库存',
  `appraiseNum` int(11) DEFAULT '0',
  PRIMARY KEY (`goodsId`)
) ENGINE=InnoDB AUTO_INCREMENT=301 DEFAULT CHARSET=utf8mb4;
