SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS `wst_areas`;
CREATE TABLE `wst_areas` (
  `areaId` int(11) NOT NULL AUTO_INCREMENT,
  `parentId` int(11) NOT NULL,
  `areaName` varchar(100) NOT NULL,
  `isShow` tinyint(4) NOT NULL DEFAULT '1',
  `areaSort` int(11) NOT NULL DEFAULT '0',
  `areaKey` char(10) DEFAULT NULL,
  `areaType` tinyint(4) NOT NULL DEFAULT '1',
  `dataFlag` tinyint(4) NOT NULL DEFAULT '1',
  `createTime` datetime DEFAULT NULL,
  PRIMARY KEY (`areaId`),
  KEY `isShow` (`isShow`,`dataFlag`),
  KEY `areaType` (`areaType`),
  KEY `parentId` (`parentId`)
) ENGINE=InnoDB AUTO_INCREMENT=3309 DEFAULT CHARSET=utf8mb4;


INSERT INTO `wst_areas` VALUES ('2', '0', '北京市', '1', '0', 'B', '0', '1', null),
('3', '0', '安徽省', '1', '0', 'A', '0', '1', null),
('4', '0', '福建省', '1', '0', 'F', '0', '1', null),
('5', '0', '甘肃省', '0', '0', 'G', '0', '1', null),
('6', '0', '广东省', '1', '0', 'G', '0', '1', null),
('7', '0', '广西壮族自治区', '1', '0', 'G', '0', '1', null),
('8', '0', '贵州省', '0', '0', 'G', '0', '1', null),
('9', '0', '海南省', '0', '0', 'H', '0', '1', null),
('10', '0', '河北省', '0', '0', 'H', '0', '1', null),
('11', '0', '河南省', '0', '0', 'H', '0', '1', null),
('12', '0', '黑龙江省', '0', '0', 'H', '0', '1', null),
('13', '0', '湖北省', '0', '0', 'H', '0', '1', null),
('14', '0', '湖南省', '0', '0', 'H', '0', '1', null),
('15', '0', '吉林省', '0', '0', 'J', '0', '1', null),
('16', '0', '江苏省', '0', '0', 'J', '0', '1', null),
('17', '0', '江西省', '0', '0', 'J', '0', '1', null),
('18', '0', '辽宁省', '0', '0', 'L', '0', '1', null),
('19', '0', '内蒙古自治区', '0', '0', 'N', '0', '1', null),
('20', '0', '宁夏回族自治区', '0', '0', 'N', '0', '1', null),
('21', '0', '青海省', '0', '0', 'Q', '0', '1', null),
('22', '0', '山东省', '0', '0', 'S', '0', '1', null),
('23', '0', '山西省', '0', '0', 'S', '0', '1', null),
('24', '0', '陕西省', '0', '0', 'S', '0', '1', null),
('25', '0', '上海市', '1', '0', 'S', '0', '1', null),
('26', '0', '四川省', '0', '0', 'S', '0', '1', null),
('27', '0', '天津市', '0', '0', 'T', '0', '1', null),
('28', '0', '西藏自治区', '0', '0', 'X', '0', '1', null),
('29', '0', '新疆维吾尔自治区', '0', '0', 'X', '0', '1', null),
('30', '0', '云南省', '0', '0', 'Y', '0', '1', null),
('31', '0', '浙江省', '1', '0', 'Z', '0', '1', null),
('32', '0', '重庆市', '0', '0', 'C', '0', '1', null),
('33', '0', '香港特别行政区', '0', '0', 'X', '0', '1', null),
('34', '0', '澳门特别行政区', '0', '0', 'A', '0', '1', null),
('35', '0', '台湾省', '0', '0', 'T', '0', '1', null),
('36', '3', '安庆市', '0', '0', 'A', '1', '1', null),
('37', '3', '蚌埠市', '0', '0', 'B', '1', '1', null),
('38', '3', '合肥市', '1', '0', 'H', '1', '1', null),
('39', '3', '池州市', '0', '0', 'C', '1', '1', null),
('40', '3', '滁州市', '0', '0', 'C', '1', '1', null),
('41', '3', '阜阳市', '0', '0', 'F', '1', '1', null),
('42', '3', '淮北市', '0', '0', 'H', '1', '1', null),
('43', '3', '淮南市', '0', '0', 'H', '1', '1', null),
('44', '3', '黄山市', '0', '0', 'H', '1', '1', null),
('45', '3', '六安市', '0', '0', 'L', '1', '1', null),
('46', '3', '马鞍山市', '0', '0', 'M', '1', '1', null),
('47', '3', '宿州市', '0', '0', 'S', '1', '1', null),
('48', '3', '铜陵市', '0', '0', 'T', '1', '1', null),
('49', '3', '芜湖市', '0', '0', 'W', '1', '1', null),
('50', '3', '宣城市', '0', '0', 'X', '1', '1', null),
('51', '3', '亳州市', '0', '0', 'H', '1', '1', null),
('52', '2', '北京', '1', '0', 'B', '1', '1', null),
('53', '4', '福州市', '1', '0', 'F', '1', '1', null),
('54', '4', '龙岩市', '1', '0', 'L', '1', '1', null),
('55', '4', '南平市', '0', '0', 'N', '1', '1', null),
('56', '4', '宁德市', '0', '0', 'N', '1', '1', null),
('57', '4', '莆田市', '0', '0', 'P', '1', '1', null),
('58', '4', '泉州市', '0', '0', 'Q', '1', '1', null),
('59', '4', '三明市', '0', '0', 'S', '1', '1', null),
('60', '4', '厦门市', '1', '0', 'X', '1', '1', null),
('61', '4', '漳州市', '0', '0', 'Z', '1', '1', null),
('62', '5', '兰州市', '0', '0', 'L', '1', '1', null),
('63', '5', '白银市', '0', '0', 'B', '1', '1', null),
('64', '5', '定西市', '0', '0', 'D', '1', '1', null),
('65', '5', '甘南藏族自治州', '0', '0', 'G', '1', '1', null),
('66', '5', '嘉峪关', '0', '0', 'J', '1', '1', null),
('67', '5', '金昌市', '0', '0', 'J', '1', '1', null),
('68', '5', '酒泉市', '0', '0', 'J', '1', '1', null),
('69', '5', '临夏回族自治州', '0', '0', 'L', '1', '1', null),
('70', '5', '陇南市', '0', '0', 'L', '1', '1', null),
('71', '5', '平凉市', '0', '0', 'P', '1', '1', null),
('72', '5', '庆阳市', '0', '0', 'Q', '1', '1', null),
('73', '5', '天水市', '0', '0', 'T', '1', '1', null),
('74', '5', '武威市', '0', '0', 'W', '1', '1', null),
('75', '5', '张掖市', '0', '0', 'Z', '1', '1', null),
('76', '6', '广州市', '1', '0', 'G', '1', '1', null),
('77', '6', '深圳市', '1', '0', 'S', '1', '1', null),
('78', '6', '潮州市', '0', '0', 'C', '1', '1', null),
('79', '6', '东莞市', '1', '0', 'D', '1', '1', null),
('80', '6', '佛山市', '1', '0', 'F', '1', '1', null),
('81', '6', '河源市', '0', '0', 'H', '1', '1', null),
('82', '6', '惠州市', '1', '0', 'H', '1', '1', null),
('83', '6', '江门市', '0', '0', 'J', '1', '1', null),
('84', '6', '揭阳市', '0', '0', 'J', '1', '1', null),
('85', '6', '茂名市', '0', '0', 'M', '1', '1', null),
('86', '6', '梅州市', '0', '0', 'M', '1', '1', null),
('87', '6', '清远市', '0', '0', 'Q', '1', '1', null),
('88', '6', '汕头市', '0', '0', 'S', '1', '1', null),
('89', '6', '汕尾市', '0', '0', 'S', '1', '1', null),
('90', '6', '韶关市', '0', '0', 'S', '1', '1', null),
('91', '6', '阳江市', '0', '0', 'Y', '1', '1', null),
('92', '6', '云浮市', '0', '0', 'Y', '1', '1', null),
('93', '6', '湛江市', '0', '0', 'Z', '1', '1', null),
('94', '6', '肇庆市', '0', '0', 'Z', '1', '1', null),
('95', '6', '中山市', '0', '0', 'Z', '1', '1', null),
('96', '6', '珠海市', '1', '0', 'Z', '1', '1', null),
('97', '7', '南宁市', '1', '0', 'N', '1', '1', null),
('98', '7', '桂林市', '1', '0', 'G', '1', '1', null),
('99', '7', '百色市', '0', '0', 'B', '1', '1', null),
('100', '7', '北海市', '0', '0', 'B', '1', '1', null),
('101', '7', '崇左市', '0', '0', 'C', '1', '1', null),
('102', '7', '防城港市', '0', '0', 'F', '1', '1', null),
('103', '7', '贵港市', '0', '0', 'G', '1', '1', null),
('104', '7', '河池市', '0', '0', 'H', '1', '1', null),
('105', '7', '贺州市', '0', '0', 'H', '1', '1', null),
('106', '7', '来宾市', '0', '0', 'L', '1', '1', null),
('107', '7', '柳州市', '0', '0', 'L', '1', '1', null),
('108', '7', '钦州市', '0', '0', 'Q', '1', '1', null),
('109', '7', '梧州市', '0', '0', 'W', '1', '1', null),
('110', '7', '玉林市', '0', '0', 'Y', '1', '1', null),
('111', '8', '贵阳市', '0', '0', 'G', '1', '1', null),
('112', '8', '安顺市', '0', '0', 'A', '1', '1', null),
('113', '8', '毕节市', '0', '0', 'B', '1', '1', null),
('114', '8', '六盘水市', '0', '0', 'L', '1', '1', null),
('115', '8', '黔东南苗族侗族自治州', '0', '0', 'Q', '1', '1', null),
('116', '8', '黔西南布依族苗族自治州', '0', '0', 'Q', '1', '1', null),
('117', '8', '黔南布依族苗族自治州', '0', '0', 'Q', '1', '1', null),
('118', '8', '铜仁', '0', '0', 'T', '1', '1', null),
('119', '8', '遵义', '0', '0', 'Z', '1', '1', null),
('120', '9', '海口市', '0', '0', 'H', '1', '1', null),
('121', '9', '三亚市', '0', '0', 'S', '1', '1', null),
('122', '9', '白沙黎族自治县', '0', '0', 'B', '1', '1', null),
('123', '9', '保亭黎族苗族自治县', '0', '0', 'B', '1', '1', null),
('124', '9', '昌江黎族自治县', '0', '0', 'C', '1', '1', null),
('125', '9', '澄迈县', '0', '0', 'C', '1', '1', null),
('126', '9', '定安县', '0', '0', 'D', '1', '1', null),
('127', '9', '东方市', '0', '0', 'D', '1', '1', null),
('128', '9', '乐东黎族自治县', '0', '0', 'L', '1', '1', null),
('129', '9', '临高县', '0', '0', 'L', '1', '1', null),
('130', '9', '陵水黎族自治县', '0', '0', 'L', '1', '1', null),
('131', '9', '琼海市', '0', '0', 'Q', '1', '1', null),
('132', '9', '琼中黎族苗族自治县', '0', '0', 'Q', '1', '1', null),
('133', '9', '屯昌县', '0', '0', 'T', '1', '1', null),
('134', '9', '万宁市', '0', '0', 'W', '1', '1', null),
('135', '9', '文昌市', '0', '0', 'W', '1', '1', null),
('136', '9', '五指山市', '0', '0', 'W', '1', '1', null),
('137', '9', '儋州市', '0', '0', 'Z', '1', '1', null),
('138', '10', '石家庄市', '0', '0', 'S', '1', '1', null),
('139', '10', '保定市', '0', '0', 'B', '1', '1', null),
('140', '10', '沧州市', '0', '0', 'C', '1', '1', null),
('141', '10', '承德市', '0', '0', 'C', '1', '1', null),
('142', '10', '邯郸市', '0', '0', 'H', '1', '1', null),
('143', '10', '衡水市', '0', '0', 'H', '1', '1', null),
('144', '10', '廊坊市', '0', '0', 'L', '1', '1', null),
('145', '10', '秦皇岛市', '0', '0', 'Q', '1', '1', null),
('146', '10', '唐山市', '0', '0', 'T', '1', '1', null),
('147', '10', '邢台市', '0', '0', 'X', '1', '1', null),
('148', '10', '张家口市', '0', '0', 'Z', '1', '1', null),
('149', '11', '郑州市', '0', '0', 'Z', '1', '1', null),
('150', '11', '洛阳市', '0', '0', 'L', '1', '1', null),
('151', '11', '开封市', '0', '0', 'K', '1', '1', null),
('152', '11', '安阳市', '0', '0', 'A', '1', '1', null),
('153', '11', '鹤壁市', '0', '0', 'H', '1', '1', null),
('154', '11', '济源市', '0', '0', 'J', '1', '1', null),
('155', '11', '焦作市', '0', '0', 'J', '1', '1', null),
('156', '11', '南阳市', '0', '0', 'N', '1', '1', null),
('157', '11', '平顶山市', '0', '0', 'P', '1', '1', null),
('158', '11', '三门峡市', '0', '0', 'S', '1', '1', null),
('159', '11', '商丘市', '0', '0', 'S', '1', '1', null),
('160', '11', '新乡市', '0', '0', 'X', '1', '1', null),
('161', '11', '信阳市', '0', '0', 'X', '1', '1', null),
('162', '11', '许昌市', '0', '0', 'X', '1', '1', null),
('163', '11', '周口市', '0', '0', 'Z', '1', '1', null),
('164', '11', '驻马店市', '0', '0', 'Z', '1', '1', null),
('165', '11', '漯河市', '0', '0', 'L', '1', '1', null),
('166', '11', '濮阳市', '0', '0', 'P', '1', '1', null),
('167', '12', '哈尔滨市', '0', '0', 'H', '1', '1', null),
('168', '12', '大庆市', '0', '0', 'D', '1', '1', null),
('169', '12', '大兴安岭地区', '0', '0', 'D', '1', '1', null),
('170', '12', '鹤岗市', '0', '0', 'H', '1', '1', null),
('171', '12', '黑河市', '0', '0', 'H', '1', '1', null),
('172', '12', '鸡西市', '0', '0', 'J', '1', '1', null),
('173', '12', '佳木斯市', '0', '0', 'J', '1', '1', null),
('174', '12', '牡丹江市', '0', '0', 'M', '1', '1', null),
('175', '12', '七台河市', '0', '0', 'Q', '1', '1', null),
('176', '12', '齐齐哈尔市', '0', '0', 'Q', '1', '1', null),
('177', '12', '双鸭山市', '0', '0', 'S', '1', '1', null),
('178', '12', '绥化市', '0', '0', 'S', '1', '1', null),
('179', '12', '伊春市', '0', '0', 'Y', '1', '1', null),
('180', '13', '武汉市', '0', '0', 'W', '1', '1', null),
('181', '13', '仙桃市', '0', '0', 'X', '1', '1', null),
('182', '13', '鄂州市', '0', '0', 'E', '1', '1', null),
('183', '13', '黄冈市', '0', '0', 'H', '1', '1', null),
('184', '13', '黄石市', '0', '0', 'H', '1', '1', null),
('185', '13', '荆门市', '0', '0', 'J', '1', '1', null),
('186', '13', '荆州市', '0', '0', 'J', '1', '1', null),
('187', '13', '潜江市', '0', '0', 'Q', '1', '1', null),
('188', '13', '神农架林区', '0', '0', 'S', '1', '1', null),
('189', '13', '十堰市', '0', '0', 'S', '1', '1', null),
('190', '13', '随州市', '0', '0', 'S', '1', '1', null),
('191', '13', '天门市', '0', '0', 'T', '1', '1', null),
('192', '13', '咸宁市', '0', '0', 'X', '1', '1', null),
('193', '13', '襄樊市', '0', '0', 'X', '1', '1', null),
('194', '13', '孝感市', '0', '0', 'X', '1', '1', null),
('195', '13', '宜昌市', '0', '0', 'Y', '1', '1', null),
('196', '13', '恩施土家族苗族自治州', '0', '0', 'E', '1', '1', null),
('197', '14', '长沙市', '0', '0', 'C', '1', '1', null),
('198', '14', '张家界市', '0', '0', 'Z', '1', '1', null),
('199', '14', '常德市', '0', '0', 'C', '1', '1', null),
('200', '14', '郴州市', '0', '0', 'C', '1', '1', null),
('201', '14', '衡阳市', '0', '0', 'H', '1', '1', null),
('202', '14', '怀化市', '0', '0', 'H', '1', '1', null),
('203', '14', '娄底市', '0', '0', 'L', '1', '1', null),
('204', '14', '邵阳市', '0', '0', 'S', '1', '1', null),
('205', '14', '湘潭市', '0', '0', 'X', '1', '1', null),
('206', '14', '湘西土家族苗族自治州', '0', '0', 'X', '1', '1', null),
('207', '14', '益阳市', '0', '0', 'Y', '1', '1', null),
('208', '14', '永州市', '0', '0', 'Y', '1', '1', null),
('209', '14', '岳阳市', '0', '0', 'Y', '1', '1', null),
('210', '14', '株洲市', '0', '0', 'Z', '1', '1', null),
('211', '15', '长春市', '0', '0', 'C', '1', '1', null),
('212', '15', '吉林市', '0', '0', 'J', '1', '1', null),
('213', '15', '白城市', '0', '0', 'B', '1', '1', null),
('214', '15', '白山市', '0', '0', 'B', '1', '1', null),
('215', '15', '辽源市', '0', '0', 'L', '1', '1', null),
('216', '15', '四平市', '0', '0', 'S', '1', '1', null),
('217', '15', '松原市', '0', '0', 'S', '1', '1', null),
('218', '15', '通化市', '0', '0', 'T', '1', '1', null),
('219', '15', '延边朝鲜族自治州', '0', '0', 'Y', '1', '1', null),
('220', '16', '南京市', '0', '0', 'N', '1', '1', null),
('221', '16', '苏州市', '0', '0', 'S', '1', '1', null),
('222', '16', '无锡市', '0', '0', 'W', '1', '1', null),
('223', '16', '常州市', '0', '0', 'C', '1', '1', null),
('224', '16', '淮安市', '0', '0', 'H', '1', '1', null),
('225', '16', '连云港市', '0', '0', 'L', '1', '1', null),
('226', '16', '南通市', '0', '0', 'N', '1', '1', null),
('227', '16', '宿迁市', '0', '0', 'S', '1', '1', null),
('228', '16', '泰州市', '0', '0', 'T', '1', '1', null),
('229', '16', '徐州市', '0', '0', 'X', '1', '1', null),
('230', '16', '盐城市', '0', '0', 'Y', '1', '1', null),
('231', '16', '扬州市', '0', '0', 'Y', '1', '1', null),
('232', '16', '镇江市', '0', '0', 'Z', '1', '1', null),
('233', '17', '南昌市', '0', '0', 'N', '1', '1', null),
('234', '17', '抚州市', '0', '0', 'F', '1', '1', null),
('235', '17', '赣州市', '0', '0', 'G', '1', '1', null),
('236', '17', '吉安市', '0', '0', 'J', '1', '1', null),
('237', '17', '景德镇市', '0', '0', 'J', '1', '1', null),
('238', '17', '九江市', '0', '0', 'J', '1', '1', null),
('239', '17', '萍乡市', '0', '0', 'P', '1', '1', null),
('240', '17', '上饶市', '0', '0', 'S', '1', '1', null),
('241', '17', '新余市', '0', '0', 'X', '1', '1', null),
('242', '17', '宜春市', '0', '0', 'Y', '1', '1', null),
('243', '17', '鹰潭市', '0', '0', 'Y', '1', '1', null),
('244', '18', '沈阳市', '0', '0', 'S', '1', '1', null),
('245', '18', '大连市', '0', '0', 'D', '1', '1', null),
('246', '18', '鞍山市', '0', '0', 'A', '1', '1', null),
('247', '18', '本溪市', '0', '0', 'B', '1', '1', null),
('248', '18', '朝阳市', '0', '0', 'C', '1', '1', null),
('249', '18', '丹东市', '0', '0', 'D', '1', '1', null),
('250', '18', '抚顺市', '0', '0', 'F', '1', '1', null),
('251', '18', '阜新市', '0', '0', 'F', '1', '1', null),
('252', '18', '葫芦岛市', '0', '0', 'H', '1', '1', null),
('253', '18', '锦州市', '0', '0', 'J', '1', '1', null),
('254', '18', '辽阳市', '0', '0', 'L', '1', '1', null),
('255', '18', '盘锦市', '0', '0', 'P', '1', '1', null),
('256', '18', '铁岭市', '0', '0', 'T', '1', '1', null),
('257', '18', '营口市', '0', '0', 'Y', '1', '1', null),
('258', '19', '呼和浩特市', '0', '0', 'H', '1', '1', null),
('259', '19', '阿拉善盟', '0', '0', 'A', '1', '1', null),
('260', '19', '巴彦淖尔盟', '0', '0', 'B', '1', '1', null),
('261', '19', '包头市', '0', '0', 'B', '1', '1', null),
('262', '19', '赤峰市', '0', '0', 'C', '1', '1', null),
('263', '19', '鄂尔多斯市', '0', '0', 'E', '1', '1', null),
('264', '19', '呼伦贝尔市', '0', '0', 'H', '1', '1', null),
('265', '19', '通辽市', '0', '0', 'T', '1', '1', null),
('266', '19', '乌海市', '0', '0', 'W', '1', '1', null),
('267', '19', '乌兰察布市', '0', '0', 'W', '1', '1', null),
('268', '19', '锡林郭勒盟', '0', '0', 'X', '1', '1', null),
('269', '19', '兴安盟', '0', '0', 'X', '1', '1', null),
('270', '20', '银川市', '0', '0', 'Y', '1', '1', null),
('271', '20', '固原市', '0', '0', 'G', '1', '1', null),
('272', '20', '石嘴山市', '0', '0', 'S', '1', '1', null),
('273', '20', '吴忠市', '0', '0', 'W', '1', '1', null),
('274', '20', '中卫市', '0', '0', 'Z', '1', '1', null),
('275', '21', '西宁市', '0', '0', 'X', '1', '1', null),
('276', '21', '果洛藏族自治州', '0', '0', 'G', '1', '1', null),
('277', '21', '海北藏族自治州', '0', '0', 'H', '1', '1', null),
('278', '21', '海东市', '0', '0', 'H', '1', '1', null),
('279', '21', '海南藏族自治州', '0', '0', 'H', '1', '1', null),
('280', '21', '海西蒙古族藏族自治州', '0', '0', 'H', '1', '1', null),
('281', '21', '黄南藏族自治州', '0', '0', 'H', '1', '1', null),
('282', '21', '玉树藏族自治州', '0', '0', 'Y', '1', '1', null),
('283', '22', '济南市', '0', '0', 'J', '1', '1', null),
('284', '22', '青岛市', '0', '0', 'Q', '1', '1', null),
('285', '22', '滨州市', '0', '0', 'B', '1', '1', null),
('286', '22', '德州市', '0', '0', 'D', '1', '1', null),
('287', '22', '东营市', '0', '0', 'D', '1', '1', null),
('288', '22', '菏泽市', '0', '0', 'H', '1', '1', null),
('289', '22', '济宁市', '0', '0', 'J', '1', '1', null),
('290', '22', '莱芜市', '0', '0', 'L', '1', '1', null),
('291', '22', '聊城市', '0', '0', 'L', '1', '1', null),
('292', '22', '临沂市', '0', '0', 'L', '1', '1', null),
('293', '22', '日照市', '0', '0', 'R', '1', '1', null),
('294', '22', '泰安市', '0', '0', 'T', '1', '1', null),
('295', '22', '威海市', '0', '0', 'W', '1', '1', null),
('296', '22', '潍坊市', '0', '0', 'W', '1', '1', null),
('297', '22', '烟台市', '0', '0', 'Y', '1', '1', null),
('298', '22', '枣庄市', '0', '0', 'Z', '1', '1', null),
('299', '22', '淄博市', '0', '0', 'Z', '1', '1', null),
('300', '23', '太原市', '0', '0', 'T', '1', '1', null),
('301', '23', '长治市', '0', '0', 'C', '1', '1', null),
('302', '23', '大同市', '0', '0', 'D', '1', '1', null),
('303', '23', '晋城市', '0', '0', 'J', '1', '1', null),
('304', '23', '晋中市', '0', '0', 'J', '1', '1', null),
('305', '23', '临汾市', '0', '0', 'L', '1', '1', null),
('306', '23', '吕梁市', '0', '0', 'L', '1', '1', null),
('307', '23', '朔州市', '0', '0', 'S', '1', '1', null),
('308', '23', '忻州市', '0', '0', 'X', '1', '1', null),
('309', '23', '阳泉市', '0', '0', 'Y', '1', '1', null),
('310', '23', '运城市', '0', '0', 'Y', '1', '1', null),
('311', '24', '西安市', '0', '0', 'X', '1', '1', null),
('312', '24', '安康市', '0', '0', 'A', '1', '1', null),
('313', '24', '宝鸡市', '0', '0', 'B', '1', '1', null),
('314', '24', '汉中市', '0', '0', 'H', '1', '1', null),
('315', '24', '商洛市', '0', '0', 'S', '1', '1', null),
('316', '24', '铜川市', '0', '0', 'T', '1', '1', null),
('317', '24', '渭南市', '0', '0', 'W', '1', '1', null),
('318', '24', '咸阳市', '0', '0', 'X', '1', '1', null),
('319', '24', '延安市', '0', '0', 'Y', '1', '1', null),
('320', '24', '榆林市', '0', '0', 'Y', '1', '1', null),
('321', '25', '上海', '1', '0', 'S', '1', '1', null),
('322', '26', '成都市', '0', '0', 'C', '1', '1', null),
('323', '26', '绵阳市', '0', '0', 'M', '1', '1', null),
('324', '26', '阿坝藏族羌族自治州', '0', '0', 'A', '1', '1', null),
('325', '26', '巴中市', '0', '0', 'B', '1', '1', null),
('326', '26', '达州市', '0', '0', 'D', '1', '1', null),
('327', '26', '德阳市', '0', '0', 'D', '1', '1', null),
('328', '26', '甘孜藏族自治州', '0', '0', 'G', '1', '1', null),
('329', '26', '广安市', '0', '0', 'G', '1', '1', null),
('330', '26', '广元市', '0', '0', 'G', '1', '1', null),
('331', '26', '乐山市', '0', '0', 'L', '1', '1', null),
('332', '26', '凉山彝族自治州', '0', '0', 'L', '1', '1', null),
('333', '26', '眉山市', '0', '0', 'M', '1', '1', null),
('334', '26', '南充市', '0', '0', 'N', '1', '1', null),
('335', '26', '内江市', '0', '0', 'N', '1', '1', null),
('336', '26', '攀枝花', '0', '0', 'P', '1', '1', null),
('337', '26', '遂宁市', '0', '0', 'S', '1', '1', null),
('338', '26', '雅安市', '0', '0', 'Y', '1', '1', null),
('339', '26', '宜宾市', '0', '0', 'Y', '1', '1', null),
('340', '26', '资阳市', '0', '0', 'Z', '1', '1', null),
('341', '26', '自贡市', '0', '0', 'Z', '1', '1', null),
('342', '26', '泸州市', '0', '0', 'L', '1', '1', null),
('343', '27', '天津', '0', '0', 'T', '1', '1', null),
('344', '28', '拉萨市', '0', '0', 'L', '1', '1', null),
('345', '28', '阿里地区', '0', '0', 'A', '1', '1', null),
('346', '28', '昌都市', '0', '0', 'C', '1', '1', null),
('347', '28', '林芝市', '0', '0', 'L', '1', '1', null),
('348', '28', '那曲地区', '0', '0', 'Q', '1', '1', null),
('349', '28', '日喀则市', '0', '0', 'R', '1', '1', null),
('350', '28', '山南市', '0', '0', 'S', '1', '1', null),
('351', '29', '乌鲁木齐市', '0', '0', 'W', '1', '1', null),
('352', '29', '阿克苏地区', '0', '0', 'A', '1', '1', null),
('353', '29', '阿拉尔', '0', '0', 'A', '1', '1', null),
('354', '29', '巴音郭楞蒙古自治州', '0', '0', 'B', '1', '1', null),
('355', '29', '博尔塔拉蒙古自治州', '0', '0', 'B', '1', '1', null),
('356', '29', '昌吉回族自治州', '0', '0', 'J', '1', '1', null),
('357', '29', '哈密市', '0', '0', 'H', '1', '1', null),
('358', '29', '和田地区', '0', '0', 'H', '1', '1', null),
('359', '29', '喀什地区', '0', '0', 'K', '1', '1', null),
('360', '29', '克拉玛依市', '0', '0', 'K', '1', '1', null),
('361', '29', '克孜勒苏柯尔克孜自治州', '0', '0', 'K', '1', '1', null),
('362', '29', '石河子', '0', '0', 'S', '1', '1', null),
('363', '29', '图木舒克', '0', '0', 'T', '1', '1', null),
('364', '29', '吐鲁番市', '0', '0', 'T', '1', '1', null),
('365', '29', '五家渠市', '0', '0', 'W', '1', '1', null),
('366', '29', '伊犁哈萨克自治州', '0', '0', 'Y', '1', '1', null),
('367', '30', '昆明市', '0', '0', 'K', '1', '1', null),
('368', '30', '怒江傈僳族自治州', '0', '0', 'N', '1', '1', null),
('369', '30', '普洱市', '0', '0', 'P', '1', '1', null),
('370', '30', '丽江市', '0', '0', 'L', '1', '1', null),
('371', '30', '保山市', '0', '0', 'B', '1', '1', null),
('372', '30', '楚雄彝族自治州', '0', '0', 'C', '1', '1', null),
('373', '30', '大理白族自治州', '0', '0', 'D', '1', '1', null),
('374', '30', '德宏傣族景颇族自治州', '0', '0', 'D', '1', '1', null),
('375', '30', '迪庆藏族自治州', '0', '0', 'D', '1', '1', null),
('376', '30', '红河哈尼族彝族自治州', '0', '0', 'H', '1', '1', null),
('377', '30', '临沧市', '0', '0', 'L', '1', '1', null),
('378', '30', '曲靖市', '0', '0', 'Q', '1', '1', null),
('379', '30', '文山壮族苗族自治州', '0', '0', 'W', '1', '1', null),
('380', '30', '西双版纳傣族自治州', '0', '0', 'X', '1', '1', null),
('381', '30', '玉溪市', '0', '0', 'Y', '1', '1', null),
('382', '30', '昭通市', '0', '0', 'Z', '1', '1', null),
('383', '31', '杭州市', '1', '0', 'H', '1', '1', null),
('384', '31', '湖州市', '1', '0', 'H', '1', '1', null),
('385', '31', '嘉兴市', '0', '0', 'J', '1', '1', null),
('386', '31', '金华市', '1', '0', 'J', '1', '1', null),
('387', '31', '丽水市', '0', '0', 'L', '1', '1', null),
('388', '31', '宁波市', '1', '0', 'N', '1', '1', null),
('389', '31', '绍兴市', '0', '0', 'S', '1', '1', null),
('390', '31', '台州市', '0', '0', 'T', '1', '1', null),
('391', '31', '温州市', '1', '0', 'W', '1', '1', null),
('392', '31', '舟山市', '0', '0', 'Z', '1', '1', null),
('393', '31', '衢州市', '0', '0', 'Q', '1', '1', null),
('394', '32', '重庆', '0', '0', 'C', '1', '1', null),
('395', '33', '香港', '0', '0', 'X', '1', '1', null),
('396', '34', '澳门', '0', '0', 'A', '1', '1', null),
('397', '35', '台湾', '0', '0', 'T', '1', '1', null),
('398', '36', '迎江区', '0', '0', null, '2', '1', null),
('399', '36', '大观区', '0', '0', null, '2', '1', null),
('400', '36', '宜秀区', '0', '0', null, '2', '1', null),
('401', '36', '桐城市', '0', '0', null, '2', '1', null),
('402', '36', '怀宁县', '0', '0', null, '2', '1', null),
('403', '36', '枞阳县', '0', '0', null, '2', '1', null),
('404', '36', '潜山县', '0', '0', null, '2', '1', null),
('405', '36', '太湖县', '0', '0', null, '2', '1', null),
('406', '36', '宿松县', '0', '0', null, '2', '1', null),
('407', '36', '望江县', '0', '0', null, '2', '1', null),
('408', '36', '岳西县', '0', '0', null, '2', '1', null),
('409', '37', '中市区', '0', '0', null, '2', '1', null),
('410', '37', '东市区', '0', '0', null, '2', '1', null),
('411', '37', '西市区', '0', '0', null, '2', '1', null),
('412', '37', '郊区', '0', '0', null, '2', '1', null),
('413', '37', '怀远县', '0', '0', null, '2', '1', null),
('414', '37', '五河县', '0', '0', null, '2', '1', null),
('415', '37', '固镇县', '0', '0', null, '2', '1', null),
('416', '38', '巢湖市', '1', '0', 'C', '2', '1', null),
('417', '38', '包河区', '1', '0', 'B', '2', '1', null),
('418', '38', '庐阳区', '1', '0', 'L', '2', '1', null),
('419', '38', '瑶海区', '1', '0', 'Y', '2', '1', null),
('420', '38', '蜀山区', '1', '0', 'S', '2', '1', null),
('421', '39', '贵池区', '0', '0', null, '2', '1', null),
('422', '39', '东至县', '0', '0', null, '2', '1', null),
('423', '39', '石台县', '0', '0', null, '2', '1', null),
('424', '39', '青阳县', '0', '0', null, '2', '1', null),
('425', '40', '琅琊区', '0', '0', null, '2', '1', null),
('426', '40', '南谯区', '0', '0', null, '2', '1', null),
('427', '40', '天长市', '0', '0', null, '2', '1', null),
('428', '40', '明光市', '0', '0', null, '2', '1', null),
('429', '40', '来安县', '0', '0', null, '2', '1', null),
('430', '40', '全椒县', '0', '0', null, '2', '1', null),
('431', '40', '定远县', '0', '0', null, '2', '1', null),
('432', '40', '凤阳县', '0', '0', null, '2', '1', null),
('433', '41', '蚌山区', '0', '0', null, '2', '1', null),
('434', '41', '龙子湖区', '0', '0', null, '2', '1', null),
('435', '41', '禹会区', '0', '0', null, '2', '1', null),
('436', '41', '淮上区', '0', '0', null, '2', '1', null),
('437', '41', '颍州区', '0', '0', null, '2', '1', null),
('438', '41', '颍东区', '0', '0', null, '2', '1', null),
('439', '41', '颍泉区', '0', '0', null, '2', '1', null),
('440', '41', '界首市', '0', '0', null, '2', '1', null),
('441', '41', '临泉县', '0', '0', null, '2', '1', null),
('442', '41', '太和县', '0', '0', null, '2', '1', null),
('443', '41', '阜南县', '0', '0', null, '2', '1', null),
('444', '41', '颖上县', '0', '0', null, '2', '1', null),
('445', '42', '相山区', '0', '0', null, '2', '1', null),
('446', '42', '杜集区', '0', '0', null, '2', '1', null),
('447', '42', '烈山区', '0', '0', null, '2', '1', null),
('448', '42', '濉溪县', '0', '0', null, '2', '1', null);
INSERT INTO `wst_areas` VALUES ('449', '43', '田家庵区', '0', '0', null, '2', '1', null),
('450', '43', '大通区', '0', '0', null, '2', '1', null),
('451', '43', '谢家集区', '0', '0', null, '2', '1', null),
('452', '43', '八公山区', '0', '0', null, '2', '1', null),
('453', '43', '潘集区', '0', '0', null, '2', '1', null),
('454', '43', '凤台县', '0', '0', null, '2', '1', null),
('455', '44', '屯溪区', '0', '0', null, '2', '1', null),
('456', '44', '黄山区', '0', '0', null, '2', '1', null),
('457', '44', '徽州区', '0', '0', null, '2', '1', null),
('458', '44', '歙县', '0', '0', null, '2', '1', null),
('459', '44', '休宁县', '0', '0', null, '2', '1', null),
('460', '44', '黟县', '0', '0', null, '2', '1', null),
('461', '44', '祁门县', '0', '0', null, '2', '1', null),
('462', '45', '金安区', '0', '0', null, '2', '1', null),
('463', '45', '裕安区', '0', '0', null, '2', '1', null),
('464', '45', '寿县', '0', '0', null, '2', '1', null),
('465', '45', '霍邱县', '0', '0', null, '2', '1', null),
('466', '45', '舒城县', '0', '0', null, '2', '1', null),
('467', '45', '金寨县', '0', '0', null, '2', '1', null),
('468', '45', '霍山县', '0', '0', null, '2', '1', null),
('469', '46', '雨山区', '0', '0', null, '2', '1', null),
('470', '46', '花山区', '0', '0', null, '2', '1', null),
('471', '46', '金家庄区', '0', '0', null, '2', '1', null),
('472', '46', '当涂县', '0', '0', null, '2', '1', null),
('473', '47', '埇桥区', '0', '0', null, '2', '1', null),
('474', '47', '砀山县', '0', '0', null, '2', '1', null),
('475', '47', '萧县', '0', '0', null, '2', '1', null),
('476', '47', '灵璧县', '0', '0', null, '2', '1', null),
('477', '47', '泗县', '0', '0', null, '2', '1', null),
('478', '48', '铜官山区', '0', '0', null, '2', '1', null),
('479', '48', '狮子山区', '0', '0', null, '2', '1', null),
('480', '48', '郊区', '0', '0', null, '2', '1', null),
('481', '48', '铜陵县', '0', '0', null, '2', '1', null),
('482', '49', '镜湖区', '0', '0', null, '2', '1', null),
('483', '49', '弋江区', '0', '0', null, '2', '1', null),
('484', '49', '鸠江区', '0', '0', null, '2', '1', null),
('485', '49', '三山区', '0', '0', null, '2', '1', null),
('486', '49', '芜湖县', '0', '0', null, '2', '1', null),
('487', '49', '繁昌县', '0', '0', null, '2', '1', null),
('488', '49', '南陵县', '0', '0', null, '2', '1', null),
('489', '50', '宣州区', '0', '0', null, '2', '1', null),
('490', '50', '宁国市', '0', '0', null, '2', '1', null),
('491', '50', '郎溪县', '0', '0', null, '2', '1', null),
('492', '50', '广德县', '0', '0', null, '2', '1', null),
('493', '50', '泾县', '0', '0', null, '2', '1', null),
('494', '50', '绩溪县', '0', '0', null, '2', '1', null),
('495', '50', '旌德县', '0', '0', null, '2', '1', null),
('496', '51', '涡阳县', '0', '0', null, '2', '1', null),
('497', '51', '蒙城县', '0', '0', null, '2', '1', null),
('498', '51', '利辛县', '0', '0', null, '2', '1', null),
('499', '51', '谯城区', '0', '0', null, '2', '1', null),
('500', '52', '东城区', '1', '0', null, '2', '1', null),
('501', '52', '西城区', '1', '0', null, '2', '1', null),
('502', '52', '海淀区', '1', '0', null, '2', '1', null),
('503', '52', '朝阳区', '1', '0', null, '2', '1', null),
('504', '52', '崇文区', '1', '0', null, '2', '1', null),
('505', '52', '宣武区', '1', '0', null, '2', '1', null),
('506', '52', '丰台区', '1', '0', null, '2', '1', null),
('507', '52', '石景山区', '1', '0', null, '2', '1', null),
('508', '52', '房山区', '1', '0', null, '2', '1', null),
('509', '52', '门头沟区', '1', '0', null, '2', '1', null),
('510', '52', '通州区', '1', '0', null, '2', '1', null),
('511', '52', '顺义区', '1', '0', null, '2', '1', null),
('512', '52', '昌平区', '1', '0', null, '2', '1', null),
('513', '52', '怀柔区', '1', '0', null, '2', '1', null),
('514', '52', '平谷区', '1', '0', null, '2', '1', null),
('515', '52', '大兴区', '1', '0', null, '2', '1', null),
('516', '52', '密云县', '1', '0', null, '2', '1', null),
('517', '52', '延庆县', '1', '0', null, '2', '1', null),
('518', '53', '鼓楼区', '1', '0', null, '2', '1', null),
('519', '53', '台江区', '1', '0', null, '2', '1', null),
('520', '53', '仓山区', '1', '0', null, '2', '1', null),
('521', '53', '马尾区', '1', '0', null, '2', '1', null),
('522', '53', '晋安区', '1', '0', null, '2', '1', null),
('523', '53', '福清市', '1', '0', null, '2', '1', null),
('524', '53', '长乐市', '1', '0', null, '2', '1', null),
('525', '53', '闽侯县', '1', '0', null, '2', '1', null),
('526', '53', '连江县', '1', '0', null, '2', '1', null),
('527', '53', '罗源县', '1', '0', null, '2', '1', null),
('528', '53', '闽清县', '1', '0', null, '2', '1', null),
('529', '53', '永泰县', '1', '0', null, '2', '1', null),
('530', '53', '平潭县', '1', '0', null, '2', '1', null),
('531', '54', '新罗区', '1', '0', null, '2', '1', null),
('532', '54', '漳平市', '1', '0', null, '2', '1', null),
('533', '54', '长汀县', '1', '0', null, '2', '1', null),
('534', '54', '永定县', '1', '0', null, '2', '1', null),
('535', '54', '上杭县', '1', '0', null, '2', '1', null),
('536', '54', '武平县', '1', '0', null, '2', '1', null),
('537', '54', '连城县', '1', '0', null, '2', '1', null),
('538', '55', '延平区', '0', '0', null, '2', '1', null),
('539', '55', '邵武市', '0', '0', null, '2', '1', null),
('540', '55', '武夷山市', '0', '0', null, '2', '1', null),
('541', '55', '建瓯市', '0', '0', null, '2', '1', null),
('542', '55', '建阳市', '0', '0', null, '2', '1', null),
('543', '55', '顺昌县', '0', '0', null, '2', '1', null),
('544', '55', '浦城县', '0', '0', null, '2', '1', null),
('545', '55', '光泽县', '0', '0', null, '2', '1', null),
('546', '55', '松溪县', '0', '0', null, '2', '1', null),
('547', '55', '政和县', '0', '0', null, '2', '1', null),
('548', '56', '蕉城区', '0', '0', null, '2', '1', null),
('549', '56', '福安市', '0', '0', null, '2', '1', null),
('550', '56', '福鼎市', '0', '0', null, '2', '1', null),
('551', '56', '霞浦县', '0', '0', null, '2', '1', null),
('552', '56', '古田县', '0', '0', null, '2', '1', null),
('553', '56', '屏南县', '0', '0', null, '2', '1', null),
('554', '56', '寿宁县', '0', '0', null, '2', '1', null),
('555', '56', '周宁县', '0', '0', null, '2', '1', null),
('556', '56', '柘荣县', '0', '0', null, '2', '1', null),
('557', '57', '城厢区', '0', '0', null, '2', '1', null),
('558', '57', '涵江区', '0', '0', null, '2', '1', null),
('559', '57', '荔城区', '0', '0', null, '2', '1', null),
('560', '57', '秀屿区', '0', '0', null, '2', '1', null),
('561', '57', '仙游县', '0', '0', null, '2', '1', null),
('562', '58', '鲤城区', '0', '0', null, '2', '1', null),
('563', '58', '丰泽区', '0', '0', null, '2', '1', null),
('564', '58', '洛江区', '0', '0', null, '2', '1', null),
('565', '58', '清濛开发区', '0', '0', null, '2', '1', null),
('566', '58', '泉港区', '0', '0', null, '2', '1', null),
('567', '58', '石狮市', '0', '0', null, '2', '1', null),
('568', '58', '晋江市', '0', '0', null, '2', '1', null),
('569', '58', '南安市', '0', '0', null, '2', '1', null),
('570', '58', '惠安县', '0', '0', null, '2', '1', null),
('571', '58', '安溪县', '0', '0', null, '2', '1', null),
('572', '58', '永春县', '0', '0', null, '2', '1', null),
('573', '58', '德化县', '0', '0', null, '2', '1', null),
('574', '58', '金门县', '0', '0', null, '2', '1', null),
('575', '59', '梅列区', '0', '0', null, '2', '1', null),
('576', '59', '三元区', '0', '0', null, '2', '1', null),
('577', '59', '永安市', '0', '0', null, '2', '1', null),
('578', '59', '明溪县', '0', '0', null, '2', '1', null),
('579', '59', '清流县', '0', '0', null, '2', '1', null),
('580', '59', '宁化县', '0', '0', null, '2', '1', null),
('581', '59', '大田县', '0', '0', null, '2', '1', null),
('582', '59', '尤溪县', '0', '0', null, '2', '1', null),
('583', '59', '沙县', '0', '0', null, '2', '1', null),
('584', '59', '将乐县', '0', '0', null, '2', '1', null),
('585', '59', '泰宁县', '0', '0', null, '2', '1', null),
('586', '59', '建宁县', '0', '0', null, '2', '1', null),
('587', '60', '思明区', '1', '0', null, '2', '1', null),
('588', '60', '海沧区', '1', '0', null, '2', '1', null),
('589', '60', '湖里区', '1', '0', null, '2', '1', null),
('590', '60', '集美区', '1', '0', null, '2', '1', null),
('591', '60', '同安区', '1', '0', null, '2', '1', null),
('592', '60', '翔安区', '1', '0', null, '2', '1', null),
('593', '61', '芗城区', '0', '0', null, '2', '1', null),
('594', '61', '龙文区', '0', '0', null, '2', '1', null),
('595', '61', '龙海市', '0', '0', null, '2', '1', null),
('596', '61', '云霄县', '0', '0', null, '2', '1', null),
('597', '61', '漳浦县', '0', '0', null, '2', '1', null),
('598', '61', '诏安县', '0', '0', null, '2', '1', null),
('599', '61', '长泰县', '0', '0', null, '2', '1', null),
('600', '61', '东山县', '0', '0', null, '2', '1', null),
('601', '61', '南靖县', '0', '0', null, '2', '1', null),
('602', '61', '平和县', '0', '0', null, '2', '1', null),
('603', '61', '华安县', '0', '0', null, '2', '1', null),
('604', '62', '皋兰县', '0', '0', null, '2', '1', null),
('605', '62', '城关区', '0', '0', null, '2', '1', null),
('606', '62', '七里河区', '0', '0', null, '2', '1', null),
('607', '62', '西固区', '0', '0', null, '2', '1', null);
INSERT INTO `wst_areas` VALUES ('608', '62', '安宁区', '0', '0', null, '2', '1', null),
('609', '62', '红古区', '0', '0', null, '2', '1', null),
('610', '62', '永登县', '0', '0', null, '2', '1', null),
('611', '62', '榆中县', '0', '0', null, '2', '1', null),
('612', '63', '白银区', '0', '0', null, '2', '1', null),
('613', '63', '平川区', '0', '0', null, '2', '1', null),
('614', '63', '会宁县', '0', '0', null, '2', '1', null),
('615', '63', '景泰县', '0', '0', null, '2', '1', null),
('616', '63', '靖远县', '0', '0', null, '2', '1', null),
('617', '64', '临洮县', '0', '0', null, '2', '1', null),
('618', '64', '陇西县', '0', '0', null, '2', '1', null),
('619', '64', '通渭县', '0', '0', null, '2', '1', null),
('620', '64', '渭源县', '0', '0', null, '2', '1', null),
('621', '64', '漳县', '0', '0', null, '2', '1', null),
('622', '64', '岷县', '0', '0', null, '2', '1', null),
('623', '64', '安定区', '0', '0', null, '2', '1', null),
('624', '64', '安定区', '0', '0', null, '2', '1', null),
('625', '65', '合作市', '0', '0', null, '2', '1', null),
('626', '65', '临潭县', '0', '0', null, '2', '1', null),
('627', '65', '卓尼县', '0', '0', null, '2', '1', null),
('628', '65', '舟曲县', '0', '0', null, '2', '1', null),
('629', '65', '迭部县', '0', '0', null, '2', '1', null),
('630', '65', '玛曲县', '0', '0', null, '2', '1', null),
('631', '65', '碌曲县', '0', '0', null, '2', '1', null),
('632', '65', '夏河县', '0', '0', null, '2', '1', null),
('633', '66', '嘉峪关市', '0', '0', null, '2', '1', null),
('634', '67', '金川区', '0', '0', null, '2', '1', null),
('635', '67', '永昌县', '0', '0', null, '2', '1', null),
('636', '68', '肃州区', '0', '0', null, '2', '1', null),
('637', '68', '玉门市', '0', '0', null, '2', '1', null),
('638', '68', '敦煌市', '0', '0', null, '2', '1', null),
('639', '68', '金塔县', '0', '0', null, '2', '1', null),
('640', '68', '瓜州县', '0', '0', null, '2', '1', null),
('641', '68', '肃北', '0', '0', null, '2', '1', null),
('642', '68', '阿克塞', '0', '0', null, '2', '1', null),
('643', '69', '临夏市', '0', '0', null, '2', '1', null),
('644', '69', '临夏县', '0', '0', null, '2', '1', null),
('645', '69', '康乐县', '0', '0', null, '2', '1', null),
('646', '69', '永靖县', '0', '0', null, '2', '1', null),
('647', '69', '广河县', '0', '0', null, '2', '1', null),
('648', '69', '和政县', '0', '0', null, '2', '1', null),
('649', '69', '东乡族自治县', '0', '0', null, '2', '1', null),
('650', '69', '积石山', '0', '0', null, '2', '1', null),
('651', '70', '成县', '0', '0', null, '2', '1', null),
('652', '70', '徽县', '0', '0', null, '2', '1', null),
('653', '70', '康县', '0', '0', null, '2', '1', null),
('654', '70', '礼县', '0', '0', null, '2', '1', null),
('655', '70', '两当县', '0', '0', null, '2', '1', null),
('656', '70', '文县', '0', '0', null, '2', '1', null),
('657', '70', '西和县', '0', '0', null, '2', '1', null),
('658', '70', '宕昌县', '0', '0', null, '2', '1', null),
('659', '70', '武都区', '0', '0', null, '2', '1', null),
('660', '71', '崇信县', '0', '0', null, '2', '1', null),
('661', '71', '华亭县', '0', '0', null, '2', '1', null),
('662', '71', '静宁县', '0', '0', null, '2', '1', null),
('663', '71', '灵台县', '0', '0', null, '2', '1', null),
('664', '71', '崆峒区', '0', '0', null, '2', '1', null),
('665', '71', '庄浪县', '0', '0', null, '2', '1', null),
('666', '71', '泾川县', '0', '0', null, '2', '1', null),
('667', '72', '合水县', '0', '0', null, '2', '1', null),
('668', '72', '华池县', '0', '0', null, '2', '1', null),
('669', '72', '环县', '0', '0', null, '2', '1', null),
('670', '72', '宁县', '0', '0', null, '2', '1', null),
('671', '72', '庆城县', '0', '0', null, '2', '1', null),
('672', '72', '西峰区', '0', '0', null, '2', '1', null),
('673', '72', '镇原县', '0', '0', null, '2', '1', null),
('674', '72', '正宁县', '0', '0', null, '2', '1', null),
('675', '73', '甘谷县', '0', '0', null, '2', '1', null),
('676', '73', '秦安县', '0', '0', null, '2', '1', null),
('677', '73', '清水县', '0', '0', null, '2', '1', null),
('678', '73', '秦州区', '0', '0', null, '2', '1', null),
('679', '73', '麦积区', '0', '0', null, '2', '1', null),
('680', '73', '武山县', '0', '0', null, '2', '1', null),
('681', '73', '张家川', '0', '0', null, '2', '1', null),
('682', '74', '古浪县', '0', '0', null, '2', '1', null),
('683', '74', '民勤县', '0', '0', null, '2', '1', null),
('684', '74', '天祝', '0', '0', null, '2', '1', null),
('685', '74', '凉州区', '0', '0', null, '2', '1', null),
('686', '75', '高台县', '0', '0', null, '2', '1', null),
('687', '75', '临泽县', '0', '0', null, '2', '1', null),
('688', '75', '民乐县', '0', '0', null, '2', '1', null),
('689', '75', '山丹县', '0', '0', null, '2', '1', null),
('690', '75', '肃南', '0', '0', null, '2', '1', null),
('691', '75', '甘州区', '0', '0', null, '2', '1', null),
('692', '76', '从化区', '1', '0', null, '2', '1', null),
('693', '76', '天河区', '1', '0', null, '2', '1', null),
('695', '76', '白云区', '1', '0', null, '2', '1', null),
('696', '76', '海珠区', '1', '0', null, '2', '1', null),
('697', '76', '荔湾区', '1', '0', null, '2', '1', null),
('698', '76', '越秀区', '1', '0', null, '2', '1', null),
('699', '76', '黄埔区', '1', '0', null, '2', '1', null),
('700', '76', '番禺区', '1', '0', null, '2', '1', null),
('701', '76', '花都区', '1', '0', null, '2', '1', null),
('702', '76', '增城区', '1', '0', null, '2', '1', null),
('703', '76', '南沙区', '1', '0', null, '2', '1', null),
('705', '77', '福田区', '1', '0', null, '2', '1', null),
('706', '77', '罗湖区', '1', '0', null, '2', '1', null),
('707', '77', '南山区', '1', '0', null, '2', '1', null),
('708', '77', '宝安区', '1', '0', null, '2', '1', null),
('709', '77', '龙岗区', '1', '0', null, '2', '1', null),
('710', '77', '盐田区', '1', '0', null, '2', '1', null),
('711', '78', '湘桥区', '0', '0', null, '2', '1', null),
('712', '78', '潮安县', '0', '0', null, '2', '1', null),
('713', '78', '饶平县', '0', '0', null, '2', '1', null),
('714', '79', '南城区', '1', '0', null, '2', '1', null),
('715', '79', '东城区', '1', '0', null, '2', '1', null),
('716', '79', '万江区', '1', '0', null, '2', '1', null),
('717', '79', '莞城区', '1', '0', null, '2', '1', null),
('718', '79', '石龙镇', '1', '0', null, '2', '1', null),
('719', '79', '虎门镇', '1', '0', null, '2', '1', null),
('720', '79', '麻涌镇', '1', '0', null, '2', '1', null),
('721', '79', '道滘镇', '1', '0', null, '2', '1', null),
('722', '79', '石碣镇', '1', '0', null, '2', '1', null),
('723', '79', '沙田镇', '1', '0', null, '2', '1', null),
('724', '79', '望牛墩镇', '1', '0', null, '2', '1', null),
('725', '79', '洪梅镇', '1', '0', null, '2', '1', null),
('726', '79', '茶山镇', '1', '0', null, '2', '1', null),
('727', '79', '寮步镇', '1', '0', null, '2', '1', null),
('728', '79', '大岭山镇', '1', '0', null, '2', '1', null),
('729', '79', '大朗镇', '1', '0', null, '2', '1', null),
('730', '79', '黄江镇', '1', '0', null, '2', '1', null),
('731', '79', '樟木头', '1', '0', null, '2', '1', null),
('732', '79', '凤岗镇', '1', '0', null, '2', '1', null),
('733', '79', '塘厦镇', '1', '0', null, '2', '1', null),
('734', '79', '谢岗镇', '1', '0', null, '2', '1', null),
('735', '79', '厚街镇', '1', '0', null, '2', '1', null),
('736', '79', '清溪镇', '1', '0', null, '2', '1', null),
('737', '79', '常平镇', '1', '0', null, '2', '1', null),
('738', '79', '桥头镇', '1', '0', null, '2', '1', null),
('739', '79', '横沥镇', '1', '0', null, '2', '1', null),
('740', '79', '东坑镇', '1', '0', null, '2', '1', null),
('741', '79', '企石镇', '1', '0', null, '2', '1', null),
('742', '79', '石排镇', '1', '0', null, '2', '1', null),
('743', '79', '长安镇', '1', '0', null, '2', '1', null),
('744', '79', '中堂镇', '1', '0', null, '2', '1', null),
('745', '79', '高埗镇', '1', '0', null, '2', '1', null),
('746', '80', '禅城区', '1', '0', null, '2', '1', null),
('747', '80', '南海区', '1', '0', null, '2', '1', null),
('748', '80', '顺德区', '1', '0', null, '2', '1', null),
('749', '80', '三水区', '1', '0', null, '2', '1', null),
('750', '80', '高明区', '1', '0', null, '2', '1', null),
('751', '81', '东源县', '0', '0', null, '2', '1', null),
('752', '81', '和平县', '0', '0', null, '2', '1', null),
('753', '81', '源城区', '0', '0', null, '2', '1', null),
('754', '81', '连平县', '0', '0', null, '2', '1', null),
('755', '81', '龙川县', '0', '0', null, '2', '1', null),
('756', '81', '紫金县', '0', '0', null, '2', '1', null),
('757', '82', '惠阳区', '1', '0', null, '2', '1', null),
('758', '82', '惠城区', '1', '0', null, '2', '1', null),
('759', '82', '大亚湾', '1', '0', null, '2', '1', null),
('760', '82', '博罗县', '1', '0', null, '2', '1', null),
('761', '82', '惠东县', '1', '0', null, '2', '1', null),
('762', '82', '龙门县', '1', '0', null, '2', '1', null),
('763', '83', '江海区', '0', '0', null, '2', '1', null),
('764', '83', '蓬江区', '0', '0', null, '2', '1', null),
('765', '83', '新会区', '0', '0', null, '2', '1', null),
('766', '83', '台山市', '0', '0', null, '2', '1', null),
('767', '83', '开平市', '0', '0', null, '2', '1', null),
('768', '83', '鹤山市', '0', '0', null, '2', '1', null),
('769', '83', '恩平市', '0', '0', null, '2', '1', null),
('770', '84', '榕城区', '0', '0', null, '2', '1', null),
('771', '84', '普宁市', '0', '0', null, '2', '1', null),
('772', '84', '揭东县', '0', '0', null, '2', '1', null),
('773', '84', '揭西县', '0', '0', null, '2', '1', null),
('774', '84', '惠来县', '0', '0', null, '2', '1', null),
('775', '85', '茂南区', '0', '0', null, '2', '1', null),
('776', '85', '茂港区', '0', '0', null, '2', '1', null),
('777', '85', '高州市', '0', '0', null, '2', '1', null),
('778', '85', '化州市', '0', '0', null, '2', '1', null),
('779', '85', '信宜市', '0', '0', null, '2', '1', null),
('780', '85', '电白县', '0', '0', null, '2', '1', null),
('781', '86', '梅县', '0', '0', null, '2', '1', null),
('782', '86', '梅江区', '0', '0', null, '2', '1', null),
('783', '86', '兴宁市', '0', '0', null, '2', '1', null),
('784', '86', '大埔县', '0', '0', null, '2', '1', null),
('785', '86', '丰顺县', '0', '0', null, '2', '1', null),
('786', '86', '五华县', '0', '0', null, '2', '1', null),
('787', '86', '平远县', '0', '0', null, '2', '1', null),
('788', '86', '蕉岭县', '0', '0', null, '2', '1', null),
('789', '87', '清城区', '0', '0', null, '2', '1', null),
('790', '87', '英德市', '0', '0', null, '2', '1', null),
('791', '87', '连州市', '0', '0', null, '2', '1', null),
('792', '87', '佛冈县', '0', '0', null, '2', '1', null),
('793', '87', '阳山县', '0', '0', null, '2', '1', null),
('794', '87', '清新县', '0', '0', null, '2', '1', null),
('795', '87', '连山', '0', '0', null, '2', '1', null),
('796', '87', '连南', '0', '0', null, '2', '1', null),
('797', '88', '南澳县', '0', '0', null, '2', '1', null),
('798', '88', '潮阳区', '0', '0', null, '2', '1', null),
('799', '88', '澄海区', '0', '0', null, '2', '1', null),
('800', '88', '龙湖区', '0', '0', null, '2', '1', null),
('801', '88', '金平区', '0', '0', null, '2', '1', null),
('802', '88', '濠江区', '0', '0', null, '2', '1', null),
('803', '88', '潮南区', '0', '0', null, '2', '1', null),
('804', '89', '城区', '0', '0', null, '2', '1', null),
('805', '89', '陆丰市', '0', '0', null, '2', '1', null),
('806', '89', '海丰县', '0', '0', null, '2', '1', null),
('807', '89', '陆河县', '0', '0', null, '2', '1', null),
('808', '90', '曲江县', '0', '0', null, '2', '1', null),
('809', '90', '浈江区', '0', '0', null, '2', '1', null),
('810', '90', '武江区', '0', '0', null, '2', '1', null),
('811', '90', '曲江区', '0', '0', null, '2', '1', null),
('812', '90', '乐昌市', '0', '0', null, '2', '1', null),
('813', '90', '南雄市', '0', '0', null, '2', '1', null),
('814', '90', '始兴县', '0', '0', null, '2', '1', null),
('815', '90', '仁化县', '0', '0', null, '2', '1', null),
('816', '90', '翁源县', '0', '0', null, '2', '1', null),
('817', '90', '新丰县', '0', '0', null, '2', '1', null),
('818', '90', '乳源', '0', '0', null, '2', '1', null),
('819', '91', '江城区', '0', '0', null, '2', '1', null),
('820', '91', '阳春市', '0', '0', null, '2', '1', null),
('821', '91', '阳西县', '0', '0', null, '2', '1', null),
('822', '91', '阳东县', '0', '0', null, '2', '1', null),
('823', '92', '云城区', '0', '0', null, '2', '1', null),
('824', '92', '罗定市', '0', '0', null, '2', '1', null),
('825', '92', '新兴县', '0', '0', null, '2', '1', null),
('826', '92', '郁南县', '0', '0', null, '2', '1', null),
('827', '92', '云安县', '0', '0', null, '2', '1', null),
('828', '93', '赤坎区', '0', '0', null, '2', '1', null),
('829', '93', '霞山区', '0', '0', null, '2', '1', null),
('830', '93', '坡头区', '0', '0', null, '2', '1', null),
('831', '93', '麻章区', '0', '0', null, '2', '1', null),
('832', '93', '廉江市', '0', '0', null, '2', '1', null),
('833', '93', '雷州市', '0', '0', null, '2', '1', null),
('834', '93', '吴川市', '0', '0', null, '2', '1', null),
('835', '93', '遂溪县', '0', '0', null, '2', '1', null),
('836', '93', '徐闻县', '0', '0', null, '2', '1', null),
('837', '94', '肇庆市', '0', '0', null, '2', '1', null),
('838', '94', '高要市', '0', '0', null, '2', '1', null),
('839', '94', '四会市', '0', '0', null, '2', '1', null),
('840', '94', '广宁县', '0', '0', null, '2', '1', null),
('841', '94', '怀集县', '0', '0', null, '2', '1', null),
('842', '94', '封开县', '0', '0', null, '2', '1', null),
('843', '94', '德庆县', '0', '0', null, '2', '1', null),
('844', '95', '石岐街道', '0', '0', null, '2', '1', null),
('845', '95', '东区街道', '0', '0', null, '2', '1', null),
('846', '95', '西区街道', '0', '0', null, '2', '1', null),
('847', '95', '环城街道', '0', '0', null, '2', '1', null),
('848', '95', '中山港街道', '0', '0', null, '2', '1', null),
('849', '95', '五桂山街道', '0', '0', null, '2', '1', null),
('850', '96', '香洲区', '1', '0', null, '2', '1', null),
('851', '96', '斗门区', '1', '0', null, '2', '1', null),
('852', '96', '金湾区', '1', '0', null, '2', '1', null),
('853', '97', '邕宁区', '1', '0', null, '2', '1', null),
('854', '97', '青秀区', '1', '0', null, '2', '1', null),
('855', '97', '兴宁区', '1', '0', null, '2', '1', null),
('856', '97', '良庆区', '1', '0', null, '2', '1', null),
('857', '97', '西乡塘区', '1', '0', null, '2', '1', null),
('858', '97', '江南区', '1', '0', null, '2', '1', null),
('859', '97', '武鸣县', '1', '0', null, '2', '1', null),
('860', '97', '隆安县', '1', '0', null, '2', '1', null),
('861', '97', '马山县', '1', '0', null, '2', '1', null),
('862', '97', '上林县', '1', '0', null, '2', '1', null),
('863', '97', '宾阳县', '1', '0', null, '2', '1', null),
('864', '97', '横县', '1', '0', null, '2', '1', null),
('865', '98', '秀峰区', '1', '0', null, '2', '1', null),
('866', '98', '叠彩区', '1', '0', null, '2', '1', null),
('867', '98', '象山区', '1', '0', null, '2', '1', null),
('868', '98', '七星区', '1', '0', null, '2', '1', null),
('869', '98', '雁山区', '1', '0', null, '2', '1', null),
('870', '98', '阳朔县', '1', '0', null, '2', '1', null),
('871', '98', '临桂县', '1', '0', null, '2', '1', null),
('872', '98', '灵川县', '1', '0', null, '2', '1', null),
('873', '98', '全州县', '1', '0', null, '2', '1', null),
('874', '98', '平乐县', '1', '0', null, '2', '1', null),
('875', '98', '兴安县', '1', '0', null, '2', '1', null),
('876', '98', '灌阳县', '1', '0', null, '2', '1', null),
('877', '98', '荔浦县', '1', '0', null, '2', '1', null),
('878', '98', '资源县', '1', '0', null, '2', '1', null),
('879', '98', '永福县', '1', '0', null, '2', '1', null),
('880', '98', '龙胜', '1', '0', null, '2', '1', null),
('881', '98', '恭城', '1', '0', null, '2', '1', null),
('882', '99', '右江区', '0', '0', null, '2', '1', null),
('883', '99', '凌云县', '0', '0', null, '2', '1', null),
('884', '99', '平果县', '0', '0', null, '2', '1', null),
('885', '99', '西林县', '0', '0', null, '2', '1', null),
('886', '99', '乐业县', '0', '0', null, '2', '1', null),
('887', '99', '德保县', '0', '0', null, '2', '1', null),
('888', '99', '田林县', '0', '0', null, '2', '1', null),
('889', '99', '田阳县', '0', '0', null, '2', '1', null),
('890', '99', '靖西县', '0', '0', null, '2', '1', null),
('891', '99', '田东县', '0', '0', null, '2', '1', null),
('892', '99', '那坡县', '0', '0', null, '2', '1', null),
('893', '99', '隆林', '0', '0', null, '2', '1', null),
('894', '100', '海城区', '0', '0', null, '2', '1', null),
('895', '100', '银海区', '0', '0', null, '2', '1', null),
('896', '100', '铁山港区', '0', '0', null, '2', '1', null),
('897', '100', '合浦县', '0', '0', null, '2', '1', null),
('898', '101', '江州区', '0', '0', null, '2', '1', null),
('899', '101', '凭祥市', '0', '0', null, '2', '1', null),
('900', '101', '宁明县', '0', '0', null, '2', '1', null),
('901', '101', '扶绥县', '0', '0', null, '2', '1', null),
('902', '101', '龙州县', '0', '0', null, '2', '1', null),
('903', '101', '大新县', '0', '0', null, '2', '1', null),
('904', '101', '天等县', '0', '0', null, '2', '1', null),
('905', '102', '港口区', '0', '0', null, '2', '1', null),
('906', '102', '防城区', '0', '0', null, '2', '1', null),
('907', '102', '东兴市', '0', '0', null, '2', '1', null),
('908', '102', '上思县', '0', '0', null, '2', '1', null),
('909', '103', '港北区', '0', '0', null, '2', '1', null),
('910', '103', '港南区', '0', '0', null, '2', '1', null),
('911', '103', '覃塘区', '0', '0', null, '2', '1', null);
INSERT INTO `wst_areas` VALUES ('912', '103', '桂平市', '0', '0', null, '2', '1', null),
('913', '103', '平南县', '0', '0', null, '2', '1', null),
('914', '104', '金城江区', '0', '0', null, '2', '1', null),
('915', '104', '宜州市', '0', '0', null, '2', '1', null),
('916', '104', '天峨县', '0', '0', null, '2', '1', null),
('917', '104', '凤山县', '0', '0', null, '2', '1', null),
('918', '104', '南丹县', '0', '0', null, '2', '1', null),
('919', '104', '东兰县', '0', '0', null, '2', '1', null),
('920', '104', '都安', '0', '0', null, '2', '1', null),
('921', '104', '罗城', '0', '0', null, '2', '1', null),
('922', '104', '巴马', '0', '0', null, '2', '1', null),
('923', '104', '环江', '0', '0', null, '2', '1', null),
('924', '104', '大化', '0', '0', null, '2', '1', null),
('925', '105', '八步区', '0', '0', null, '2', '1', null),
('926', '105', '钟山县', '0', '0', null, '2', '1', null),
('927', '105', '昭平县', '0', '0', null, '2', '1', null),
('928', '105', '富川', '0', '0', null, '2', '1', null),
('929', '106', '兴宾区', '0', '0', null, '2', '1', null),
('930', '106', '合山市', '0', '0', null, '2', '1', null),
('931', '106', '象州县', '0', '0', null, '2', '1', null),
('932', '106', '武宣县', '0', '0', null, '2', '1', null),
('933', '106', '忻城县', '0', '0', null, '2', '1', null),
('934', '106', '金秀', '0', '0', null, '2', '1', null),
('935', '107', '城中区', '0', '0', null, '2', '1', null),
('936', '107', '鱼峰区', '0', '0', null, '2', '1', null),
('937', '107', '柳北区', '0', '0', null, '2', '1', null),
('938', '107', '柳南区', '0', '0', null, '2', '1', null),
('939', '107', '柳江县', '0', '0', null, '2', '1', null),
('940', '107', '柳城县', '0', '0', null, '2', '1', null),
('941', '107', '鹿寨县', '0', '0', null, '2', '1', null),
('942', '107', '融安县', '0', '0', null, '2', '1', null),
('943', '107', '融水', '0', '0', null, '2', '1', null),
('944', '107', '三江', '0', '0', null, '2', '1', null),
('945', '108', '钦南区', '0', '0', null, '2', '1', null),
('946', '108', '钦北区', '0', '0', null, '2', '1', null),
('947', '108', '灵山县', '0', '0', null, '2', '1', null),
('948', '108', '浦北县', '0', '0', null, '2', '1', null),
('949', '109', '万秀区', '0', '0', null, '2', '1', null),
('950', '109', '蝶山区', '0', '0', null, '2', '1', null),
('951', '109', '长洲区', '0', '0', null, '2', '1', null),
('952', '109', '岑溪市', '0', '0', null, '2', '1', null),
('953', '109', '苍梧县', '0', '0', null, '2', '1', null),
('954', '109', '藤县', '0', '0', null, '2', '1', null),
('955', '109', '蒙山县', '0', '0', null, '2', '1', null),
('956', '110', '玉州区', '0', '0', null, '2', '1', null),
('957', '110', '北流市', '0', '0', null, '2', '1', null),
('958', '110', '容县', '0', '0', null, '2', '1', null),
('959', '110', '陆川县', '0', '0', null, '2', '1', null),
('960', '110', '博白县', '0', '0', null, '2', '1', null),
('961', '110', '兴业县', '0', '0', null, '2', '1', null),
('962', '111', '南明区', '0', '0', null, '2', '1', null),
('963', '111', '云岩区', '0', '0', null, '2', '1', null),
('964', '111', '花溪区', '0', '0', null, '2', '1', null),
('965', '111', '乌当区', '0', '0', null, '2', '1', null),
('966', '111', '白云区', '0', '0', null, '2', '1', null),
('967', '111', '小河区', '0', '0', null, '2', '1', null),
('968', '111', '金阳新区', '0', '0', null, '2', '1', null),
('969', '111', '新天园区', '0', '0', null, '2', '1', null),
('970', '111', '清镇市', '0', '0', null, '2', '1', null),
('971', '111', '开阳县', '0', '0', null, '2', '1', null),
('972', '111', '修文县', '0', '0', null, '2', '1', null),
('973', '111', '息烽县', '0', '0', null, '2', '1', null),
('974', '112', '西秀区', '0', '0', null, '2', '1', null),
('975', '112', '关岭', '0', '0', null, '2', '1', null),
('976', '112', '镇宁', '0', '0', null, '2', '1', null),
('977', '112', '紫云', '0', '0', null, '2', '1', null),
('978', '112', '平坝县', '0', '0', null, '2', '1', null),
('979', '112', '普定县', '0', '0', null, '2', '1', null),
('980', '113', '毕节市', '0', '0', null, '2', '1', null),
('981', '113', '大方县', '0', '0', null, '2', '1', null),
('982', '113', '黔西县', '0', '0', null, '2', '1', null),
('983', '113', '金沙县', '0', '0', null, '2', '1', null),
('984', '113', '织金县', '0', '0', null, '2', '1', null),
('985', '113', '纳雍县', '0', '0', null, '2', '1', null),
('986', '113', '赫章县', '0', '0', null, '2', '1', null),
('987', '113', '威宁', '0', '0', null, '2', '1', null),
('988', '114', '钟山区', '0', '0', null, '2', '1', null),
('989', '114', '六枝特区', '0', '0', null, '2', '1', null),
('990', '114', '水城县', '0', '0', null, '2', '1', null),
('991', '114', '盘县', '0', '0', null, '2', '1', null),
('992', '115', '凯里市', '0', '0', null, '2', '1', null),
('993', '115', '黄平县', '0', '0', null, '2', '1', null),
('994', '115', '施秉县', '0', '0', null, '2', '1', null),
('995', '115', '三穗县', '0', '0', null, '2', '1', null),
('996', '115', '镇远县', '0', '0', null, '2', '1', null),
('997', '115', '岑巩县', '0', '0', null, '2', '1', null),
('998', '115', '天柱县', '0', '0', null, '2', '1', null),
('999', '115', '锦屏县', '0', '0', null, '2', '1', null),
('1000', '115', '剑河县', '0', '0', null, '2', '1', null),
('1001', '115', '台江县', '0', '0', null, '2', '1', null),
('1002', '115', '黎平县', '0', '0', null, '2', '1', null),
('1003', '115', '榕江县', '0', '0', null, '2', '1', null),
('1004', '115', '从江县', '0', '0', null, '2', '1', null),
('1005', '115', '雷山县', '0', '0', null, '2', '1', null),
('1006', '115', '麻江县', '0', '0', null, '2', '1', null),
('1007', '115', '丹寨县', '0', '0', null, '2', '1', null),
('1008', '116', '都匀市', '0', '0', null, '2', '1', null),
('1009', '116', '福泉市', '0', '0', null, '2', '1', null),
('1010', '116', '荔波县', '0', '0', null, '2', '1', null),
('1011', '116', '贵定县', '0', '0', null, '2', '1', null),
('1012', '116', '瓮安县', '0', '0', null, '2', '1', null),
('1013', '116', '独山县', '0', '0', null, '2', '1', null),
('1014', '116', '平塘县', '0', '0', null, '2', '1', null),
('1015', '116', '罗甸县', '0', '0', null, '2', '1', null),
('1016', '116', '长顺县', '0', '0', null, '2', '1', null),
('1017', '116', '龙里县', '0', '0', null, '2', '1', null),
('1018', '116', '惠水县', '0', '0', null, '2', '1', null),
('1019', '116', '三都', '0', '0', null, '2', '1', null),
('1020', '117', '兴义市', '0', '0', null, '2', '1', null),
('1021', '117', '兴仁县', '0', '0', null, '2', '1', null),
('1022', '117', '普安县', '0', '0', null, '2', '1', null),
('1023', '117', '晴隆县', '0', '0', null, '2', '1', null),
('1024', '117', '贞丰县', '0', '0', null, '2', '1', null),
('1025', '117', '望谟县', '0', '0', null, '2', '1', null),
('1026', '117', '册亨县', '0', '0', null, '2', '1', null),
('1027', '117', '安龙县', '0', '0', null, '2', '1', null),
('1028', '118', '铜仁市', '0', '0', null, '2', '1', null),
('1029', '118', '江口县', '0', '0', null, '2', '1', null),
('1030', '118', '石阡县', '0', '0', null, '2', '1', null),
('1031', '118', '思南县', '0', '0', null, '2', '1', null),
('1032', '118', '德江县', '0', '0', null, '2', '1', null),
('1033', '118', '玉屏', '0', '0', null, '2', '1', null),
('1034', '118', '印江', '0', '0', null, '2', '1', null),
('1035', '118', '沿河', '0', '0', null, '2', '1', null),
('1036', '118', '松桃', '0', '0', null, '2', '1', null),
('1037', '118', '万山特区', '0', '0', null, '2', '1', null),
('1038', '119', '红花岗区', '0', '0', null, '2', '1', null),
('1039', '119', '务川县', '0', '0', null, '2', '1', null),
('1040', '119', '道真县', '0', '0', null, '2', '1', null),
('1041', '119', '汇川区', '0', '0', null, '2', '1', null),
('1042', '119', '赤水市', '0', '0', null, '2', '1', null),
('1043', '119', '仁怀市', '0', '0', null, '2', '1', null),
('1044', '119', '遵义县', '0', '0', null, '2', '1', null),
('1045', '119', '桐梓县', '0', '0', null, '2', '1', null),
('1046', '119', '绥阳县', '0', '0', null, '2', '1', null),
('1047', '119', '正安县', '0', '0', null, '2', '1', null),
('1048', '119', '凤冈县', '0', '0', null, '2', '1', null),
('1049', '119', '湄潭县', '0', '0', null, '2', '1', null),
('1050', '119', '余庆县', '0', '0', null, '2', '1', null),
('1051', '119', '习水县', '0', '0', null, '2', '1', null),
('1052', '119', '道真', '0', '0', null, '2', '1', null),
('1053', '119', '务川', '0', '0', null, '2', '1', null),
('1054', '120', '秀英区', '0', '0', null, '2', '1', null),
('1055', '120', '龙华区', '0', '0', null, '2', '1', null),
('1056', '120', '琼山区', '0', '0', null, '2', '1', null),
('1057', '120', '美兰区', '0', '0', null, '2', '1', null),
('1058', '137', '市区', '0', '0', null, '2', '1', null),
('1059', '137', '洋浦开发区', '0', '0', null, '2', '1', null),
('1060', '137', '那大镇', '0', '0', null, '2', '1', null),
('1061', '137', '王五镇', '0', '0', null, '2', '1', null),
('1062', '137', '雅星镇', '0', '0', null, '2', '1', null),
('1063', '137', '大成镇', '0', '0', null, '2', '1', null),
('1064', '137', '中和镇', '0', '0', null, '2', '1', null),
('1065', '137', '峨蔓镇', '0', '0', null, '2', '1', null),
('1066', '137', '南丰镇', '0', '0', null, '2', '1', null),
('1067', '137', '白马井镇', '0', '0', null, '2', '1', null),
('1068', '137', '兰洋镇', '0', '0', null, '2', '1', null),
('1069', '137', '和庆镇', '0', '0', null, '2', '1', null),
('1070', '137', '海头镇', '0', '0', null, '2', '1', null),
('1071', '137', '排浦镇', '0', '0', null, '2', '1', null),
('1072', '137', '东成镇', '0', '0', null, '2', '1', null),
('1073', '137', '光村镇', '0', '0', null, '2', '1', null),
('1074', '137', '木棠镇', '0', '0', null, '2', '1', null),
('1075', '137', '新州镇', '0', '0', null, '2', '1', null),
('1076', '137', '三都镇', '0', '0', null, '2', '1', null),
('1077', '137', '其他', '0', '0', null, '2', '1', null),
('1078', '138', '长安区', '0', '0', null, '2', '1', null),
('1079', '138', '桥东区', '0', '0', null, '2', '1', null),
('1080', '138', '桥西区', '0', '0', null, '2', '1', null),
('1081', '138', '新华区', '0', '0', null, '2', '1', null),
('1082', '138', '裕华区', '0', '0', null, '2', '1', null),
('1083', '138', '井陉矿区', '0', '0', null, '2', '1', null),
('1084', '138', '高新区', '0', '0', null, '2', '1', null),
('1085', '138', '辛集市', '0', '0', null, '2', '1', null),
('1086', '138', '藁城市', '0', '0', null, '2', '1', null),
('1087', '138', '晋州市', '0', '0', null, '2', '1', null),
('1088', '138', '新乐市', '0', '0', null, '2', '1', null),
('1089', '138', '鹿泉市', '0', '0', null, '2', '1', null),
('1090', '138', '井陉县', '0', '0', null, '2', '1', null),
('1091', '138', '正定县', '0', '0', null, '2', '1', null),
('1092', '138', '栾城县', '0', '0', null, '2', '1', null),
('1093', '138', '行唐县', '0', '0', null, '2', '1', null),
('1094', '138', '灵寿县', '0', '0', null, '2', '1', null),
('1095', '138', '高邑县', '0', '0', null, '2', '1', null),
('1096', '138', '深泽县', '0', '0', null, '2', '1', null),
('1097', '138', '赞皇县', '0', '0', null, '2', '1', null),
('1098', '138', '无极县', '0', '0', null, '2', '1', null),
('1099', '138', '平山县', '0', '0', null, '2', '1', null),
('1100', '138', '元氏县', '0', '0', null, '2', '1', null),
('1101', '138', '赵县', '0', '0', null, '2', '1', null),
('1102', '139', '新市区', '0', '0', null, '2', '1', null),
('1103', '139', '南市区', '0', '0', null, '2', '1', null),
('1104', '139', '北市区', '0', '0', null, '2', '1', null),
('1105', '139', '涿州市', '0', '0', null, '2', '1', null),
('1106', '139', '定州市', '0', '0', null, '2', '1', null),
('1107', '139', '安国市', '0', '0', null, '2', '1', null),
('1108', '139', '高碑店市', '0', '0', null, '2', '1', null),
('1109', '139', '满城县', '0', '0', null, '2', '1', null),
('1110', '139', '清苑县', '0', '0', null, '2', '1', null),
('1111', '139', '涞水县', '0', '0', null, '2', '1', null),
('1112', '139', '阜平县', '0', '0', null, '2', '1', null),
('1113', '139', '徐水县', '0', '0', null, '2', '1', null),
('1114', '139', '定兴县', '0', '0', null, '2', '1', null),
('1115', '139', '唐县', '0', '0', null, '2', '1', null),
('1116', '139', '高阳县', '0', '0', null, '2', '1', null),
('1117', '139', '容城县', '0', '0', null, '2', '1', null),
('1118', '139', '涞源县', '0', '0', null, '2', '1', null),
('1119', '139', '望都县', '0', '0', null, '2', '1', null),
('1120', '139', '安新县', '0', '0', null, '2', '1', null),
('1121', '139', '易县', '0', '0', null, '2', '1', null),
('1122', '139', '曲阳县', '0', '0', null, '2', '1', null),
('1123', '139', '蠡县', '0', '0', null, '2', '1', null),
('1124', '139', '顺平县', '0', '0', null, '2', '1', null),
('1125', '139', '博野县', '0', '0', null, '2', '1', null),
('1126', '139', '雄县', '0', '0', null, '2', '1', null),
('1127', '140', '运河区', '0', '0', null, '2', '1', null),
('1128', '140', '新华区', '0', '0', null, '2', '1', null),
('1129', '140', '泊头市', '0', '0', null, '2', '1', null),
('1130', '140', '任丘市', '0', '0', null, '2', '1', null),
('1131', '140', '黄骅市', '0', '0', null, '2', '1', null),
('1132', '140', '河间市', '0', '0', null, '2', '1', null),
('1133', '140', '沧县', '0', '0', null, '2', '1', null),
('1134', '140', '青县', '0', '0', null, '2', '1', null),
('1135', '140', '东光县', '0', '0', null, '2', '1', null),
('1136', '140', '海兴县', '0', '0', null, '2', '1', null),
('1137', '140', '盐山县', '0', '0', null, '2', '1', null),
('1138', '140', '肃宁县', '0', '0', null, '2', '1', null),
('1139', '140', '南皮县', '0', '0', null, '2', '1', null),
('1140', '140', '吴桥县', '0', '0', null, '2', '1', null),
('1141', '140', '献县', '0', '0', null, '2', '1', null),
('1142', '140', '孟村', '0', '0', null, '2', '1', null),
('1143', '141', '双桥区', '0', '0', null, '2', '1', null),
('1144', '141', '双滦区', '0', '0', null, '2', '1', null),
('1145', '141', '鹰手营子矿区', '0', '0', null, '2', '1', null),
('1146', '141', '承德县', '0', '0', null, '2', '1', null),
('1147', '141', '兴隆县', '0', '0', null, '2', '1', null),
('1148', '141', '平泉县', '0', '0', null, '2', '1', null),
('1149', '141', '滦平县', '0', '0', null, '2', '1', null),
('1150', '141', '隆化县', '0', '0', null, '2', '1', null),
('1151', '141', '丰宁', '0', '0', null, '2', '1', null),
('1152', '141', '宽城', '0', '0', null, '2', '1', null),
('1153', '141', '围场', '0', '0', null, '2', '1', null),
('1154', '142', '从台区', '0', '0', null, '2', '1', null),
('1155', '142', '复兴区', '0', '0', null, '2', '1', null),
('1156', '142', '邯山区', '0', '0', null, '2', '1', null),
('1157', '142', '峰峰矿区', '0', '0', null, '2', '1', null),
('1158', '142', '武安市', '0', '0', null, '2', '1', null),
('1159', '142', '邯郸县', '0', '0', null, '2', '1', null),
('1160', '142', '临漳县', '0', '0', null, '2', '1', null),
('1161', '142', '成安县', '0', '0', null, '2', '1', null),
('1162', '142', '大名县', '0', '0', null, '2', '1', null),
('1163', '142', '涉县', '0', '0', null, '2', '1', null),
('1164', '142', '磁县', '0', '0', null, '2', '1', null),
('1165', '142', '肥乡县', '0', '0', null, '2', '1', null),
('1166', '142', '永年县', '0', '0', null, '2', '1', null),
('1167', '142', '邱县', '0', '0', null, '2', '1', null),
('1168', '142', '鸡泽县', '0', '0', null, '2', '1', null),
('1169', '142', '广平县', '0', '0', null, '2', '1', null),
('1170', '142', '馆陶县', '0', '0', null, '2', '1', null),
('1171', '142', '魏县', '0', '0', null, '2', '1', null),
('1172', '142', '曲周县', '0', '0', null, '2', '1', null),
('1173', '143', '桃城区', '0', '0', null, '2', '1', null),
('1174', '143', '冀州市', '0', '0', null, '2', '1', null),
('1175', '143', '深州市', '0', '0', null, '2', '1', null),
('1176', '143', '枣强县', '0', '0', null, '2', '1', null),
('1177', '143', '武邑县', '0', '0', null, '2', '1', null),
('1178', '143', '武强县', '0', '0', null, '2', '1', null),
('1179', '143', '饶阳县', '0', '0', null, '2', '1', null),
('1180', '143', '安平县', '0', '0', null, '2', '1', null),
('1181', '143', '故城县', '0', '0', null, '2', '1', null),
('1182', '143', '景县', '0', '0', null, '2', '1', null),
('1183', '143', '阜城县', '0', '0', null, '2', '1', null),
('1184', '144', '安次区', '0', '0', null, '2', '1', null),
('1185', '144', '广阳区', '0', '0', null, '2', '1', null),
('1186', '144', '霸州市', '0', '0', null, '2', '1', null),
('1187', '144', '三河市', '0', '0', null, '2', '1', null),
('1188', '144', '固安县', '0', '0', null, '2', '1', null),
('1189', '144', '永清县', '0', '0', null, '2', '1', null),
('1190', '144', '香河县', '0', '0', null, '2', '1', null),
('1191', '144', '大城县', '0', '0', null, '2', '1', null),
('1192', '144', '文安县', '0', '0', null, '2', '1', null),
('1193', '144', '大厂', '0', '0', null, '2', '1', null),
('1194', '145', '海港区', '0', '0', null, '2', '1', null),
('1195', '145', '山海关区', '0', '0', null, '2', '1', null),
('1196', '145', '北戴河区', '0', '0', null, '2', '1', null),
('1197', '145', '昌黎县', '0', '0', null, '2', '1', null),
('1198', '145', '抚宁县', '0', '0', null, '2', '1', null),
('1199', '145', '卢龙县', '0', '0', null, '2', '1', null),
('1200', '145', '青龙', '0', '0', null, '2', '1', null),
('1201', '146', '路北区', '0', '0', null, '2', '1', null),
('1202', '146', '路南区', '0', '0', null, '2', '1', null),
('1203', '146', '古冶区', '0', '0', null, '2', '1', null),
('1204', '146', '开平区', '0', '0', null, '2', '1', null),
('1205', '146', '丰南区', '0', '0', null, '2', '1', null),
('1206', '146', '丰润区', '0', '0', null, '2', '1', null),
('1207', '146', '遵化市', '0', '0', null, '2', '1', null),
('1208', '146', '迁安市', '0', '0', null, '2', '1', null),
('1209', '146', '滦县', '0', '0', null, '2', '1', null),
('1210', '146', '滦南县', '0', '0', null, '2', '1', null),
('1211', '146', '乐亭县', '0', '0', null, '2', '1', null),
('1212', '146', '迁西县', '0', '0', null, '2', '1', null),
('1213', '146', '玉田县', '0', '0', null, '2', '1', null),
('1214', '146', '唐海县', '0', '0', null, '2', '1', null),
('1215', '147', '桥东区', '0', '0', null, '2', '1', null),
('1216', '147', '桥西区', '0', '0', null, '2', '1', null),
('1217', '147', '南宫市', '0', '0', null, '2', '1', null),
('1473', '173', '同江市', '0', '0', null, '2', '1', null),
('1474', '173', '富锦市', '0', '0', null, '2', '1', null),
('1475', '173', '桦南县', '0', '0', null, '2', '1', null),
('1476', '173', '桦川县', '0', '0', null, '2', '1', null);
INSERT INTO `wst_areas` VALUES ('1477', '173', '汤原县', '0', '0', null, '2', '1', null),
('1478', '173', '抚远县', '0', '0', null, '2', '1', null),
('1479', '174', '爱民区', '0', '0', null, '2', '1', null),
('1480', '174', '东安区', '0', '0', null, '2', '1', null),
('1481', '174', '阳明区', '0', '0', null, '2', '1', null),
('1482', '174', '西安区', '0', '0', null, '2', '1', null),
('1483', '174', '绥芬河市', '0', '0', null, '2', '1', null),
('1484', '174', '海林市', '0', '0', null, '2', '1', null),
('1485', '174', '宁安市', '0', '0', null, '2', '1', null),
('1486', '174', '穆棱市', '0', '0', null, '2', '1', null),
('1487', '174', '东宁县', '0', '0', null, '2', '1', null),
('1488', '174', '林口县', '0', '0', null, '2', '1', null),
('1489', '175', '桃山区', '0', '0', null, '2', '1', null),
('1490', '175', '新兴区', '0', '0', null, '2', '1', null),
('1491', '175', '茄子河区', '0', '0', null, '2', '1', null),
('1492', '175', '勃利县', '0', '0', null, '2', '1', null),
('1493', '176', '龙沙区', '0', '0', null, '2', '1', null),
('1494', '176', '昂昂溪区', '0', '0', null, '2', '1', null),
('1495', '176', '铁峰区', '0', '0', null, '2', '1', null),
('1496', '176', '建华区', '0', '0', null, '2', '1', null),
('1497', '176', '富拉尔基区', '0', '0', null, '2', '1', null),
('1498', '176', '碾子山区', '0', '0', null, '2', '1', null),
('1499', '176', '梅里斯达斡尔区', '0', '0', null, '2', '1', null),
('1500', '176', '讷河市', '0', '0', null, '2', '1', null),
('1501', '176', '龙江县', '0', '0', null, '2', '1', null),
('1502', '176', '依安县', '0', '0', null, '2', '1', null),
('1503', '176', '泰来县', '0', '0', null, '2', '1', null),
('1504', '176', '甘南县', '0', '0', null, '2', '1', null),
('1505', '176', '富裕县', '0', '0', null, '2', '1', null),
('1506', '176', '克山县', '0', '0', null, '2', '1', null),
('1507', '176', '克东县', '0', '0', null, '2', '1', null),
('1508', '176', '拜泉县', '0', '0', null, '2', '1', null),
('1509', '177', '尖山区', '0', '0', null, '2', '1', null),
('1510', '177', '岭东区', '0', '0', null, '2', '1', null),
('1511', '177', '四方台区', '0', '0', null, '2', '1', null),
('1512', '177', '宝山区', '0', '0', null, '2', '1', null),
('1513', '177', '集贤县', '0', '0', null, '2', '1', null),
('1514', '177', '友谊县', '0', '0', null, '2', '1', null),
('1515', '177', '宝清县', '0', '0', null, '2', '1', null),
('1516', '177', '饶河县', '0', '0', null, '2', '1', null),
('1517', '178', '北林区', '0', '0', null, '2', '1', null),
('1518', '178', '安达市', '0', '0', null, '2', '1', null),
('1519', '178', '肇东市', '0', '0', null, '2', '1', null),
('1520', '178', '海伦市', '0', '0', null, '2', '1', null),
('1521', '178', '望奎县', '0', '0', null, '2', '1', null),
('1522', '178', '兰西县', '0', '0', null, '2', '1', null),
('1523', '178', '青冈县', '0', '0', null, '2', '1', null),
('1524', '178', '庆安县', '0', '0', null, '2', '1', null),
('1525', '178', '明水县', '0', '0', null, '2', '1', null),
('1526', '178', '绥棱县', '0', '0', null, '2', '1', null),
('1527', '179', '伊春区', '0', '0', null, '2', '1', null),
('1528', '179', '带岭区', '0', '0', null, '2', '1', null),
('1529', '179', '南岔区', '0', '0', null, '2', '1', null),
('1530', '179', '金山屯区', '0', '0', null, '2', '1', null),
('1531', '179', '西林区', '0', '0', null, '2', '1', null),
('1532', '179', '美溪区', '0', '0', null, '2', '1', null),
('1533', '179', '乌马河区', '0', '0', null, '2', '1', null),
('1534', '179', '翠峦区', '0', '0', null, '2', '1', null),
('1535', '179', '友好区', '0', '0', null, '2', '1', null),
('1536', '179', '上甘岭区', '0', '0', null, '2', '1', null),
('1537', '179', '五营区', '0', '0', null, '2', '1', null),
('1538', '179', '红星区', '0', '0', null, '2', '1', null),
('1539', '179', '新青区', '0', '0', null, '2', '1', null),
('1540', '179', '汤旺河区', '0', '0', null, '2', '1', null),
('1541', '179', '乌伊岭区', '0', '0', null, '2', '1', null),
('1542', '179', '铁力市', '0', '0', null, '2', '1', null),
('1543', '179', '嘉荫县', '0', '0', null, '2', '1', null),
('1544', '180', '江岸区', '0', '0', null, '2', '1', null),
('1545', '180', '武昌区', '0', '0', null, '2', '1', null),
('1546', '180', '江汉区', '0', '0', null, '2', '1', null),
('1547', '180', '硚口区', '0', '0', null, '2', '1', null),
('1548', '180', '汉阳区', '0', '0', null, '2', '1', null),
('1549', '180', '青山区', '0', '0', null, '2', '1', null),
('1550', '180', '洪山区', '0', '0', null, '2', '1', null),
('1551', '180', '东西湖区', '0', '0', null, '2', '1', null),
('1552', '180', '汉南区', '0', '0', null, '2', '1', null),
('1553', '180', '蔡甸区', '0', '0', null, '2', '1', null),
('1554', '180', '江夏区', '0', '0', null, '2', '1', null),
('1555', '180', '黄陂区', '0', '0', null, '2', '1', null),
('1556', '180', '新洲区', '0', '0', null, '2', '1', null),
('1557', '180', '经济开发区', '0', '0', null, '2', '1', null),
('1558', '181', '仙桃市', '0', '0', null, '2', '1', null),
('1559', '182', '鄂城区', '0', '0', null, '2', '1', null),
('1560', '182', '华容区', '0', '0', null, '2', '1', null),
('1561', '182', '梁子湖区', '0', '0', null, '2', '1', null),
('1562', '183', '黄州区', '0', '0', null, '2', '1', null),
('1563', '183', '麻城市', '0', '0', null, '2', '1', null),
('1564', '183', '武穴市', '0', '0', null, '2', '1', null),
('1565', '183', '团风县', '0', '0', null, '2', '1', null),
('1566', '183', '红安县', '0', '0', null, '2', '1', null),
('1567', '183', '罗田县', '0', '0', null, '2', '1', null),
('1568', '183', '英山县', '0', '0', null, '2', '1', null),
('1569', '183', '浠水县', '0', '0', null, '2', '1', null),
('1570', '183', '蕲春县', '0', '0', null, '2', '1', null),
('1571', '183', '黄梅县', '0', '0', null, '2', '1', null),
('1572', '184', '黄石港区', '0', '0', null, '2', '1', null),
('1573', '184', '西塞山区', '0', '0', null, '2', '1', null),
('1574', '184', '下陆区', '0', '0', null, '2', '1', null),
('1575', '184', '铁山区', '0', '0', null, '2', '1', null),
('1576', '184', '大冶市', '0', '0', null, '2', '1', null),
('1577', '184', '阳新县', '0', '0', null, '2', '1', null),
('1578', '185', '东宝区', '0', '0', null, '2', '1', null),
('1579', '185', '掇刀区', '0', '0', null, '2', '1', null),
('1580', '185', '钟祥市', '0', '0', null, '2', '1', null),
('1581', '185', '京山县', '0', '0', null, '2', '1', null),
('1582', '185', '沙洋县', '0', '0', null, '2', '1', null),
('1583', '186', '沙市区', '0', '0', null, '2', '1', null),
('1584', '186', '荆州区', '0', '0', null, '2', '1', null),
('1585', '186', '石首市', '0', '0', null, '2', '1', null),
('1586', '186', '洪湖市', '0', '0', null, '2', '1', null),
('1587', '186', '松滋市', '0', '0', null, '2', '1', null),
('1588', '186', '公安县', '0', '0', null, '2', '1', null),
('1589', '186', '监利县', '0', '0', null, '2', '1', null),
('1590', '186', '江陵县', '0', '0', null, '2', '1', null),
('1591', '187', '潜江市', '0', '0', null, '2', '1', null),
('1592', '188', '神农架林区', '0', '0', null, '2', '1', null),
('1593', '189', '张湾区', '0', '0', null, '2', '1', null),
('1594', '189', '茅箭区', '0', '0', null, '2', '1', null),
('1595', '189', '丹江口市', '0', '0', null, '2', '1', null),
('1596', '189', '郧县', '0', '0', null, '2', '1', null),
('1597', '189', '郧西县', '0', '0', null, '2', '1', null),
('1598', '189', '竹山县', '0', '0', null, '2', '1', null),
('1599', '189', '竹溪县', '0', '0', null, '2', '1', null),
('1600', '189', '房县', '0', '0', null, '2', '1', null),
('1601', '190', '曾都区', '0', '0', null, '2', '1', null),
('1602', '190', '广水市', '0', '0', null, '2', '1', null),
('1603', '191', '天门市', '0', '0', null, '2', '1', null),
('1604', '192', '咸安区', '0', '0', null, '2', '1', null),
('1605', '192', '赤壁市', '0', '0', null, '2', '1', null),
('1606', '192', '嘉鱼县', '0', '0', null, '2', '1', null),
('1607', '192', '通城县', '0', '0', null, '2', '1', null),
('1608', '192', '崇阳县', '0', '0', null, '2', '1', null),
('1609', '192', '通山县', '0', '0', null, '2', '1', null),
('1610', '193', '襄城区', '0', '0', null, '2', '1', null),
('1611', '193', '樊城区', '0', '0', null, '2', '1', null),
('1612', '193', '襄阳区', '0', '0', null, '2', '1', null),
('1613', '193', '老河口市', '0', '0', null, '2', '1', null),
('1614', '193', '枣阳市', '0', '0', null, '2', '1', null),
('1615', '193', '宜城市', '0', '0', null, '2', '1', null),
('1616', '193', '南漳县', '0', '0', null, '2', '1', null),
('1617', '193', '谷城县', '0', '0', null, '2', '1', null),
('1618', '193', '保康县', '0', '0', null, '2', '1', null),
('1619', '194', '孝南区', '0', '0', null, '2', '1', null),
('1620', '194', '应城市', '0', '0', null, '2', '1', null),
('1621', '194', '安陆市', '0', '0', null, '2', '1', null),
('1622', '194', '汉川市', '0', '0', null, '2', '1', null),
('1623', '194', '孝昌县', '0', '0', null, '2', '1', null),
('1624', '194', '大悟县', '0', '0', null, '2', '1', null),
('1625', '194', '云梦县', '0', '0', null, '2', '1', null),
('1626', '195', '长阳', '0', '0', null, '2', '1', null),
('1627', '195', '五峰', '0', '0', null, '2', '1', null),
('1628', '195', '西陵区', '0', '0', null, '2', '1', null),
('1629', '195', '伍家岗区', '0', '0', null, '2', '1', null),
('1630', '195', '点军区', '0', '0', null, '2', '1', null),
('1631', '195', '猇亭区', '0', '0', null, '2', '1', null),
('1632', '195', '夷陵区', '0', '0', null, '2', '1', null),
('1633', '195', '宜都市', '0', '0', null, '2', '1', null),
('1634', '195', '当阳市', '0', '0', null, '2', '1', null),
('1635', '195', '枝江市', '0', '0', null, '2', '1', null),
('1636', '195', '远安县', '0', '0', null, '2', '1', null),
('1637', '195', '兴山县', '0', '0', null, '2', '1', null),
('1638', '195', '秭归县', '0', '0', null, '2', '1', null),
('1639', '196', '恩施市', '0', '0', null, '2', '1', null),
('1640', '196', '利川市', '0', '0', null, '2', '1', null),
('1641', '196', '建始县', '0', '0', null, '2', '1', null),
('1642', '196', '巴东县', '0', '0', null, '2', '1', null),
('1643', '196', '宣恩县', '0', '0', null, '2', '1', null),
('1644', '196', '咸丰县', '0', '0', null, '2', '1', null),
('1645', '196', '来凤县', '0', '0', null, '2', '1', null),
('1646', '196', '鹤峰县', '0', '0', null, '2', '1', null),
('1647', '197', '岳麓区', '0', '0', null, '2', '1', null),
('1648', '197', '芙蓉区', '0', '0', null, '2', '1', null),
('1649', '197', '天心区', '0', '0', null, '2', '1', null),
('1650', '197', '开福区', '0', '0', null, '2', '1', null),
('1651', '197', '雨花区', '0', '0', null, '2', '1', null),
('1652', '197', '开发区', '0', '0', null, '2', '1', null),
('1653', '197', '浏阳市', '0', '0', null, '2', '1', null),
('1654', '197', '长沙县', '0', '0', null, '2', '1', null),
('1655', '197', '望城县', '0', '0', null, '2', '1', null),
('1656', '197', '宁乡县', '0', '0', null, '2', '1', null),
('1657', '198', '永定区', '0', '0', null, '2', '1', null),
('1658', '198', '武陵源区', '0', '0', null, '2', '1', null),
('1659', '198', '慈利县', '0', '0', null, '2', '1', null),
('1660', '198', '桑植县', '0', '0', null, '2', '1', null),
('1661', '199', '武陵区', '0', '0', null, '2', '1', null),
('1662', '199', '鼎城区', '0', '0', null, '2', '1', null),
('1663', '199', '津市市', '0', '0', null, '2', '1', null),
('1664', '199', '安乡县', '0', '0', null, '2', '1', null),
('1665', '199', '汉寿县', '0', '0', null, '2', '1', null),
('1666', '199', '澧县', '0', '0', null, '2', '1', null),
('1667', '199', '临澧县', '0', '0', null, '2', '1', null),
('1668', '199', '桃源县', '0', '0', null, '2', '1', null),
('1669', '199', '石门县', '0', '0', null, '2', '1', null),
('1670', '200', '北湖区', '0', '0', null, '2', '1', null),
('1671', '200', '苏仙区', '0', '0', null, '2', '1', null),
('1672', '200', '资兴市', '0', '0', null, '2', '1', null),
('1673', '200', '桂阳县', '0', '0', null, '2', '1', null),
('1674', '200', '宜章县', '0', '0', null, '2', '1', null),
('1675', '200', '永兴县', '0', '0', null, '2', '1', null),
('1676', '200', '嘉禾县', '0', '0', null, '2', '1', null),
('1677', '200', '临武县', '0', '0', null, '2', '1', null),
('1678', '200', '汝城县', '0', '0', null, '2', '1', null),
('1679', '200', '桂东县', '0', '0', null, '2', '1', null),
('1680', '200', '安仁县', '0', '0', null, '2', '1', null),
('1681', '201', '雁峰区', '0', '0', null, '2', '1', null),
('1682', '201', '珠晖区', '0', '0', null, '2', '1', null),
('1683', '201', '石鼓区', '0', '0', null, '2', '1', null),
('1684', '201', '蒸湘区', '0', '0', null, '2', '1', null),
('1685', '201', '南岳区', '0', '0', null, '2', '1', null),
('1686', '201', '耒阳市', '0', '0', null, '2', '1', null),
('1687', '201', '常宁市', '0', '0', null, '2', '1', null),
('1688', '201', '衡阳县', '0', '0', null, '2', '1', null),
('1689', '201', '衡南县', '0', '0', null, '2', '1', null),
('1690', '201', '衡山县', '0', '0', null, '2', '1', null),
('1691', '201', '衡东县', '0', '0', null, '2', '1', null),
('1692', '201', '祁东县', '0', '0', null, '2', '1', null),
('1693', '202', '鹤城区', '0', '0', null, '2', '1', null),
('1694', '202', '靖州', '0', '0', null, '2', '1', null),
('1695', '202', '麻阳', '0', '0', null, '2', '1', null),
('1696', '202', '通道', '0', '0', null, '2', '1', null),
('1697', '202', '新晃', '0', '0', null, '2', '1', null),
('1698', '202', '芷江', '0', '0', null, '2', '1', null),
('1699', '202', '沅陵县', '0', '0', null, '2', '1', null),
('1700', '202', '辰溪县', '0', '0', null, '2', '1', null),
('1701', '202', '溆浦县', '0', '0', null, '2', '1', null),
('1702', '202', '中方县', '0', '0', null, '2', '1', null),
('1703', '202', '会同县', '0', '0', null, '2', '1', null),
('1704', '202', '洪江市', '0', '0', null, '2', '1', null),
('1705', '203', '娄星区', '0', '0', null, '2', '1', null),
('1706', '203', '冷水江市', '0', '0', null, '2', '1', null),
('1707', '203', '涟源市', '0', '0', null, '2', '1', null),
('1708', '203', '双峰县', '0', '0', null, '2', '1', null),
('1709', '203', '新化县', '0', '0', null, '2', '1', null),
('1710', '204', '城步', '0', '0', null, '2', '1', null),
('1711', '204', '双清区', '0', '0', null, '2', '1', null),
('1712', '204', '大祥区', '0', '0', null, '2', '1', null),
('1713', '204', '北塔区', '0', '0', null, '2', '1', null),
('1714', '204', '武冈市', '0', '0', null, '2', '1', null),
('1715', '204', '邵东县', '0', '0', null, '2', '1', null),
('1716', '204', '新邵县', '0', '0', null, '2', '1', null),
('1717', '204', '邵阳县', '0', '0', null, '2', '1', null),
('1718', '204', '隆回县', '0', '0', null, '2', '1', null),
('1719', '204', '洞口县', '0', '0', null, '2', '1', null),
('1720', '204', '绥宁县', '0', '0', null, '2', '1', null),
('1721', '204', '新宁县', '0', '0', null, '2', '1', null),
('1722', '205', '岳塘区', '0', '0', null, '2', '1', null),
('1723', '205', '雨湖区', '0', '0', null, '2', '1', null),
('1724', '205', '湘乡市', '0', '0', null, '2', '1', null),
('1725', '205', '韶山市', '0', '0', null, '2', '1', null),
('1726', '205', '湘潭县', '0', '0', null, '2', '1', null),
('1727', '206', '吉首市', '0', '0', null, '2', '1', null),
('1728', '206', '泸溪县', '0', '0', null, '2', '1', null);
INSERT INTO `wst_areas` VALUES ('1729', '206', '凤凰县', '0', '0', null, '2', '1', null),
('1730', '206', '花垣县', '0', '0', null, '2', '1', null),
('1731', '206', '保靖县', '0', '0', null, '2', '1', null),
('1732', '206', '古丈县', '0', '0', null, '2', '1', null),
('1733', '206', '永顺县', '0', '0', null, '2', '1', null),
('1734', '206', '龙山县', '0', '0', null, '2', '1', null),
('1735', '207', '赫山区', '0', '0', null, '2', '1', null),
('1736', '207', '资阳区', '0', '0', null, '2', '1', null),
('1737', '207', '沅江市', '0', '0', null, '2', '1', null),
('1738', '207', '南县', '0', '0', null, '2', '1', null),
('1739', '207', '桃江县', '0', '0', null, '2', '1', null),
('1740', '207', '安化县', '0', '0', null, '2', '1', null),
('1741', '208', '江华', '0', '0', null, '2', '1', null),
('1742', '208', '冷水滩区', '0', '0', null, '2', '1', null),
('1743', '208', '零陵区', '0', '0', null, '2', '1', null),
('1744', '208', '祁阳县', '0', '0', null, '2', '1', null),
('1745', '208', '东安县', '0', '0', null, '2', '1', null),
('1746', '208', '双牌县', '0', '0', null, '2', '1', null),
('1747', '208', '道县', '0', '0', null, '2', '1', null),
('1748', '208', '江永县', '0', '0', null, '2', '1', null),
('1749', '208', '宁远县', '0', '0', null, '2', '1', null),
('1750', '208', '蓝山县', '0', '0', null, '2', '1', null),
('1751', '208', '新田县', '0', '0', null, '2', '1', null),
('1752', '209', '岳阳楼区', '0', '0', null, '2', '1', null),
('1753', '209', '君山区', '0', '0', null, '2', '1', null),
('1754', '209', '云溪区', '0', '0', null, '2', '1', null),
('1755', '209', '汨罗市', '0', '0', null, '2', '1', null),
('1756', '209', '临湘市', '0', '0', null, '2', '1', null),
('1757', '209', '岳阳县', '0', '0', null, '2', '1', null),
('1758', '209', '华容县', '0', '0', null, '2', '1', null),
('1759', '209', '湘阴县', '0', '0', null, '2', '1', null),
('1760', '209', '平江县', '0', '0', null, '2', '1', null),
('1761', '210', '天元区', '0', '0', null, '2', '1', null),
('1762', '210', '荷塘区', '0', '0', null, '2', '1', null),
('1763', '210', '芦淞区', '0', '0', null, '2', '1', null),
('1764', '210', '石峰区', '0', '0', null, '2', '1', null),
('1765', '210', '醴陵市', '0', '0', null, '2', '1', null),
('1766', '210', '株洲县', '0', '0', null, '2', '1', null),
('1767', '210', '攸县', '0', '0', null, '2', '1', null),
('1768', '210', '茶陵县', '0', '0', null, '2', '1', null),
('1769', '210', '炎陵县', '0', '0', null, '2', '1', null),
('1770', '211', '朝阳区', '0', '0', null, '2', '1', null),
('1771', '211', '宽城区', '0', '0', null, '2', '1', null),
('1772', '211', '二道区', '0', '0', null, '2', '1', null),
('1773', '211', '南关区', '0', '0', null, '2', '1', null),
('1774', '211', '绿园区', '0', '0', null, '2', '1', null),
('1775', '211', '双阳区', '0', '0', null, '2', '1', null),
('1776', '211', '净月潭开发区', '0', '0', null, '2', '1', null),
('1777', '211', '高新技术开发区', '0', '0', null, '2', '1', null),
('1778', '211', '经济技术开发区', '0', '0', null, '2', '1', null),
('1779', '211', '汽车产业开发区', '0', '0', null, '2', '1', null),
('1780', '211', '德惠市', '0', '0', null, '2', '1', null),
('1781', '211', '九台市', '0', '0', null, '2', '1', null),
('1782', '211', '榆树市', '0', '0', null, '2', '1', null),
('1783', '211', '农安县', '0', '0', null, '2', '1', null),
('1784', '212', '船营区', '0', '0', null, '2', '1', null),
('1785', '212', '昌邑区', '0', '0', null, '2', '1', null),
('1786', '212', '龙潭区', '0', '0', null, '2', '1', null),
('1787', '212', '丰满区', '0', '0', null, '2', '1', null),
('1788', '212', '蛟河市', '0', '0', null, '2', '1', null),
('1789', '212', '桦甸市', '0', '0', null, '2', '1', null),
('1790', '212', '舒兰市', '0', '0', null, '2', '1', null),
('1791', '212', '磐石市', '0', '0', null, '2', '1', null),
('1792', '212', '永吉县', '0', '0', null, '2', '1', null),
('1793', '213', '洮北区', '0', '0', null, '2', '1', null),
('1794', '213', '洮南市', '0', '0', null, '2', '1', null),
('1795', '213', '大安市', '0', '0', null, '2', '1', null),
('1796', '213', '镇赉县', '0', '0', null, '2', '1', null),
('1797', '213', '通榆县', '0', '0', null, '2', '1', null),
('1798', '214', '江源区', '0', '0', null, '2', '1', null),
('1799', '214', '八道江区', '0', '0', null, '2', '1', null),
('1800', '214', '长白', '0', '0', null, '2', '1', null),
('1801', '214', '临江市', '0', '0', null, '2', '1', null),
('1802', '214', '抚松县', '0', '0', null, '2', '1', null),
('1803', '214', '靖宇县', '0', '0', null, '2', '1', null),
('1804', '215', '龙山区', '0', '0', null, '2', '1', null),
('1805', '215', '西安区', '0', '0', null, '2', '1', null),
('1806', '215', '东丰县', '0', '0', null, '2', '1', null),
('1807', '215', '东辽县', '0', '0', null, '2', '1', null),
('1808', '216', '铁西区', '0', '0', null, '2', '1', null),
('1809', '216', '铁东区', '0', '0', null, '2', '1', null),
('1810', '216', '伊通', '0', '0', null, '2', '1', null),
('1811', '216', '公主岭市', '0', '0', null, '2', '1', null),
('1812', '216', '双辽市', '0', '0', null, '2', '1', null),
('1813', '216', '梨树县', '0', '0', null, '2', '1', null),
('1814', '217', '前郭尔罗斯', '0', '0', null, '2', '1', null),
('1815', '217', '宁江区', '0', '0', null, '2', '1', null),
('1816', '217', '长岭县', '0', '0', null, '2', '1', null),
('1817', '217', '乾安县', '0', '0', null, '2', '1', null),
('1818', '217', '扶余县', '0', '0', null, '2', '1', null),
('1819', '218', '东昌区', '0', '0', null, '2', '1', null),
('1820', '218', '二道江区', '0', '0', null, '2', '1', null),
('1821', '218', '梅河口市', '0', '0', null, '2', '1', null),
('1822', '218', '集安市', '0', '0', null, '2', '1', null),
('1823', '218', '通化县', '0', '0', null, '2', '1', null),
('1824', '218', '辉南县', '0', '0', null, '2', '1', null),
('1825', '218', '柳河县', '0', '0', null, '2', '1', null),
('1826', '219', '延吉市', '0', '0', null, '2', '1', null),
('1827', '219', '图们市', '0', '0', null, '2', '1', null),
('1828', '219', '敦化市', '0', '0', null, '2', '1', null),
('1829', '219', '珲春市', '0', '0', null, '2', '1', null),
('1830', '219', '龙井市', '0', '0', null, '2', '1', null),
('1831', '219', '和龙市', '0', '0', null, '2', '1', null),
('1832', '219', '安图县', '0', '0', null, '2', '1', null),
('1833', '219', '汪清县', '0', '0', null, '2', '1', null),
('1834', '220', '玄武区', '0', '0', null, '2', '1', null),
('1835', '220', '鼓楼区', '0', '0', null, '2', '1', null),
('1836', '220', '白下区', '0', '0', null, '2', '1', null),
('1837', '220', '建邺区', '0', '0', null, '2', '1', null),
('1838', '220', '秦淮区', '0', '0', null, '2', '1', null),
('1839', '220', '雨花台区', '0', '0', null, '2', '1', null),
('1840', '220', '下关区', '0', '0', null, '2', '1', null),
('1841', '220', '栖霞区', '0', '0', null, '2', '1', null),
('1842', '220', '浦口区', '0', '0', null, '2', '1', null),
('1843', '220', '江宁区', '0', '0', null, '2', '1', null),
('1844', '220', '六合区', '0', '0', null, '2', '1', null),
('1845', '220', '溧水县', '0', '0', null, '2', '1', null),
('1846', '220', '高淳县', '0', '0', null, '2', '1', null),
('1847', '221', '沧浪区', '0', '0', null, '2', '1', null),
('1848', '221', '金阊区', '0', '0', null, '2', '1', null),
('1849', '221', '平江区', '0', '0', null, '2', '1', null),
('1850', '221', '虎丘区', '0', '0', null, '2', '1', null),
('1851', '221', '吴中区', '0', '0', null, '2', '1', null),
('1852', '221', '相城区', '0', '0', null, '2', '1', null),
('1853', '221', '园区', '0', '0', null, '2', '1', null),
('1854', '221', '新区', '0', '0', null, '2', '1', null),
('1855', '221', '常熟市', '0', '0', null, '2', '1', null),
('1856', '221', '张家港市', '0', '0', null, '2', '1', null),
('1857', '221', '玉山镇', '0', '0', null, '2', '1', null),
('1858', '221', '巴城镇', '0', '0', null, '2', '1', null),
('1859', '221', '周市镇', '0', '0', null, '2', '1', null),
('1860', '221', '陆家镇', '0', '0', null, '2', '1', null),
('1861', '221', '花桥镇', '0', '0', null, '2', '1', null),
('1862', '221', '淀山湖镇', '0', '0', null, '2', '1', null),
('1863', '221', '张浦镇', '0', '0', null, '2', '1', null),
('1864', '221', '周庄镇', '0', '0', null, '2', '1', null),
('1865', '221', '千灯镇', '0', '0', null, '2', '1', null),
('1866', '221', '锦溪镇', '0', '0', null, '2', '1', null),
('1867', '221', '开发区', '0', '0', null, '2', '1', null),
('1868', '221', '吴江市', '0', '0', null, '2', '1', null),
('1869', '221', '太仓市', '0', '0', null, '2', '1', null),
('1870', '222', '崇安区', '0', '0', null, '2', '1', null),
('1871', '222', '北塘区', '0', '0', null, '2', '1', null),
('1872', '222', '南长区', '0', '0', null, '2', '1', null),
('1873', '222', '锡山区', '0', '0', null, '2', '1', null),
('1874', '222', '惠山区', '0', '0', null, '2', '1', null),
('1875', '222', '滨湖区', '0', '0', null, '2', '1', null),
('1876', '222', '新区', '0', '0', null, '2', '1', null),
('1877', '222', '江阴市', '0', '0', null, '2', '1', null),
('1878', '222', '宜兴市', '0', '0', null, '2', '1', null),
('1879', '223', '天宁区', '0', '0', null, '2', '1', null),
('1880', '223', '钟楼区', '0', '0', null, '2', '1', null),
('1881', '223', '戚墅堰区', '0', '0', null, '2', '1', null),
('1882', '223', '郊区', '0', '0', null, '2', '1', null),
('1883', '223', '新北区', '0', '0', null, '2', '1', null),
('1884', '223', '武进区', '0', '0', null, '2', '1', null),
('1885', '223', '溧阳市', '0', '0', null, '2', '1', null),
('1886', '223', '金坛市', '0', '0', null, '2', '1', null),
('1887', '224', '清河区', '0', '0', null, '2', '1', null),
('1888', '224', '清浦区', '0', '0', null, '2', '1', null),
('1889', '224', '楚州区', '0', '0', null, '2', '1', null),
('1890', '224', '淮阴区', '0', '0', null, '2', '1', null),
('1891', '224', '涟水县', '0', '0', null, '2', '1', null),
('1892', '224', '洪泽县', '0', '0', null, '2', '1', null),
('1893', '224', '盱眙县', '0', '0', null, '2', '1', null),
('1894', '224', '金湖县', '0', '0', null, '2', '1', null),
('1895', '225', '新浦区', '0', '0', null, '2', '1', null),
('1896', '225', '连云区', '0', '0', null, '2', '1', null),
('1897', '225', '海州区', '0', '0', null, '2', '1', null),
('1898', '225', '赣榆县', '0', '0', null, '2', '1', null),
('1899', '225', '东海县', '0', '0', null, '2', '1', null),
('1900', '225', '灌云县', '0', '0', null, '2', '1', null),
('1901', '225', '灌南县', '0', '0', null, '2', '1', null),
('1902', '226', '崇川区', '0', '0', null, '2', '1', null),
('1903', '226', '港闸区', '0', '0', null, '2', '1', null),
('1904', '226', '经济开发区', '0', '0', null, '2', '1', null),
('1905', '226', '启东市', '0', '0', null, '2', '1', null),
('1906', '226', '如皋市', '0', '0', null, '2', '1', null),
('1907', '226', '通州市', '0', '0', null, '2', '1', null),
('1908', '226', '海门市', '0', '0', null, '2', '1', null),
('1909', '226', '海安县', '0', '0', null, '2', '1', null),
('1910', '226', '如东县', '0', '0', null, '2', '1', null),
('1911', '227', '宿城区', '0', '0', null, '2', '1', null),
('1912', '227', '宿豫区', '0', '0', null, '2', '1', null),
('1913', '227', '宿豫县', '0', '0', null, '2', '1', null),
('1914', '227', '沭阳县', '0', '0', null, '2', '1', null),
('1915', '227', '泗阳县', '0', '0', null, '2', '1', null),
('1916', '227', '泗洪县', '0', '0', null, '2', '1', null),
('1917', '228', '海陵区', '0', '0', null, '2', '1', null),
('1918', '228', '高港区', '0', '0', null, '2', '1', null),
('1919', '228', '兴化市', '0', '0', null, '2', '1', null),
('1920', '228', '靖江市', '0', '0', null, '2', '1', null),
('1921', '228', '泰兴市', '0', '0', null, '2', '1', null),
('1922', '228', '姜堰市', '0', '0', null, '2', '1', null),
('1923', '229', '云龙区', '0', '0', null, '2', '1', null),
('1924', '229', '鼓楼区', '0', '0', null, '2', '1', null),
('1925', '229', '九里区', '0', '0', null, '2', '1', null),
('1926', '229', '贾汪区', '0', '0', null, '2', '1', null),
('1927', '229', '泉山区', '0', '0', null, '2', '1', null),
('1928', '229', '新沂市', '0', '0', null, '2', '1', null),
('1929', '229', '邳州市', '0', '0', null, '2', '1', null),
('1930', '229', '丰县', '0', '0', null, '2', '1', null),
('1931', '229', '沛县', '0', '0', null, '2', '1', null),
('1932', '229', '铜山县', '0', '0', null, '2', '1', null),
('1933', '229', '睢宁县', '0', '0', null, '2', '1', null),
('1934', '230', '城区', '0', '0', null, '2', '1', null),
('1935', '230', '亭湖区', '0', '0', null, '2', '1', null),
('1936', '230', '盐都区', '0', '0', null, '2', '1', null),
('1937', '230', '盐都县', '0', '0', null, '2', '1', null),
('1938', '230', '东台市', '0', '0', null, '2', '1', null),
('1939', '230', '大丰市', '0', '0', null, '2', '1', null),
('1940', '230', '响水县', '0', '0', null, '2', '1', null),
('1941', '230', '滨海县', '0', '0', null, '2', '1', null),
('1942', '230', '阜宁县', '0', '0', null, '2', '1', null),
('1943', '230', '射阳县', '0', '0', null, '2', '1', null),
('1944', '230', '建湖县', '0', '0', null, '2', '1', null),
('1945', '231', '广陵区', '0', '0', null, '2', '1', null),
('1946', '231', '维扬区', '0', '0', null, '2', '1', null),
('1947', '231', '邗江区', '0', '0', null, '2', '1', null),
('1948', '231', '仪征市', '0', '0', null, '2', '1', null),
('1949', '231', '高邮市', '0', '0', null, '2', '1', null),
('1950', '231', '江都市', '0', '0', null, '2', '1', null),
('1951', '231', '宝应县', '0', '0', null, '2', '1', null),
('1952', '232', '京口区', '0', '0', null, '2', '1', null),
('1953', '232', '润州区', '0', '0', null, '2', '1', null),
('1954', '232', '丹徒区', '0', '0', null, '2', '1', null),
('1955', '232', '丹阳市', '0', '0', null, '2', '1', null),
('1956', '232', '扬中市', '0', '0', null, '2', '1', null),
('1957', '232', '句容市', '0', '0', null, '2', '1', null),
('1958', '233', '东湖区', '0', '0', null, '2', '1', null),
('1959', '233', '西湖区', '0', '0', null, '2', '1', null),
('1960', '233', '青云谱区', '0', '0', null, '2', '1', null),
('1961', '233', '湾里区', '0', '0', null, '2', '1', null),
('1962', '233', '青山湖区', '0', '0', null, '2', '1', null),
('1963', '233', '红谷滩新区', '0', '0', null, '2', '1', null),
('1964', '233', '昌北区', '0', '0', null, '2', '1', null),
('1965', '233', '高新区', '0', '0', null, '2', '1', null),
('1966', '233', '南昌县', '0', '0', null, '2', '1', null),
('1967', '233', '新建县', '0', '0', null, '2', '1', null),
('1968', '233', '安义县', '0', '0', null, '2', '1', null),
('1969', '233', '进贤县', '0', '0', null, '2', '1', null),
('1970', '234', '临川区', '0', '0', null, '2', '1', null),
('1971', '234', '南城县', '0', '0', null, '2', '1', null),
('1972', '234', '黎川县', '0', '0', null, '2', '1', null),
('1973', '234', '南丰县', '0', '0', null, '2', '1', null),
('1974', '234', '崇仁县', '0', '0', null, '2', '1', null),
('1975', '234', '乐安县', '0', '0', null, '2', '1', null),
('1976', '234', '宜黄县', '0', '0', null, '2', '1', null),
('1977', '234', '金溪县', '0', '0', null, '2', '1', null),
('1978', '234', '资溪县', '0', '0', null, '2', '1', null),
('1979', '234', '东乡县', '0', '0', null, '2', '1', null),
('1980', '234', '广昌县', '0', '0', null, '2', '1', null),
('1981', '235', '章贡区', '0', '0', null, '2', '1', null),
('1982', '235', '于都县', '0', '0', null, '2', '1', null),
('1983', '235', '瑞金市', '0', '0', null, '2', '1', null),
('1984', '235', '南康市', '0', '0', null, '2', '1', null),
('1985', '235', '赣县', '0', '0', null, '2', '1', null),
('1986', '235', '信丰县', '0', '0', null, '2', '1', null),
('1987', '235', '大余县', '0', '0', null, '2', '1', null),
('1988', '235', '上犹县', '0', '0', null, '2', '1', null),
('1989', '235', '崇义县', '0', '0', null, '2', '1', null),
('1990', '235', '安远县', '0', '0', null, '2', '1', null),
('1991', '235', '龙南县', '0', '0', null, '2', '1', null),
('1992', '235', '定南县', '0', '0', null, '2', '1', null),
('1993', '235', '全南县', '0', '0', null, '2', '1', null),
('1994', '235', '宁都县', '0', '0', null, '2', '1', null),
('1995', '235', '兴国县', '0', '0', null, '2', '1', null),
('1996', '235', '会昌县', '0', '0', null, '2', '1', null),
('1997', '235', '寻乌县', '0', '0', null, '2', '1', null),
('1998', '235', '石城县', '0', '0', null, '2', '1', null),
('1999', '236', '安福县', '0', '0', null, '2', '1', null),
('2000', '236', '吉州区', '0', '0', null, '2', '1', null),
('2001', '236', '青原区', '0', '0', null, '2', '1', null),
('2002', '236', '井冈山市', '0', '0', null, '2', '1', null),
('2003', '236', '吉安县', '0', '0', null, '2', '1', null),
('2004', '236', '吉水县', '0', '0', null, '2', '1', null),
('2005', '236', '峡江县', '0', '0', null, '2', '1', null),
('2006', '236', '新干县', '0', '0', null, '2', '1', null),
('2007', '236', '永丰县', '0', '0', null, '2', '1', null),
('2008', '236', '泰和县', '0', '0', null, '2', '1', null),
('2009', '236', '遂川县', '0', '0', null, '2', '1', null),
('2010', '236', '万安县', '0', '0', null, '2', '1', null),
('2011', '236', '永新县', '0', '0', null, '2', '1', null),
('2012', '237', '珠山区', '0', '0', null, '2', '1', null),
('2013', '237', '昌江区', '0', '0', null, '2', '1', null),
('2014', '237', '乐平市', '0', '0', null, '2', '1', null),
('2015', '237', '浮梁县', '0', '0', null, '2', '1', null),
('2016', '238', '浔阳区', '0', '0', null, '2', '1', null),
('2017', '238', '庐山区', '0', '0', null, '2', '1', null),
('2018', '238', '瑞昌市', '0', '0', null, '2', '1', null),
('2019', '238', '九江县', '0', '0', null, '2', '1', null),
('2020', '238', '武宁县', '0', '0', null, '2', '1', null),
('2021', '238', '修水县', '0', '0', null, '2', '1', null),
('2022', '238', '永修县', '0', '0', null, '2', '1', null),
('2023', '238', '德安县', '0', '0', null, '2', '1', null),
('2024', '238', '星子县', '0', '0', null, '2', '1', null),
('2025', '238', '都昌县', '0', '0', null, '2', '1', null),
('2026', '238', '湖口县', '0', '0', null, '2', '1', null),
('2027', '238', '彭泽县', '0', '0', null, '2', '1', null),
('2028', '239', '安源区', '0', '0', null, '2', '1', null),
('2029', '239', '湘东区', '0', '0', null, '2', '1', null),
('2030', '239', '莲花县', '0', '0', null, '2', '1', null),
('2031', '239', '芦溪县', '0', '0', null, '2', '1', null),
('2032', '239', '上栗县', '0', '0', null, '2', '1', null),
('2033', '240', '信州区', '0', '0', null, '2', '1', null),
('2034', '240', '德兴市', '0', '0', null, '2', '1', null),
('2035', '240', '上饶县', '0', '0', null, '2', '1', null),
('2036', '240', '广丰县', '0', '0', null, '2', '1', null),
('2037', '240', '玉山县', '0', '0', null, '2', '1', null),
('2038', '240', '铅山县', '0', '0', null, '2', '1', null),
('2039', '240', '横峰县', '0', '0', null, '2', '1', null),
('2040', '240', '弋阳县', '0', '0', null, '2', '1', null),
('2041', '240', '余干县', '0', '0', null, '2', '1', null),
('2042', '240', '波阳县', '0', '0', null, '2', '1', null),
('2043', '240', '万年县', '0', '0', null, '2', '1', null),
('2044', '240', '婺源县', '0', '0', null, '2', '1', null),
('2045', '241', '渝水区', '0', '0', null, '2', '1', null),
('2046', '241', '分宜县', '0', '0', null, '2', '1', null),
('2047', '242', '袁州区', '0', '0', null, '2', '1', null),
('2048', '242', '丰城市', '0', '0', null, '2', '1', null),
('2049', '242', '樟树市', '0', '0', null, '2', '1', null),
('2050', '242', '高安市', '0', '0', null, '2', '1', null),
('2051', '242', '奉新县', '0', '0', null, '2', '1', null),
('2052', '242', '万载县', '0', '0', null, '2', '1', null),
('2053', '242', '上高县', '0', '0', null, '2', '1', null),
('2054', '242', '宜丰县', '0', '0', null, '2', '1', null),
('2055', '242', '靖安县', '0', '0', null, '2', '1', null),
('2056', '242', '铜鼓县', '0', '0', null, '2', '1', null),
('2057', '243', '月湖区', '0', '0', null, '2', '1', null),
('2058', '243', '贵溪市', '0', '0', null, '2', '1', null),
('2059', '243', '余江县', '0', '0', null, '2', '1', null),
('2060', '244', '沈河区', '0', '0', null, '2', '1', null),
('2061', '244', '皇姑区', '0', '0', null, '2', '1', null),
('2062', '244', '和平区', '0', '0', null, '2', '1', null),
('2063', '244', '大东区', '0', '0', null, '2', '1', null),
('2064', '244', '铁西区', '0', '0', null, '2', '1', null),
('2065', '244', '苏家屯区', '0', '0', null, '2', '1', null),
('2066', '244', '东陵区', '0', '0', null, '2', '1', null),
('2067', '244', '沈北新区', '0', '0', null, '2', '1', null),
('2068', '244', '于洪区', '0', '0', null, '2', '1', null),
('2069', '244', '浑南新区', '0', '0', null, '2', '1', null),
('2070', '244', '新民市', '0', '0', null, '2', '1', null),
('2071', '244', '辽中县', '0', '0', null, '2', '1', null),
('2072', '244', '康平县', '0', '0', null, '2', '1', null),
('2073', '244', '法库县', '0', '0', null, '2', '1', null),
('2074', '245', '西岗区', '0', '0', null, '2', '1', null),
('2075', '245', '中山区', '0', '0', null, '2', '1', null),
('2076', '245', '沙河口区', '0', '0', null, '2', '1', null),
('2077', '245', '甘井子区', '0', '0', null, '2', '1', null),
('2078', '245', '旅顺口区', '0', '0', null, '2', '1', null),
('2079', '245', '金州区', '0', '0', null, '2', '1', null),
('2080', '245', '开发区', '0', '0', null, '2', '1', null),
('2081', '245', '瓦房店市', '0', '0', null, '2', '1', null),
('2082', '245', '普兰店市', '0', '0', null, '2', '1', null),
('2083', '245', '庄河市', '0', '0', null, '2', '1', null),
('2084', '245', '长海县', '0', '0', null, '2', '1', null),
('2085', '246', '铁东区', '0', '0', null, '2', '1', null),
('2086', '246', '铁西区', '0', '0', null, '2', '1', null),
('2087', '246', '立山区', '0', '0', null, '2', '1', null),
('2088', '246', '千山区', '0', '0', null, '2', '1', null),
('2089', '246', '岫岩', '0', '0', null, '2', '1', null),
('2090', '246', '海城市', '0', '0', null, '2', '1', null),
('2091', '246', '台安县', '0', '0', null, '2', '1', null),
('2092', '247', '本溪', '0', '0', null, '2', '1', null),
('2093', '247', '平山区', '0', '0', null, '2', '1', null),
('2094', '247', '明山区', '0', '0', null, '2', '1', null),
('2095', '247', '溪湖区', '0', '0', null, '2', '1', null),
('2096', '247', '南芬区', '0', '0', null, '2', '1', null),
('2097', '247', '桓仁', '0', '0', null, '2', '1', null),
('2098', '248', '双塔区', '0', '0', null, '2', '1', null),
('2099', '248', '龙城区', '0', '0', null, '2', '1', null),
('2100', '248', '喀喇沁左翼蒙古族自治县', '0', '0', null, '2', '1', null),
('2101', '248', '北票市', '0', '0', null, '2', '1', null),
('2102', '248', '凌源市', '0', '0', null, '2', '1', null),
('2103', '248', '朝阳县', '0', '0', null, '2', '1', null),
('2104', '248', '建平县', '0', '0', null, '2', '1', null),
('2105', '249', '振兴区', '0', '0', null, '2', '1', null),
('2106', '249', '元宝区', '0', '0', null, '2', '1', null),
('2107', '249', '振安区', '0', '0', null, '2', '1', null),
('2108', '249', '宽甸', '0', '0', null, '2', '1', null),
('2109', '249', '东港市', '0', '0', null, '2', '1', null),
('2110', '249', '凤城市', '0', '0', null, '2', '1', null),
('2111', '250', '顺城区', '0', '0', null, '2', '1', null),
('2112', '250', '新抚区', '0', '0', null, '2', '1', null),
('2113', '250', '东洲区', '0', '0', null, '2', '1', null),
('2114', '250', '望花区', '0', '0', null, '2', '1', null),
('2115', '250', '清原', '0', '0', null, '2', '1', null),
('2116', '250', '新宾', '0', '0', null, '2', '1', null),
('2117', '250', '抚顺县', '0', '0', null, '2', '1', null),
('2118', '251', '阜新', '0', '0', null, '2', '1', null),
('2119', '251', '海州区', '0', '0', null, '2', '1', null),
('2120', '251', '新邱区', '0', '0', null, '2', '1', null),
('2121', '251', '太平区', '0', '0', null, '2', '1', null),
('2122', '251', '清河门区', '0', '0', null, '2', '1', null),
('2123', '251', '细河区', '0', '0', null, '2', '1', null),
('2124', '251', '彰武县', '0', '0', null, '2', '1', null),
('2125', '252', '龙港区', '0', '0', null, '2', '1', null),
('2126', '252', '南票区', '0', '0', null, '2', '1', null),
('2127', '252', '连山区', '0', '0', null, '2', '1', null),
('2128', '252', '兴城市', '0', '0', null, '2', '1', null);
INSERT INTO `wst_areas` VALUES ('2129', '252', '绥中县', '0', '0', null, '2', '1', null),
('2130', '252', '建昌县', '0', '0', null, '2', '1', null),
('2131', '253', '太和区', '0', '0', null, '2', '1', null),
('2132', '253', '古塔区', '0', '0', null, '2', '1', null),
('2133', '253', '凌河区', '0', '0', null, '2', '1', null),
('2134', '253', '凌海市', '0', '0', null, '2', '1', null),
('2135', '253', '北镇市', '0', '0', null, '2', '1', null),
('2136', '253', '黑山县', '0', '0', null, '2', '1', null),
('2137', '253', '义县', '0', '0', null, '2', '1', null),
('2138', '254', '白塔区', '0', '0', null, '2', '1', null),
('2139', '254', '文圣区', '0', '0', null, '2', '1', null),
('2140', '254', '宏伟区', '0', '0', null, '2', '1', null),
('2141', '254', '太子河区', '0', '0', null, '2', '1', null),
('2142', '254', '弓长岭区', '0', '0', null, '2', '1', null),
('2143', '254', '灯塔市', '0', '0', null, '2', '1', null),
('2144', '254', '辽阳县', '0', '0', null, '2', '1', null),
('2145', '255', '双台子区', '0', '0', null, '2', '1', null),
('2146', '255', '兴隆台区', '0', '0', null, '2', '1', null),
('2147', '255', '大洼县', '0', '0', null, '2', '1', null),
('2148', '255', '盘山县', '0', '0', null, '2', '1', null),
('2149', '256', '银州区', '0', '0', null, '2', '1', null),
('2150', '256', '清河区', '0', '0', null, '2', '1', null),
('2151', '256', '调兵山市', '0', '0', null, '2', '1', null),
('2152', '256', '开原市', '0', '0', null, '2', '1', null),
('2153', '256', '铁岭县', '0', '0', null, '2', '1', null),
('2154', '256', '西丰县', '0', '0', null, '2', '1', null),
('2155', '256', '昌图县', '0', '0', null, '2', '1', null),
('2156', '257', '站前区', '0', '0', null, '2', '1', null),
('2157', '257', '西市区', '0', '0', null, '2', '1', null),
('2158', '257', '鲅鱼圈区', '0', '0', null, '2', '1', null),
('2159', '257', '老边区', '0', '0', null, '2', '1', null),
('2160', '257', '盖州市', '0', '0', null, '2', '1', null),
('2161', '257', '大石桥市', '0', '0', null, '2', '1', null),
('2162', '258', '回民区', '0', '0', null, '2', '1', null),
('2163', '258', '玉泉区', '0', '0', null, '2', '1', null),
('2164', '258', '新城区', '0', '0', null, '2', '1', null),
('2165', '258', '赛罕区', '0', '0', null, '2', '1', null),
('2166', '258', '清水河县', '0', '0', null, '2', '1', null),
('2167', '258', '土默特左旗', '0', '0', null, '2', '1', null),
('2168', '258', '托克托县', '0', '0', null, '2', '1', null),
('2169', '258', '和林格尔县', '0', '0', null, '2', '1', null),
('2170', '258', '武川县', '0', '0', null, '2', '1', null),
('2171', '259', '阿拉善左旗', '0', '0', null, '2', '1', null),
('2172', '259', '阿拉善右旗', '0', '0', null, '2', '1', null),
('2173', '259', '额济纳旗', '0', '0', null, '2', '1', null),
('2174', '260', '临河区', '0', '0', null, '2', '1', null),
('2175', '260', '五原县', '0', '0', null, '2', '1', null),
('2176', '260', '磴口县', '0', '0', null, '2', '1', null),
('2177', '260', '乌拉特前旗', '0', '0', null, '2', '1', null),
('2178', '260', '乌拉特中旗', '0', '0', null, '2', '1', null),
('2179', '260', '乌拉特后旗', '0', '0', null, '2', '1', null),
('2180', '260', '杭锦后旗', '0', '0', null, '2', '1', null),
('2181', '261', '昆都仑区', '0', '0', null, '2', '1', null),
('2182', '261', '青山区', '0', '0', null, '2', '1', null),
('2183', '261', '东河区', '0', '0', null, '2', '1', null),
('2184', '261', '九原区', '0', '0', null, '2', '1', null),
('2185', '261', '石拐区', '0', '0', null, '2', '1', null),
('2186', '261', '白云矿区', '0', '0', null, '2', '1', null),
('2187', '261', '土默特右旗', '0', '0', null, '2', '1', null),
('2188', '261', '固阳县', '0', '0', null, '2', '1', null),
('2189', '261', '达尔罕茂明安联合旗', '0', '0', null, '2', '1', null),
('2190', '262', '红山区', '0', '0', null, '2', '1', null),
('2191', '262', '元宝山区', '0', '0', null, '2', '1', null),
('2192', '262', '松山区', '0', '0', null, '2', '1', null),
('2193', '262', '阿鲁科尔沁旗', '0', '0', null, '2', '1', null),
('2194', '262', '巴林左旗', '0', '0', null, '2', '1', null),
('2195', '262', '巴林右旗', '0', '0', null, '2', '1', null),
('2196', '262', '林西县', '0', '0', null, '2', '1', null),
('2197', '262', '克什克腾旗', '0', '0', null, '2', '1', null),
('2198', '262', '翁牛特旗', '0', '0', null, '2', '1', null),
('2199', '262', '喀喇沁旗', '0', '0', null, '2', '1', null),
('2200', '262', '宁城县', '0', '0', null, '2', '1', null),
('2201', '262', '敖汉旗', '0', '0', null, '2', '1', null),
('2202', '263', '东胜区', '0', '0', null, '2', '1', null),
('2203', '263', '达拉特旗', '0', '0', null, '2', '1', null),
('2204', '263', '准格尔旗', '0', '0', null, '2', '1', null),
('2205', '263', '鄂托克前旗', '0', '0', null, '2', '1', null),
('2206', '263', '鄂托克旗', '0', '0', null, '2', '1', null),
('2207', '263', '杭锦旗', '0', '0', null, '2', '1', null),
('2208', '263', '乌审旗', '0', '0', null, '2', '1', null),
('2209', '263', '伊金霍洛旗', '0', '0', null, '2', '1', null),
('2210', '264', '海拉尔区', '0', '0', null, '2', '1', null),
('2211', '264', '莫力达瓦', '0', '0', null, '2', '1', null),
('2212', '264', '满洲里市', '0', '0', null, '2', '1', null),
('2213', '264', '牙克石市', '0', '0', null, '2', '1', null),
('2214', '264', '扎兰屯市', '0', '0', null, '2', '1', null),
('2215', '264', '额尔古纳市', '0', '0', null, '2', '1', null),
('2216', '264', '根河市', '0', '0', null, '2', '1', null),
('2217', '264', '阿荣旗', '0', '0', null, '2', '1', null),
('2218', '264', '鄂伦春自治旗', '0', '0', null, '2', '1', null),
('2219', '264', '鄂温克族自治旗', '0', '0', null, '2', '1', null),
('2220', '264', '陈巴尔虎旗', '0', '0', null, '2', '1', null),
('2221', '264', '新巴尔虎左旗', '0', '0', null, '2', '1', null),
('2222', '264', '新巴尔虎右旗', '0', '0', null, '2', '1', null),
('2223', '265', '科尔沁区', '0', '0', null, '2', '1', null),
('2224', '265', '霍林郭勒市', '0', '0', null, '2', '1', null),
('2225', '265', '科尔沁左翼中旗', '0', '0', null, '2', '1', null),
('2226', '265', '科尔沁左翼后旗', '0', '0', null, '2', '1', null),
('2227', '265', '开鲁县', '0', '0', null, '2', '1', null),
('2228', '265', '库伦旗', '0', '0', null, '2', '1', null),
('2229', '265', '奈曼旗', '0', '0', null, '2', '1', null),
('2230', '265', '扎鲁特旗', '0', '0', null, '2', '1', null),
('2231', '266', '海勃湾区', '0', '0', null, '2', '1', null),
('2232', '266', '乌达区', '0', '0', null, '2', '1', null),
('2233', '266', '海南区', '0', '0', null, '2', '1', null),
('2234', '267', '化德县', '0', '0', null, '2', '1', null),
('2235', '267', '集宁区', '0', '0', null, '2', '1', null),
('2236', '267', '丰镇市', '0', '0', null, '2', '1', null),
('2237', '267', '卓资县', '0', '0', null, '2', '1', null),
('2238', '267', '商都县', '0', '0', null, '2', '1', null),
('2239', '267', '兴和县', '0', '0', null, '2', '1', null),
('2240', '267', '凉城县', '0', '0', null, '2', '1', null),
('2241', '267', '察哈尔右翼前旗', '0', '0', null, '2', '1', null),
('2242', '267', '察哈尔右翼中旗', '0', '0', null, '2', '1', null),
('2243', '267', '察哈尔右翼后旗', '0', '0', null, '2', '1', null),
('2244', '267', '四子王旗', '0', '0', null, '2', '1', null),
('2245', '268', '二连浩特市', '0', '0', null, '2', '1', null),
('2246', '268', '锡林浩特市', '0', '0', null, '2', '1', null),
('2247', '268', '阿巴嘎旗', '0', '0', null, '2', '1', null),
('2248', '268', '苏尼特左旗', '0', '0', null, '2', '1', null),
('2249', '268', '苏尼特右旗', '0', '0', null, '2', '1', null),
('2250', '268', '东乌珠穆沁旗', '0', '0', null, '2', '1', null),
('2251', '268', '西乌珠穆沁旗', '0', '0', null, '2', '1', null),
('2252', '268', '太仆寺旗', '0', '0', null, '2', '1', null),
('2253', '268', '镶黄旗', '0', '0', null, '2', '1', null),
('2254', '268', '正镶白旗', '0', '0', null, '2', '1', null),
('2255', '268', '正蓝旗', '0', '0', null, '2', '1', null),
('2256', '268', '多伦县', '0', '0', null, '2', '1', null),
('2257', '269', '乌兰浩特市', '0', '0', null, '2', '1', null),
('2258', '269', '阿尔山市', '0', '0', null, '2', '1', null),
('2259', '269', '科尔沁右翼前旗', '0', '0', null, '2', '1', null),
('2260', '269', '科尔沁右翼中旗', '0', '0', null, '2', '1', null),
('2261', '269', '扎赉特旗', '0', '0', null, '2', '1', null),
('2262', '269', '突泉县', '0', '0', null, '2', '1', null),
('2263', '270', '西夏区', '0', '0', null, '2', '1', null),
('2264', '270', '金凤区', '0', '0', null, '2', '1', null),
('2265', '270', '兴庆区', '0', '0', null, '2', '1', null),
('2266', '270', '灵武市', '0', '0', null, '2', '1', null),
('2267', '270', '永宁县', '0', '0', null, '2', '1', null),
('2268', '270', '贺兰县', '0', '0', null, '2', '1', null),
('2269', '271', '原州区', '0', '0', null, '2', '1', null),
('2270', '271', '海原县', '0', '0', null, '2', '1', null),
('2271', '271', '西吉县', '0', '0', null, '2', '1', null),
('2272', '271', '隆德县', '0', '0', null, '2', '1', null),
('2273', '271', '泾源县', '0', '0', null, '2', '1', null),
('2274', '271', '彭阳县', '0', '0', null, '2', '1', null),
('2275', '272', '惠农县', '0', '0', null, '2', '1', null),
('2276', '272', '大武口区', '0', '0', null, '2', '1', null),
('2277', '272', '惠农区', '0', '0', null, '2', '1', null),
('2278', '272', '陶乐县', '0', '0', null, '2', '1', null),
('2279', '272', '平罗县', '0', '0', null, '2', '1', null),
('2280', '273', '利通区', '0', '0', null, '2', '1', null),
('2281', '273', '中卫县', '0', '0', null, '2', '1', null),
('2282', '273', '青铜峡市', '0', '0', null, '2', '1', null),
('2283', '273', '中宁县', '0', '0', null, '2', '1', null),
('2284', '273', '盐池县', '0', '0', null, '2', '1', null),
('2285', '273', '同心县', '0', '0', null, '2', '1', null),
('2286', '274', '沙坡头区', '0', '0', null, '2', '1', null),
('2287', '274', '海原县', '0', '0', null, '2', '1', null),
('2288', '274', '中宁县', '0', '0', null, '2', '1', null),
('2289', '275', '城中区', '0', '0', null, '2', '1', null),
('2290', '275', '城东区', '0', '0', null, '2', '1', null),
('2291', '275', '城西区', '0', '0', null, '2', '1', null),
('2292', '275', '城北区', '0', '0', null, '2', '1', null),
('2293', '275', '湟中县', '0', '0', null, '2', '1', null),
('2294', '275', '湟源县', '0', '0', null, '2', '1', null),
('2295', '275', '大通', '0', '0', null, '2', '1', null),
('2296', '276', '玛沁县', '0', '0', null, '2', '1', null),
('2297', '276', '班玛县', '0', '0', null, '2', '1', null),
('2298', '276', '甘德县', '0', '0', null, '2', '1', null),
('2299', '276', '达日县', '0', '0', null, '2', '1', null),
('2300', '276', '久治县', '0', '0', null, '2', '1', null),
('2301', '276', '玛多县', '0', '0', null, '2', '1', null),
('2302', '277', '海晏县', '0', '0', null, '2', '1', null),
('2303', '277', '祁连县', '0', '0', null, '2', '1', null),
('2304', '277', '刚察县', '0', '0', null, '2', '1', null),
('2305', '277', '门源', '0', '0', null, '2', '1', null),
('2306', '278', '平安县', '0', '0', null, '2', '1', null),
('2307', '278', '乐都县', '0', '0', null, '2', '1', null),
('2308', '278', '民和', '0', '0', null, '2', '1', null),
('2309', '278', '互助', '0', '0', null, '2', '1', null),
('2310', '278', '化隆', '0', '0', null, '2', '1', null),
('2311', '278', '循化', '0', '0', null, '2', '1', null),
('2312', '279', '共和县', '0', '0', null, '2', '1', null),
('2313', '279', '同德县', '0', '0', null, '2', '1', null),
('2314', '279', '贵德县', '0', '0', null, '2', '1', null),
('2315', '279', '兴海县', '0', '0', null, '2', '1', null),
('2316', '279', '贵南县', '0', '0', null, '2', '1', null),
('2317', '280', '德令哈市', '0', '0', null, '2', '1', null),
('2318', '280', '格尔木市', '0', '0', null, '2', '1', null),
('2319', '280', '乌兰县', '0', '0', null, '2', '1', null),
('2320', '280', '都兰县', '0', '0', null, '2', '1', null),
('2321', '280', '天峻县', '0', '0', null, '2', '1', null),
('2322', '281', '同仁县', '0', '0', null, '2', '1', null),
('2323', '281', '尖扎县', '0', '0', null, '2', '1', null),
('2324', '281', '泽库县', '0', '0', null, '2', '1', null),
('2325', '281', '河南蒙古族自治县', '0', '0', null, '2', '1', null),
('2326', '282', '玉树县', '0', '0', null, '2', '1', null),
('2327', '282', '杂多县', '0', '0', null, '2', '1', null),
('2328', '282', '称多县', '0', '0', null, '2', '1', null),
('2329', '282', '治多县', '0', '0', null, '2', '1', null),
('2330', '282', '囊谦县', '0', '0', null, '2', '1', null),
('2331', '282', '曲麻莱县', '0', '0', null, '2', '1', null),
('2332', '283', '市中区', '0', '0', null, '2', '1', null),
('2333', '283', '历下区', '0', '0', null, '2', '1', null),
('2334', '283', '天桥区', '0', '0', null, '2', '1', null),
('2335', '283', '槐荫区', '0', '0', null, '2', '1', null),
('2336', '283', '历城区', '0', '0', null, '2', '1', null),
('2337', '283', '长清区', '0', '0', null, '2', '1', null),
('2338', '283', '章丘市', '0', '0', null, '2', '1', null),
('2339', '283', '平阴县', '0', '0', null, '2', '1', null),
('2340', '283', '济阳县', '0', '0', null, '2', '1', null),
('2341', '283', '商河县', '0', '0', null, '2', '1', null),
('2342', '284', '市南区', '0', '0', null, '2', '1', null),
('2343', '284', '市北区', '0', '0', null, '2', '1', null),
('2344', '284', '城阳区', '0', '0', null, '2', '1', null),
('2345', '284', '四方区', '0', '0', null, '2', '1', null),
('2346', '284', '李沧区', '0', '0', null, '2', '1', null),
('2347', '284', '黄岛区', '0', '0', null, '2', '1', null),
('2348', '284', '崂山区', '0', '0', null, '2', '1', null),
('2349', '284', '胶州市', '0', '0', null, '2', '1', null),
('2350', '284', '即墨市', '0', '0', null, '2', '1', null),
('2351', '284', '平度市', '0', '0', null, '2', '1', null),
('2352', '284', '胶南市', '0', '0', null, '2', '1', null),
('2353', '284', '莱西市', '0', '0', null, '2', '1', null),
('2354', '285', '滨城区', '0', '0', null, '2', '1', null),
('2355', '285', '惠民县', '0', '0', null, '2', '1', null),
('2356', '285', '阳信县', '0', '0', null, '2', '1', null),
('2357', '285', '无棣县', '0', '0', null, '2', '1', null),
('2358', '285', '沾化县', '0', '0', null, '2', '1', null),
('2359', '285', '博兴县', '0', '0', null, '2', '1', null),
('2360', '285', '邹平县', '0', '0', null, '2', '1', null),
('2361', '286', '德城区', '0', '0', null, '2', '1', null),
('2362', '286', '陵县', '0', '0', null, '2', '1', null),
('2363', '286', '乐陵市', '0', '0', null, '2', '1', null),
('2364', '286', '禹城市', '0', '0', null, '2', '1', null),
('2365', '286', '宁津县', '0', '0', null, '2', '1', null),
('2366', '286', '庆云县', '0', '0', null, '2', '1', null),
('2367', '286', '临邑县', '0', '0', null, '2', '1', null),
('2368', '286', '齐河县', '0', '0', null, '2', '1', null),
('2369', '286', '平原县', '0', '0', null, '2', '1', null),
('2370', '286', '夏津县', '0', '0', null, '2', '1', null),
('2371', '286', '武城县', '0', '0', null, '2', '1', null),
('2372', '287', '东营区', '0', '0', null, '2', '1', null),
('2373', '287', '河口区', '0', '0', null, '2', '1', null),
('2374', '287', '垦利县', '0', '0', null, '2', '1', null),
('2375', '287', '利津县', '0', '0', null, '2', '1', null),
('2376', '287', '广饶县', '0', '0', null, '2', '1', null),
('2377', '288', '牡丹区', '0', '0', null, '2', '1', null),
('2378', '288', '曹县', '0', '0', null, '2', '1', null),
('2379', '288', '单县', '0', '0', null, '2', '1', null),
('2380', '288', '成武县', '0', '0', null, '2', '1', null),
('2381', '288', '巨野县', '0', '0', null, '2', '1', null),
('2382', '288', '郓城县', '0', '0', null, '2', '1', null),
('2383', '288', '鄄城县', '0', '0', null, '2', '1', null),
('2384', '288', '定陶县', '0', '0', null, '2', '1', null),
('2385', '288', '东明县', '0', '0', null, '2', '1', null),
('2386', '289', '市中区', '0', '0', null, '2', '1', null),
('2387', '289', '任城区', '0', '0', null, '2', '1', null),
('2388', '289', '曲阜市', '0', '0', null, '2', '1', null),
('2389', '289', '兖州市', '0', '0', null, '2', '1', null),
('2390', '289', '邹城市', '0', '0', null, '2', '1', null),
('2391', '289', '微山县', '0', '0', null, '2', '1', null),
('2392', '289', '鱼台县', '0', '0', null, '2', '1', null),
('2393', '289', '金乡县', '0', '0', null, '2', '1', null),
('2394', '289', '嘉祥县', '0', '0', null, '2', '1', null),
('2395', '289', '汶上县', '0', '0', null, '2', '1', null),
('2396', '289', '泗水县', '0', '0', null, '2', '1', null),
('2397', '289', '梁山县', '0', '0', null, '2', '1', null),
('2398', '290', '莱城区', '0', '0', null, '2', '1', null),
('2399', '290', '钢城区', '0', '0', null, '2', '1', null),
('2400', '291', '东昌府区', '0', '0', null, '2', '1', null),
('2401', '291', '临清市', '0', '0', null, '2', '1', null),
('2402', '291', '阳谷县', '0', '0', null, '2', '1', null),
('2403', '291', '莘县', '0', '0', null, '2', '1', null),
('2404', '291', '茌平县', '0', '0', null, '2', '1', null),
('2405', '291', '东阿县', '0', '0', null, '2', '1', null),
('2406', '291', '冠县', '0', '0', null, '2', '1', null),
('2407', '291', '高唐县', '0', '0', null, '2', '1', null),
('2408', '292', '兰山区', '0', '0', null, '2', '1', null),
('2409', '292', '罗庄区', '0', '0', null, '2', '1', null),
('2410', '292', '河东区', '0', '0', null, '2', '1', null),
('2411', '292', '沂南县', '0', '0', null, '2', '1', null),
('2412', '292', '郯城县', '0', '0', null, '2', '1', null),
('2413', '292', '沂水县', '0', '0', null, '2', '1', null),
('2414', '292', '苍山县', '0', '0', null, '2', '1', null),
('2415', '292', '费县', '0', '0', null, '2', '1', null),
('2416', '292', '平邑县', '0', '0', null, '2', '1', null),
('2417', '292', '莒南县', '0', '0', null, '2', '1', null),
('2418', '292', '蒙阴县', '0', '0', null, '2', '1', null),
('2419', '292', '临沭县', '0', '0', null, '2', '1', null),
('2420', '293', '东港区', '0', '0', null, '2', '1', null),
('2421', '293', '岚山区', '0', '0', null, '2', '1', null),
('2422', '293', '五莲县', '0', '0', null, '2', '1', null),
('2423', '293', '莒县', '0', '0', null, '2', '1', null),
('2424', '294', '泰山区', '0', '0', null, '2', '1', null),
('2425', '294', '岱岳区', '0', '0', null, '2', '1', null),
('2426', '294', '新泰市', '0', '0', null, '2', '1', null),
('2427', '294', '肥城市', '0', '0', null, '2', '1', null),
('2428', '294', '宁阳县', '0', '0', null, '2', '1', null),
('2429', '294', '东平县', '0', '0', null, '2', '1', null),
('2430', '295', '荣成市', '0', '0', null, '2', '1', null),
('2431', '295', '乳山市', '0', '0', null, '2', '1', null),
('2432', '295', '环翠区', '0', '0', null, '2', '1', null),
('2433', '295', '文登市', '0', '0', null, '2', '1', null),
('2434', '296', '潍城区', '0', '0', null, '2', '1', null),
('2435', '296', '寒亭区', '0', '0', null, '2', '1', null),
('2436', '296', '坊子区', '0', '0', null, '2', '1', null),
('2437', '296', '奎文区', '0', '0', null, '2', '1', null),
('2438', '296', '青州市', '0', '0', null, '2', '1', null),
('2439', '296', '诸城市', '0', '0', null, '2', '1', null),
('2440', '296', '寿光市', '0', '0', null, '2', '1', null),
('2441', '296', '安丘市', '0', '0', null, '2', '1', null),
('2442', '296', '高密市', '0', '0', null, '2', '1', null),
('2443', '296', '昌邑市', '0', '0', null, '2', '1', null),
('2444', '296', '临朐县', '0', '0', null, '2', '1', null),
('2445', '296', '昌乐县', '0', '0', null, '2', '1', null),
('2446', '297', '芝罘区', '0', '0', null, '2', '1', null),
('2447', '297', '福山区', '0', '0', null, '2', '1', null),
('2448', '297', '牟平区', '0', '0', null, '2', '1', null),
('2449', '297', '莱山区', '0', '0', null, '2', '1', null),
('2450', '297', '开发区', '0', '0', null, '2', '1', null),
('2451', '297', '龙口市', '0', '0', null, '2', '1', null),
('2452', '297', '莱阳市', '0', '0', null, '2', '1', null),
('2453', '297', '莱州市', '0', '0', null, '2', '1', null),
('2454', '297', '蓬莱市', '0', '0', null, '2', '1', null),
('2455', '297', '招远市', '0', '0', null, '2', '1', null),
('2456', '297', '栖霞市', '0', '0', null, '2', '1', null),
('2457', '297', '海阳市', '0', '0', null, '2', '1', null),
('2458', '297', '长岛县', '0', '0', null, '2', '1', null),
('2459', '298', '市中区', '0', '0', null, '2', '1', null),
('2460', '298', '山亭区', '0', '0', null, '2', '1', null),
('2461', '298', '峄城区', '0', '0', null, '2', '1', null),
('2462', '298', '台儿庄区', '0', '0', null, '2', '1', null),
('2463', '298', '薛城区', '0', '0', null, '2', '1', null),
('2464', '298', '滕州市', '0', '0', null, '2', '1', null),
('2465', '299', '张店区', '0', '0', null, '2', '1', null),
('2466', '299', '临淄区', '0', '0', null, '2', '1', null),
('2467', '299', '淄川区', '0', '0', null, '2', '1', null),
('2468', '299', '博山区', '0', '0', null, '2', '1', null),
('2469', '299', '周村区', '0', '0', null, '2', '1', null),
('2470', '299', '桓台县', '0', '0', null, '2', '1', null),
('2471', '299', '高青县', '0', '0', null, '2', '1', null),
('2472', '299', '沂源县', '0', '0', null, '2', '1', null),
('2473', '300', '杏花岭区', '0', '0', null, '2', '1', null),
('2474', '300', '小店区', '0', '0', null, '2', '1', null),
('2475', '300', '迎泽区', '0', '0', null, '2', '1', null),
('2476', '300', '尖草坪区', '0', '0', null, '2', '1', null),
('2477', '300', '万柏林区', '0', '0', null, '2', '1', null),
('2478', '300', '晋源区', '0', '0', null, '2', '1', null),
('2479', '300', '高新开发区', '0', '0', null, '2', '1', null),
('2480', '300', '民营经济开发区', '0', '0', null, '2', '1', null),
('2481', '300', '经济技术开发区', '0', '0', null, '2', '1', null),
('2482', '300', '清徐县', '0', '0', null, '2', '1', null),
('2483', '300', '阳曲县', '0', '0', null, '2', '1', null),
('2484', '300', '娄烦县', '0', '0', null, '2', '1', null),
('2485', '300', '古交市', '0', '0', null, '2', '1', null),
('2486', '301', '城区', '0', '0', null, '2', '1', null),
('2487', '301', '郊区', '0', '0', null, '2', '1', null),
('2488', '301', '沁县', '0', '0', null, '2', '1', null),
('2489', '301', '潞城市', '0', '0', null, '2', '1', null),
('2490', '301', '长治县', '0', '0', null, '2', '1', null),
('2491', '301', '襄垣县', '0', '0', null, '2', '1', null),
('2492', '301', '屯留县', '0', '0', null, '2', '1', null),
('2493', '301', '平顺县', '0', '0', null, '2', '1', null),
('2494', '301', '黎城县', '0', '0', null, '2', '1', null),
('2495', '301', '壶关县', '0', '0', null, '2', '1', null),
('2496', '301', '长子县', '0', '0', null, '2', '1', null),
('2497', '301', '武乡县', '0', '0', null, '2', '1', null),
('2498', '301', '沁源县', '0', '0', null, '2', '1', null),
('2499', '302', '城区', '0', '0', null, '2', '1', null),
('2500', '302', '矿区', '0', '0', null, '2', '1', null),
('2501', '302', '南郊区', '0', '0', null, '2', '1', null),
('2502', '302', '新荣区', '0', '0', null, '2', '1', null),
('2503', '302', '阳高县', '0', '0', null, '2', '1', null),
('2504', '302', '天镇县', '0', '0', null, '2', '1', null),
('2505', '302', '广灵县', '0', '0', null, '2', '1', null),
('2506', '302', '灵丘县', '0', '0', null, '2', '1', null),
('2507', '302', '浑源县', '0', '0', null, '2', '1', null),
('2508', '302', '左云县', '0', '0', null, '2', '1', null),
('2509', '302', '大同县', '0', '0', null, '2', '1', null),
('2510', '303', '城区', '0', '0', null, '2', '1', null),
('2511', '303', '高平市', '0', '0', null, '2', '1', null),
('2512', '303', '沁水县', '0', '0', null, '2', '1', null),
('2513', '303', '阳城县', '0', '0', null, '2', '1', null),
('2514', '303', '陵川县', '0', '0', null, '2', '1', null),
('2515', '303', '泽州县', '0', '0', null, '2', '1', null),
('2516', '304', '榆次区', '0', '0', null, '2', '1', null),
('2517', '304', '介休市', '0', '0', null, '2', '1', null),
('2518', '304', '榆社县', '0', '0', null, '2', '1', null),
('2519', '304', '左权县', '0', '0', null, '2', '1', null),
('2520', '304', '和顺县', '0', '0', null, '2', '1', null),
('2521', '304', '昔阳县', '0', '0', null, '2', '1', null),
('2522', '304', '寿阳县', '0', '0', null, '2', '1', null),
('2523', '304', '太谷县', '0', '0', null, '2', '1', null),
('2524', '304', '祁县', '0', '0', null, '2', '1', null),
('2525', '304', '平遥县', '0', '0', null, '2', '1', null),
('2526', '304', '灵石县', '0', '0', null, '2', '1', null),
('2527', '305', '尧都区', '0', '0', null, '2', '1', null),
('2528', '305', '侯马市', '0', '0', null, '2', '1', null);
INSERT INTO `wst_areas` VALUES ('2529', '305', '霍州市', '0', '0', null, '2', '1', null),
('2530', '305', '曲沃县', '0', '0', null, '2', '1', null),
('2531', '305', '翼城县', '0', '0', null, '2', '1', null),
('2532', '305', '襄汾县', '0', '0', null, '2', '1', null),
('2533', '305', '洪洞县', '0', '0', null, '2', '1', null),
('2534', '305', '吉县', '0', '0', null, '2', '1', null),
('2535', '305', '安泽县', '0', '0', null, '2', '1', null),
('2536', '305', '浮山县', '0', '0', null, '2', '1', null),
('2537', '305', '古县', '0', '0', null, '2', '1', null),
('2538', '305', '乡宁县', '0', '0', null, '2', '1', null),
('2539', '305', '大宁县', '0', '0', null, '2', '1', null),
('2540', '305', '隰县', '0', '0', null, '2', '1', null),
('2541', '305', '永和县', '0', '0', null, '2', '1', null),
('2542', '305', '蒲县', '0', '0', null, '2', '1', null),
('2543', '305', '汾西县', '0', '0', null, '2', '1', null),
('2544', '306', '离石市', '0', '0', null, '2', '1', null),
('2545', '306', '离石区', '0', '0', null, '2', '1', null),
('2546', '306', '孝义市', '0', '0', null, '2', '1', null),
('2547', '306', '汾阳市', '0', '0', null, '2', '1', null),
('2548', '306', '文水县', '0', '0', null, '2', '1', null),
('2549', '306', '交城县', '0', '0', null, '2', '1', null),
('2550', '306', '兴县', '0', '0', null, '2', '1', null),
('2551', '306', '临县', '0', '0', null, '2', '1', null),
('2552', '306', '柳林县', '0', '0', null, '2', '1', null),
('2553', '306', '石楼县', '0', '0', null, '2', '1', null),
('2554', '306', '岚县', '0', '0', null, '2', '1', null),
('2555', '306', '方山县', '0', '0', null, '2', '1', null),
('2556', '306', '中阳县', '0', '0', null, '2', '1', null),
('2557', '306', '交口县', '0', '0', null, '2', '1', null),
('2558', '307', '朔城区', '0', '0', null, '2', '1', null),
('2559', '307', '平鲁区', '0', '0', null, '2', '1', null),
('2560', '307', '山阴县', '0', '0', null, '2', '1', null),
('2561', '307', '应县', '0', '0', null, '2', '1', null),
('2562', '307', '右玉县', '0', '0', null, '2', '1', null),
('2563', '307', '怀仁县', '0', '0', null, '2', '1', null),
('2564', '308', '忻府区', '0', '0', null, '2', '1', null),
('2565', '308', '原平市', '0', '0', null, '2', '1', null),
('2566', '308', '定襄县', '0', '0', null, '2', '1', null),
('2567', '308', '五台县', '0', '0', null, '2', '1', null),
('2568', '308', '代县', '0', '0', null, '2', '1', null),
('2569', '308', '繁峙县', '0', '0', null, '2', '1', null),
('2570', '308', '宁武县', '0', '0', null, '2', '1', null),
('2571', '308', '静乐县', '0', '0', null, '2', '1', null),
('2572', '308', '神池县', '0', '0', null, '2', '1', null),
('2573', '308', '五寨县', '0', '0', null, '2', '1', null),
('2574', '308', '岢岚县', '0', '0', null, '2', '1', null),
('2575', '308', '河曲县', '0', '0', null, '2', '1', null),
('2576', '308', '保德县', '0', '0', null, '2', '1', null),
('2577', '308', '偏关县', '0', '0', null, '2', '1', null),
('2578', '309', '城区', '0', '0', null, '2', '1', null),
('2579', '309', '矿区', '0', '0', null, '2', '1', null),
('2580', '309', '郊区', '0', '0', null, '2', '1', null),
('2581', '309', '平定县', '0', '0', null, '2', '1', null),
('2582', '309', '盂县', '0', '0', null, '2', '1', null),
('2583', '310', '盐湖区', '0', '0', null, '2', '1', null),
('2584', '310', '永济市', '0', '0', null, '2', '1', null),
('2585', '310', '河津市', '0', '0', null, '2', '1', null),
('2586', '310', '临猗县', '0', '0', null, '2', '1', null),
('2587', '310', '万荣县', '0', '0', null, '2', '1', null),
('2588', '310', '闻喜县', '0', '0', null, '2', '1', null),
('2589', '310', '稷山县', '0', '0', null, '2', '1', null),
('2590', '310', '新绛县', '0', '0', null, '2', '1', null),
('2591', '310', '绛县', '0', '0', null, '2', '1', null),
('2592', '310', '垣曲县', '0', '0', null, '2', '1', null),
('2593', '310', '夏县', '0', '0', null, '2', '1', null),
('2594', '310', '平陆县', '0', '0', null, '2', '1', null),
('2595', '310', '芮城县', '0', '0', null, '2', '1', null),
('2596', '311', '莲湖区', '0', '0', null, '2', '1', null),
('2597', '311', '新城区', '0', '0', null, '2', '1', null),
('2598', '311', '碑林区', '0', '0', null, '2', '1', null),
('2599', '311', '雁塔区', '0', '0', null, '2', '1', null),
('2600', '311', '灞桥区', '0', '0', null, '2', '1', null),
('2601', '311', '未央区', '0', '0', null, '2', '1', null),
('2602', '311', '阎良区', '0', '0', null, '2', '1', null),
('2603', '311', '临潼区', '0', '0', null, '2', '1', null),
('2604', '311', '长安区', '0', '0', null, '2', '1', null),
('2605', '311', '蓝田县', '0', '0', null, '2', '1', null),
('2606', '311', '周至县', '0', '0', null, '2', '1', null),
('2607', '311', '户县', '0', '0', null, '2', '1', null),
('2608', '311', '高陵县', '0', '0', null, '2', '1', null),
('2609', '312', '汉滨区', '0', '0', null, '2', '1', null),
('2610', '312', '汉阴县', '0', '0', null, '2', '1', null),
('2611', '312', '石泉县', '0', '0', null, '2', '1', null),
('2612', '312', '宁陕县', '0', '0', null, '2', '1', null),
('2613', '312', '紫阳县', '0', '0', null, '2', '1', null),
('2614', '312', '岚皋县', '0', '0', null, '2', '1', null),
('2615', '312', '平利县', '0', '0', null, '2', '1', null),
('2616', '312', '镇坪县', '0', '0', null, '2', '1', null),
('2617', '312', '旬阳县', '0', '0', null, '2', '1', null),
('2618', '312', '白河县', '0', '0', null, '2', '1', null),
('2619', '313', '陈仓区', '0', '0', null, '2', '1', null),
('2620', '313', '渭滨区', '0', '0', null, '2', '1', null),
('2621', '313', '金台区', '0', '0', null, '2', '1', null),
('2622', '313', '凤翔县', '0', '0', null, '2', '1', null),
('2623', '313', '岐山县', '0', '0', null, '2', '1', null),
('2624', '313', '扶风县', '0', '0', null, '2', '1', null),
('2625', '313', '眉县', '0', '0', null, '2', '1', null),
('2626', '313', '陇县', '0', '0', null, '2', '1', null),
('2627', '313', '千阳县', '0', '0', null, '2', '1', null),
('2628', '313', '麟游县', '0', '0', null, '2', '1', null),
('2629', '313', '凤县', '0', '0', null, '2', '1', null),
('2630', '313', '太白县', '0', '0', null, '2', '1', null),
('2631', '314', '汉台区', '0', '0', null, '2', '1', null),
('2632', '314', '南郑县', '0', '0', null, '2', '1', null),
('2633', '314', '城固县', '0', '0', null, '2', '1', null),
('2634', '314', '洋县', '0', '0', null, '2', '1', null),
('2635', '314', '西乡县', '0', '0', null, '2', '1', null),
('2636', '314', '勉县', '0', '0', null, '2', '1', null),
('2637', '314', '宁强县', '0', '0', null, '2', '1', null),
('2638', '314', '略阳县', '0', '0', null, '2', '1', null),
('2639', '314', '镇巴县', '0', '0', null, '2', '1', null),
('2640', '314', '留坝县', '0', '0', null, '2', '1', null),
('2641', '314', '佛坪县', '0', '0', null, '2', '1', null),
('2642', '315', '商州区', '0', '0', null, '2', '1', null),
('2643', '315', '洛南县', '0', '0', null, '2', '1', null),
('2644', '315', '丹凤县', '0', '0', null, '2', '1', null),
('2645', '315', '商南县', '0', '0', null, '2', '1', null),
('2646', '315', '山阳县', '0', '0', null, '2', '1', null),
('2647', '315', '镇安县', '0', '0', null, '2', '1', null),
('2648', '315', '柞水县', '0', '0', null, '2', '1', null),
('2649', '316', '耀州区', '0', '0', null, '2', '1', null),
('2650', '316', '王益区', '0', '0', null, '2', '1', null),
('2651', '316', '印台区', '0', '0', null, '2', '1', null),
('2652', '316', '宜君县', '0', '0', null, '2', '1', null),
('2653', '317', '临渭区', '0', '0', null, '2', '1', null),
('2654', '317', '韩城市', '0', '0', null, '2', '1', null),
('2655', '317', '华阴市', '0', '0', null, '2', '1', null),
('2656', '317', '华县', '0', '0', null, '2', '1', null),
('2657', '317', '潼关县', '0', '0', null, '2', '1', null),
('2658', '317', '大荔县', '0', '0', null, '2', '1', null),
('2659', '317', '合阳县', '0', '0', null, '2', '1', null),
('2660', '317', '澄城县', '0', '0', null, '2', '1', null),
('2661', '317', '蒲城县', '0', '0', null, '2', '1', null),
('2662', '317', '白水县', '0', '0', null, '2', '1', null),
('2663', '317', '富平县', '0', '0', null, '2', '1', null),
('2664', '318', '秦都区', '0', '0', null, '2', '1', null),
('2665', '318', '渭城区', '0', '0', null, '2', '1', null),
('2666', '318', '杨陵区', '0', '0', null, '2', '1', null),
('2667', '318', '兴平市', '0', '0', null, '2', '1', null),
('2668', '318', '三原县', '0', '0', null, '2', '1', null),
('2669', '318', '泾阳县', '0', '0', null, '2', '1', null),
('2670', '318', '乾县', '0', '0', null, '2', '1', null),
('2671', '318', '礼泉县', '0', '0', null, '2', '1', null),
('2672', '318', '永寿县', '0', '0', null, '2', '1', null),
('2673', '318', '彬县', '0', '0', null, '2', '1', null),
('2674', '318', '长武县', '0', '0', null, '2', '1', null),
('2675', '318', '旬邑县', '0', '0', null, '2', '1', null),
('2676', '318', '淳化县', '0', '0', null, '2', '1', null),
('2677', '318', '武功县', '0', '0', null, '2', '1', null),
('2678', '319', '吴起县', '0', '0', null, '2', '1', null),
('2679', '319', '宝塔区', '0', '0', null, '2', '1', null),
('2680', '319', '延长县', '0', '0', null, '2', '1', null),
('2681', '319', '延川县', '0', '0', null, '2', '1', null),
('2682', '319', '子长县', '0', '0', null, '2', '1', null),
('2683', '319', '安塞县', '0', '0', null, '2', '1', null),
('2684', '319', '志丹县', '0', '0', null, '2', '1', null),
('2685', '319', '甘泉县', '0', '0', null, '2', '1', null),
('2686', '319', '富县', '0', '0', null, '2', '1', null),
('2687', '319', '洛川县', '0', '0', null, '2', '1', null),
('2688', '319', '宜川县', '0', '0', null, '2', '1', null),
('2689', '319', '黄龙县', '0', '0', null, '2', '1', null),
('2690', '319', '黄陵县', '0', '0', null, '2', '1', null),
('2691', '320', '榆阳区', '0', '0', null, '2', '1', null),
('2692', '320', '神木县', '0', '0', null, '2', '1', null),
('2693', '320', '府谷县', '0', '0', null, '2', '1', null),
('2694', '320', '横山县', '0', '0', null, '2', '1', null),
('2695', '320', '靖边县', '0', '0', null, '2', '1', null),
('2696', '320', '定边县', '0', '0', null, '2', '1', null),
('2697', '320', '绥德县', '0', '0', null, '2', '1', null),
('2698', '320', '米脂县', '0', '0', null, '2', '1', null),
('2699', '320', '佳县', '0', '0', null, '2', '1', null),
('2700', '320', '吴堡县', '0', '0', null, '2', '1', null),
('2701', '320', '清涧县', '0', '0', null, '2', '1', null),
('2702', '320', '子洲县', '0', '0', null, '2', '1', null),
('2703', '321', '长宁区', '1', '0', null, '2', '1', null),
('2704', '321', '闸北区', '1', '0', null, '2', '1', null),
('2705', '321', '闵行区', '1', '0', null, '2', '1', null),
('2706', '321', '徐汇区', '1', '0', null, '2', '1', null),
('2707', '321', '浦东新区', '1', '0', null, '2', '1', null),
('2708', '321', '杨浦区', '1', '0', null, '2', '1', null),
('2709', '321', '普陀区', '1', '0', null, '2', '1', null),
('2710', '321', '静安区', '1', '0', null, '2', '1', null),
('2711', '321', '卢湾区', '1', '0', null, '2', '1', null),
('2712', '321', '虹口区', '1', '0', null, '2', '1', null),
('2713', '321', '黄浦区', '1', '0', null, '2', '1', null),
('2714', '321', '南汇区', '1', '0', null, '2', '1', null),
('2715', '321', '松江区', '1', '0', null, '2', '1', null),
('2716', '321', '嘉定区', '1', '0', null, '2', '1', null),
('2717', '321', '宝山区', '1', '0', null, '2', '1', null),
('2718', '321', '青浦区', '1', '0', null, '2', '1', null),
('2719', '321', '金山区', '1', '0', null, '2', '1', null),
('2720', '321', '奉贤区', '1', '0', null, '2', '1', null),
('2721', '321', '崇明县', '1', '0', null, '2', '1', null),
('2722', '322', '青羊区', '0', '0', null, '2', '1', null),
('2723', '322', '锦江区', '0', '0', null, '2', '1', null),
('2724', '322', '金牛区', '0', '0', null, '2', '1', null),
('2725', '322', '武侯区', '0', '0', null, '2', '1', null),
('2726', '322', '成华区', '0', '0', null, '2', '1', null),
('2727', '322', '龙泉驿区', '0', '0', null, '2', '1', null),
('2728', '322', '青白江区', '0', '0', null, '2', '1', null),
('2729', '322', '新都区', '0', '0', null, '2', '1', null),
('2730', '322', '温江区', '0', '0', null, '2', '1', null),
('2731', '322', '高新区', '0', '0', null, '2', '1', null),
('2732', '322', '高新西区', '0', '0', null, '2', '1', null),
('2733', '322', '都江堰市', '0', '0', null, '2', '1', null),
('2734', '322', '彭州市', '0', '0', null, '2', '1', null),
('2735', '322', '邛崃市', '0', '0', null, '2', '1', null),
('2736', '322', '崇州市', '0', '0', null, '2', '1', null),
('2737', '322', '金堂县', '0', '0', null, '2', '1', null),
('2738', '322', '双流县', '0', '0', null, '2', '1', null),
('2739', '322', '郫县', '0', '0', null, '2', '1', null),
('2740', '322', '大邑县', '0', '0', null, '2', '1', null),
('2741', '322', '蒲江县', '0', '0', null, '2', '1', null),
('2742', '322', '新津县', '0', '0', null, '2', '1', null),
('2743', '322', '都江堰市', '0', '0', null, '2', '1', null),
('2744', '322', '彭州市', '0', '0', null, '2', '1', null),
('2745', '322', '邛崃市', '0', '0', null, '2', '1', null),
('2746', '322', '崇州市', '0', '0', null, '2', '1', null),
('2747', '322', '金堂县', '0', '0', null, '2', '1', null),
('2748', '322', '双流县', '0', '0', null, '2', '1', null),
('2749', '322', '郫县', '0', '0', null, '2', '1', null),
('2750', '322', '大邑县', '0', '0', null, '2', '1', null),
('2751', '322', '蒲江县', '0', '0', null, '2', '1', null),
('2752', '322', '新津县', '0', '0', null, '2', '1', null),
('2753', '323', '涪城区', '0', '0', null, '2', '1', null),
('2754', '323', '游仙区', '0', '0', null, '2', '1', null),
('2755', '323', '江油市', '0', '0', null, '2', '1', null),
('2756', '323', '盐亭县', '0', '0', null, '2', '1', null),
('2757', '323', '三台县', '0', '0', null, '2', '1', null),
('2758', '323', '平武县', '0', '0', null, '2', '1', null),
('2759', '323', '安县', '0', '0', null, '2', '1', null),
('2760', '323', '梓潼县', '0', '0', null, '2', '1', null),
('2761', '323', '北川县', '0', '0', null, '2', '1', null),
('2762', '324', '马尔康县', '0', '0', null, '2', '1', null),
('2763', '324', '汶川县', '0', '0', null, '2', '1', null),
('2764', '324', '理县', '0', '0', null, '2', '1', null),
('2765', '324', '茂县', '0', '0', null, '2', '1', null),
('2766', '324', '松潘县', '0', '0', null, '2', '1', null),
('2767', '324', '九寨沟县', '0', '0', null, '2', '1', null),
('2768', '324', '金川县', '0', '0', null, '2', '1', null),
('2769', '324', '小金县', '0', '0', null, '2', '1', null),
('2770', '324', '黑水县', '0', '0', null, '2', '1', null),
('2771', '324', '壤塘县', '0', '0', null, '2', '1', null),
('2772', '324', '阿坝县', '0', '0', null, '2', '1', null),
('2773', '324', '若尔盖县', '0', '0', null, '2', '1', null),
('2774', '324', '红原县', '0', '0', null, '2', '1', null),
('2775', '325', '巴州区', '0', '0', null, '2', '1', null),
('2776', '325', '通江县', '0', '0', null, '2', '1', null),
('2777', '325', '南江县', '0', '0', null, '2', '1', null),
('2778', '325', '平昌县', '0', '0', null, '2', '1', null),
('2779', '326', '通川区', '0', '0', null, '2', '1', null),
('2780', '326', '万源市', '0', '0', null, '2', '1', null),
('2781', '326', '达县', '0', '0', null, '2', '1', null),
('2782', '326', '宣汉县', '0', '0', null, '2', '1', null),
('2783', '326', '开江县', '0', '0', null, '2', '1', null),
('2784', '326', '大竹县', '0', '0', null, '2', '1', null),
('2785', '326', '渠县', '0', '0', null, '2', '1', null),
('2786', '327', '旌阳区', '0', '0', null, '2', '1', null),
('2787', '327', '广汉市', '0', '0', null, '2', '1', null),
('2788', '327', '什邡市', '0', '0', null, '2', '1', null),
('2789', '327', '绵竹市', '0', '0', null, '2', '1', null),
('2790', '327', '罗江县', '0', '0', null, '2', '1', null),
('2791', '327', '中江县', '0', '0', null, '2', '1', null),
('2792', '328', '康定县', '0', '0', null, '2', '1', null),
('2793', '328', '丹巴县', '0', '0', null, '2', '1', null),
('2794', '328', '泸定县', '0', '0', null, '2', '1', null),
('2795', '328', '炉霍县', '0', '0', null, '2', '1', null),
('2796', '328', '九龙县', '0', '0', null, '2', '1', null),
('2797', '328', '甘孜县', '0', '0', null, '2', '1', null),
('2798', '328', '雅江县', '0', '0', null, '2', '1', null),
('2799', '328', '新龙县', '0', '0', null, '2', '1', null),
('2800', '328', '道孚县', '0', '0', null, '2', '1', null),
('2801', '328', '白玉县', '0', '0', null, '2', '1', null),
('2802', '328', '理塘县', '0', '0', null, '2', '1', null),
('2803', '328', '德格县', '0', '0', null, '2', '1', null),
('2804', '328', '乡城县', '0', '0', null, '2', '1', null),
('2805', '328', '石渠县', '0', '0', null, '2', '1', null),
('2806', '328', '稻城县', '0', '0', null, '2', '1', null),
('2807', '328', '色达县', '0', '0', null, '2', '1', null),
('2808', '328', '巴塘县', '0', '0', null, '2', '1', null),
('2809', '328', '得荣县', '0', '0', null, '2', '1', null),
('2810', '329', '广安区', '0', '0', null, '2', '1', null),
('2811', '329', '华蓥市', '0', '0', null, '2', '1', null),
('2812', '329', '岳池县', '0', '0', null, '2', '1', null),
('2813', '329', '武胜县', '0', '0', null, '2', '1', null),
('2814', '329', '邻水县', '0', '0', null, '2', '1', null),
('2815', '330', '利州区', '0', '0', null, '2', '1', null),
('2816', '330', '元坝区', '0', '0', null, '2', '1', null),
('2817', '330', '朝天区', '0', '0', null, '2', '1', null),
('2818', '330', '旺苍县', '0', '0', null, '2', '1', null),
('2819', '330', '青川县', '0', '0', null, '2', '1', null),
('2820', '330', '剑阁县', '0', '0', null, '2', '1', null),
('2821', '330', '苍溪县', '0', '0', null, '2', '1', null),
('2822', '331', '峨眉山市', '0', '0', null, '2', '1', null),
('2823', '331', '乐山市', '0', '0', null, '2', '1', null),
('2824', '331', '犍为县', '0', '0', null, '2', '1', null),
('2825', '331', '井研县', '0', '0', null, '2', '1', null),
('2826', '331', '夹江县', '0', '0', null, '2', '1', null),
('2827', '331', '沐川县', '0', '0', null, '2', '1', null),
('2828', '331', '峨边', '0', '0', null, '2', '1', null),
('2829', '331', '马边', '0', '0', null, '2', '1', null),
('2830', '332', '西昌市', '0', '0', null, '2', '1', null),
('2831', '332', '盐源县', '0', '0', null, '2', '1', null),
('2832', '332', '德昌县', '0', '0', null, '2', '1', null),
('2833', '332', '会理县', '0', '0', null, '2', '1', null),
('2834', '332', '会东县', '0', '0', null, '2', '1', null),
('2835', '332', '宁南县', '0', '0', null, '2', '1', null),
('2836', '332', '普格县', '0', '0', null, '2', '1', null),
('2837', '332', '布拖县', '0', '0', null, '2', '1', null);
INSERT INTO `wst_areas` VALUES ('2838', '332', '金阳县', '0', '0', null, '2', '1', null),
('2839', '332', '昭觉县', '0', '0', null, '2', '1', null),
('2840', '332', '喜德县', '0', '0', null, '2', '1', null),
('2841', '332', '冕宁县', '0', '0', null, '2', '1', null),
('2842', '332', '越西县', '0', '0', null, '2', '1', null),
('2843', '332', '甘洛县', '0', '0', null, '2', '1', null),
('2844', '332', '美姑县', '0', '0', null, '2', '1', null),
('2845', '332', '雷波县', '0', '0', null, '2', '1', null),
('2846', '332', '木里', '0', '0', null, '2', '1', null),
('2847', '333', '东坡区', '0', '0', null, '2', '1', null),
('2848', '333', '仁寿县', '0', '0', null, '2', '1', null),
('2849', '333', '彭山县', '0', '0', null, '2', '1', null),
('2850', '333', '洪雅县', '0', '0', null, '2', '1', null),
('2851', '333', '丹棱县', '0', '0', null, '2', '1', null),
('2852', '333', '青神县', '0', '0', null, '2', '1', null),
('2853', '334', '阆中市', '0', '0', null, '2', '1', null),
('2854', '334', '南部县', '0', '0', null, '2', '1', null),
('2855', '334', '营山县', '0', '0', null, '2', '1', null),
('2856', '334', '蓬安县', '0', '0', null, '2', '1', null),
('2857', '334', '仪陇县', '0', '0', null, '2', '1', null),
('2858', '334', '顺庆区', '0', '0', null, '2', '1', null),
('2859', '334', '高坪区', '0', '0', null, '2', '1', null),
('2860', '334', '嘉陵区', '0', '0', null, '2', '1', null),
('2861', '334', '西充县', '0', '0', null, '2', '1', null),
('2862', '335', '市中区', '0', '0', null, '2', '1', null),
('2863', '335', '东兴区', '0', '0', null, '2', '1', null),
('2864', '335', '威远县', '0', '0', null, '2', '1', null),
('2865', '335', '资中县', '0', '0', null, '2', '1', null),
('2866', '335', '隆昌县', '0', '0', null, '2', '1', null),
('2867', '336', '东  区', '0', '0', null, '2', '1', null),
('2868', '336', '西  区', '0', '0', null, '2', '1', null),
('2869', '336', '仁和区', '0', '0', null, '2', '1', null),
('2870', '336', '米易县', '0', '0', null, '2', '1', null),
('2871', '336', '盐边县', '0', '0', null, '2', '1', null),
('2872', '337', '船山区', '0', '0', null, '2', '1', null),
('2873', '337', '安居区', '0', '0', null, '2', '1', null),
('2874', '337', '蓬溪县', '0', '0', null, '2', '1', null),
('2875', '337', '射洪县', '0', '0', null, '2', '1', null),
('2876', '337', '大英县', '0', '0', null, '2', '1', null),
('2877', '338', '雨城区', '0', '0', null, '2', '1', null),
('2878', '338', '名山县', '0', '0', null, '2', '1', null),
('2879', '338', '荥经县', '0', '0', null, '2', '1', null),
('2880', '338', '汉源县', '0', '0', null, '2', '1', null),
('2881', '338', '石棉县', '0', '0', null, '2', '1', null),
('2882', '338', '天全县', '0', '0', null, '2', '1', null),
('2883', '338', '芦山县', '0', '0', null, '2', '1', null),
('2884', '338', '宝兴县', '0', '0', null, '2', '1', null),
('2885', '339', '翠屏区', '0', '0', null, '2', '1', null),
('2886', '339', '宜宾县', '0', '0', null, '2', '1', null),
('2887', '339', '南溪县', '0', '0', null, '2', '1', null),
('2888', '339', '江安县', '0', '0', null, '2', '1', null),
('2889', '339', '长宁县', '0', '0', null, '2', '1', null),
('2890', '339', '高县', '0', '0', null, '2', '1', null),
('2891', '339', '珙县', '0', '0', null, '2', '1', null),
('2892', '339', '筠连县', '0', '0', null, '2', '1', null),
('2893', '339', '兴文县', '0', '0', null, '2', '1', null),
('2894', '339', '屏山县', '0', '0', null, '2', '1', null),
('2895', '340', '雁江区', '0', '0', null, '2', '1', null),
('2896', '340', '简阳市', '0', '0', null, '2', '1', null),
('2897', '340', '安岳县', '0', '0', null, '2', '1', null),
('2898', '340', '乐至县', '0', '0', null, '2', '1', null),
('2899', '341', '大安区', '0', '0', null, '2', '1', null),
('2900', '341', '自流井区', '0', '0', null, '2', '1', null),
('2901', '341', '贡井区', '0', '0', null, '2', '1', null),
('2902', '341', '沿滩区', '0', '0', null, '2', '1', null),
('2903', '341', '荣县', '0', '0', null, '2', '1', null),
('2904', '341', '富顺县', '0', '0', null, '2', '1', null),
('2905', '342', '江阳区', '0', '0', null, '2', '1', null),
('2906', '342', '纳溪区', '0', '0', null, '2', '1', null),
('2907', '342', '龙马潭区', '0', '0', null, '2', '1', null),
('2908', '342', '泸县', '0', '0', null, '2', '1', null),
('2909', '342', '合江县', '0', '0', null, '2', '1', null),
('2910', '342', '叙永县', '0', '0', null, '2', '1', null),
('2911', '342', '古蔺县', '0', '0', null, '2', '1', null),
('2912', '343', '和平区', '0', '0', null, '2', '1', null),
('2913', '343', '河西区', '0', '0', null, '2', '1', null),
('2914', '343', '南开区', '0', '0', null, '2', '1', null),
('2915', '343', '河北区', '0', '0', null, '2', '1', null),
('2916', '343', '河东区', '0', '0', null, '2', '1', null),
('2917', '343', '红桥区', '0', '0', null, '2', '1', null),
('2918', '343', '东丽区', '0', '0', null, '2', '1', null),
('2919', '343', '津南区', '0', '0', null, '2', '1', null),
('2920', '343', '西青区', '0', '0', null, '2', '1', null),
('2921', '343', '北辰区', '0', '0', null, '2', '1', null),
('2922', '343', '塘沽区', '0', '0', null, '2', '1', null),
('2923', '343', '汉沽区', '0', '0', null, '2', '1', null),
('2924', '343', '大港区', '0', '0', null, '2', '1', null),
('2925', '343', '武清区', '0', '0', null, '2', '1', null),
('2926', '343', '宝坻区', '0', '0', null, '2', '1', null),
('2927', '343', '经济开发区', '0', '0', null, '2', '1', null),
('2928', '343', '宁河县', '0', '0', null, '2', '1', null),
('2929', '343', '静海县', '0', '0', null, '2', '1', null),
('2930', '343', '蓟县', '0', '0', null, '2', '1', null),
('2931', '344', '城关区', '0', '0', null, '2', '1', null),
('2932', '344', '林周县', '0', '0', null, '2', '1', null),
('2933', '344', '当雄县', '0', '0', null, '2', '1', null),
('2934', '344', '尼木县', '0', '0', null, '2', '1', null),
('2935', '344', '曲水县', '0', '0', null, '2', '1', null),
('2936', '344', '堆龙德庆县', '0', '0', null, '2', '1', null),
('2937', '344', '达孜县', '0', '0', null, '2', '1', null),
('2938', '344', '墨竹工卡县', '0', '0', null, '2', '1', null),
('2939', '345', '噶尔县', '0', '0', null, '2', '1', null),
('2940', '345', '普兰县', '0', '0', null, '2', '1', null),
('2941', '345', '札达县', '0', '0', null, '2', '1', null),
('2942', '345', '日土县', '0', '0', null, '2', '1', null),
('2943', '345', '革吉县', '0', '0', null, '2', '1', null),
('2944', '345', '改则县', '0', '0', null, '2', '1', null),
('2945', '345', '措勤县', '0', '0', null, '2', '1', null),
('2946', '346', '昌都县', '0', '0', null, '2', '1', null),
('2947', '346', '江达县', '0', '0', null, '2', '1', null),
('2948', '346', '贡觉县', '0', '0', null, '2', '1', null),
('2949', '346', '类乌齐县', '0', '0', null, '2', '1', null),
('2950', '346', '丁青县', '0', '0', null, '2', '1', null),
('2951', '346', '察雅县', '0', '0', null, '2', '1', null),
('2952', '346', '八宿县', '0', '0', null, '2', '1', null),
('2953', '346', '左贡县', '0', '0', null, '2', '1', null),
('2954', '346', '芒康县', '0', '0', null, '2', '1', null),
('2955', '346', '洛隆县', '0', '0', null, '2', '1', null),
('2956', '346', '边坝县', '0', '0', null, '2', '1', null),
('2957', '347', '林芝县', '0', '0', null, '2', '1', null),
('2958', '347', '工布江达县', '0', '0', null, '2', '1', null),
('2959', '347', '米林县', '0', '0', null, '2', '1', null),
('2960', '347', '墨脱县', '0', '0', null, '2', '1', null),
('2961', '347', '波密县', '0', '0', null, '2', '1', null),
('2962', '347', '察隅县', '0', '0', null, '2', '1', null),
('2963', '347', '朗县', '0', '0', null, '2', '1', null),
('2964', '348', '那曲县', '0', '0', null, '2', '1', null),
('2965', '348', '嘉黎县', '0', '0', null, '2', '1', null),
('2966', '348', '比如县', '0', '0', null, '2', '1', null),
('2967', '348', '聂荣县', '0', '0', null, '2', '1', null),
('2968', '348', '安多县', '0', '0', null, '2', '1', null),
('2969', '348', '申扎县', '0', '0', null, '2', '1', null),
('2970', '348', '索县', '0', '0', null, '2', '1', null),
('2971', '348', '班戈县', '0', '0', null, '2', '1', null),
('2972', '348', '巴青县', '0', '0', null, '2', '1', null),
('2973', '348', '尼玛县', '0', '0', null, '2', '1', null),
('2974', '349', '日喀则市', '0', '0', null, '2', '1', null),
('2975', '349', '南木林县', '0', '0', null, '2', '1', null),
('2976', '349', '江孜县', '0', '0', null, '2', '1', null),
('2977', '349', '定日县', '0', '0', null, '2', '1', null),
('2978', '349', '萨迦县', '0', '0', null, '2', '1', null),
('2979', '349', '拉孜县', '0', '0', null, '2', '1', null),
('2980', '349', '昂仁县', '0', '0', null, '2', '1', null),
('2981', '349', '谢通门县', '0', '0', null, '2', '1', null),
('2982', '349', '白朗县', '0', '0', null, '2', '1', null),
('2983', '349', '仁布县', '0', '0', null, '2', '1', null),
('2984', '349', '康马县', '0', '0', null, '2', '1', null),
('2985', '349', '定结县', '0', '0', null, '2', '1', null),
('2986', '349', '仲巴县', '0', '0', null, '2', '1', null),
('2987', '349', '亚东县', '0', '0', null, '2', '1', null),
('2988', '349', '吉隆县', '0', '0', null, '2', '1', null),
('2989', '349', '聂拉木县', '0', '0', null, '2', '1', null),
('2990', '349', '萨嘎县', '0', '0', null, '2', '1', null),
('2991', '349', '岗巴县', '0', '0', null, '2', '1', null),
('2992', '350', '乃东县', '0', '0', null, '2', '1', null),
('2993', '350', '扎囊县', '0', '0', null, '2', '1', null),
('2994', '350', '贡嘎县', '0', '0', null, '2', '1', null),
('2995', '350', '桑日县', '0', '0', null, '2', '1', null),
('2996', '350', '琼结县', '0', '0', null, '2', '1', null),
('2997', '350', '曲松县', '0', '0', null, '2', '1', null),
('2998', '350', '措美县', '0', '0', null, '2', '1', null),
('2999', '350', '洛扎县', '0', '0', null, '2', '1', null),
('3000', '350', '加查县', '0', '0', null, '2', '1', null),
('3001', '350', '隆子县', '0', '0', null, '2', '1', null),
('3002', '350', '错那县', '0', '0', null, '2', '1', null),
('3003', '350', '浪卡子县', '0', '0', null, '2', '1', null),
('3004', '351', '天山区', '0', '0', null, '2', '1', null),
('3005', '351', '沙依巴克区', '0', '0', null, '2', '1', null),
('3006', '351', '新市区', '0', '0', null, '2', '1', null),
('3007', '351', '水磨沟区', '0', '0', null, '2', '1', null),
('3008', '351', '头屯河区', '0', '0', null, '2', '1', null),
('3009', '351', '达坂城区', '0', '0', null, '2', '1', null),
('3010', '351', '米东区', '0', '0', null, '2', '1', null),
('3011', '351', '乌鲁木齐县', '0', '0', null, '2', '1', null),
('3012', '352', '阿克苏市', '0', '0', null, '2', '1', null),
('3013', '352', '温宿县', '0', '0', null, '2', '1', null),
('3014', '352', '库车县', '0', '0', null, '2', '1', null),
('3015', '352', '沙雅县', '0', '0', null, '2', '1', null),
('3016', '352', '新和县', '0', '0', null, '2', '1', null),
('3017', '352', '拜城县', '0', '0', null, '2', '1', null),
('3018', '352', '乌什县', '0', '0', null, '2', '1', null),
('3019', '352', '阿瓦提县', '0', '0', null, '2', '1', null),
('3020', '352', '柯坪县', '0', '0', null, '2', '1', null),
('3021', '353', '阿拉尔市', '0', '0', null, '2', '1', null),
('3022', '354', '库尔勒市', '0', '0', null, '2', '1', null),
('3023', '354', '轮台县', '0', '0', null, '2', '1', null),
('3024', '354', '尉犁县', '0', '0', null, '2', '1', null),
('3025', '354', '若羌县', '0', '0', null, '2', '1', null),
('3026', '354', '且末县', '0', '0', null, '2', '1', null),
('3027', '354', '焉耆', '0', '0', null, '2', '1', null),
('3028', '354', '和静县', '0', '0', null, '2', '1', null),
('3029', '354', '和硕县', '0', '0', null, '2', '1', null),
('3030', '354', '博湖县', '0', '0', null, '2', '1', null),
('3031', '355', '博乐市', '0', '0', null, '2', '1', null),
('3032', '355', '精河县', '0', '0', null, '2', '1', null),
('3033', '355', '温泉县', '0', '0', null, '2', '1', null),
('3034', '356', '呼图壁县', '0', '0', null, '2', '1', null),
('3035', '356', '米泉市', '0', '0', null, '2', '1', null),
('3036', '356', '昌吉市', '0', '0', null, '2', '1', null),
('3037', '356', '阜康市', '0', '0', null, '2', '1', null),
('3038', '356', '玛纳斯县', '0', '0', null, '2', '1', null),
('3039', '356', '奇台县', '0', '0', null, '2', '1', null),
('3040', '356', '吉木萨尔县', '0', '0', null, '2', '1', null),
('3041', '356', '木垒', '0', '0', null, '2', '1', null),
('3042', '357', '哈密市', '0', '0', null, '2', '1', null),
('3043', '357', '伊吾县', '0', '0', null, '2', '1', null),
('3044', '357', '巴里坤', '0', '0', null, '2', '1', null),
('3045', '358', '和田市', '0', '0', null, '2', '1', null),
('3046', '358', '和田县', '0', '0', null, '2', '1', null),
('3047', '358', '墨玉县', '0', '0', null, '2', '1', null),
('3048', '358', '皮山县', '0', '0', null, '2', '1', null),
('3049', '358', '洛浦县', '0', '0', null, '2', '1', null),
('3050', '358', '策勒县', '0', '0', null, '2', '1', null),
('3051', '358', '于田县', '0', '0', null, '2', '1', null),
('3052', '358', '民丰县', '0', '0', null, '2', '1', null),
('3053', '359', '喀什市', '0', '0', null, '2', '1', null),
('3054', '359', '疏附县', '0', '0', null, '2', '1', null),
('3055', '359', '疏勒县', '0', '0', null, '2', '1', null),
('3056', '359', '英吉沙县', '0', '0', null, '2', '1', null),
('3057', '359', '泽普县', '0', '0', null, '2', '1', null),
('3058', '359', '莎车县', '0', '0', null, '2', '1', null),
('3059', '359', '叶城县', '0', '0', null, '2', '1', null),
('3060', '359', '麦盖提县', '0', '0', null, '2', '1', null),
('3061', '359', '岳普湖县', '0', '0', null, '2', '1', null),
('3062', '359', '伽师县', '0', '0', null, '2', '1', null),
('3063', '359', '巴楚县', '0', '0', null, '2', '1', null),
('3064', '359', '塔什库尔干', '0', '0', null, '2', '1', null),
('3065', '360', '克拉玛依市', '0', '0', null, '2', '1', null),
('3066', '361', '阿图什市', '0', '0', null, '2', '1', null),
('3067', '361', '阿克陶县', '0', '0', null, '2', '1', null),
('3068', '361', '阿合奇县', '0', '0', null, '2', '1', null),
('3069', '361', '乌恰县', '0', '0', null, '2', '1', null),
('3070', '362', '石河子市', '0', '0', null, '2', '1', null),
('3071', '363', '图木舒克市', '0', '0', null, '2', '1', null),
('3072', '364', '吐鲁番市', '0', '0', null, '2', '1', null),
('3073', '364', '鄯善县', '0', '0', null, '2', '1', null),
('3074', '364', '托克逊县', '0', '0', null, '2', '1', null),
('3075', '365', '五家渠市', '0', '0', null, '2', '1', null),
('3076', '366', '阿勒泰市', '0', '0', null, '2', '1', null),
('3077', '366', '布克赛尔', '0', '0', null, '2', '1', null),
('3078', '366', '伊宁市', '0', '0', null, '2', '1', null),
('3079', '366', '布尔津县', '0', '0', null, '2', '1', null);
INSERT INTO `wst_areas` VALUES ('3080', '366', '奎屯市', '0', '0', null, '2', '1', null),
('3081', '366', '乌苏市', '0', '0', null, '2', '1', null),
('3082', '366', '额敏县', '0', '0', null, '2', '1', null),
('3083', '366', '富蕴县', '0', '0', null, '2', '1', null),
('3084', '366', '伊宁县', '0', '0', null, '2', '1', null),
('3085', '366', '福海县', '0', '0', null, '2', '1', null),
('3086', '366', '霍城县', '0', '0', null, '2', '1', null),
('3087', '366', '沙湾县', '0', '0', null, '2', '1', null),
('3088', '366', '巩留县', '0', '0', null, '2', '1', null),
('3089', '366', '哈巴河县', '0', '0', null, '2', '1', null),
('3090', '366', '托里县', '0', '0', null, '2', '1', null),
('3091', '366', '青河县', '0', '0', null, '2', '1', null),
('3092', '366', '新源县', '0', '0', null, '2', '1', null),
('3093', '366', '裕民县', '0', '0', null, '2', '1', null),
('3094', '366', '和布克赛尔', '0', '0', null, '2', '1', null),
('3095', '366', '吉木乃县', '0', '0', null, '2', '1', null),
('3096', '366', '昭苏县', '0', '0', null, '2', '1', null),
('3097', '366', '特克斯县', '0', '0', null, '2', '1', null),
('3098', '366', '尼勒克县', '0', '0', null, '2', '1', null),
('3099', '366', '察布查尔', '0', '0', null, '2', '1', null),
('3100', '367', '盘龙区', '0', '0', null, '2', '1', null),
('3101', '367', '五华区', '0', '0', null, '2', '1', null),
('3102', '367', '官渡区', '0', '0', null, '2', '1', null),
('3103', '367', '西山区', '0', '0', null, '2', '1', null),
('3104', '367', '东川区', '0', '0', null, '2', '1', null),
('3105', '367', '安宁市', '0', '0', null, '2', '1', null),
('3106', '367', '呈贡县', '0', '0', null, '2', '1', null),
('3107', '367', '晋宁县', '0', '0', null, '2', '1', null),
('3108', '367', '富民县', '0', '0', null, '2', '1', null),
('3109', '367', '宜良县', '0', '0', null, '2', '1', null),
('3110', '367', '嵩明县', '0', '0', null, '2', '1', null),
('3111', '367', '石林县', '0', '0', null, '2', '1', null),
('3112', '367', '禄劝', '0', '0', null, '2', '1', null),
('3113', '367', '寻甸', '0', '0', null, '2', '1', null),
('3114', '368', '兰坪', '0', '0', null, '2', '1', null),
('3115', '368', '泸水县', '0', '0', null, '2', '1', null),
('3116', '368', '福贡县', '0', '0', null, '2', '1', null),
('3117', '368', '贡山', '0', '0', null, '2', '1', null),
('3118', '369', '宁洱', '0', '0', null, '2', '1', null),
('3119', '369', '思茅区', '0', '0', null, '2', '1', null),
('3120', '369', '墨江', '0', '0', null, '2', '1', null),
('3121', '369', '景东', '0', '0', null, '2', '1', null),
('3122', '369', '景谷', '0', '0', null, '2', '1', null),
('3123', '369', '镇沅', '0', '0', null, '2', '1', null),
('3124', '369', '江城', '0', '0', null, '2', '1', null),
('3125', '369', '孟连', '0', '0', null, '2', '1', null),
('3126', '369', '澜沧', '0', '0', null, '2', '1', null),
('3127', '369', '西盟', '0', '0', null, '2', '1', null),
('3128', '370', '古城区', '0', '0', null, '2', '1', null),
('3129', '370', '宁蒗', '0', '0', null, '2', '1', null),
('3130', '370', '玉龙', '0', '0', null, '2', '1', null),
('3131', '370', '永胜县', '0', '0', null, '2', '1', null),
('3132', '370', '华坪县', '0', '0', null, '2', '1', null),
('3133', '371', '隆阳区', '0', '0', null, '2', '1', null),
('3134', '371', '施甸县', '0', '0', null, '2', '1', null),
('3135', '371', '腾冲县', '0', '0', null, '2', '1', null),
('3136', '371', '龙陵县', '0', '0', null, '2', '1', null),
('3137', '371', '昌宁县', '0', '0', null, '2', '1', null),
('3138', '372', '楚雄市', '0', '0', null, '2', '1', null),
('3139', '372', '双柏县', '0', '0', null, '2', '1', null),
('3140', '372', '牟定县', '0', '0', null, '2', '1', null),
('3141', '372', '南华县', '0', '0', null, '2', '1', null),
('3142', '372', '姚安县', '0', '0', null, '2', '1', null),
('3143', '372', '大姚县', '0', '0', null, '2', '1', null),
('3144', '372', '永仁县', '0', '0', null, '2', '1', null),
('3145', '372', '元谋县', '0', '0', null, '2', '1', null),
('3146', '372', '武定县', '0', '0', null, '2', '1', null),
('3147', '372', '禄丰县', '0', '0', null, '2', '1', null),
('3148', '373', '大理市', '0', '0', null, '2', '1', null),
('3149', '373', '祥云县', '0', '0', null, '2', '1', null),
('3150', '373', '宾川县', '0', '0', null, '2', '1', null),
('3151', '373', '弥渡县', '0', '0', null, '2', '1', null),
('3152', '373', '永平县', '0', '0', null, '2', '1', null),
('3153', '373', '云龙县', '0', '0', null, '2', '1', null),
('3154', '373', '洱源县', '0', '0', null, '2', '1', null),
('3155', '373', '剑川县', '0', '0', null, '2', '1', null),
('3156', '373', '鹤庆县', '0', '0', null, '2', '1', null),
('3157', '373', '漾濞', '0', '0', null, '2', '1', null),
('3158', '373', '南涧', '0', '0', null, '2', '1', null),
('3159', '373', '巍山', '0', '0', null, '2', '1', null),
('3160', '374', '潞西市', '0', '0', null, '2', '1', null),
('3161', '374', '瑞丽市', '0', '0', null, '2', '1', null),
('3162', '374', '梁河县', '0', '0', null, '2', '1', null),
('3163', '374', '盈江县', '0', '0', null, '2', '1', null),
('3164', '374', '陇川县', '0', '0', null, '2', '1', null),
('3165', '375', '香格里拉县', '0', '0', null, '2', '1', null),
('3166', '375', '德钦县', '0', '0', null, '2', '1', null),
('3167', '375', '维西', '0', '0', null, '2', '1', null),
('3168', '376', '泸西县', '0', '0', null, '2', '1', null),
('3169', '376', '蒙自县', '0', '0', null, '2', '1', null),
('3170', '376', '个旧市', '0', '0', null, '2', '1', null),
('3171', '376', '开远市', '0', '0', null, '2', '1', null),
('3172', '376', '绿春县', '0', '0', null, '2', '1', null),
('3173', '376', '建水县', '0', '0', null, '2', '1', null),
('3174', '376', '石屏县', '0', '0', null, '2', '1', null),
('3175', '376', '弥勒县', '0', '0', null, '2', '1', null),
('3176', '376', '元阳县', '0', '0', null, '2', '1', null),
('3177', '376', '红河县', '0', '0', null, '2', '1', null),
('3178', '376', '金平', '0', '0', null, '2', '1', null),
('3179', '376', '河口', '0', '0', null, '2', '1', null),
('3180', '376', '屏边', '0', '0', null, '2', '1', null),
('3181', '377', '临翔区', '0', '0', null, '2', '1', null),
('3182', '377', '凤庆县', '0', '0', null, '2', '1', null),
('3183', '377', '云县', '0', '0', null, '2', '1', null),
('3184', '377', '永德县', '0', '0', null, '2', '1', null),
('3185', '377', '镇康县', '0', '0', null, '2', '1', null),
('3186', '377', '双江', '0', '0', null, '2', '1', null),
('3187', '377', '耿马', '0', '0', null, '2', '1', null),
('3188', '377', '沧源', '0', '0', null, '2', '1', null),
('3189', '378', '麒麟区', '0', '0', null, '2', '1', null),
('3190', '378', '宣威市', '0', '0', null, '2', '1', null),
('3191', '378', '马龙县', '0', '0', null, '2', '1', null),
('3192', '378', '陆良县', '0', '0', null, '2', '1', null),
('3193', '378', '师宗县', '0', '0', null, '2', '1', null),
('3194', '378', '罗平县', '0', '0', null, '2', '1', null),
('3195', '378', '富源县', '0', '0', null, '2', '1', null),
('3196', '378', '会泽县', '0', '0', null, '2', '1', null),
('3197', '378', '沾益县', '0', '0', null, '2', '1', null),
('3198', '379', '文山县', '0', '0', null, '2', '1', null),
('3199', '379', '砚山县', '0', '0', null, '2', '1', null),
('3200', '379', '西畴县', '0', '0', null, '2', '1', null),
('3201', '379', '麻栗坡县', '0', '0', null, '2', '1', null),
('3202', '379', '马关县', '0', '0', null, '2', '1', null),
('3203', '379', '丘北县', '0', '0', null, '2', '1', null),
('3204', '379', '广南县', '0', '0', null, '2', '1', null),
('3205', '379', '富宁县', '0', '0', null, '2', '1', null),
('3206', '380', '景洪市', '0', '0', null, '2', '1', null),
('3207', '380', '勐海县', '0', '0', null, '2', '1', null),
('3208', '380', '勐腊县', '0', '0', null, '2', '1', null),
('3209', '381', '红塔区', '0', '0', null, '2', '1', null),
('3210', '381', '江川县', '0', '0', null, '2', '1', null),
('3211', '381', '澄江县', '0', '0', null, '2', '1', null),
('3212', '381', '通海县', '0', '0', null, '2', '1', null),
('3213', '381', '华宁县', '0', '0', null, '2', '1', null),
('3214', '381', '易门县', '0', '0', null, '2', '1', null),
('3215', '381', '峨山', '0', '0', null, '2', '1', null),
('3216', '381', '新平', '0', '0', null, '2', '1', null),
('3217', '381', '元江', '0', '0', null, '2', '1', null),
('3218', '382', '昭阳区', '0', '0', null, '2', '1', null),
('3219', '382', '鲁甸县', '0', '0', null, '2', '1', null),
('3220', '382', '巧家县', '0', '0', null, '2', '1', null),
('3221', '382', '盐津县', '0', '0', null, '2', '1', null),
('3222', '382', '大关县', '0', '0', null, '2', '1', null),
('3223', '382', '永善县', '0', '0', null, '2', '1', null),
('3224', '382', '绥江县', '0', '0', null, '2', '1', null),
('3225', '382', '镇雄县', '0', '0', null, '2', '1', null),
('3226', '382', '彝良县', '0', '0', null, '2', '1', null),
('3227', '382', '威信县', '0', '0', null, '2', '1', null),
('3228', '382', '水富县', '0', '0', null, '2', '1', null),
('3229', '383', '西湖区', '1', '0', null, '2', '1', null);
INSERT INTO `wst_areas` VALUES ('3230', '383', '上城区', '1', '0', null, '2', '1', null),
('3231', '383', '下城区', '1', '0', null, '2', '1', null),
('3232', '383', '拱墅区', '1', '0', null, '2', '1', null),
('3233', '383', '滨江区', '1', '0', null, '2', '1', null),
('3234', '383', '江干区', '1', '0', null, '2', '1', null),
('3235', '383', '萧山区', '1', '0', null, '2', '1', null),
('3236', '383', '余杭区', '1', '0', null, '2', '1', null),
('3237', '383', '市郊', '1', '0', null, '2', '-1', null),
('3238', '383', '建德市', '1', '0', null, '2', '1', null),
('3239', '383', '富阳市', '1', '0', null, '2', '1', null),
('3240', '383', '临安市', '1', '0', null, '2', '1', null),
('3241', '383', '桐庐县', '1', '0', null, '2', '1', null),
('3242', '383', '淳安县', '1', '0', null, '2', '1', null),
('3243', '384', '吴兴区', '1', '0', null, '2', '1', null),
('3244', '384', '南浔区', '1', '0', null, '2', '1', null),
('3245', '384', '德清县', '1', '0', null, '2', '1', null),
('3246', '384', '长兴县', '1', '0', null, '2', '1', null),
('3247', '384', '安吉县', '1', '0', null, '2', '1', null),
('3248', '385', '南湖区', '0', '0', null, '2', '1', null),
('3249', '385', '秀洲区', '0', '0', null, '2', '1', null),
('3250', '385', '海宁市', '0', '0', null, '2', '1', null),
('3251', '385', '嘉善县', '0', '0', null, '2', '1', null),
('3252', '385', '平湖市', '0', '0', null, '2', '1', null),
('3253', '385', '桐乡市', '0', '0', null, '2', '1', null),
('3254', '385', '海盐县', '0', '0', null, '2', '1', null),
('3255', '386', '婺城区', '1', '0', null, '2', '1', null),
('3256', '386', '金东区', '1', '0', null, '2', '1', null),
('3257', '386', '兰溪市', '1', '0', null, '2', '1', null),
('3258', '386', '市区', '1', '0', null, '2', '-1', null),
('3259', '386', '佛堂镇', '1', '0', null, '2', '1', null),
('3260', '386', '上溪镇', '1', '0', null, '2', '1', null),
('3261', '386', '义亭镇', '1', '0', null, '2', '1', null),
('3262', '386', '大陈镇', '1', '0', null, '2', '1', null),
('3263', '386', '苏溪镇', '1', '0', null, '2', '1', null),
('3264', '386', '赤岸镇', '1', '0', null, '2', '1', null),
('3265', '386', '东阳市', '1', '0', null, '2', '1', null),
('3266', '386', '永康市', '1', '0', null, '2', '1', null),
('3267', '386', '武义县', '1', '0', null, '2', '1', null),
('3268', '386', '浦江县', '1', '0', null, '2', '1', null),
('3269', '386', '磐安县', '1', '0', null, '2', '1', null),
('3270', '387', '莲都区', '0', '0', null, '2', '1', null),
('3271', '387', '龙泉市', '0', '0', null, '2', '1', null),
('3272', '387', '青田县', '0', '0', null, '2', '1', null),
('3273', '387', '缙云县', '0', '0', null, '2', '1', null),
('3274', '387', '遂昌县', '0', '0', null, '2', '1', null),
('3275', '387', '松阳县', '0', '0', null, '2', '1', null),
('3276', '387', '云和县', '0', '0', null, '2', '1', null),
('3277', '387', '庆元县', '0', '0', null, '2', '1', null),
('3278', '387', '景宁', '0', '0', null, '2', '1', null),
('3279', '388', '海曙区', '1', '0', null, '2', '1', null),
('3280', '388', '江东区', '1', '0', null, '2', '1', null),
('3281', '388', '江北区', '1', '0', null, '2', '1', null),
('3282', '388', '镇海区', '1', '0', null, '2', '1', null),
('3283', '388', '北仑区', '1', '0', null, '2', '1', null),
('3284', '388', '鄞州区', '1', '0', null, '2', '1', null),
('3285', '388', '余姚市', '1', '0', null, '2', '1', null),
('3286', '388', '慈溪市', '1', '0', null, '2', '1', null),
('3287', '388', '奉化市', '1', '0', null, '2', '1', null),
('3288', '388', '象山县', '1', '0', null, '2', '1', null),
('3289', '388', '宁海县', '1', '0', null, '2', '1', null),
('3290', '389', '越城区', '0', '0', null, '2', '1', null),
('3291', '389', '上虞市', '0', '0', null, '2', '1', null),
('3292', '389', '嵊州市', '0', '0', null, '2', '1', null),
('3293', '38', '长丰县', '1', '0', 'C', '2', '1', '2020-04-27 22:51:55'),
('3294', '38', '肥东县', '1', '0', 'F', '2', '1', '2020-04-27 22:52:02'),
('3295', '38', '肥西县', '1', '0', 'F', '2', '1', '2020-04-27 22:52:09'),
('3296', '38', '庐江县', '1', '0', 'L', '2', '1', '2020-04-27 22:52:16'),
('3297', '391', '鹿城区', '1', '0', 'L', '2', '1', '2020-04-27 23:45:11'),
('3298', '391', '龙湾区', '1', '0', 'L', '2', '1', '2020-04-27 23:45:26'),
('3299', '391', '瓯海区', '1', '0', 'O', '2', '1', '2020-04-27 23:46:00'),
('3300', '391', '洞头区', '1', '0', 'D', '2', '1', '2020-04-27 23:46:08'),
('3301', '391', '瑞安市', '1', '0', 'R', '2', '1', '2020-04-27 23:46:21'),
('3302', '391', '乐清市', '1', '0', 'L', '2', '1', '2020-04-27 23:46:32'),
('3303', '391', '龙港市', '1', '0', 'L', '2', '1', '2020-04-27 23:46:38'),
('3304', '391', '永嘉县', '1', '0', 'Y', '2', '1', '2020-04-27 23:46:45'),
('3305', '391', '平阳县', '1', '0', 'P', '2', '1', '2020-04-27 23:46:51'),
('3306', '391', '苍南县', '1', '0', 'C', '2', '1', '2020-04-27 23:46:58'),
('3307', '391', '文成县', '1', '0', 'W', '2', '1', '2020-04-27 23:47:38'),
('3308', '391', '泰顺县', '1', '0', 'T', '2', '1', '2020-04-27 23:47:45');
