var currPage = totalPage = 0;
var loading = false;
$(document).ready(function(){
  getcouponList();
  // Tab切换卡
  $('.tab-item').click(function(){
      $(this).addClass('tab-curr').siblings().removeClass('tab-curr');
      var status = $(this).attr('status');
      $('#status').val(status);
      reFlashList();
  });
  $(window).scroll(function(){  
    if (loading) return;
    if ((5 + $(window).scrollTop()) >= ($(document).height() - $(window).height())) {
      currPage = Number( $('#currPage').val() );
      totalPage = Number( $('#totalPage').val() );
      if( totalPage > 0 && currPage < totalPage ){
          getcouponList();
      }
    }
  });
  //阻止遮罩层冒泡
  $(".wst-cp-card").bind('click', function(event) {
    $('.wst-cp-card').fadeOut(200);
  });
  $(".cards").bind('click', function(event) {
    event.stopPropagation();
  });
});
// 获取优惠券列表
function getcouponList(){
  $('#Load').show();
    loading = true;
    var param = {};
    param.status = $('#status').val();
    param.pagesize = 10;
    param.page = Number( $('#currPage').val() ) + 1;
    $.post(WST.AU('coupon://users/pageQuery'), param, function(data){
        var json = WST.toJson(data);
        var html = '';
        if(json && json.data && json.data.length>0){
          var gettpl = document.getElementById('shopList').innerHTML;
          laytpl(gettpl).render(json.data, function(html){
            $('#order-box').append(html);
          });

          $('#currPage').val(json.current_page);
          $('#totalPage').val(json.last_page);
        }else{
            html += '<div class="no-data-box">';
            html += '<div class="no-data"></div>';
            html += '<div class="no-data-txt">暂无相关优惠券</div>';
            html += '</div>';
            $('#order-box').html(html);
            $('#order-box').html(html);
        }
        // WST.imgAdapt('j-imgAdapt');
        loading = false;
        $('#Load').hide();
        echo.init();//图片懒加载
    });
}
// 刷新列表页
function reFlashList(){
  $('#currPage').val('0');
  $('#order-box').html(' ');
  getcouponList();
}
//使用优惠券
function useCoupon(couponId){
  location.href = WST.AU('coupon://coupons/moCouponGoods',{'couponId':couponId});
}
function openCard(){
  if($('.wst-cp-card').css("display")=='none'){
    $('.wst-cp-card').fadeIn(200);
  }else{
    $('.wst-cp-card').fadeOut(200);
  }
}
//领取优惠码
function getCard(){
  var $code=$.trim($('#code').val());
  if(!$code){
    $.toptips('请输入优惠码','info');
    return false;
  }
  var param= {};
  param.codes =$code;
  $.post(WST.AU('coupon://coupons/receiveCard'),param,function(data){
    var json =WST.toJson(data);
    if(json.status==1){
       $.toast(json.msg,'success');
       $('.wst-cp-card').fadeOut(200);
       getcouponList();
    }else{
       $.toptips(json.msg,'info');
    } 
  })
}