<?php
namespace addons\coupon\model;
use think\addons\BaseModel as Base;
use addons\coupon\validate\Coupons as Validate;
use think\Db;
use think\Loader;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 优惠券接口
 */
class Coupons extends Base{
	protected $pk = 'couponId';
	/***
	 * 安装插件
	 */
	public function installMenu(){
		Db::startTrans();
		try{
			$hooks = ['wechatDocumentGoodsDetail','wechatDocumentUserIndexTerm','wechatDocumentUserIndexTools','wechatDocumentCartShopPromotion','wechatDocumentOrderSummaryView',
			   'mobileDocumentGoodsDetail','mobileDocumentUserIndexTerm','mobileDocumentUserIndexTools','mobileDocumentCartShopPromotion','mobileDocumentOrderSummaryView',
			   'afterCalculateCartMoney','afterQueryCarts','beforeInsertOrder','afterQueryGoods'];
			$this->bindHoods("Coupon", $hooks);
			$now = date("Y-m-d H:i:s");
			//后台中心
			$rs=Db::name('menus')->insert(["parentId"=>93,"menuName"=>"优惠券","isShow"=>1,"menuSort"=>1,"dataFlag"=>1,"menuMark"=>"coupon"]);
			if($rs !==false){
				$datas = [];
				$parentId = Db::name('menus')->getLastInsID();
				$datas[] = ["menuId"=>$parentId,"privilegeCode"=>"COUPON_YHJ_00","privilegeName"=>"查看优惠券","isMenuPrivilege"=>1,"privilegeUrl"=>"/addon/coupon-admin-index","otherPrivilegeUrl"=>"/addon/coupon-admin-pageQuery","dataFlag"=>1,"isEnable"=>1];
				$datas[] = ["menuId"=>$parentId,"privilegeCode"=>"COUPON_YHJ_01","privilegeName"=>"添加优惠券","isMenuPrivilege"=>0,"privilegeUrl"=>"/addon/coupon-admin-edit","otherPrivilegeUrl"=>"/addon/coupon-admin-toEdit","dataFlag"=>1,"isEnable"=>1];
				$datas[] = ["menuId"=>$parentId,"privilegeCode"=>"COUPON_YHJ_02","privilegeName"=>"修改优惠券","isMenuPrivilege"=>0,"privilegeUrl"=>"/addon/coupon-admin-edit","otherPrivilegeUrl"=>"/addon/coupon-admin-toEdit","dataFlag"=>1,"isEnable"=>1];
				$datas[] = ["menuId"=>$parentId,"privilegeCode"=>"COUPON_YHJ_03","privilegeName"=>"删除优惠券","isMenuPrivilege"=>0,"privilegeUrl"=>"/addon/coupon-admin-index","otherPrivilegeUrl"=>"/addon/coupon-admin-del","dataFlag"=>1,"isEnable"=>1];
				$datas[] = ["menuId"=>$parentId,"privilegeCode"=>"COUPON_YHJ_04","privilegeName"=>"查看优惠码","isMenuPrivilege"=>0,"privilegeUrl"=>"/addon/coupon-admin-card","otherPrivilegeUrl"=>"/addon/coupon-admin-card","dataFlag"=>1,"isEnable"=>1];
				Db::name('privileges')->insertAll($datas);
			}
			$this->addMobileBtn();
			installSql("coupon");
			Db::commit();
			return true;
		}catch (\Exception $e) {
			Db::rollback();
			return false;
		}
	}

	/**
	 * 删除菜单
	 */
	public function uninstallMenu(){
		Db::startTrans();
		try{
			$hooks = ['wechatDocumentGoodsDetail','wechatDocumentUserIndexTerm','wechatDocumentUserIndexTools','wechatDocumentCartShopPromotion','wechatDocumentOrderSummaryView',
			   'mobileDocumentGoodsDetail','mobileDocumentUserIndexTerm','mobileDocumentUserIndexTools','mobileDocumentCartShopPromotion','mobileDocumentOrderSummaryView',
			   'afterCalculateCartMoney','afterQueryCarts','beforeInsertOrder','afterQueryGoods'];
			$this->unbindHoods("Coupon", $hooks);
			Db::name('menus')->where(["menuMark"=>"coupon"])->delete();
			Db::name('privileges')->where("privilegeCode","like","COUPON_%")->delete();
			uninstallSql("coupon");//传入插件名
			$this->delMobileBtn();
			Db::commit();
			return true;
		}catch (\Exception $e) {
			Db::rollback();
			return false;
		}
	}

	/**
	 * 菜单显示隐藏
	 */
	public function toggleShow($isShow = 1){
		Db::startTrans();
		try{
			$rs=Db::name('menus')->where(["menuMark"=>"coupon"])->update(["isShow"=>$isShow]);
			if($isShow==1){
				$this->addMobileBtn();
			}else{
				$this->delMobileBtn();
			}
			Db::commit();
			return true;
		}catch (\Exception $e) {
			Db::rollback();
			return false;
		}
	}
	
	public function addMobileBtn(){
//		$data = array();
//		$data["btnName"] = "领券中心";
//		$data["btnSrc"] = 0;
//		$data["btnUrl"] = "/addon/coupon-coupons-moindex";
//		$data["btnImg"] = "addons/coupon/view/mobile/img/coupon.png";
//		$data["addonsName"] = "Coupon";
//		$data["btnSort"] = 6;
//		Db::name('mobile_btns')->insert($data);
		$data = array();
		$data["btnName"] = "领券中心";
		$data["btnSrc"] = 1;
		$data["btnUrl"] = "/addon/coupon-coupons-wxindex";
		$data["btnImg"] = "addons/coupon/view/images/logo.png";
		$data["addonsName"] = "Coupon";
		$data["btnSort"] = 6;
		Db::name('mobile_btns')->insert($data);
		$data = array();
		$data["btnName"] = "领券中心";
		$data["btnSrc"] = 2;
		$data["btnUrl"] = "/pages/addons/package/pages/coupon/coupon";
		$data["btnImg"] = "/wststore/weapp/view/weapp/addons/closure/coupon/image/coupon.png";
		$data["addonsName"] = "Coupon";
		$data["btnSort"] = 6;
		Db::name('mobile_btns')->insert($data);
	}
	
	public function delMobileBtn(){
		Db::name('mobile_btns')->where(["addonsName"=>"Coupon"])->delete();
	}
	/**
	 * 查看优惠码
	 */
	public function pageQueryByCouponCards($id =0){
		$id=($id>0)?$id:(int)input('id/d');
		$card=Db::name('coupons')->alias('c')
			->join('__COUPON_CARD__ cd','c.couponId=cd.couponId and c.dataFlag=1','inner')
			->where('c.couponId',$id)
			->field('c.couponValue,c.useCondition,c.useObjects,c.useMoney,cd.startDate,cd.endDate,cd.code,cd.dataFlag')
			->order('cd.dataFlag desc')
			->paginate(input('pagesize/d'))->toArray();
		return $card;
	}
	/**
	 * 获取优惠券信息
	 */
	public function getById($id = 0){
		$id = ($id>0)?$id:(int)input('couponId/d');
		$couppn = $this->where(['couponId'=>$id,'dataFlag'=>1])->find();
		$couppn['goods'] = [];
		//判断是否需要加载商品信息
		if($couppn['useObjects']==1){
			$couppn['goods'] = Db::name('coupon_goods')->alias('cg')
				   ->join('__GOODS_LIBS__ g','g.goodsLibId=cg.goodsLibId and g.isSale=1 and g.dataFlag=1','inner')
				   ->where('cg.couponId',$id)
				   ->field('goodsImg,goodsName,g.goodsLibId')
				   ->select();
		}
		return $couppn;
	}
	/**
	 * 获取优惠券下边的商品列表
	 */
	public function pageQueryByCouponGoods(){
		//查询条件
		$keyword = input('keyword');
		$where = [];
		if($keyword!='')$where[] = ['goodsName','like','%'.$keyword.'%'];
		//排序条件
		$orderBy = input('condition/d',0);
		$orderBy = ($orderBy>=0 && $orderBy<=4)?$orderBy:0;
		$order = (input('desc/d',0)==1)?1:0;
		$pageBy = ['gs.saleNum','gs.shopPrice','gs.visitNum','gs.saleTime'];
		$pageOrder = ['desc','asc'];
		$couponId = (int)input('couponId/d',0);
		$shopId=(int)input('shopId/d',0);
		$shopId = ($shopId>0)?$shopId:(int)session('WST_USER_SHOP.shopId');
		$coupon = $this->where(['couponId'=>$couponId,'dataFlag'=>1])->find();
		if($coupon['useObjects']==1){
			//指定商品
			$rs =Db::name('coupon_goods')->alias('cg')
					 ->join('__GOODS_LIBS__ g','g.goodsLibId=cg.goodsLibId and g.isSale=1 and g.dataFlag=1','inner')
					 ->join('__GOODS__ gs','g.goodsLibId=gs.goodsLibId')
					 ->where(['cg.couponId'=>$couponId,'g.dataFlag'=>1,'g.isSale'=>1,'gs.shopId'=>$shopId])
					 ->where($where)
					 ->field('g.goodsImg,g.goodsName,g.goodsLibId,gs.goodsId,gs.shopPrice,gs.saleNum')
					 ->order($pageBy[$orderBy]." ".$pageOrder[$order].",goodsLibId asc")
					 ->paginate(input('pagesize/d'))->toArray();
		}else{
			//全部商品
			$rs = Db::name('goods_libs')->alias('g')
					 ->join('__GOODS__ gs','g.goodsLibId=gs.goodsLibId')
					 ->where(['g.dataFlag'=>1,'g.isSale'=>1,'gs.shopId'=>$shopId])
					 ->where($where)
					 ->field('g.goodsImg,g.goodsName,g.goodsLibId,gs.goodsId,gs.shopPrice,gs.saleNum')
					 ->order($pageBy[$orderBy]." ".$pageOrder[$order].",goodsLibId asc")
					 ->paginate(input('pagesize/d'))->toArray();
		}
		return $rs;
	}

	/**
	 * 查询商品
	 */
	public function searchGoods(){
		$goodsCatId = (int)input('post.goodsCatId');
		$goodsName = input('post.goodsName');
		$where = [];
		$where['dataFlag'] = 1;
		$where['isSale'] = 1;
		if($goodsCatId>0)$where['goodsCatId'] = $goodsCatId;
		if($goodsName!='')$where[] = ['goodsName|goodsSn','like','%'.$goodsName.'%'];
		$rs = Db::name('goods_libs')->where($where)->field('goodsImg,goodsName,goodsLibId')->order('goodsName asc')->select();
		return WSTReturn('',1,$rs);
	}

	/**
	 * 新增优惠前
	 */
	public function add(){
		$data = input('post.');
		unset($data['couponId']);
		$data['createTime'] = date('Y-m-d H:i:s');
		$goodsLibId = explode(',',$data['useObjectIds']);
		$validate = new Validate;
		if(!$validate->check($data)){
			return WSTReturn($validate->getError());
		}
		//如果不是系统触发,清除状态   
		//if($data['couponType']!=0){$data['typeStatus']=0;$data['startGrantDate']='';$data['endGrangDate']='';}
		//如果不是人工触发,清除状态 
		//if($data['couponType']!=1)$data['limitNum']==1;
		//如果是系统触发,发放时间要小于有效时间
//		if($data['couponType']==0){
//		if( WSTStrToTime($data['startDate']) <= WSTStrToTime($data['startGrantDate']) ){return WSTReturn('发放时间必须小于有效时间');}
//		if( WSTStrToTime($data['endDate']) <= WSTStrToTime($data['endGrantDate']) ){return WSTReturn('发放时间必须小于有效时间');}
//		}
		if(WSTStrToTime($data['startDate']) >WSTStrToTime($data['endDate'])){return WSTReturn('结束时间必须大于开始时间');}
		$goods = [];
		if($data['useObjects']==1){
			$goods = Db::name('goods_libs')->where([['goodsLibId','in',$goodsLibId],['isSale','=',1],['dataFlag','=',1]])
					   ->field('goodsLibId,goodsCatId')->select();
			if(empty($goods))return WSTReturn('请选择优惠券适用的商品');
		}
		Db::startTrans();
		try{
			$result = $this->allowField(true)->save($data);
			if(false !== $result){
				//优惠码
				if($data['couponType']==3){
					$arr=[];
					//获取随机优惠码
					$card=generateCode($data['couponNum'],'',$code_length =10);
					for ($i=0; $i <count($card); $i++) { 
						$cgoods=[];
						$cgoods['startDate']=$data['startDate'];
						$cgoods['endDate']=$data['endDate'];
						$cgoods['code']=$card[$i];
						$cgoods['couponId'] = $this->couponId;
						$cgoods['createTime'] = date('Y-m-d H:i:s');
						$arr[]=$cgoods;
					}
					Db::name('coupon_card')->insertAll($arr);
				}
				if($data['useObjects']==1){
					
					//保存优惠券适用的商品
					$arr = [];
					for($i=0;$i<count($goods);$i++){
						$cgoods = [];
						$cgoods['couponId'] = $this->couponId;
						$cgoods['goodsLibId'] = $goods[$i]['goodsLibId'];
						$arr[] = $cgoods;
						$goodsCatId[] =$goods[$i]['goodsCatId'];
					}
					$goodsCatIds=array_unique($goodsCatId);
					Db::name('coupon_goods')->insertAll($arr);
					//保存优惠券涉及的分类
					$arr = [];
					foreach ($goodsCatIds as $key => $v) {
						$cgoods = [];
						$cgoods['catId'] = $v;
						$cgoods['couponId'] = $this->couponId;
						$arr[] = $cgoods;
					}
					Db::name('coupon_cats')->insertAll($arr);
				}else{
					//获取所有分类
					$cats = Db::name('goods_cats')->where(['dataFlag'=>1,'parentId'=>0])->field('catId')->select();
					$arr = [];
					foreach ($cats as $key => $v) {
						$cgoods = [];
						$cgoods['catId'] = $v['catId'];
						$cgoods['couponId'] = $this->couponId;
						$arr[] = $cgoods;
					}
					Db::name('coupon_cats')->insertAll($arr);
				}
			}
			Db::commit();
			return WSTReturn('新增成功',1);
		}catch (\Exception $e) {
			Db::rollback();
			return WSTReturn('新增失败');
		}
	}
	/**
	 * 编辑优惠券
	 */
	public function edit(){
		$data = input('post.');
		$goodsLibId = explode(',',$data['useObjectIds']);
		$validate = new Validate;
		if(!$validate->check($data)){
			return WSTReturn($validate->getError());
		}
		//如果不是系统触发,清除状态   
		//if($data['couponType']!=0){$data['typeStatus']=0;$data['startGrantDate']='';$data['endGrangDate']='';}
		//如果不是人工触发,清除状态 
		//if($data['couponType']!=1)$data['limitNum']==1;
		//如果是系统触发,发放时间要小于有效时间
//		if($data['couponType']==0){
//		if( WSTStrToTime($data['startDate']) <= WSTStrToTime($data['startGrantDate']) ){return WSTReturn('发放时间必须小于有效时间');}
//		if( WSTStrToTime($data['endDate']) <= WSTStrToTime($data['endGrantDate']) ){return WSTReturn('发放时间必须小于有效时间');}
//		}
		if(WSTStrToTime($data['startDate']) >WSTStrToTime($data['endDate'])){return WSTReturn('结束时间必须大于开始时间');}
		//是否有优惠码
		$card=Db::name('coupons')->alias('c')
			->join('__COUPON_CARD__ cd','c.couponId=cd.couponId')
			->where('c.couponId',$data['couponId'])
			->select();
		if($card)$data['couponType']=3;
		$goods = [];
		if($data['useObjects']==1){
			$goods = Db::name('goods_libs')->where([['goodsLibId','in',$goodsLibId],['isSale','=',1],['dataFlag','=',1]])
					   ->field('goodsLibId,goodsCatId')->select();
			if(empty($goods))return WSTReturn('请选择优惠券适用的商品');
		}else{
			$data['useObjectIds'] = '';
		}
		$couponNum = $this->where('couponId',$data['couponId'])->field('couponNum')->find();
		if($data['couponNum']<$couponNum['couponNum'])return WSTReturn('发行量不能比已设置发行量还小');
		WSTUnset($data,'createTime,dataFlag');
		
		Db::startTrans();
		try{
			$result = $this->allowField(true)->update($data,['couponId'=>$data['couponId']]);
			if(false !== $result){
				Db::name('coupon_goods')->where('couponId',$data['couponId'])->delete();
				Db::name('coupon_cats')->where('couponId',$data['couponId'])->delete();
				// 修改优惠码
				if($card){
					if($data['couponType']==3){
						Db::name('coupon_card')->where('couponId',$data['couponId'])->update(['startDate'=>$data['startDate'],'endDate'=>$data['endDate']]);
					}
				}
				if($data['useObjects']==1){
					//保存优惠券适用的商品
					$arr = [];
					for($i=0;$i<count($goods);$i++){
						$cgoods = [];
						$cgoods['couponId'] = $data['couponId'];
						$cgoods['goodsLibId'] = $goods[$i]['goodsLibId'];
						$arr[] = $cgoods;
						$goodsCatId[] = $goods[$i]['goodsCatId'];
					}
					$goodsCatIds=array_unique($goodsCatId);
					Db::name('coupon_goods')->insertAll($arr);
					//保存优惠券涉及的分类
					$arr = [];
					foreach ($goodsCatIds as $key => $v) {
						$cgoods = [];
						$cgoods['catId'] = $v;
						$cgoods['couponId'] = $data['couponId'];
						$arr[] = $cgoods;
					}
					Db::name('coupon_cats')->insertAll($arr);
				}else{
					//获取所有分类
					$cats = Db::name('goods_cats')->where(['dataFlag'=>1,'parentId'=>0])->field('catId')->select();
					$arr = [];
					foreach ($cats as $key => $v) {
						$cgoods = [];
						$cgoods['catId'] = $v['catId'];
						$cgoods['couponId'] = $data['couponId'];
						$arr[] = $cgoods;
					}
					Db::name('coupon_cats')->insertAll($arr);
				}
			}
			Db::commit();
			return WSTReturn('编辑成功',1);
		}catch (\Exception $e) {
			Db::rollback();
			return WSTReturn('编辑失败');
		}
	}

	/**
	 * 删除优惠券
	 */
	public function del(){
		$id = (int)input('id/d',0);
		$result = $this->where(['couponId'=>$id])->update(['dataFlag'=>-1]);
		if(false !== $result){
			Db::name('coupon_users')->where('couponId',$id)->delete();
			Db::name('coupon_goods')->where('couponId',$id)->delete();
			Db::name('coupon_cats')->where('couponId',$id)->delete();
		}
		return WSTReturn('删除成功',1);
	}

	/**
	 * 优惠券列表
	 */
	public function pageQuery(){
		$useCondition = (int)input('useCondition/d',-1);
		$where = ['dataFlag'=>1];
		if(in_array($useCondition,[0,1]))$where['useCondition'] = $useCondition;
		$page =  $this->where($where)
					 ->order('createTime desc')
					 ->paginate(input('pagesize/d'))->toArray();
		$page['status'] = 1;
		return $page;
	}

	/**
	 * 获取前台优惠券列表
	 */
	public function pageCouponQuery($uId=0){
		$catId = (int)input('catId/d',-1);
		// $useCondition = (int)input('useCondition/d',-1);
		$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
		$where['c.dataFlag'] = 1;
		$where['c.couponType'] = 2;
		$where[] = ['endDate','>=',date('Y-m-d')];
		// if(in_array($useCondition,[0,1]))$where['useCondition'] = $useCondition;
		if($catId<=0){
			$page =Db:: name('coupons')->alias('c')->where($where)->order('endDate desc')->paginate(input('pagesize/d'))->toArray();
		}else{
			$where['cg.catId'] = $catId;
			$page = Db::name('coupon_cats')->alias('cg')
						->join('__COUPONS__ c','cg.couponId =c.couponId')
						->where($where)
						->order('c.endDate desc')
					->paginate(input('paginate/d'))->toArray();
					  
		}
		$userCoupons = [];
		if($userId>0){
			$userCoupons = Db::name('coupon_users')->where(['userId'=>$userId])->column('couponId');
		}
		$time = time();
		foreach ($page['data'] as $key => $v) {
			$page['data'][$key]['isOut'] = (($v['couponNum']<=$v['receiveNum']) || ($time>WSTStrToTime($v['endDate']." 23:59:59")))?true:false;
			$page['data'][$key]['isReceive'] = ($userId>0)?in_array($v['couponId'],$userCoupons):false;
		}
		return $page;
	}

	/**
	 * 领取优惠券
	 */
	public function receive($uId=0){
		$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
		if($userId==0)return WSTReturn('领取失败失败，请先登录',-2);
		$couponId = (int)input('couponId/d',0);
		if($userId==0 || $couponId<=0)return WSTReturn('领取优惠券失败');
		$coupon = $this->get($couponId);
		if($coupon->dataFlag==-1)return WSTReturn('领取优惠券失败');
		if($coupon->couponNum<=$coupon->receiveNum)return WSTReturn('对不起，优惠券已领完');
		Db::startTrans();
		try{
			//查询用户是否领取过，是否已超过临取数量
			$receiveNum = Db::name('coupon_users')->where(['userId'=>$userId,'couponId'=>$couponId])->count();
			if($coupon->limitNum!=0){
				if($receiveNum>=$coupon->limitNum)return WSTReturn('对不起，该优惠券您的领取已达上限');
			}
			//查询是否是可领取的用户类型 couponType=1
//			$couponType=Db::name('coupons')->where(['couponType'=>1,'couponId'=>$couponId])->find();
//			if($couponType==0){
//				return WSTReturn('对不起，您无法领取该优惠券');
//			}
			$couponUser = [];
			$couponUser['couponId'] = $coupon->couponId;
			$couponUser['userId'] = $userId;
			$couponUser['isUse'] = 0;
			$couponUser['createTime'] = date('Y-m-d h:i:s');
			$rs=Db::name('coupon_users')->insert($couponUser);
			$coupon->receiveNum = $coupon->receiveNum+1;
			$coupon->save();
			Db::commit();
			return WSTReturn('领取优惠券成功',1);
		}catch (\Exception $e) {
			Db::rollback();
			return WSTReturn('领取优惠券失败');
		}
	}

	/**
	 * 获取商品是否有满减券
	 */
	public function getGoodsCouponTags($goodsId){
		$time = date('Y-m-d');
		//查询是否有针对该商品的优惠券
		$goods =Db::name('goods')->where('goodsId',$goodsId)->field('goodsLibId')->find();
		$hasCoupon = Db::name('coupon_goods')->alias('cg')
					->join('__COUPONS__ c','cg.couponId=c.couponId')
					->where([['endDate','>=',$time],['goodsLibId','=',$goods['goodsLibId']],['dataFlag','=',1]])->count();
		if($hasCoupon>0)return 1;
		//查询一下是否有针对分类的优惠券
		$goods = Db::name('goods')->alias('cg')
				->join('__GOODS_LIBS__ c' , 'cg.goodsLibId=c.goodsLibId')
				->where([['cg.goodsId','=',$goodsId],['c.dataFlag','=',1],['c.isSale','=',1]])
				->field('c.goodsCatIdPath')
				->find();
		$goodsCatIdPath = explode('_',$goods['goodsCatIdPath']);
		$hasCoupon = Db::name('coupon_cats')->alias('cg')
					   ->join('__COUPONS__ c','cg.couponId=c.couponId')
					   ->where([['endDate','>=',$time],['catId','=',(int)$goodsCatIdPath[0]],['c.dataFlag','=',1]])->count();
		if($hasCoupon>0)return 1;
			return 0;
	}

	/**
	 * 加载合适的商品优惠券
	 */
	public function getCouponsByGoods($uId=0){
		$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
		$goodsId = (int)input('goodsId/d',0);
		//获取商品唯一优惠券标识
		$goods = Db::name('goods')->where([['goodsId','=',$goodsId]])->field('goodsLibId')->find();
	   //获取全部类型的优惠券
		$rs[] =  Db::name('coupons')->where([['dataFlag','=',1],['useObjects','=',0],['couponType','=',2]])->order('couponValue asc')->select();
	   //获取部分类型且符合商品的优惠券
		$rs[] =  Db::name('coupon_goods')->alias('cg')
		->join('coupons c','cg.couponId=c.couponId')
		->where([['cg.goodsLibId','=',$goods['goodsLibId']],['dataFlag','=',1],['couponType','=',2]])
		->order('c.couponValue asc')
		->select();

		//获取已领优惠券列表
		$reRs = Db::name('coupon_users')->where('userId',$userId)->column('couponId');
		$coupons = [];
		$time = time();
		foreach($rs as $key =>$val){
			foreach ($val as $k => $v) {
				$v['isReceive'] = false;
				//过期的优惠券
				if($time > WSTStrToTime($v['endDate']." 23:59:59"))continue;
				if(in_array($v['couponId'],$reRs))$v['isReceive'] = true;
				unset($v['dataFlag'],$v['createTime'],$v['useObjectIds'],$v['useObjects']);
				$coupons[] = $v;
			}
		}
		return WSTReturn('',1,$coupons);
	}

	/**
	 * 加载店铺下的优惠券
	 */
	public function getCouponsByShop($shopId = 0,$uId=0){
		$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
		$shopId = ($shopId>0)?$shopId:(int)input('shopId/d',0);
		//获取优惠券列表
		$rs =  Db::name('coupons')->where(['dataFlag'=>1,'shopId'=>$shopId])->order('couponValue asc')->select();
		//获取已领优惠券列表
		$reRs = Db::name('coupon_users')->where(['userId'=>$userId,'shopId'=>$shopId])->column('couponId');
		$coupons = [];
		$time = time();
		foreach ($rs as $key => $v) {
			$v['isReceive'] = false;
			//过期的优惠券
			if($time > strtotime($v['endDate']." 23:59:59"))continue;
			if(in_array($v['couponId'],$reRs))$v['isReceive'] = true;
			unset($v['dataFlag'],$v['createTime'],$v['useObjectIds'],$v['useObjects']);
			$coupons[] = $v;
		}
		return WSTReturn('',1,['coupons'=>$coupons,'receive'=>count($reRs)]);
	}

	/**
	 * 加载已领未使用的商品优惠券
	 * 1.【指定商品】要商品符合
	 * 2.【指定商品】要商品总价符合
	 * 3.【店铺通用】订单总价符合
	 */
	public function getAvailableCoupons($cartGoods,$uId=0){
		//构造用于比较的数组
		$carts = ['ids'=>[],'totalMoney'=>0];//存放优惠券里指定的商品id，每个商品的总价,订单总价
		foreach($cartGoods['cartGoods'] as $key =>$v){
			//将店铺商品ID转为后台商品ID
			$goodsLibId=Db::name('goods')->where('goodsId',$v['goodsId'])->field('goodsLibId')->find();
			$carts['ids'][]=$goodsLibId['goodsLibId'];//后台商品id
			$carts['goodsId'][]=$v['goodsId'];//店铺商品id
			$carts[$v['goodsId']]['totalMoney'] = $v['cartNum']*$v['shopPrice'];
			$carts['totalMoney'] += $v['cartNum']*$v['shopPrice'];
		}
		$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
		//获取优惠券列表
		$rs =  Db::name('coupons')->where(['dataFlag'=>1])->order('couponValue asc')->select();
		//获取用户已领未用的优惠券列表
		$reRs = Db::name('coupon_users')->where(['userId'=>$userId,'isUse'=>0])->column('couponId');
		$coupons = [];
		$time = time();
		foreach ($rs as $key => $v) {
			//过期的优惠券要过滤
			if($time > strtotime($v['endDate']." 23:59:59"))continue;
			//如果没有领取的优惠券也过滤掉
			if(!in_array($v['couponId'],$reRs))continue;
			//指定商品，但又不是本商品的优惠券要过滤
			if($v['useObjects']==1){
				$ids = explode(',',$v['useObjectIds']);
				//判断两个数组是否有交集，没有交集则跳过	后台id
				$intersection = array_intersect($carts['ids'],$ids);
				if(empty($intersection))continue;
				//取数组内的交易进行判断金额是否满足，有一个满足的话都通过
				$isFind = false;
				$intersection =$carts['goodsId'];	//店铺id
				foreach ($intersection as $gkey => $goodsId) {	
					//有设置使用条件
					if($v['useCondition']==1){
						if($v['useMoney']<=$carts[$goodsId]['totalMoney']){
							$isFind = true;
							continue;
						}
					}else{
						$isFind = true;
						continue;
					}
				}
				if(!$isFind)continue;
			}else{

				//商品总价不符合的要过滤
				if($v['useCondition']==1 && $v['useMoney']>$carts['totalMoney'])continue;
			}
			unset($v['dataFlag'],$v['createTime'],$v['useObjectIds'],$v['useObjects']);
			$coupons[] = $v;
		}
		return $coupons;
	}

	/**
	 * 计算订单金额
	 */
	public function calculateCartMoney($params){
		$couponId = input('couponId');
		if($couponId=='' || $couponId==0)return;
		$derateMoney = 0;
		//订单key值转化为购物车key值
		$cartGoods=[];
		$cartGoods['cartGoods']=$params['carts']['carts'];
		//查找可用的优惠券
		$coupons = $this->getAvailableCoupons($cartGoods,$params['uId']);
		//校验优惠券是否有效
		$rightCoupon=[];
		foreach ($coupons as $key => $v) {
			if($v['couponId'] ==$couponId)$rightCoupon =$v;
		}
		//计算出店铺可以优惠后的价格
		if($rightCoupon['useCondition']==1){
			if($params['data']['totalGoodsMoney']>=$rightCoupon['useMoney']){
				$derateMoney = $derateMoney + $rightCoupon['couponValue'];
			}
		}else{
			$derateMoney = $derateMoney + $rightCoupon['couponValue'];
		}
		$params['data']['totalGoodsMoney'] = WSTPositiveNum($params['data']['totalGoodsMoney'] - $derateMoney);
		$params['data']['totalMoney'] = WSTPositiveNum($params['data']['totalMoney'] - $derateMoney);
	}
	/**
	 * 订单执行前插入
	 */
	public function beforeInsertOrder($params){
		$shopCart = $params['carts'];
		$order = $params['order'];
		$couponId = (int)input('couponId/d',0);
		$coupon = [];
		foreach ($shopCart['coupons'] as $key => $v) {
			if($couponId==$v['couponId']){
				$coupon = $v;
				break;
			}
		}
		if(!empty($coupon)){
			//加载未使用的优惠券
			$couponUser = Db::name('coupon_users')->where(['userId'=>$order['userId'],'isUse'=>0,'couponId'=>$coupon['couponId']])->limit(1)->select();
			if(!empty($couponUser)){
				$couponUser = $couponUser[0];
				Db::name('coupon_users')->where(['id'=>$couponUser['id']])->update(['isUse'=>1,'orderNo'=>$order['orderNo'],'useTime'=>date('Y-m-d H:i:s')]);
				//使用优惠券
				$params['order']['userCouponId'] = $couponUser['id'];
				if($coupon['useCondition']==1){
					$params['order'] ['userCouponJson'] = json_encode(['text'=>'满'.$coupon['useMoney']."减".$coupon['couponValue'],'money'=>$coupon['couponValue']]);
				}else{
					$params['order'] ['userCouponJson'] = json_encode(['text'=>"优惠券￥".$coupon['couponValue'],'money'=>$coupon['couponValue']]);
				}
				//修改订单信息
				$realTotalMoney = $order['realTotalMoney']-$coupon['couponValue'];
				$params['order']['realTotalMoney'] = ($realTotalMoney>0)?$realTotalMoney:0;
				$params['order']['needPay'] = $params['order']['realTotalMoney'];
				if($params['order']['needPay']<=0){
					$params['order']['orderStatus'] = 0;//待发货
					$params['order']['isPay'] = 1;
				}
			}
		}
	}

	/**
	 * 用户-优惠券列表
	 */
	public function pageQueryByUser($uId=0){
		$status = (int)input('status/d',0);
		$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
		$where = ['c.dataFlag'=>1,'cu.userId'=>$userId];
		$where2 = '';
		if($status==0)$where2 =' isUse=0 and c.endDate>="'.date('Y-m-d').'"';
		if($status==1)$where2 =' isUse=1 ';
		if($status==2)$where2 =' isUse=0 and c.endDate<"'.date('Y-m-d').'"';
		$page =  $this->alias('c')->join('__COUPON_USERS__ cu','c.couponId=cu.couponId')
					  ->where($where)
					  ->where($where2)
					  ->field('c.*')
					  ->order('c.createTime desc')
					  ->paginate(input('pagesize/d'))->toArray();
		$page['status'] = 1;
		$page['couponStatus'] = $status;
		return $page;
	}

	/**
	 * 获取用户
	 */
	public function getCouponNumByUser($uId=0){
	   $data = [];
	   $userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
	   $where = ['c.dataFlag'=>1,'cu.userId'=>$userId];
	   $data['num0'] = $this->alias('c')->join('__COUPON_USERS__ cu','c.couponId=cu.couponId')
					  ->join('__SHOPS__ s','c.shopId=s.shopId and s.dataFlag=1 and s.shopStatus=1')
					  ->where($where)
					  ->where(' isUse=0 and c.endDate>"'.date('Y-m-d').'"')
					  ->count();
	   $data['num1'] = $this->alias('c')->join('__COUPON_USERS__ cu','c.couponId=cu.couponId')
					  ->join('__SHOPS__ s','c.shopId=s.shopId and s.dataFlag=1 and s.shopStatus=1')
					  ->where($where)
					  ->where(' isUse=1 ')
					  ->count();
	   $data['num2'] = $this->alias('c')->join('__COUPON_USERS__ cu','c.couponId=cu.couponId')
					  ->join('__SHOPS__ s','c.shopId=s.shopId and s.dataFlag=1 and s.shopStatus=1')
					  ->where($where)
					  ->where(' isUse=0 and c.endDate<"'.date('Y-m-d').'" ')
					  ->count();
	   return $data;
	}

	/**
	 * 更改店铺状态时的处理函数
	 */
	public function afterChangeShopStatus($params){
		$shopId = (int)$params['shopId'];
		if($shopId<=0)return;
		$shop = model('common/shops')->get($shopId);
		//店铺状态不正常的话就删除了优惠券
		if($shop->applyStatus==2 && ($shop->dataFlag!=1 || $shop->shopStatus!=1)){
			 $this->where('shopId',$shopId)->update(['dataFlag'=>-1]);
		}
	}

	/**
	 * 领取的优惠券数
	 */
	public function couponsNum($uId=0){
		$userId = ($uId==0)?(int)session('WST_USER.userId'):$uId;
		$rs = Db::name('coupon_users')->alias('cu')->join('__COUPONS__ c','c.couponId=cu.couponId')
		->where('cu.userId='.$userId.' and cu.isUse=0 and c.endDate>='.date('Y-m-d'))->count();
		return $rs;
	}
	/**
	 * 领取优惠码
	 */
	public function receiveCard($uId=0){
		$userId =($uId==0)?(int)session('WST_USER.userId'):$uId;
		if($userId==0)return WSTReturn('领取失败，请先登录',-2);
		$code =input('codes');
		$time = time();
		if(!$code)return WSTReturn('请输入优惠码');
		//是否存在优惠码
		$card=Db::name('coupon_card')->where(['code'=>$code,'dataFlag'=>0])->find();
		if($card){
			//是否过期
			if($time > strtotime($card['endDate']." 23:59:59"))return WSTReturn('对不起，该优惠码已失效');
			//是否使用
			if($card['userId'] !=0 || $card['dataFlag']==1)return WSTReturn('该优惠码已被领取');
			// 是否达到总数量
			$coupon = $this->get($card['couponId']);
			if($coupon->dataFlag==-1)return WSTReturn('对不起，优惠码领取失败');
			if($coupon->couponNum<=$coupon->receiveNum)return WSTReturn('对不起，优惠码已领完');
			Db::startTrans();
			try{
				//查询用户是否领取过
				$userCard=Db::name('coupon_users')->where('cardId',$card['cardId'])->find();
				if($userCard)return WSTReturn('你已经领过该优惠码拉');
				// 是否超过临取数量
				$cardNum=Db::name('coupon_users')->where(['userId'=>$userId,'couponId'=>$card['couponId']])->count();
				if($coupon->limitNum !=0){
					if($cardNum>=$coupon->limitNum)return WSTReturn('对不起，该优惠码您的领取已达上限');
				}
				//领取优惠码
				$cd=Db::name('coupon_card')->where('code',$code)->update(['userId'=>$userId,'dataFlag'=>1]);
				// 生成优惠劵
				if($cd){
					$couponUser = [];
					$couponUser['couponId'] = $card['couponId'];
					$couponUser['cardId']=$card['cardId'];
					$couponUser['userId'] = $userId;
					$couponUser['isUse'] = 0;
					$couponUser['createTime'] = date('Y-m-d H:i:s');
					$rs=Db::name('coupon_users')->insert($couponUser);
				}
				$coupon->receiveNum = $coupon->receiveNum+1;
				$coupon->save();
				Db::commit();
				return WSTReturn('优惠码领取成功',1);
			}catch (\Exception $e) {
				Db::rollback();
				return WSTReturn('优惠码领取失败');
			}
		}else{
			return WSTReturn('请输入正确的优惠码');
		}
	}
	/**
	 * 优惠券链接
	 */
	public function pageQueryLink($uId=0){
		$couponId =(int)input('id/d',0);
		$userId =($uId==0)?(int)session('WST_USER.userId'):$uId;
		if($couponId ==0) return WSTReturn('没有优惠券');
		$rs=Db::name('coupons')->where(['couponId'=>$couponId,'dataFlag'=>1,'couponType'=>2])->find();
		if($rs){
			//网站当前根目录路径
			$path=WSTDomain();
			//加密
			$time=$rs['createTime'];
			$url=$time.$couponId;
			$returnUrl = rawurlencode(base64_encode($url));//编码
			//$returnUrl = parse_str(base64_decode($returnUrl));//解码   或者
			// $returnUrl = base64_decode($returnUrl);//解码
			$path=$path.'/addon/coupon-users-wxlinks.html?id='.$returnUrl;
			return WSTReturn($path,1);
		}
	}
	public function toAnalysisLink($uId=0){
		$id=input('id',0);
		if(!$id)return WSTReturn('无效链接',-1);
		$userId =($uId==0)?(int)session('WST_USER.userId'):$uId;
		if($userId==0)return WSTReturn('领取失败，请先登录',-2);
		$returnUrl = base64_decode($id);//解码
		$createTime=substr($returnUrl, 0,19);
		$couponId=substr($returnUrl, 19);
		$rs=Db::name('coupons')->where(['couponId'=>$couponId,'dataFlag'=>1,'couponType'=>2,'createTime'=>$createTime])->find();
		if($rs){
			$time=time();
			//是否过期
			if($time > strtotime($rs['endDate']." 23:59:59"))return WSTReturn('对不起，该链接已失效');
			//是否达到领取上限
			$count=Db::name('coupon_users')->where(['userId'=>$userId,'couponId'=>$couponId])->count();
			if($rs['limitNum']<=$count)return WSTReturn('对不起，你已达上限');
			if($rs['couponNum']<=$rs['receiveNum'])return WSTReturn('对不起，优惠券已领完');
			$coupon = $this->get($rs['couponId']);
			Db::startTrans();
			try{
				// 生成优惠劵
				$couponUser = [];
				$couponUser['couponId'] = $rs['couponId'];
				$couponUser['cardId']=0;
				$couponUser['userId'] = $userId;
				$couponUser['isUse'] = 0;
				$couponUser['createTime'] = date('Y-m-d H:i:s');
				$rd=Db::name('coupon_users')->insert($couponUser);
				$coupon->receiveNum = $coupon->receiveNum+1;
				$coupon->save();
				Db::commit();
				return WSTReturn('优惠券领取成功',1);
			}catch (\Exception $e) {
				Db::rollback();
				return WSTReturn('优惠劵领取失败');
			}
		}else{
			return WSTReturn('无效链接',-1);
		}
	}
	//系统触发，用户注册送优惠券
	public function sendCouponRegist($params){
		$userId=(int)$params['userId'];
		if($userId<=0)return;
		$rs=Db::name('coupons')->where([['couponType', '=',0],['typeStatus','=',1],['dataFlag','=',1]])->select();
		if($rs){
			$arr=[];
			foreach ($rs as $k => $v) {
				//删除已有 过了发放日期 跟超过限量
				if(Db::name('coupon_users')->where(['userId'=>$userId,'couponId'=>$v['couponId']])->find())continue;
				if(WSTStrToTime($v['endGrantDate']) <WSTStrToTime($params['createTime']))continue;
				if($v['receiveNum']>=$v['couponNum'])continue;
				$arr[]=$v;
			}
			if($arr){
				// 生成优惠劵
				Db::startTrans();
				try{
					foreach ($arr as $k => $v) {
						if($v['couponId']){
							$coupon = $this->get($v['couponId']);
							$couponUser = [];
							$couponUser['couponId'] = $v['couponId'];
							$couponUser['cardId']=0;
							$couponUser['userId'] = $userId;
							$couponUser['isUse'] = 0;
							$couponUser['createTime'] = date('Y-m-d H:i:s');
							Db::name('coupon_users')->insert($couponUser);
							$coupon->receiveNum = $coupon->receiveNum+1;
							$coupon->save();
						}
					}
					//发送一条用户信息
					$mallName=WSTConfig();
					$content="尊敬的用户,恭喜你成为 ".$mallName['mallName']." 的新用户, ".$mallName['mallName']." 送您优惠劵 ".count($arr)."张";
					WSTSendMsg($userId,$content,['from'=>0,'dataId'=>0]);
					Db::commit();
					return WSTReturn('优惠券领取成功',1);
				}catch (\Exception $e) {
				Db::rollback();
				return WSTReturn('优惠劵领取失败');
				}
			}else{
				return WSTReturn('暂无优惠劵');
			}
		}
	}
	//系统触发 生日送优惠券
	public function sendCouponBirthday($uId=0){
		$userId =($uId==0)?(int)session('WST_USER.userId'):$uId;
		if($userId ==0)return;// WSTReturn('未登录',-2);
		$rs=Db::name('users')->where('userId',$userId)->field('brithday')->find();
		if($rs){
			$date =date('Y-m-d H:i:s');
			$date1=$rs['brithday'];
			//距离生日还有几天
			$day=get_days($date1);
			if($day>=0 && $day<=7){
				$rd=Db::name('coupons')->where(['couponType'=>0,'typeStatus'=>2,'dataFlag'=>1])->select();
				if($rd){
					$arr=[];
					foreach ($rd as $k => $v) {
						//删除已有 过了发放日期 跟超过限量
						if(Db::name('coupon_users')->where(['userId'=>$userId,'couponId'=>$v['couponId']])->find())continue;
						if(WSTStrToTime($v['endGrantDate']) <WSTStrToTime($date))continue;
						if($v['receiveNum']>=$v['couponNum'])continue;
						$arr[]=$v;
					}
					if($arr){
						//生成优惠劵
						Db::startTrans();
						try{
							foreach ($arr as $k => $v) {
								if($v['couponId']){
									$coupon = $this->get($v['couponId']);
									$couponUser = [];
									$couponUser['couponId'] = $v['couponId'];
									$couponUser['cardId']=0;
									$couponUser['userId'] = $userId;
									$couponUser['isUse'] = 0;
									$couponUser['createTime'] = date('Y-m-d H:i:s');
									Db::name('coupon_users')->insert($couponUser);
									$coupon->receiveNum = $coupon->receiveNum+1;
									$coupon->save();
								}
							}
							//发送一条用户信息
							$mallName=WSTConfig();
							if($day==0){
								$content="尊敬的用户,今天是您的生日, ".$mallName['mallName']." 送您优惠劵 ".count($arr)."张, 祝您生日快乐";
							}else{
								$content="尊敬的用户,距离您的生日还有".$day."天, ".$mallName['mallName']." 送您优惠劵 ".count($arr)."张, 祝您生日快乐";
							}
							WSTSendMsg($userId,$content,['from'=>0,'dataId'=>0]);
							Db::commit();
							return WSTReturn('优惠券领取成功',1);
						}catch (\Exception $e) {
						Db::rollback();
						return WSTReturn('优惠劵领取失败');
						}
					}
				}
			}
		}
	}

	public function getUserRanks(){
	    $res = Db::name('user_ranks')->where(['dataFlag'=>1])->select();
	    return $res;
    }

    /**
     * 搜索用户
     */
    public function searchUsers(){
        $key = input('key');
        $start = date('Y-m-d 00:00:00',strtotime(input('startDate')));
        $end = date('Y-m-d 23:59:59',strtotime(input('endDate')));
        $rankId = input('rankId');
        $rank = '';
        if($rankId>0)$rank = Db::name('user_ranks')->where(['rankId'=>$rankId])->find();
        $couponId = input('couponId');
        $couponUserIds = Db::name('coupon_users')->where(['couponId'=>$couponId])->column('userId');
        $where = [];
        $where[] = ['userStatus','=',1];
        $where[] = ['dataFlag','=',1];
        if($rank!=''){
            $where[] = ['userTotalScore','>=',$rank['startScore']];
            $where[] = ['userTotalScore','<=',$rank['endScore']];
        }
        if($key!='')$where[] = ['loginName|userName|userPhone','like','%'.$key.'%'];
        $rs = Db::name('users')
            ->where($where)
            ->whereTime('createTime','between',[$start,$end])
            ->field('userId,loginName,userTotalScore')
            ->select();
        $users = [];
        foreach($rs as $key => $v){
            if(!in_array($v['userId'],$couponUserIds)){
                $users[] = $v;
            }
        }
        return WSTReturn('',1,$users);
    }

    /**
     * 发放优惠券
     */
    public function give(){
        $couponId = input('couponId');
        $userIds = explode(',',input('ids'));
        $couponNum = count($userIds);
        $coupon = Db::name('coupons')->where(['couponId'=>$couponId])->find();
        // 判断优惠券是否过期
        $time = time();
        if($time > WSTStrToTime($coupon['endDate']." 23:59:59"))return WSTReturn('优惠券已过期，不能发放');
        // 优惠券剩余数量
        $couponCount = (int)$coupon['couponNum']-(int)$coupon['receiveNum'];
        if($couponNum>$couponCount)return WSTReturn('优惠券数量还剩'.$couponCount.'张，不足以发放给所选用户');
        $limitNum = $coupon['limitNum'];
        for($i=0;$i<count($userIds);$i++){
            $receiveNum = Db::name('coupon_users')->where(['userId'=>$userIds[$i],'couponId'=>$couponId])->count();
            if($limitNum!=0 && $receiveNum>=$limitNum)return WSTReturn('所选用户领取优惠券已达上限');
        }
        Db::startTrans();
        try{
            for($i=0;$i<count($userIds);$i++){
                $data = [
                    'couponId'=>$couponId,
                    'userId'=>$userIds[$i],
                    'isUse'=>0,
                    'createTime'=>date('Y-m-d H:i:s')
                ];
                Db::name('coupon_users')->insert($data);
            }
            $rs = Db::name('coupons')->where(['couponId'=>$couponId])->setInc('receiveNum',$couponNum);
            if(false !== $rs){
                Db::commit();
                return WSTReturn('发放成功',1);
            }
        }catch (\Exception $e) {
            Db::rollback();
            return WSTReturn('发放失败');
        }
    }

    /**
     * 获取优惠券列表
     */
    public function pageQueryByCoupons(){
        $couponId = (int)input('couponId');
        $isUse = (int)input('isUse');
        if(!in_array($isUse,[-1,0,1]))$isUse = -1;
        $where = [];
        $where[] = ['couponId','=',$couponId];
        if($isUse!=-1)$where[] = ['isUse','=',$isUse];
        return Db::name('coupon_users')->alias('c')
            ->join('__USERS__ u','u.userId=c.userId')
            ->where($where)
            ->field('u.loginName,c.createTime,c.isUse,useTime,orderNo')
            ->order('c.createTime desc')
            ->paginate(input('pagesize/d'))->toArray();
    }
}
