alter table `wst_orders` add userCouponId int default 0 comment '用户使用的优惠券ID';
alter table `wst_orders` add userCouponJson text comment '优惠券说明';

DROP TABLE IF EXISTS `wst_coupon_goods`;
CREATE TABLE `wst_coupon_goods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `couponId` int(11) NOT NULL,
  `goodsLibId` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `goodsLibId` (`goodsLibId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `wst_coupon_cats`;
CREATE TABLE `wst_coupon_cats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `couponId` int(11) NOT NULL,
  `catId` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `catId` (`catId`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `wst_coupon_users`;
CREATE TABLE `wst_coupon_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `couponId` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `isUse` tinyint(4) NOT NULL DEFAULT '0',
  `orderNo` varchar(50) DEFAULT NULL,
  `useTime` datetime DEFAULT NULL,
  `createTime` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `userId` (`userId`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `wst_coupons`;
CREATE TABLE `wst_coupons` (
  `couponId` int(11) NOT NULL AUTO_INCREMENT,
  `couponValue` int(11) NOT NULL DEFAULT '0',
  `useCondition` tinyint(4) NOT NULL DEFAULT '0',
  `useMoney` int(11) DEFAULT NULL COMMENT '0',
  `startDate` date NOT NULL,
  `endDate` date NOT NULL,
  `couponNum` int(11) NOT NULL DEFAULT '0',
  `limitNum` int(11) NOT NULL DEFAULT '0',
  `receiveNum` int(11) DEFAULT '0',
  `useObjects` tinyint(4) NOT NULL DEFAULT '0',
  `useObjectIds` text,
  `dataFlag` tinyint(4) NOT NULL DEFAULT '1',
  `createTime` datetime NOT NULL,
  `couponType` tinyint(4) NOT NULL DEFAULT   '1' COMMENT  '0：系统发放 1：人工发放 2：链接发放 3：优惠码',
  `typeStatus` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0：无 1：用户注册 2：用户生日',
  `startGrantDate` date DEFAULT NULL,
  `endGrantDate` date DEFAULT NULL,
  PRIMARY KEY (`couponId`),
  KEY `startDate` (`startDate`,`endDate`,`dataFlag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `wst_coupon_card`;
CREATE TABLE `wst_coupon_card` (
  `cardId` int(11) NOT NULL AUTO_INCREMENT,
  `code` char(10) DEFAULT '' COMMENT '优惠码',
  `couponId` int(11) NOT NULL,
  `userId` int(11) DEFAULT '0' COMMENT '用户id',
  `dlength` int(11) DEFAULT '0' COMMENT '时长',
  `startDate` date DEFAULT NULL COMMENT '开始时间',
  `endDate` date DEFAULT NULL COMMENT '结束时间',
  `localcity` int(11) DEFAULT '0' COMMENT '城市code',
  `createTime` datetime DEFAULT NULL COMMENT '创建时间',
  `dataFlag` int(5) DEFAULT '0' COMMENT '是否已经使用  0未使用  1已使用',
  PRIMARY KEY (`cardId`),
  KEY `code` (`code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='优惠码';