<?php
namespace addons\coupon\controller;

use think\addons\Controller;
use addons\coupon\model\Coupons as M;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 优惠券插件
 */
class Admin extends Controller{
	// protected $beforeActionList = ['checkAdminAuth' ];
	public function __construct(){
		parent::__construct();
		$this->assign("v",WSTConf('CONF.wstVersion'));
	}
	/**
	 * 优惠券列表
	 */
	public function index(){
    	return $this->fetch("/admin/list");
	}
	/**
	 * 加载优惠券数据
	 */
	public function pageQuery(){
		$m = new M();
		return WSTGrid($m->pageQuery());
	}

	/**
	 * 跳去编辑页面
	 */
	public function edit(){
		$id = (int)input('id');
		$object = [];
		$m = new M();
		if($id>0){
            $object = $m->getById($id);
		}else{
			$object = $m->getEModel('coupons');
			$object['goods'] = [];
		}
		$this->assign("object",$object);
		return $this->fetch("/admin/edit");
	}

	/**
	 * 保存优惠券信息
	 */
	public function toEdit(){
		$id = (int)input('post.couponId');
		$m = new M();
		if($id==0){
            return $m->add();
		}else{
            return $m->edit();
		}
	}

	/**
	 * 删除优惠券
	 */
	public function del(){
		$m = new M();
		return $m->del();
	}
	/**
	 * 查询商品
	 */
	public function searchGoods(){
		$m = new M();
		return $m->searchGoods();
	}
	/**
	 * 跳去优惠码
	 */
	public function card(){
		$id = (int)input('id/d');
		$this->assign('id',$id);
		return $this->fetch("/admin/card");
	}
	/**
	 * 查看优惠码
	 */
	public function pageQueryByCouponCards(){
		$m =new M();
		return WSTGrid($m->pageQueryByCouponCards());
	}
	/**
	 * 查看优惠劵链接
	 */
	public function pageQueryLink(){
		$m = new M();
		return $m->pageQueryLink();
	}

	/*
	 * 跳去发放优惠券的页面
	 */
    public function give(){
        $couponId = (int)input('id');
        $m = new M();
        $userRank = $m->getUserRanks();
        $this->assign('couponId',$couponId);
        $this->assign('userRank',$userRank);
        $this->assign("startDate",date('Y-m-d',strtotime("-1month")));
        $this->assign("endDate",date('Y-m-d'));
        return $this->fetch("/admin/give");
    }

    /*
     * 搜索用户
     */
    public function searchUsers(){
        $m = new M();
        return $m->searchUsers();
    }

    /**
     * 发放优惠券
     */
    public function toGive(){
        $m = new M();
        return $m->give();
    }

    /**
     * 查看优惠券领取情况
     */
    public function coupons(){
        $this->assign("p",(int)input("p"));
        $this->assign("id",(int)input("id"));
        return $this->fetch("/admin/coupons");
    }

    /**
     * 加载优惠券领取列表
     */
    public function pageQueryByCoupons(){
        $m = new M();
        return WSTGrid($m->pageQueryByCoupons());
    }
}