<?php
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 */
function WSTAdminGrant($code){
	$STAFF = session("WST_STAFF");
	if(in_array($code,$STAFF['privileges']))return true;
	return false;
}
/**
 * 生成优惠码
 * @param int $nums             生成多少个优惠码
 * @param array $exist_array     排除指定数组中的优惠码
 * @param int $code_length         生成优惠码的长度
 * @param int $prefix              生成指定前缀
 * @return array                 返回优惠码数组
 */
function generateCode( $nums=200,$exist_array='',$code_length = 8,$prefix = '' ) {

    $characters = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnpqrstuvwxyz";
    $promotion_codes = array();//这个数组用来接收生成的优惠码

    for($j = 0 ; $j < $nums; $j++) {
            
        $code = '';
            
        for ($i = 0; $i < $code_length; $i++) {

            $code .= $characters[mt_rand(0, strlen($characters)-1)];

        }
            
        //如果生成的4位随机数不再我们定义的$promotion_codes数组里面
        if( !in_array($code,$promotion_codes) ) {

            if( is_array($exist_array) ) {
                    
                if( !in_array($code,$exist_array) ) {//排除已经使用的优惠码

                    $promotion_codes[$j] = $prefix.$code; //将生成的新优惠码赋值给promotion_codes数组

                } else {

                    $j--;

                }
                    
            } else {
                    
                $promotion_codes[$j] = $prefix.$code;//将优惠码赋值给数组
                    
            }

        } else {
            $j--;
        }
    }

    return $promotion_codes;
}
/**
 * 计算当前时间距离用户生日还差多少天
 * @param  date $date1 [2017-07-18]
 * @param  date $date2 [2017-07-24] 
 * @return int        相差天数
 */
function get_days($date1)
{
    //如果用户没有设置时间，返回今年一整年的天数
    $date = date('Y-m-d');
    if(!$date1 && is_null($date1)){
        // $yearDay = countdays($date);
        return 365;
    }
    $Y = date('Y');
    $date1 = strtotime($Y . substr($date1,4,6));
    //获取当前时间戳
    $date2time = strtotime($date);
    //如果相等表示今天过生日返回0
    if($date1 == $date2time){
        return 0;
    }
    //如果生日大于当前时间 表示今年生日还没有过
    if ($date1 > $date2time) {
        $day = ($date1 - $date2time) / 86400;
    }
 
    //如果生日大于当前时间 表示今年生日已经过了
    if ($date1 < $date2time) {
        //计算相差天数
        $day = (($date1 - strtotime($Y . '-01-01')) / 86400) + ((strtotime($Y . '-12-31') - $date2time) / 86400);
    }
    return $day;
}